/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.entities.messaging.QNotification;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.messaging.NotificationServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.messaging.notifications.NotificationQuery;
import org.cyclos.model.messaging.notifications.NotificationVO;
import org.cyclos.model.messaging.notifications.NotificationsStatusVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.stereotype.Service;

@Service
public class NotificationServiceImpl
extends BaseServiceImpl
implements NotificationServiceLocal {
    private static final QNotification $ = QNotification.notification;

    public NotificationsStatusVO getNotificationsStatus() {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            return null;
        }
        int n = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.user().eq((Object)basicUser), NotificationServiceImpl.$.read.isNull().or((Predicate)NotificationServiceImpl.$.read.isFalse())})).count(NotificationServiceImpl.$.id);
        Date date = basicUser.getNotificationsLastViewDate();
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{$}).where((Predicate)$.user().eq((Object)basicUser));
        if (date != null) {
            dBQuery.where((Predicate)NotificationServiceImpl.$.date.goe((Comparable)date));
        }
        int n2 = dBQuery.count(NotificationServiceImpl.$.id);
        NotificationsStatusVO notificationsStatusVO = new NotificationsStatusVO();
        notificationsStatusVO.setUnreadNotifications(n);
        notificationsStatusVO.setNewNotifications(n2);
        notificationsStatusVO.setLastViewDate(this.toDateTime(date));
        return notificationsStatusVO;
    }

    public NotificationVO load(@NotNull Long l) throws FrameworkException {
        return (NotificationVO)this.conversionHandler.convert(NotificationVO.class, (Object)this.find(Notification.class, l));
    }

    public void markAllRead() {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser != null) {
            this.update((EntityPath<?>)$).set((Path)NotificationServiceImpl.$.read, (Object)true).where(new Predicate[]{$.user().eq((Object)basicUser)}).execute();
        }
    }

    public void markAsRead(List<Long> list) {
        if (CollectionHelper.isNotEmpty(list)) {
            for (Long l : list) {
                Notification notification = this.find(Notification.class, l);
                notification.setRead(true);
                this.persist((IEntity)notification);
            }
        }
    }

    public void remove(Long l) {
        Notification notification = this.find(Notification.class, l);
        this.remove((IEntity)notification);
    }

    public void removeAll(BasicUser basicUser) {
        this.delete((EntityPath<?>)$).where(new Predicate[]{$.user().eq((Object)basicUser)}).execute();
    }

    public void removeAll(Collection<Long> collection) {
        CollectionHelper.orEmpty(collection).forEach(this::remove);
    }

    public Page<NotificationVO> search(NotificationQuery notificationQuery) throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{$}).where((Predicate)NotificationServiceImpl.$.user().id.eq((Object)basicUser.getId()));
        if (notificationQuery.isOnlyUnread()) {
            dBQuery.where((Predicate)NotificationServiceImpl.$.read.isFalse().or((Predicate)NotificationServiceImpl.$.read.isNull()));
        }
        if (notificationQuery.isOnlyNew()) {
            Date date = basicUser.getNotificationsLastViewDate();
            if (date != null) {
                dBQuery.where((Predicate)NotificationServiceImpl.$.date.goe((Comparable)date));
            }
            dBQuery.where((Predicate)NotificationServiceImpl.$.read.isFalse());
        }
        dBQuery.orderBy(NotificationServiceImpl.$.date.desc());
        return dBQuery.page(NotificationVO.class, (QueryParameters)notificationQuery, (Expression)$);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network());
    }
}

