/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Date;
import org.cyclos.entities.messaging.QIncomingMessage;
import org.cyclos.entities.messaging.QOutgoingMessage;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.IEntity;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurgeMessagesOnTrashRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PURGE_MESSAGES_ON_TRASH;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        int n = this.cyclosProperties.getPurgeMessagesOnTrashDays();
        if (n < 1) {
            return 0L;
        }
        long l = 0L;
        l += this.purgeIncomingMessages(n);
        return l += this.purgeOutgoingMessages(n);
    }

    private long purgeIncomingMessages(int n) {
        QIncomingMessage qIncomingMessage = QIncomingMessage.incomingMessage;
        return this.delete((EntityPath<?>)qIncomingMessage).where(new Predicate[]{qIncomingMessage.removedAt.addDays(Integer.valueOf(n)).lt((Expression)DateTimeExpression.currentTimestamp()), qIncomingMessage.messageOwner.eq((Object)MessageOwner.SYSTEM)}).execute();
    }

    private long purgeOutgoingMessages(int n) {
        QOutgoingMessage qOutgoingMessage = QOutgoingMessage.outgoingMessage;
        Date date = DateHelper.subtract((Date)DateHelper.now(), (TimeField)TimeField.DAYS, (int)n);
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{qOutgoingMessage}).where(new Predicate[]{qOutgoingMessage.removedAt.lt((Comparable)date), qOutgoingMessage.messageOwner.eq((Object)MessageOwner.SYSTEM)})).iterate((Expression)qOutgoingMessage);
        return this.processBatch(closeableIterator, (T outgoingMessage) -> this.rawEntityManagerHandler.remove((IEntity)outgoingMessage));
    }
}

