/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.mobile;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.CyclosVersion;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.contentmanagement.HomeContent;
import org.cyclos.entities.contentmanagement.WelcomeContent;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelSettingsAccessor;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.system.PinChannelConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QProductMyAccessClient;
import org.cyclos.entities.users.QProductMyTokenType;
import org.cyclos.entities.users.QProductTokenType;
import org.cyclos.entities.users.QProductUserTokenType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.InternalAuthServiceLocal;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.contentmanagement.InternalTranslationMessageServiceLocal;
import org.cyclos.impl.contentmanagement.InternalUiServiceLocal;
import org.cyclos.impl.contentmanagement.MobilePageServiceLocal;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.impl.messaging.MessageServiceLocal;
import org.cyclos.impl.messaging.NotificationServiceLocal;
import org.cyclos.impl.mobile.ContentHelper;
import org.cyclos.impl.mobile.InternalMobileServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserRegionalSettingsServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.VersionedVO;
import org.cyclos.model.access.MobileOperation;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.principaltypes.MemberAccessClientPermission;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalVO;
import org.cyclos.model.access.principaltypes.TokenType;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transactions.ReceivePaymentData;
import org.cyclos.model.contentmanagement.BaseGetVersionedDataParams;
import org.cyclos.model.contentmanagement.GetMobileUserDataParams;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageVO;
import org.cyclos.model.contentmanagement.translations.TranslationsData;
import org.cyclos.model.mobile.MobileSubmodule;
import org.cyclos.model.system.configurations.CaptchaProvider;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.DimensionsDTO;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.server.model.mobile.BaseMobileData;
import org.cyclos.server.model.mobile.MobileGuestData;
import org.cyclos.server.model.mobile.MobileUserData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalMobileServiceImpl
extends BaseServiceImpl
implements InternalMobileServiceLocal {
    private static final String HOME_PAGE_USER_DATA_FIELD = "homePage";
    @Autowired
    private InternalTranslationMessageServiceLocal internalTranslationMessageService;
    @Autowired
    private InternalUiServiceLocal internalUiService;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private LoginServiceLocal loginService;
    @Autowired
    private MobilePageServiceLocal mobilePageService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private TokenServiceLocal tokenService;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private AccessClientServiceLocal accessClientService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private OrderServiceLocal orderService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private InternalAuthServiceLocal internalAuthService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private NotificationServiceLocal notificationService;
    @Autowired
    private MessageServiceLocal messageService;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private UserRegionalSettingsServiceLocal userRegionalSettingsService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;

    public String generateLinkForMobile(String string) {
        return this.linkGeneratorHandler.mobile(string);
    }

    public ContentHelper getContentHandler(BaseGetVersionedDataParams baseGetVersionedDataParams) {
        return new ContentHelper(baseGetVersionedDataParams, this.getSessionData(), this.internalUiService);
    }

    public MobileGuestData getGuestData(Long l, PinLocatorVO pinLocatorVO, GetVersionedDataParams getVersionedDataParams) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        MobileGuestData mobileGuestData = new MobileGuestData();
        ContentHelper contentHelper = this.fill((BaseMobileData)mobileGuestData, (BaseGetVersionedDataParams)getVersionedDataParams);
        mobileGuestData.setLoginData(this.loginService.getLoginData(sessionData.getChannel(), l, pinLocatorVO));
        if (l != null && this.trustedDeviceService.exists(l.longValue())) {
            mobileGuestData.setApprovalData(this.deviceConfirmationService.getApprovalData(l));
        }
        contentHelper.setHeader(arg_0 -> ((MobileGuestData)mobileGuestData).setLoginHeader(arg_0)).setFooter(arg_0 -> ((MobileGuestData)mobileGuestData).setLoginFooter(arg_0));
        WelcomeContent welcomeContent = configurationAccessor.getWelcomeContent();
        if (welcomeContent != null && welcomeContent.isEnabled()) {
            contentHelper.setWelcomePage(arg_0 -> ((MobileGuestData)mobileGuestData).setWelcomePage(arg_0));
            mobileGuestData.setWelcomePageEnabled(true);
        }
        mobileGuestData.setGroupsForRegistration(this.userService.getPublicRegistrationGroups());
        mobileGuestData.setAllowQuickPayment(sessionData.getConfiguration().isAllowQuickPaymentMobile());
        mobileGuestData.setMediumScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getMediumScreenRegistrationWizard()));
        mobileGuestData.setSmallScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getSmallScreenRegistrationWizard()));
        return mobileGuestData;
    }

    public String getRecaptchaKey() {
        CaptchaConfiguration captchaConfiguration = this.getSessionData().getConfiguration().getCaptchaConfiguration();
        if (captchaConfiguration.getProvider() != CaptchaProvider.RECAPTCHA_V2) {
            throw new EntityNotFoundException();
        }
        return captchaConfiguration.getRecaptchaKey();
    }

    public MobileUserData getUserData(GetMobileUserDataParams getMobileUserDataParams) throws FrameworkException {
        List list;
        boolean bl;
        MobileUserData mobileUserData = new MobileUserData();
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        boolean bl2 = sessionData.getAccessClient() != null;
        HomeContent homeContent = configurationAccessor.getHomeContent();
        boolean bl3 = bl = homeContent != null && homeContent.isEnabled() && homeContent.getShowIn().shouldShowFor(bl2);
        if (bl) {
            mobileUserData.setUpdateHomeOnEvents(homeContent.getUpdateOnEvents());
        }
        if (this.onlyHomeContentIsNeeded(sessionData)) {
            if (bl) {
                new ContentHelper((BaseGetVersionedDataParams)getMobileUserDataParams, sessionData, this.internalUiService).setHomePage(arg_0 -> ((MobileUserData)mobileUserData).setHomePage(arg_0));
            }
            return mobileUserData;
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        User user = basicUser == null ? null : basicUser.getUser();
        ChannelAccessAccessor channelAccessAccessor = sessionData.getChannelAccessAccessor();
        ChannelSettingsAccessor channelSettingsAccessor = sessionData.getChannelSettingsAccessor();
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = channelSettingsAccessor.getPayment();
        ContentHelper contentHelper = this.fill((BaseMobileData)mobileUserData, (BaseGetVersionedDataParams)getMobileUserDataParams);
        if (bl) {
            contentHelper.setHomePage(arg_0 -> ((MobileUserData)mobileUserData).setHomePage(arg_0));
            mobileUserData.setHomePageEnabled(true);
            mobileUserData.setReloadHomePage(StringHelper.isThymeleaf((String)homeContent.getContent()) || StringHelper.hasVariables((String)homeContent.getContent()));
            mobileUserData.setHideQuickActions(homeContent.isHideQuickActions());
        }
        mobileUserData.setAuth(this.internalAuthService.getCurrentAuth());
        mobileUserData.setNameOfUser(basicUser.getName());
        if (bl2) {
            contentHelper.setPosHelp(arg_0 -> ((MobileUserData)mobileUserData).setPosHelp(arg_0));
            list = this.mobilePageService.getPosMobilePages();
        } else {
            contentHelper.setMobileHelp(arg_0 -> ((MobileUserData)mobileUserData).setMobileHelp(arg_0));
            list = this.mobilePageService.getUserMobilePages();
        }
        mobileUserData.setPages(this.conversionHandler.convertList(MobilePageVO.class, (Iterable)list));
        List list2 = this.tokenService.getReceiveTokenTypes();
        mobileUserData.setCanReceiveFromNfcTag(CollectionHelper.orEmpty((List)list2).stream().filter(TokenType::isNFCTag).findAny().isPresent());
        mobileUserData.setDeviceActivationMode(this.trustedDeviceService.getDeviceActivationMode());
        mobileUserData.setMobileCameraOnPayment(paymentPrincipalsConfiguration.isScanQrCode());
        mobileUserData.setHideUsersSearchMenu(this.initializationService.isHideUserSearchInMenu());
        mobileUserData.setAutoCompleteResults(Integer.valueOf(configurationAccessor.getAutocompleteResults()));
        mobileUserData.setAllowedOperations(this.getAllowedOperations());
        mobileUserData.setPersonalizeOtherUsers(CollectionHelper.orEmpty((List)this.getProducts().member().getActivateUserTokenTypes()).stream().filter(tokenPrincipalType -> tokenPrincipalType.getTokenType().isNFCTag()).findAny().isPresent());
        boolean bl4 = mobileUserData.getAllowedOperations().contains(MobileOperation.MAKE_SYSTEM_PAYMENT) || mobileUserData.getAllowedOperations().contains(MobileOperation.MAKE_USER_PAYMENT);
        boolean bl5 = bl4 && (sessionData.getProducts().member().getMyTokenTypes().keysSet((Path)QProductMyTokenType.productMyTokenType.enable).stream().anyMatch(tokenPrincipalType -> tokenPrincipalType.getTokenType().isSupportCamera() && paymentPrincipalsConfiguration.getPrincipalTypes().contains(tokenPrincipalType)) || paymentPrincipalsConfiguration.isScanQrCode());
        mobileUserData.setScanQR(bl5 || this.hasPermission(Permission.MY_PAYMENT_TICKETS_APPROVE) || sessionData.isTrusted() || basicUser != null && this.userChannelService.isChannelAccessible(basicUser, this.channelService.getEasyInvoice()));
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (sessionData.isAdmin()) {
            arrayList.addAll(this.customOperationService.getRunnableOperationsForSystem());
            arrayList2.addAll(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listSystemForRun()));
        }
        if (user != null) {
            arrayList.addAll(this.customOperationService.getRunnableOperationsForUser(new UserLocatorVO(user.getId())));
        }
        mobileUserData.setCustomOperations(arrayList);
        arrayList2.addAll(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listForRun(user)));
        mobileUserData.setWizards(arrayList2);
        Set set = channelSettingsAccessor.getPrincipalTypesAllowingQrCode();
        List list3 = set.stream().map(principalType -> {
            UserPrincipal userPrincipal = this.profileFieldHandler.getPrincipal(basicUser, principalType);
            String string = null;
            if (userPrincipal == null) {
                return null;
            }
            string = userPrincipal instanceof Token ? ((Token)userPrincipal).getMaskedValue() : userPrincipal.getPrincipal();
            if (string == null) {
                return null;
            }
            PrincipalVO principalVO = new PrincipalVO();
            principalVO.setType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, principalType));
            principalVO.setValue(string);
            return principalVO;
        }).filter(principalVO -> principalVO != null && principalVO.getValue() != null).collect(Collectors.toList());
        mobileUserData.setPrincipalsAllowingQRCode(list3);
        mobileUserData.setShoppingCartWebShopCount(Integer.valueOf(this.orderService.countCartItems()));
        mobileUserData.setMessagesStatus(this.messageService.getMessagesStatus());
        mobileUserData.setNotificationsStatus(this.notificationService.getNotificationsStatus());
        mobileUserData.setEnableBluetoothPrinter(configurationAccessor.isEnableBluetoothPrinterMobile());
        mobileUserData.setApplyDefaultUserSearchFiltersOnPayment(configurationAccessor.isApplyDefaultUserSearchFiltersOnPayment());
        mobileUserData.setMapPreference(configurationAccessor.getMapPreferenceMobile());
        mobileUserData.setTopUpEnabled(this.voucherConfigurationService.listVisible(sessionData.getLoggedUser()).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null));
        PinChannelConfiguration pinChannelConfiguration = channelAccessAccessor.getPinConfiguration();
        if (pinChannelConfiguration != null) {
            mobileUserData.setPinPrompt(pinChannelConfiguration.getDevicePinOnStartup());
        }
        mobileUserData.setTrustedDevicePrompt(channelAccessAccessor.getTrustedDeviceOnStartup());
        return mobileUserData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private ContentHelper fill(BaseMobileData baseMobileData, BaseGetVersionedDataParams baseGetVersionedDataParams) {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        baseMobileData.setCurrentClientTime(this.conversionHandler.toDateTime(new Date()));
        baseMobileData.setApplicationUsername(configurationAccessor.getApplicationUsername());
        baseMobileData.setCyclosVersion(CyclosVersion.get());
        baseMobileData.setNumberFormat(configurationAccessor.getNumberFormat());
        baseMobileData.setDateFormat(configurationAccessor.getDateFormat());
        baseMobileData.setTimeFormat(configurationAccessor.getTimeFormat());
        baseMobileData.setLanguageTemplate(configurationAccessor.getLanguage().getTemplate());
        baseMobileData.setRootUrl(configurationAccessor.getFullUrl());
        baseMobileData.setMapBrowserApiKey(configurationAccessor.getMapBrowserApiKey());
        baseMobileData.setLocalesData(this.userRegionalSettingsService.getLocalesData());
        ContentHelper contentHelper = new ContentHelper(baseGetVersionedDataParams, sessionData, this.internalUiService).setTheme(arg_0 -> ((BaseMobileData)baseMobileData).setTheme(arg_0), true);
        Language language = configurationAccessor.getLanguage();
        if (InternalUiServiceLocal.changed(() -> language, (VersionedVO)baseGetVersionedDataParams.getLanguage(), (String)baseGetVersionedDataParams.getCyclosVersion())) {
            TranslationsData translationsData = this.internalTranslationMessageService.getBySubmodules(CollectionHelper.asSet((Object[])MobileSubmodule.values()));
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            translationsData.getTranslations().forEach((string, string2) -> linkedHashMap.put(StringHelper.removeStart((String)string, (String)"MOBILE."), string2));
            translationsData.setTranslations(linkedHashMap);
            baseMobileData.setInitialTranslations(translationsData);
        }
        baseMobileData.setMaxUploadSize((FileSizeDTO)this.conversionHandler.convert(FileSizeDTO.class, (Object)configurationAccessor.getMaxUploadSize()));
        baseMobileData.setMaxImageDimensions((DimensionsDTO)this.conversionHandler.convert(DimensionsDTO.class, (Object)configurationAccessor.getMaxImageDimensions()));
        baseMobileData.setJpegQuality(Integer.valueOf(configurationAccessor.getJpegQuality()));
        return contentHelper;
    }

    private List<MobileOperation> getAllowedOperations() {
        Object object2;
        SessionData sessionData = this.getSessionData();
        ArrayList<MobileOperation> arrayList = new ArrayList<MobileOperation>();
        for (Object object2 : MobileOperation.values()) {
            if (object2 == MobileOperation.POS_ASSIGN || object2 == MobileOperation.POS_UNASSIGN || !this.isAllowedOperation((MobileOperation)object2, arrayList, sessionData)) continue;
            arrayList.add((MobileOperation)object2);
        }
        BooleanPropertiesHolder booleanPropertiesHolder = sessionData.getProducts().member().getMyAccessClients();
        Set set = booleanPropertiesHolder.keysSet((Path)QProductMyAccessClient.productMyAccessClient.activate);
        set.removeIf(accessClientPrincipalType -> !sessionData.getChannelAccessAccessor().getPrincipalTypes().contains(accessClientPrincipalType));
        User user = this.getLoggedUser();
        object2 = set.iterator();
        while (object2.hasNext()) {
            AccessClientPrincipalType accessClientPrincipalType2 = (AccessClientPrincipalType)object2.next();
            if (!this.accessClientService.canActivateAccessClient(accessClientPrincipalType2, user)) continue;
            arrayList.add(MobileOperation.POS_ASSIGN);
            break;
        }
        if (CollectionHelper.containsAny((Collection)set, (Collection)(object2 = booleanPropertiesHolder.keysSet((Path)QProductMyAccessClient.productMyAccessClient.unassign)))) {
            arrayList.add(MobileOperation.POS_UNASSIGN);
        }
        return arrayList;
    }

    private boolean hasMakePaymentPermission(boolean bl, SessionData sessionData) {
        SystemAccountOwner systemAccountOwner;
        if (bl) {
            if (!sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_USER)) {
                return false;
            }
            systemAccountOwner = null;
        } else {
            if (!sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_SYSTEM)) {
                return false;
            }
            systemAccountOwner = SystemAccountOwner.instance();
        }
        PerformPaymentData performPaymentData = this.transactionService.getPaymentData((InternalAccountOwner)sessionData.getLoggedUser(), (InternalAccountOwner)systemAccountOwner, null);
        return CollectionHelper.isNotEmpty((Iterable)performPaymentData.getAccounts());
    }

    private boolean hasReceivePaymentPermission(SessionData sessionData) {
        if (!sessionData.hasPermission(Permission.MY_PAYMENTS_RECEIVE)) {
            return false;
        }
        ReceivePaymentData receivePaymentData = this.transactionService.getReceivePaymentData();
        return CollectionHelper.isNotEmpty((Iterable)receivePaymentData.getAccounts());
    }

    private boolean isAllowedOperation(MobileOperation mobileOperation, List<MobileOperation> list, SessionData sessionData) {
        AccessClient accessClient = sessionData.getAccessClient();
        boolean bl = accessClient != null;
        boolean bl2 = bl && accessClient.getType().getPermission() == MemberAccessClientPermission.ALL;
        boolean bl3 = sessionData.isBroker() || sessionData.isAdmin();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        switch (mobileOperation) {
            case CARD_READ: {
                return !bl && !productsAccessor.userManagement().getUserTokenTypes().keysSet((Path)QProductUserTokenType.productUserTokenType.view).isEmpty();
            }
            case CARD_PERSONALIZE: {
                return (bl2 || !bl) && (bl3 && !productsAccessor.userManagement().getUserTokenTypes().keysSet((Path)QProductTokenType.productTokenType.personalize).isEmpty() || !productsAccessor.member().getActivateUserTokenTypes().isEmpty());
            }
            case CARD_PERSONALIZE_SELF: {
                return !bl && !productsAccessor.member().getMyTokenTypes().keysSet((Path)QProductTokenType.productTokenType.personalize).isEmpty();
            }
            case CARD_FORMAT: 
            case CARD_INITIALIZE: {
                return !bl && !productsAccessor.userManagement().getUserTokenTypes().keysSet((Path)QProductUserTokenType.productUserTokenType.initialize).isEmpty();
            }
            case MAKE_SYSTEM_PAYMENT: {
                return this.hasMakePaymentPermission(false, sessionData);
            }
            case MAKE_USER_PAYMENT: {
                return this.hasMakePaymentPermission(true, sessionData);
            }
            case MANAGE_CONTACTS: {
                return !bl && this.hasPermission(Permission.MY_CONTACTS_ENABLE);
            }
            case MANAGE_OPERATORS: {
                return this.hasPermission(Permission.MY_OPERATORS_MANAGE_OPERATORS, Permission.USER_OPERATORS_MANAGE);
            }
            case VIEW_USER_PROFILE: {
                return bl3 || sessionData.hasPermission(Permission.USER_VISIBILITY_PROFILE);
            }
            case NFC_ACTIVATE: {
                if (!bl) {
                    for (TokenPrincipalType tokenPrincipalType : productsAccessor.member().getMyTokenTypes().keysSet((Path)QProductMyTokenType.productMyTokenType.enable)) {
                        if (!tokenPrincipalType.getTokenType().isNFCDevice()) continue;
                        return true;
                    }
                }
                return false;
            }
            case NFC_DEACTIVATE: {
                if (!bl) {
                    for (TokenPrincipalType tokenPrincipalType : productsAccessor.member().getMyTokenTypes().keysSet((Path)QProductMyTokenType.productMyTokenType.cancel)) {
                        if (!tokenPrincipalType.getTokenType().isNFCDevice()) continue;
                        return true;
                    }
                }
                return false;
            }
            case POS_ASSIGN: 
            case POS_UNASSIGN: {
                throw new IllegalArgumentException("Unsupported mobile operation : " + String.valueOf(mobileOperation));
            }
            case RECEIVE_PAYMENT: {
                return this.hasReceivePaymentPermission(sessionData);
            }
            case VOUCHERS: {
                return this.hasPermission(Permission.MY_VOUCHERS_VIEW_VOUCHERS);
            }
            case BUY_VOUCHER: {
                return this.hasPermission(Permission.MY_VOUCHERS_BUY);
            }
            case REDEEM_VOUCHER: {
                return this.hasPermission(Permission.MY_VOUCHERS_REDEEM);
            }
            case VIEW_REDEEMED: {
                return this.hasPermission(Permission.MY_VOUCHERS_VIEW_TRANSACTIONS);
            }
            case USERS_SEARCH: {
                return sessionData.isAdmin() || sessionData.hasPermission(Permission.USER_VISIBILITY_SEARCH);
            }
            case MAP_DIRECTORY: {
                ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
                return configurationAccessor.isUseMap() && this.groupsHandler.directory().basic().isNotEmpty();
            }
            case VIEW_ACCOUNT_INFORMATION: {
                return sessionData.isMember() && !sessionData.getProducts().grantedAccountTypes().isEmpty();
            }
            case REGISTER_USERS_AS_MANAGER: {
                return this.isUserManager() && !this.groupsHandler.getPossibleRegistrationGroups(true, false).isEmpty() && this.hasPermission(Permission.USERS_REGISTER);
            }
            case REGISTER_USERS_AS_MEMBER: {
                return this.isMember() && !this.groupsHandler.getPossibleRegistrationGroups(true, true).isEmpty() && this.hasPermission(Permission.USERS_REGISTER);
            }
            case CREATE_TICKET: {
                return this.hasPermission(Permission.MY_PAYMENT_TICKETS_CREATE);
            }
            case ACCEPT_TICKET: {
                return this.hasPermission(Permission.MY_PAYMENT_TICKETS_APPROVE);
            }
            case PAYMENT_REQUESTS: {
                return this.hasPermission(Permission.MY_PAYMENT_REQUESTS_VIEW);
            }
            case SEND_PAYMENT_REQUEST_TO_SYSTEM: {
                return this.hasPermission(Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM);
            }
            case SEND_PAYMENT_REQUEST_TO_USER: {
                return this.hasPermission(Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER);
            }
            case MANAGE_PASSWORDS: {
                return this.hasPermission(Permission.MY_PASSWORDS_MANAGE);
            }
            case VIEW_ADVERTISEMENTS: {
                return this.hasPermission(Permission.USER_ADS_VIEW, Permission.USER_WEB_SHOP_VIEW);
            }
            case PURCHASES: {
                return this.hasPermission(Permission.USER_WEB_SHOP_PURCHASE);
            }
        }
        throw new IllegalArgumentException("Unsupported mobile operation: " + String.valueOf(mobileOperation));
    }

    private boolean onlyHomeContentIsNeeded(SessionData sessionData) {
        FieldSelector fieldSelector = sessionData.getRequestData().getFields();
        Collection collection = fieldSelector == null ? null : fieldSelector.getFields();
        return CollectionHelper.size((Collection)collection) == 1 && HOME_PAGE_USER_DATA_FIELD.equals(CollectionHelper.first((Iterable)collection));
    }
}

