/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search;

import java.util.List;
import java.util.function.Supplier;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.User;
import org.cyclos.impl.search.DelegatingEntitySearchHandlerImpl;
import org.cyclos.impl.search.RecordCountResult;
import org.cyclos.impl.search.RecordSearchHandler;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RecordSearchHandlerFactoryBean
extends AbstractFactoryBean<RecordSearchHandler> {
    @Autowired
    @Lazy
    private SearchHandler searchHandler;

    public Class<?> getObjectType() {
        return RecordSearchHandler.class;
    }

    protected RecordSearchHandler createInstance() throws Exception {
        return new DelegatingRecordSearchHandlerImpl(() -> ((SearchHandler)this.searchHandler).record());
    }

    private static class DelegatingRecordSearchHandlerImpl
    extends DelegatingEntitySearchHandlerImpl<Record, RecordQuery, RecordVO, RecordSearchHandler>
    implements RecordSearchHandler {
        public DelegatingRecordSearchHandlerImpl(Supplier<RecordSearchHandler> supplier) {
            super(supplier);
        }

        public List<RecordCountResult> counts(User user) {
            return ((RecordSearchHandler)this.delegate()).counts(user);
        }
    }
}

