/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search;

import java.util.function.Supplier;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.impl.search.DelegatingEntitySearchHandlerImpl;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TransactionSearchHandlerFactoryBean
extends AbstractFactoryBean<TransactionSearchHandler> {
    @Autowired
    @Lazy
    private SearchHandler searchHandler;

    public Class<?> getObjectType() {
        return TransactionSearchHandler.class;
    }

    protected TransactionSearchHandler createInstance() throws Exception {
        return new DelegatingTransactionSearchHandlerImpl(() -> ((SearchHandler)this.searchHandler).transaction());
    }

    private static class DelegatingTransactionSearchHandlerImpl
    extends DelegatingEntitySearchHandlerImpl<Transaction, TransactionOverviewQuery, TransactionResultVO, TransactionSearchHandler>
    implements TransactionSearchHandler {
        public DelegatingTransactionSearchHandlerImpl(Supplier<TransactionSearchHandler> supplier) {
            super(supplier);
        }

        public DataIterator<Transaction> export(TransactionQuery transactionQuery) {
            return ((TransactionSearchHandler)this.delegate()).export(transactionQuery);
        }

        public Page<TransactionResultVO> searchTransactions(TransactionQuery transactionQuery) {
            return ((TransactionSearchHandler)this.delegate()).searchTransactions(transactionQuery);
        }
    }
}

