/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search;

import java.util.Map;
import java.util.function.Supplier;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.User;
import org.cyclos.impl.search.DelegatingEntitySearchHandlerImpl;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.sql.AccountStatusUpdateResult;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserSearchHandlerFactoryBean
extends AbstractFactoryBean<UserSearchHandler> {
    @Autowired
    @Lazy
    private SearchHandler searchHandler;

    public Class<?> getObjectType() {
        return UserSearchHandler.class;
    }

    protected UserSearchHandler createInstance() throws Exception {
        return new DelegatingUserSearchHandlerImpl(() -> ((SearchHandler)this.searchHandler).user());
    }

    private static class DelegatingUserSearchHandlerImpl
    extends DelegatingEntitySearchHandlerImpl<User, UserQuery, UserWithFieldsVO, UserSearchHandler>
    implements UserSearchHandler {
        public DelegatingUserSearchHandlerImpl(Supplier<UserSearchHandler> supplier) {
            super(supplier);
        }

        public DataIterator<UserWithBalanceVO> exportWithBalances(UserWithBalanceQuery userWithBalanceQuery) {
            return ((UserSearchHandler)this.delegate()).exportWithBalances(userWithBalanceQuery);
        }

        public UsersWithBalancesOverview getBalancesOverview(UserWithBalanceQuery userWithBalanceQuery) {
            return ((UserSearchHandler)this.delegate()).getBalancesOverview(userWithBalanceQuery);
        }

        public void onBrokerChange(User user) {
            ((UserSearchHandler)this.delegate()).onBrokerChange(user);
        }

        public void onGroupChange(User user) {
            ((UserSearchHandler)this.delegate()).onGroupChange(user);
        }

        public Page<UserWithBalanceVO> searchWithBalances(UserWithBalanceQuery userWithBalanceQuery) {
            return ((UserSearchHandler)this.delegate()).searchWithBalances(userWithBalanceQuery);
        }

        public void updateBalances(Map<UserAccount, AccountStatusUpdateResult> map) {
            ((UserSearchHandler)this.delegate()).updateBalances(map);
        }

        public void updateLastLogin(User user) {
            ((UserSearchHandler)this.delegate()).updateLastLogin(user);
        }

        public void updateUserFields(User user, boolean bl) {
            ((UserSearchHandler)this.delegate()).updateUserFields(user, bl);
        }
    }
}

