/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.QBasicAd;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.search.AdSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.search.opensearch.OpenSearchEntitySearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.advertisements.AdOrderBy;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.AdvertisementVO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.users.addresses.AdAddressResult;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class OpenSearchAdSearchHandlerImpl
extends OpenSearchEntitySearchHandlerImpl<BasicAd, BasicAdQuery, BasicAdVO>
implements AdSearchHandler {
    private static final String INDEX = "ads";
    public static final String VERSION = "10";
    private static final String PARENT_CATEGORIES = "parentCategories";
    private static final String CURRENCY = "currency";
    private static final String PROMOTIONAL_PERIOD = "promotionalPeriod";
    private static final String HAS_IMAGE = "hasImage";
    @Autowired
    @Lazy
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    @Lazy
    private AdServiceSecurity adServiceSecurity;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private CurrencyServiceLocal currencyService;
    @Autowired
    @Lazy
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    @Lazy
    private BrokeringServiceLocal brokeringService;

    public OpenSearchAdSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl) {
        super(openSearchHandlerImpl, BasicAd.class, QBasicAd.basicAd);
    }

    public String indexName() {
        return INDEX;
    }

    @Override
    public String indexVersion() {
        return VERSION;
    }

    @Override
    protected DBQuery<Long> allIdsToIndexQuery() {
        QBasicAd qBasicAd = (QBasicAd)this.$;
        return (DBQuery)super.allIdsToIndexQuery().where((Predicate)qBasicAd.deletedDate.isNull());
    }

    @Override
    protected void fillSource(BasicAd basicAd, SourceAccessor sourceAccessor) {
        User user = basicAd.getOwner();
        HashSet hashSet = new HashSet();
        basicAd.getCategories().forEach(adCategory -> this.collectParentCategories(hashSet, (AdCategory)adCategory));
        sourceAccessor.set((Property<?, ?>)BasicAdVO.TYPE, (Object)basicAd.getType());
        sourceAccessor.set((Property<?, ?>)BasicAdVO.PUBLICATION_PERIOD, (Object)basicAd.getPublicationPeriod());
        sourceAccessor.set((Property<?, ?>)BasicAdVO.CATEGORIES, (Object)basicAd.getCategories());
        sourceAccessor.set(PARENT_CATEGORIES, hashSet);
        sourceAccessor.set((Property<?, ?>)BasicAdVO.IMAGE, (Object)SourceAccessor.from((Image)basicAd.getImage()));
        sourceAccessor.set(HAS_IMAGE, (Object)(basicAd.getImage() != null ? 1 : 0));
        sourceAccessor.set((Property<?, ?>)BasicAdDTO.CREATION_DATE, (Object)basicAd.getCreationDate());
        sourceAccessor.set((Property<?, ?>)BasicAdVO.STATUS, (Object)basicAd.getStatus());
        sourceAccessor.setOwnerUser(user, null);
        sourceAccessor.set((BasicUser)user, BasicAdVO.NAME, basicAd.getName(), ValueMatch.LANGUAGE, false);
        sourceAccessor.set((BasicUser)user, (Property<?, ?>)BasicAdVO.DESCRIPTION, basicAd.getDescription(), ValueMatch.LANGUAGE, true);
        CurrencyAmount currencyAmount = basicAd.getPrice();
        if (currencyAmount != null) {
            sourceAccessor.set(CURRENCY, (Object)currencyAmount.getCurrency());
            sourceAccessor.set((Property<?, ?>)BasicAdVO.PRICE, (Object)currencyAmount.getAmount());
            sourceAccessor.set((Property<?, ?>)BasicAdVO.PROMOTIONAL_PRICE, (Object)basicAd.getPromotionalPrice());
            sourceAccessor.set(PROMOTIONAL_PERIOD, (Object)basicAd.getPromotionalPeriod());
        }
        if (basicAd instanceof AdWebShop) {
            AdWebShop adWebShop = (AdWebShop)basicAd;
            sourceAccessor.set((Property<?, ?>)AdWebShopVO.ALLOW_DECIMAL, (Object)adWebShop.isAllowDecimal());
            sourceAccessor.set((Property<?, ?>)AdWebShopVO.MIN_ALLOWED_IN_CART, (Object)adWebShop.getMinAllowedInCart());
            sourceAccessor.set((Property<?, ?>)AdWebShopVO.MAX_ALLOWED_IN_CART, (Object)adWebShop.getMaxAllowedInCart());
            sourceAccessor.set((Property<?, ?>)AdWebShopVO.PRODUCT_NUMBER, (Object)adWebShop.getProductNumber());
            sourceAccessor.set((Property<?, ?>)AdWebShopVO.STOCK_TYPE, (Object)adWebShop.getStockType());
            sourceAccessor.set((Property<?, ?>)AdWebShopVO.STOCK_QUANTITY, (Object)adWebShop.getStockQuantity());
        }
        sourceAccessor.setCustomValues((BasicUser)user, basicAd, null);
        sourceAccessor.set("addresses", basicAd.getAddresses().stream().map(userAddress -> SourceAccessor.from((GeoLocatedAddress)userAddress, this.contactInfoFieldService.listForMap())).collect(Collectors.toList()));
        sourceAccessor.set("adAddresses", basicAd.getAdAddresses().stream().map(adAddress -> SourceAccessor.from((GeoLocatedAddress)adAddress, null)).collect(Collectors.toList()));
    }

    @Override
    protected ResultsCollector<BasicAdQuery, BasicAdVO> resultsCollector(BasicAdQuery basicAdQuery2) {
        Set<Long> set = this.getFavoriteIds(basicAdQuery2);
        return (basicAdQuery, list, searchHit) -> this.collectBasicAdVOs((BasicAdQuery)basicAdQuery, list, searchHit, set);
    }

    @Override
    protected List<SortBuilder<?>> toSort(BasicAdQuery basicAdQuery) {
        AdOrderBy adOrderBy = (AdOrderBy)ObjectHelper.defaultValue((Object)basicAdQuery.getOrderBy(), (Object)InvocationContext.getSessionData().getConfiguration().getAdsSortOrder());
        if (adOrderBy == AdOrderBy.RELEVANCE && StringHelper.isBlank((Object)basicAdQuery.getKeywords()) || adOrderBy == AdOrderBy.DISTANCE && !ModelHelper.isValid((DistanceDTO)basicAdQuery.getDistance())) {
            adOrderBy = AdOrderBy.DATE;
        }
        switch (adOrderBy) {
            case PRICE_HIGHEST: 
            case PRICE_LOWEST: {
                SortOrder sortOrder = adOrderBy == AdOrderBy.PRICE_HIGHEST ? SortOrder.DESC : SortOrder.ASC;
                return Collections.singletonList(((FieldSortBuilder)SortBuilders.fieldSort((String)BasicAdVO.PRICE.getName()).order(sortOrder)).unmappedType("float"));
            }
            case DATE: {
                return Collections.singletonList(SortBuilders.fieldSort((String)BasicAdDTO.CREATION_DATE.getName()).order(SortOrder.DESC));
            }
            case DISTANCE: {
                String string = GeoLocatedAddressVO.LOCATION.getName();
                LatLongDTO latLongDTO = basicAdQuery.getDistance().getLocation();
                double d = latLongDTO.getLatitude().doubleValue();
                double d2 = latLongDTO.getLongitude().doubleValue();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("lat", d);
                hashMap.put("lon", d2);
                hashMap.put("suffix", string);
                return Arrays.asList(SortBuilders.geoDistanceSort((String)("addresses." + string), (double)d, (double)d2).setNestedSort(new NestedSortBuilder("addresses")).order(SortOrder.ASC), SortBuilders.geoDistanceSort((String)("adAddresses." + string), (double)d, (double)d2).setNestedSort(new NestedSortBuilder("adAddresses")).order(SortOrder.ASC));
            }
        }
        return null;
    }

    @Override
    protected QueryBuilder toWhere(BasicAdQuery basicAdQuery) {
        BigDecimal bigDecimal;
        String string2;
        Object object;
        DateTime dateTime;
        TimeIntervalDTO timeIntervalDTO;
        HashMap<Object, Object> hashMap;
        Collection<Object> collection;
        SessionData sessionData = InvocationContext.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        User user = sessionData.getLoggedUser();
        Set set = this.conversionHandler.convertSet(User.class, (Iterable)basicAdQuery.getBrokers());
        boolean bl = sessionData.isBroker() && set.size() == 1 && set.contains(sessionData.getLoggedUser());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)basicAdQuery.getOwner());
        List list = this.adCustomFieldService.listVisible(user2, sessionData.isAdmin() || bl);
        list.removeIf(adCustomField -> !adCustomField.isAllowedAsSearchFilter());
        boolean bl2 = sessionData.isBroker() && set.size() == 1 && sessionData.getLoggedUser().equals(CollectionHelper.first((Iterable)set));
        QueryAccessor queryAccessor = new QueryAccessor();
        this.visibility(queryAccessor).others();
        AdCategory adCategory = (AdCategory)this.conversionHandler.convert(AdCategory.class, (Object)basicAdQuery.getCategory());
        if (adCategory != null) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)BasicAdVO.CATEGORIES.getName(), (Object)adCategory.getId())).should((QueryBuilder)QueryBuilders.termQuery((String)PARENT_CATEGORIES, (Object)adCategory.getId())));
        } else {
            collection = this.adCategoryService.listVisible(user).stream().map(EntityModel::getId).collect(Collectors.toList());
            if (CollectionHelper.isEmpty(collection)) {
                queryAccessor.invalid();
            } else {
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)BasicAdVO.CATEGORIES.getName(), collection)).should((QueryBuilder)QueryBuilders.termsQuery((String)PARENT_CATEGORIES, collection)));
            }
        }
        queryAccessor.enums((Property<?, ?>)BasicAdVO.TYPE, (Collection<? extends Enum<?>>)CollectionHelper.asSet((Object[])new AdType[]{basicAdQuery.getType()}));
        if (CollectionHelper.isNotEmpty((Iterable)basicAdQuery.getStatuses())) {
            collection = new HashSet(basicAdQuery.getStatuses());
            if (collection.contains(AdStatus.ACTIVE) || collection.contains(AdStatus.EXPIRED)) {
                collection.add(AdStatus.SCHEDULED);
                collection.add(AdStatus.ACTIVE);
            }
            queryAccessor.enums((Property<?, ?>)BasicAdVO.STATUS, (Collection<? extends Enum<?>>)collection);
            hashMap = new HashMap<String, Object>();
            hashMap.put("now", System.currentTimeMillis());
            hashMap.put("statuses", basicAdQuery.getStatuses().stream().map(Enum::name).collect(Collectors.toSet()));
            queryAccessor.script(this.loadScript("ads-filter-status", hashMap));
        }
        if (user != null && !user.equals((Object)user2)) {
            queryAccessor.mustNot((QueryBuilder)QueryBuilders.termQuery((String)BasicAdVO.STATUS.getName(), (String)AdStatus.DRAFT.name()));
        }
        queryAccessor.enums("userStatus", Arrays.asList(UserStatus.ACTIVE, UserStatus.BLOCKED));
        if (user2 != null) {
            queryAccessor.must((QueryBuilder)QueryBuilders.termQuery((String)"owner", (String)user2.getId().toString()));
        }
        if (StringHelper.isNotBlank((Object)basicAdQuery.getKeywords())) {
            collection = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.AD_KEYWORDS, bl, null);
            hashMap = new HashMap<String, Float>(this.fieldWeights(collection));
            hashMap.putAll(this.fieldWeights(list));
            OpenSearchAccessor.languageSuffixes((BasicUser)user).forEach(string -> {
                hashMap.put(OpenSearchAccessor.suffix(BasicAdVO.NAME.getName(), string), Float.valueOf(2.5f));
                hashMap.put(OpenSearchAccessor.suffix(BasicAdVO.DESCRIPTION.getName(), string), Float.valueOf(2.0f));
            });
            HashSet<String> hashSet = new HashSet<String>(this.exactMatchNames(collection));
            hashSet.addAll(this.exactMatchNames(list));
            queryAccessor.keywords(basicAdQuery.getKeywords(), hashMap, hashSet, collection.contains(BasicProfileField.PHONE));
        }
        if (basicAdQuery.isHasImages()) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)HAS_IMAGE, (boolean)true));
        }
        queryAccessor.customFields(AdCustomField.class, basicAdQuery.getAdCustomValues(), adCustomField -> list.contains(adCustomField) && (sessionData.isSystem() || adCustomField.isShowInSearch()));
        collection = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.AD_FILTER, bl, null);
        queryAccessor.user(collection, basicAdQuery.getUserProfileFields(), basicAdQuery.getGroups(), basicAdQuery.getBrokers(), null, null);
        hashMap = basicAdQuery.getAddressResult();
        boolean bl3 = hashMap == AdAddressResult.ALL_LOCATED_ADDRESSES || hashMap == AdAddressResult.NEAREST_ADDRESS;
        QueryBuilder queryBuilder = QueryAccessor.toAddressesQueryBuilder(basicAdQuery.getDistance(), bl3, bl3, "addresses");
        if (queryBuilder != null) {
            timeIntervalDTO = QueryAccessor.toAddressesQueryBuilder(basicAdQuery.getDistance(), bl3, bl3, "adAddresses");
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should(queryBuilder).should((QueryBuilder)timeIntervalDTO));
        }
        if ((timeIntervalDTO = basicAdQuery.getPublishedSince()) != null && timeIntervalDTO.getField() != null && timeIntervalDTO.getAmount() != null) {
            dateTime = this.conversionHandler.toDateTime(DateHelper.subtract((Date)new Date(), (ITimeInterval)timeIntervalDTO));
            queryAccessor.period(OpenSearchAccessor.periodBegin(BasicAdVO.PUBLICATION_PERIOD), (IDatePeriod)ModelHelper.datePeriod((DateTime)dateTime, null));
        }
        queryAccessor.period(OpenSearchAccessor.periodBegin(BasicAdVO.PUBLICATION_PERIOD), (IDatePeriod)basicAdQuery.getPublicationPeriod());
        queryAccessor.period(OpenSearchAccessor.periodEnd(BasicAdVO.PUBLICATION_PERIOD), (IDatePeriod)basicAdQuery.getExpirationPeriod());
        dateTime = (Currency)this.conversionHandler.convert(Currency.class, (Object)basicAdQuery.getCurrency());
        if (dateTime != null) {
            queryAccessor.entities(CURRENCY, (Collection<? extends SimpleEntity>)CollectionHelper.asSet((Object[])new Currency[]{dateTime}));
        }
        boolean bl4 = sessionData.isMember() && !bl2;
        Set set2 = SimpleEntity.uniqueIds((Collection)this.currencyService.listForAds(null));
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)CURRENCY)));
        if (!set2.isEmpty()) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)CURRENCY, (Collection)set2));
        }
        if (user != null && bl4 && basicUser.isBroker() && !(object = this.brokeringService.listBrokeredIds(user)).isEmpty()) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"owner", (Collection)object));
        }
        queryAccessor.filter((QueryBuilder)boolQueryBuilder);
        object = basicAdQuery.getPriceRange();
        if (object != null) {
            string2 = (Currency)this.conversionHandler.convert(Currency.class, (Object)object.getCurrency());
            if (string2 != null) {
                queryAccessor.entities(CURRENCY, (Collection<? extends SimpleEntity>)CollectionHelper.asSet((Object[])new Currency[]{string2}));
            }
            bigDecimal = object.getMin();
            BigDecimal bigDecimal2 = object.getMax();
            if (bigDecimal != null || bigDecimal2 != null) {
                double d;
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("now", System.currentTimeMillis());
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)BasicAdVO.PRICE.getName());
                RangeQueryBuilder rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)BasicAdVO.PROMOTIONAL_PRICE.getName());
                if (bigDecimal != null) {
                    d = bigDecimal.doubleValue();
                    rangeQueryBuilder.from((Object)d);
                    rangeQueryBuilder2.from((Object)d);
                    hashMap2.put("min", d);
                }
                if (bigDecimal2 != null) {
                    d = bigDecimal2.doubleValue();
                    rangeQueryBuilder.to((Object)d);
                    rangeQueryBuilder2.to((Object)d);
                    hashMap2.put("max", d);
                }
                queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)rangeQueryBuilder).should((QueryBuilder)rangeQueryBuilder2));
                queryAccessor.script(this.loadScript("ads-filter-price", hashMap2));
            }
        }
        if (StringHelper.isNotBlank((Object)(string2 = basicAdQuery.getProductNumber()))) {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)AdWebShopVO.PRODUCT_NUMBER.getName(), (String)string2));
        }
        if (basicAdQuery.getFavoritesFor() != null) {
            bigDecimal = (User)this.conversionHandler.convert(User.class, (Object)basicAdQuery.getFavoritesFor());
            queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)EntityVO.ID.getName(), this.getFavoriteIds((BasicUser)bigDecimal)));
        }
        if (basicAdQuery.getOrderBy() == AdOrderBy.RANDOM) {
            queryAccessor.randomScore();
        }
        return queryAccessor.queryBuilder();
    }

    private void collectBasicAdVOs(BasicAdQuery basicAdQuery, List<BasicAdVO> list, SearchHit searchHit, Set<Long> set) {
        SessionData sessionData = InvocationContext.getSessionData();
        BasicAdVO basicAdVO = this.toBasicAdVO(basicAdQuery, searchHit, set);
        AdAddressResult adAddressResult = (AdAddressResult)ObjectHelper.defaultValue((Object)basicAdQuery.getAddressResult(), (Object)AdAddressResult.NO_ADDRESSES);
        DistanceDTO distanceDTO = basicAdQuery.getDistance();
        LatLongDTO latLongDTO = ModelHelper.isValid((DistanceDTO)distanceDTO) ? distanceDTO.getLocation() : null;
        Double d = latLongDTO == null ? null : Double.valueOf(distanceDTO.getDistance().doubleValue());
        List list2 = (List)searchHit.getSourceAsMap().get("addresses");
        List list3 = list2 == null ? new ArrayList() : list2;
        list3.addAll(CollectionHelper.orEmpty((List)((List)searchHit.getSourceAsMap().get("adAddresses"))));
        if (adAddressResult == AdAddressResult.NO_ADDRESSES) {
            list.add(basicAdVO);
        } else {
            boolean bl = sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
            List<UserAddressVO> list4 = list3.stream().map(map -> new SourceAccessor((Map<String, Object>)map).asUserAddressVO(sessionData, latLongDTO, this.contactInfoFieldService.listForMap())).filter(userAddressVO -> bl || !userAddressVO.isHidden()).collect(Collectors.toList());
            if (adAddressResult == AdAddressResult.NEAREST_ADDRESS) {
                list4.stream().filter(userAddressVO -> userAddressVO.getCurrentDistance() != null).sorted(Comparator.comparing(GeoLocatedAddressVO::getCurrentDistance)).findFirst().ifPresent(arg_0 -> ((BasicAdVO)basicAdVO).setAddress(arg_0));
                list.add(basicAdVO);
            } else {
                if (d != null) {
                    list4.removeIf(userAddressVO -> userAddressVO.getCurrentDistance() == null || userAddressVO.getCurrentDistance() > d);
                }
                if (list4.size() == 1) {
                    basicAdVO.setAddress((UserAddressVO)CollectionHelper.first(list4));
                    list.add(basicAdVO);
                } else {
                    list4.forEach(userAddressVO -> {
                        BasicAdVO basicAdVO2 = (BasicAdVO)ClassHelper.instantiate(basicAdVO.getClass());
                        basicAdVO.copyPropertiesTo((Bean)basicAdVO2);
                        basicAdVO2.setAddress(userAddressVO);
                        list.add(basicAdVO2);
                    });
                }
            }
        }
    }

    private void collectParentCategories(Set<AdCategory> set, AdCategory adCategory) {
        while (adCategory.getParent() != null) {
            AdCategory adCategory2 = adCategory.getParent();
            if (adCategory2 != null) {
                set.add(adCategory2);
            }
            adCategory = adCategory2;
        }
    }

    private Set<Long> getFavoriteIds(BasicAdQuery basicAdQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        if (!sessionData.isMember()) {
            return Collections.emptySet();
        }
        User user = (User)this.conversionHandler.convert(User.class, (Object)basicAdQuery.getOwner());
        if (sessionData.getLoggedUser().equals((Object)user)) {
            return Collections.emptySet();
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        return this.getFavoriteIds(basicUser);
    }

    private Set<Long> getFavoriteIds(BasicUser basicUser) {
        QBasicUser qBasicUser = QBasicUser.basicUser;
        QBasicAd qBasicAd = QBasicAd.basicAd;
        return ((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qBasicUser}).join((CollectionExpression)qBasicUser.favoriteAds, (Path)qBasicAd)).where((Predicate)qBasicUser.eq((Object)basicUser))).set((Expression)qBasicAd.id);
    }

    private BasicAdVO toBasicAdVO(BasicAdQuery basicAdQuery, SearchHit searchHit, Set<Long> set) {
        BigDecimal bigDecimal;
        AdvertisementVO advertisementVO;
        boolean bl;
        User user;
        Object object;
        int n;
        AdWebShopVO adWebShopVO;
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        AdType adType = sourceAccessor.getAsEnum(AdType.class, BasicAdVO.TYPE);
        SessionData sessionData = InvocationContext.getSessionData();
        UserVO userVO = sourceAccessor.getAsUserVO(sessionData, this.userService, "user");
        Long l = sourceAccessor.getAsLong(CURRENCY);
        if (adType == AdType.WEB_SHOP) {
            adWebShopVO = new AdWebShopVO();
            n = sourceAccessor.getAsBoolean((Property<?, ?>)AdWebShopVO.ALLOW_DECIMAL);
            int n2 = n != 0 ? 2 : 0;
            adWebShopVO.setAllowDecimal(n != 0);
            adWebShopVO.setMinAllowedInCart(sourceAccessor.getAsBigDecimal((Property<?, ?>)AdWebShopVO.MIN_ALLOWED_IN_CART, n2));
            adWebShopVO.setMaxAllowedInCart(sourceAccessor.getAsBigDecimal((Property<?, ?>)AdWebShopVO.MAX_ALLOWED_IN_CART, n2));
            adWebShopVO.setProductNumber(sourceAccessor.getAsString((Property<?, ?>)AdWebShopVO.PRODUCT_NUMBER));
            adWebShopVO.setStockType(sourceAccessor.getAsEnum(AdWebShopStockType.class, AdWebShopVO.STOCK_TYPE));
            adWebShopVO.setStockQuantity(sourceAccessor.getAsBigDecimal((Property<?, ?>)AdWebShopVO.STOCK_QUANTITY, n2));
            adWebShopVO.setInStock(AdWebShop.isInStock((AdWebShopStockType)adWebShopVO.getStockType(), (BigDecimal)adWebShopVO.getStockQuantity()));
            object = sessionData.getLoggedUser();
            user = (User)this.conversionHandler.convert(User.class, (Object)userVO);
            bl = SimpleEntity.uniqueIds((Collection)this.currencyService.listForAds(user, false)).contains(l);
            boolean bl2 = object != null && adWebShopVO.isInStock() && sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASE) && !object.equals((Object)user) && bl;
            adWebShopVO.setCanAddToCart(bl2);
            advertisementVO = adWebShopVO;
        } else {
            advertisementVO = new AdvertisementVO();
        }
        advertisementVO.setId(Long.valueOf(searchHit.getId()));
        advertisementVO.setType(adType);
        advertisementVO.setCategories((Set)sourceAccessor.getAsEntityVOs(AdCategory.class, AdCategoryVO.class, (Property<?, ?>)BasicAdVO.CATEGORIES, HashSet::new));
        advertisementVO.setImage(sourceAccessor.getAsImageVO((Property<?, ?>)BasicAdVO.IMAGE));
        advertisementVO.setPublicationPeriod(sourceAccessor.getAsDatePeriodDTO((Property<?, ?>)BasicAdVO.PUBLICATION_PERIOD));
        advertisementVO.setStatus(BasicAd.getActualStatus((DatePeriod)((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)advertisementVO.getPublicationPeriod())), (boolean)false, null, (AdStatus)sourceAccessor.getAsEnum(AdStatus.class, BasicAdVO.STATUS)));
        advertisementVO.setCreationDate(sourceAccessor.getAsDateTime((Property<?, ?>)BasicAdVO.CREATION_DATE));
        if (sessionData.isLoggedIn() || !sessionData.getConfiguration().isHideAdOwnerToGuests()) {
            advertisementVO.setOwner(userVO);
        }
        advertisementVO.setName(sourceAccessor.getAsString(SourceAccessor.ignoredSuffix(BasicAdVO.NAME.getName())));
        advertisementVO.setDescription(sourceAccessor.getAsString(SourceAccessor.ignoredSuffix(BasicAdVO.DESCRIPTION.getName())));
        if ((sessionData.isLoggedIn() || !sessionData.getConfiguration().isHideAdPriceToGuests()) && (adWebShopVO = sourceAccessor.getAsEntityVO(Currency.class, CurrencyVO.class, CURRENCY)) != null && (bigDecimal = sourceAccessor.getAsBigDecimal((Property<?, ?>)BasicAdVO.PRICE, n = adWebShopVO.getPrecision())) != null) {
            advertisementVO.setPrice(ModelHelper.currencyAmount((CurrencyVO)adWebShopVO, (BigDecimal)bigDecimal));
            object = sourceAccessor.getAsBigDecimal((Property<?, ?>)BasicAdVO.PROMOTIONAL_PRICE, n);
            advertisementVO.setPromotionalPrice((BigDecimal)object);
            if (object == null) {
                advertisementVO.setCurrentPrice(bigDecimal);
            } else {
                user = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)sourceAccessor.getAsDatePeriodDTO(PROMOTIONAL_PERIOD));
                bl = user != null && user.includes(new Date());
                advertisementVO.setPromotionalPeriodActive(bl);
                advertisementVO.setCurrentPrice((BigDecimal)(bl ? object : bigDecimal));
            }
        }
        if (basicAdQuery.isReturnEditable()) {
            adWebShopVO = (User)this.rawEntityManagerHandler.find(User.class, advertisementVO.getOwner().getId());
            advertisementVO.setEditable(this.adServiceSecurity.hasManageAccess(null, advertisementVO.getStatus(), advertisementVO.getStatus(), advertisementVO.getType(), (User)adWebShopVO));
        }
        advertisementVO.setFavoriteForViewer(set.contains(advertisementVO.getId()));
        return advertisementVO;
    }
}

