/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.Scroll;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;

public class OpenSearchCloseableIterator<QP extends QueryParameters, T>
implements DataIterator<T> {
    public static final String MISSING_SORT_FIELD = "missingSortField";
    private static final int SCROLL_THRESHOLD = 200;
    private static final int SCROLL_FETCH_SIZE = 1000;
    private final OpenSearchHandlerImpl searchHandler;
    private final QP params;
    private final ResultsCollector<QP, T> collector;
    private boolean skipTotalCount;
    private int currentPage;
    private int pageSize;
    private int fetchSize;
    private boolean useScroll;
    private boolean partialData;
    private String scrollId;
    private Scroll scroll;
    private SearchHits hits;
    private Long totalCount;
    private List<T> nextResults;
    private int result;

    public static boolean isPartialData(SearchResponse searchResponse) {
        return searchResponse.getFailedShards() > 0 || searchResponse.getSuccessfulShards() + searchResponse.getSkippedShards() < searchResponse.getTotalShards();
    }

    public OpenSearchCloseableIterator(SessionData sessionData, OpenSearchHandlerImpl openSearchHandlerImpl, String string, QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list, ResultsCollector<QP, T> resultsCollector, Consumer<SearchSourceBuilder> consumer) {
        this.searchHandler = openSearchHandlerImpl;
        this.params = QP;
        this.collector = resultsCollector;
        QueryHelper.ensurePageData(QP);
        this.currentPage = QP.getCurrentPage();
        this.pageSize = QP.getPageSize();
        this.useScroll = this.currentPage == 0 && this.pageSize > 200;
        Scroll scroll = this.scroll = this.useScroll ? new Scroll(TimeValue.timeValueMinutes((long)1L)) : null;
        this.skipTotalCount = this.pageSize == 0 ? false : sessionData.getConfiguration().isSkipTotalCount() || QP.isSkipTotalCount();
        this.fetchSize = this.skipTotalCount ? this.pageSize + 1 : this.pageSize;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(this.useScroll ? 1000 : this.fetchSize);
        searchSourceBuilder.from(this.currentPage * this.pageSize);
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.trackTotalHits(true);
        CollectionHelper.orEmpty(list).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
        if (consumer != null) {
            consumer.accept(searchSourceBuilder);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{string});
        searchRequest.source(searchSourceBuilder);
        if (this.useScroll) {
            searchRequest.scroll(this.scroll);
        }
        try {
            SearchResponse searchResponse = openSearchHandlerImpl.getClient().search(searchRequest, OpenSearchHandlerImpl.REQUEST_OPTIONS);
            this.scrollId = this.useScroll ? searchResponse.getScrollId() : null;
            this.hits = searchResponse.getHits();
            this.partialData = OpenSearchCloseableIterator.isPartialData(searchResponse);
            this.totalCount = this.hits.getTotalHits().value;
        }
        catch (OpenSearchStatusException openSearchStatusException) {
            if (this.isMaxResultWindow(openSearchStatusException) || Stream.of(openSearchStatusException.getSuppressed()).anyMatch(this::isMaxResultWindow)) {
                TranslationHandler translationHandler = (TranslationHandler)InvocationContext.bean(TranslationHandler.class);
                throw new ValidationException(translationHandler.message(GeneralKeys.Errors.SEARCH_OUT_OF_RANGE, new Object[0]));
            }
            if (this.isMissingSortField(openSearchStatusException) || Stream.of(openSearchStatusException.getSuppressed()).anyMatch(this::isMissingSortField)) {
                TranslationHandler translationHandler = (TranslationHandler)InvocationContext.bean(TranslationHandler.class);
                ValidationException validationException = new ValidationException(translationHandler.message(GeneralKeys.Errors.SEARCH_MISSING_SORT_FIELD, new Object[0]));
                validationException.setAttribute(MISSING_SORT_FIELD, (Object)true);
                throw validationException;
            }
            throw new UnexpectedDataAccessException("Error running OpenSearch query: " + String.valueOf(searchSourceBuilder), (Throwable)openSearchStatusException);
        }
        catch (Exception exception) {
            throw new UnexpectedDataAccessException("Error running OpenSearch query: " + String.valueOf(searchSourceBuilder), (Throwable)exception);
        }
        this.processHits();
    }

    public Page<T> asPage() {
        try (OpenSearchCloseableIterator openSearchCloseableIterator = this;){
            boolean bl;
            List list = new ArrayList();
            openSearchCloseableIterator.forEachRemaining(list::add);
            if (this.skipTotalCount) {
                boolean bl2 = bl = list.size() > this.pageSize;
                if (bl) {
                    list = list.subList(0, this.pageSize);
                }
            } else {
                int n = (int)(Math.ceil((double)this.totalCount.longValue() / (double)this.pageSize) - 1.0);
                bl = this.currentPage < n;
            }
            PageImpl pageImpl = new PageImpl(list, this.pageSize, this.currentPage, this.skipTotalCount ? null : Integer.valueOf(this.totalCount.intValue()), bl, this.isPartialData());
            return pageImpl;
        }
    }

    public void close() {
        if (this.scrollId != null) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(this.scrollId);
            this.searchHandler.scheduleClearScroll(clearScrollRequest, null, null);
            this.scrollId = null;
        }
    }

    public SearchHits getHits() {
        return this.hits;
    }

    public boolean hasNext() {
        return CollectionHelper.isNotEmpty(this.nextResults);
    }

    public boolean isPartialData() {
        return this.partialData;
    }

    public T next() {
        if (CollectionHelper.isEmpty(this.nextResults)) {
            throw new NoSuchElementException();
        }
        T t = this.nextResults.remove(0);
        ++this.result;
        if (this.result >= this.pageSize) {
            this.nextResults = null;
            this.close();
        } else if (this.nextResults.isEmpty() && this.useScroll) {
            this.fetchNext();
        }
        return t;
    }

    private void fetchNext() {
        SearchResponse searchResponse;
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(this.scrollId);
        searchScrollRequest.scroll(this.scroll);
        try {
            searchResponse = this.searchHandler.getClient().scroll(searchScrollRequest, OpenSearchHandlerImpl.REQUEST_OPTIONS);
        }
        catch (Exception exception) {
            throw new UnexpectedDataAccessException((Throwable)exception);
        }
        this.scrollId = searchResponse.getScrollId();
        this.hits = searchResponse.getHits();
        this.partialData |= OpenSearchCloseableIterator.isPartialData(searchResponse);
        if (CollectionHelper.isEmpty((Object[])this.hits.getHits())) {
            this.nextResults = null;
        } else {
            this.processHits();
        }
    }

    private boolean isMaxResultWindow(Throwable throwable) {
        String string = throwable == null ? null : throwable.getMessage();
        return string != null && string.contains("index.max_result_window");
    }

    private boolean isMissingSortField(Throwable throwable) {
        String string = throwable == null ? null : throwable.getMessage();
        return string != null && string.contains("No mapping found") && string.contains("in order to sort");
    }

    private void processHits() {
        this.nextResults = new ArrayList<T>(this.hits.getHits().length);
        for (SearchHit searchHit : this.hits.getHits()) {
            this.collector.collect(this.params, this.nextResults, searchHit);
        }
        this.collector.postProcess(this.params, this.nextResults);
    }
}

