/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.search.EntitySearchHandler;
import org.cyclos.impl.search.IndexEntitiesBackgroundTask;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.search.opensearch.OpenSearchCloseableIterator;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.OpenSearchUserVisibilityApplier;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.system.fields.HasValueMatch;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CloseableIteratorAdapter;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.core.CountRequest;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class OpenSearchEntitySearchHandlerImpl<E extends NetworkedEntity, Q extends QueryParameters, R>
implements EntitySearchHandler<E, Q, R> {
    private static final String VERSION_TOKEN = "VERSION_TOKEN";
    private static final String NUMBER_OF_SHARDS_TOKEN = "NUMBER_OF_SHARDS_TOKEN";
    private static final String NUMBER_OF_REPLICAS_TOKEN = "NUMBER_OF_REPLICAS_TOKEN";
    private static final Object META_FIELD = "_meta";
    private static Pattern INCLUDE = Pattern.compile("\\s*\\\"\\#include[^\\\"]*\\\"\\s*\\:\\s*\\\"([\\w\\.|:]+)\\\"");
    @Autowired
    protected CyclosProperties cyclosProperties;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    protected ProfileFieldHandler profileFieldHandler;
    @Autowired
    protected UserLocatorHandler userLocatorHandler;
    @Autowired
    @Lazy
    protected UserServiceLocal userService;
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected ProductsHandler productsHandler;
    @Autowired
    protected ConfigurationHandler configurationHandler;
    @Autowired
    protected GroupsHandler groupsHandler;
    @Autowired
    protected CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    protected ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    protected NativeQueryHandler nativeQueryHandler;
    @Autowired
    protected RecurringTaskHandler recurringTaskHandler;
    @Autowired
    protected JsonConverter jsonConverter;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    private TranslationHandler translationHandler;
    protected final RequestOptions requestOptions = OpenSearchHandlerImpl.REQUEST_OPTIONS;
    protected final OpenSearchHandlerImpl searchHandler;
    protected final Class<E> entityType;
    protected final EntityPath<E> $;
    protected final NumberPath<Long> idPath;
    protected Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, String> cachedScripts = new ConcurrentHashMap<String, String>();
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private AlertServiceLocal alertService;
    protected RestHighLevelClient client;

    public static String getCreateIndexSource(String string3, String string4, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        OpenSearchEntitySearchHandlerImpl.appendIndexSource(stringBuilder, string3, null, false);
        String[] stringArray = new String[]{VERSION_TOKEN, NUMBER_OF_SHARDS_TOKEN, NUMBER_OF_REPLICAS_TOKEN};
        Arrays.asList(stringArray).stream().filter(string -> stringBuilder.indexOf((String)string) < 0).findAny().ifPresent(string2 -> {
            throw new IllegalArgumentException("Invalid definition for index " + string3 + ": missing token: " + string2);
        });
        return StringUtils.replaceEach((String)stringBuilder.toString(), (String[])stringArray, (String[])new String[]{string4, String.valueOf(n), String.valueOf(n2)});
    }

    private static void appendIndexSource(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        String[] stringArray = OpenSearchEntitySearchHandlerImpl.readIndexSourceLines(string, bl);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            Matcher matcher = INCLUDE.matcher(string3);
            if (matcher.find()) {
                String[] stringArray2 = StringUtils.split((String)matcher.group(1), (String)":");
                OpenSearchEntitySearchHandlerImpl.appendIndexSource(stringBuilder, stringArray2[0], stringArray2.length == 1 ? null : stringArray2[1], true);
                if (!string3.contains(",")) continue;
                while (Character.isWhitespace(stringBuilder.charAt(stringBuilder.length() - 1))) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
                stringBuilder.append(",\n");
                continue;
            }
            if (i == 1 && StringHelper.isNotBlank((Object)string2)) {
                string3 = string3.replaceFirst("\"(\\w+)\"", "\"" + string2 + "\"");
            }
            stringBuilder.append(string3).append("\n");
        }
    }

    private static String[] readIndexSourceLines(String string, boolean bl) {
        String string2;
        String string3 = "/opensearch/" + string + ".json";
        try {
            string2 = StringHelper.trim((Object)ResourceHelper.readContent((String)string3));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't read resource " + string3, iOException);
        }
        if (bl) {
            string2 = StringHelper.removeStart((String)StringHelper.removeEnd((String)string2, (String)"}"), (String)"{");
        }
        return string2.split("[\\r\\n]+");
    }

    public OpenSearchEntitySearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl, Class<E> clazz, EntityPath<E> entityPath) {
        this.searchHandler = openSearchHandlerImpl;
        this.entityType = clazz;
        this.$ = entityPath;
        this.client = openSearchHandlerImpl.getClient();
        this.idPath = (NumberPath)FieldHelper.get(entityPath, (String)EntityVO.ID.getName());
    }

    public final Map<String, Object> entityToMap(E e) {
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set(EntityVO.ID.getName(), (Object)e.getId());
        sourceAccessor.set("network", (Object)e.getNetwork());
        this.fillSource(e, sourceAccessor);
        return sourceAccessor.map();
    }

    public DataIterator<E> exportEntities(Q q) {
        return this.idsToEntities(this.doExportIds((QueryParameters)q, this.toWhere(q), this.toSort(q)));
    }

    public void index(E e) {
        this.searchHandler.addEntityToIndex(this.indexName(), e.getId());
    }

    public String indexDescriptorName() {
        return this.indexName();
    }

    public abstract String indexVersion();

    @Deprecated
    public final DataIterator<E> iterateEntities(Q q) {
        return this.idsToEntities(this.doExportIds((QueryParameters)q, this.toWhere(q), this.toSort(q)));
    }

    @Deprecated
    public final DataIterator<Long> iterateIds(Q q) {
        return this.doExportIds((QueryParameters)q, this.toWhere(q), this.toSort(q));
    }

    public long reindex() {
        String string = this.indexName();
        long l = 0L;
        if (this.cyclosProperties.isTestingEnv()) {
            l = this.indexAll(() -> this.allIdsToIndexQuery());
        } else {
            this.removeScheduledIndexings();
            l = this.nativeQueryHandler.insertReindexBackgroundTasks(this.entityType, string, 50);
            this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
        }
        if (this.logReindex()) {
            if (l == 0L) {
                this.logger.info("No {} to index", (Object)string);
            } else {
                this.logger.info("Reindexing {} with {} background tasks", (Object)string, (Object)l);
            }
        }
        return l;
    }

    public void remove(Long l) {
        DeleteRequest deleteRequest = new DeleteRequest(this.indexName(), l.toString());
        this.searchHandler.scheduleDelete(deleteRequest, null, null);
    }

    public final Page<R> search(Q q) {
        Page<R> page = this.preExecuteSearch(q);
        if (page != null) {
            return page;
        }
        return this.search((QueryParameters)q, this.toWhere(q), this.toSort(q), (ResultsCollector)this.resultsCollector(q));
    }

    public final Page<E> searchEntities(Q q) {
        Page<R> page = this.preExecuteSearch(q);
        if (page != null) {
            return PageImpl.transformed(page, this::toEntity);
        }
        return this.search((QueryParameters)q, this.toWhere(q), this.toSort(q), (ResultsCollector)this.entityResultsCollector(q));
    }

    public boolean syncIndex() {
        Object object;
        CountRequest countRequest;
        GetMappingsRequest getMappingsRequest;
        boolean bl;
        String string = this.indexName();
        String string2 = this.indexVersion();
        try {
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{string});
            bl = this.client.indices().exists(getIndexRequest, this.requestOptions);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't check for OpenSearch index " + string, iOException);
        }
        boolean bl2 = false;
        if (bl) {
            try {
                getMappingsRequest = new GetMappingsRequest();
                getMappingsRequest.indices(new String[]{string});
                countRequest = this.client.indices().getMapping(getMappingsRequest, this.requestOptions);
                object = ((MappingMetadata)countRequest.mappings().get(string)).getSourceAsMap();
                Map map = (Map)object.get(META_FIELD);
                String string3 = map == null ? null : (String)map.get("version");
                bl2 = !string2.equalsIgnoreCase(string3);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Couldn't check index version " + string, iOException);
            }
        }
        if (bl2) {
            this.logger.info("The index version has changed, it must be recreated " + string);
            getMappingsRequest = new DeleteIndexRequest(string);
            try {
                this.client.indices().delete((DeleteIndexRequest)getMappingsRequest, this.requestOptions);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Couldn't delete index " + string, iOException);
            }
            bl = false;
        }
        if (!bl) {
            this.logger.info("Creating index " + string);
            getMappingsRequest = new CreateIndexRequest(string);
            try {
                int n = Integer.parseInt(this.cyclosProperties.getSearchHandlerProperties().getProperty("shards", "1"));
                int n2 = Integer.parseInt(this.cyclosProperties.getSearchHandlerProperties().getProperty("replicas", "1"));
                getMappingsRequest.source(OpenSearchEntitySearchHandlerImpl.getCreateIndexSource(this.indexDescriptorName(), string2, n, n2), XContentType.JSON);
                this.client.indices().create((CreateIndexRequest)getMappingsRequest, this.requestOptions);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Couldn't create index " + string, exception);
            }
        }
        boolean bl3 = false;
        if (bl) {
            try {
                countRequest = new CountRequest(new String[]{string});
                object = this.client.count(countRequest, this.requestOptions);
                bl3 = object.getCount() > 0L;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Couldn't get the number of documents on OpenSearch index " + string);
            }
        }
        if (!bl || !bl3) {
            if (this.cyclosProperties.isTestingEnv()) {
                this.reindex();
            } else {
                this.removeScheduledIndexings();
                this.backgroundTaskHandler.schedule(InlineScriptBackgroundTask.scheduling(this.getBeanName() + ".reindex()"));
            }
        }
        return bl;
    }

    public OpenSearchUserVisibilityApplier visibility(QueryAccessor queryAccessor) {
        return (OpenSearchUserVisibilityApplier)this.beanHandler.autowire((Object)new OpenSearchUserVisibilityApplier(queryAccessor));
    }

    protected DBQuery<Long> allIdsToIndexQuery() {
        return this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).select(this.idPath);
    }

    protected Consumer<SearchSourceBuilder> defaultSearchCustomizer() {
        return null;
    }

    protected <QP extends QueryParameters> DataIterator<E> doExportEntities(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list) {
        DataIterator<Long> dataIterator = this.doExportIds(QP, queryBuilder, list);
        return this.idsToEntities(dataIterator);
    }

    protected <QP extends QueryParameters> DataIterator<Long> doExportIds(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list2) {
        QueryHelper.applyExport(QP);
        ResultsCollector resultsCollector = (queryParameters, list, searchHit) -> list.add((Long)CoercionHelper.coerce(Long.class, (Object)searchHit.getId()));
        Consumer<SearchSourceBuilder> consumer = searchSourceBuilder -> searchSourceBuilder.fetchSource(false);
        return this.newIterator(QP, queryBuilder, list2, resultsCollector, consumer);
    }

    protected ResultsCollector<Q, E> entityResultsCollector(Q q) {
        return (queryParameters, list, searchHit) -> this.find((Long)CoercionHelper.coerce(Long.class, (Object)searchHit.getId()));
    }

    protected Set<String> exactMatchNames(Collection<? extends HasValueMatch> collection) {
        return CollectionHelper.orEmpty(collection).stream().filter(hasValueMatch -> hasValueMatch.getValueMatch() == ValueMatch.EXACT).map(OpenSearchAccessor::exactMatchFieldName).collect(Collectors.toSet());
    }

    protected <QP extends QueryParameters, T> OpenSearchCloseableIterator<QP, T> export(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list, ResultsCollector<QP, T> resultsCollector) {
        QueryHelper.applyExport(QP);
        return this.newIterator(QP, queryBuilder, list, resultsCollector, this.defaultSearchCustomizer());
    }

    protected Map<String, Float> fieldWeights(Collection<? extends HasValueMatch> collection) {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        for (HasValueMatch hasValueMatch : collection) {
            ValueMatch valueMatch = hasValueMatch.getValueMatch();
            if (valueMatch != ValueMatch.TEXT && valueMatch != ValueMatch.LANGUAGE) continue;
            float f = hasValueMatch == BasicProfileField.FULL_NAME ? 1.5f : 1.0f;
            String string = OpenSearchAccessor.baseName(hasValueMatch);
            if (valueMatch == ValueMatch.LANGUAGE) {
                for (String string2 : SourceAccessor.languageSuffixes(null)) {
                    hashMap.put(OpenSearchAccessor.suffix(string, string2), Float.valueOf(f));
                }
                continue;
            }
            boolean bl = hasValueMatch instanceof CustomField;
            hashMap.put(bl ? OpenSearchAccessor.textSuffix(string) : string, Float.valueOf(f));
        }
        return hashMap;
    }

    protected abstract void fillSource(E var1, SourceAccessor var2);

    protected E find(Long l) {
        return (E)((NetworkedEntity)this.rawEntityManagerHandler.find(this.entityType, l));
    }

    protected List<E> findAll(List<Long> list) {
        Map map = ((DBQuery)this.rawEntityManagerHandler.selectFrom(this.$).where((Predicate)this.idPath.in(list))).map(this.idPath, this.$);
        return list.stream().map(map::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected void generateAlertForPartialData() {
        this.invokerHandler.submitAsInParallelTransaction(InvocationContext.getSessionData(), TransactionLevel.READ_WRITE, transactionStatus -> this.alertService.create(SystemAlertType.PARTIAL_DATA_RETURNED, new Object[]{this.indexName()}));
    }

    protected String getBeanName() {
        return StringUtils.uncapitalize((String)StringUtils.removeEnd((String)StringUtils.removeStart((String)this.getClass().getSimpleName(), (String)"OpenSearch"), (String)"Impl"));
    }

    protected FormatterImpl getFormatter() {
        return InvocationContext.getFormatter(null);
    }

    protected long indexAll(Supplier<DBQuery<Long>> supplier) {
        String string = this.indexName();
        if (this.cyclosProperties.isTestingEnv()) {
            List list2 = supplier.get().fetch();
            this.searchHandler.performIndex(string, list2);
            return list2.size();
        }
        MutableLong mutableLong = new MutableLong();
        try (CloseableIterator closeableIterator = supplier.get().iterate();){
            Iterators.partition((Iterator)closeableIterator, (int)20).forEachRemaining(list -> {
                this.backgroundTaskHandler.schedule(new IndexEntitiesBackgroundTask.IndexEntitiesContext(string, (Collection<Long>)list).scheduling());
                mutableLong.add((long)list.size());
            });
        }
        return mutableLong.longValue();
    }

    protected <QP extends QueryParameters> DataIterator<E> iterateEntities(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list) {
        return this.idsToEntities(this.doExportIds(QP, queryBuilder, list));
    }

    protected Script loadScript(String string, Map<String, Object> map) {
        String string2 = this.cyclosProperties.isDevelopment() ? this.readScriptCode(string) : this.cachedScripts.computeIfAbsent(string, this::readScriptCode);
        return OpenSearchAccessor.newScript(string2, map);
    }

    protected boolean logReindex() {
        return true;
    }

    protected String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, messageKey, objectArray);
    }

    protected String message(MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageKey, objectArray);
    }

    protected Set<String> phoneNumberNames(Collection<? extends HasValueMatch> collection) {
        return CollectionHelper.orEmpty(collection).stream().filter(hasValueMatch -> BasicProfileField.PHONE == hasValueMatch).map(OpenSearchAccessor::storedFieldName).collect(Collectors.toSet());
    }

    protected Page<R> preExecuteSearch(Q q) {
        return null;
    }

    protected boolean processResponse(SearchResponse searchResponse) {
        boolean bl = OpenSearchCloseableIterator.isPartialData(searchResponse);
        if (bl) {
            this.generateAlertForPartialData();
        }
        return bl;
    }

    protected abstract ResultsCollector<Q, R> resultsCollector(Q var1);

    protected <QP extends QueryParameters, T> Page<T> search(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list, ResultsCollector<QP, T> resultsCollector) {
        return this.search(QP, queryBuilder, list, resultsCollector, this.defaultSearchCustomizer());
    }

    protected <QP extends QueryParameters, T> Page<T> search(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list, ResultsCollector<QP, T> resultsCollector, Consumer<SearchSourceBuilder> consumer) {
        return this.newIterator(QP, queryBuilder, list, resultsCollector, consumer).asPage();
    }

    protected E toEntity(R r) {
        return this.find(((IEntity)r).getId());
    }

    protected abstract List<SortBuilder<?>> toSort(Q var1);

    protected abstract QueryBuilder toWhere(Q var1);

    private DataIterator<E> idsToEntities(DataIterator<Long> dataIterator) {
        UnmodifiableIterator unmodifiableIterator = Iterators.partition(dataIterator, (int)200);
        Iterator iterator = Iterators.transform((Iterator)unmodifiableIterator, this::findAll);
        Iterator iterator2 = Iterators.transform((Iterator)iterator, Collection::iterator);
        return CloseableIteratorHelper.asDataIterator((CloseableIterator)new CloseableIteratorAdapter(Iterators.concat((Iterator)iterator2)), (boolean)dataIterator.isPartialData());
    }

    private <QP extends QueryParameters, T> OpenSearchCloseableIterator<QP, T> newIterator(QP QP, QueryBuilder queryBuilder, List<SortBuilder<?>> list, ResultsCollector<QP, T> resultsCollector, Consumer<SearchSourceBuilder> consumer) {
        OpenSearchCloseableIterator openSearchCloseableIterator = new OpenSearchCloseableIterator<QP, T>(InvocationContext.getSessionData(), this.searchHandler, this.indexName(), QP, queryBuilder, list, resultsCollector, consumer){

            @Override
            public void close() {
                super.close();
                if (this.isPartialData()) {
                    OpenSearchEntitySearchHandlerImpl.this.generateAlertForPartialData();
                }
            }
        };
        return openSearchCloseableIterator;
    }

    private String readScriptCode(String string) {
        String string2 = "/opensearch/" + string + ".painless";
        try {
            String string3 = ResourceHelper.readContent((String)string2);
            if (string3 == null) {
                throw new IllegalStateException("Script file not found: " + string2);
            }
            return string3;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private void removeScheduledIndexings() {
        QBackgroundTaskExecution qBackgroundTaskExecution = QBackgroundTaskExecution.backgroundTaskExecution;
        this.rawEntityManagerHandler.delete((EntityPath)qBackgroundTaskExecution).where(new Predicate[]{qBackgroundTaskExecution.className.eq((Object)IndexEntitiesBackgroundTask.class.getName()), qBackgroundTaskExecution.context.startsWith(this.indexName())}).execute();
    }
}

