/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QRecord;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.search.RecordCountResult;
import org.cyclos.impl.search.RecordSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.search.opensearch.OpenSearchEntitySearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SimpleResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.system.fields.HasValueMatch;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SystemRecordVO;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.aggregations.metrics.ValueCount;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class OpenSearchRecordSearchHandlerImpl
extends OpenSearchEntitySearchHandlerImpl<Record, RecordQuery, RecordVO>
implements RecordSearchHandler {
    private static final String INDEX = "records";
    public static final String VERSION = "8";
    private static final String SINGLE_RECORD_ID = "singleRecordId";
    @Autowired
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    @Lazy
    private RecordTypeServiceLocal recordTypeService;

    public OpenSearchRecordSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl) {
        super(openSearchHandlerImpl, Record.class, QRecord.record);
    }

    public List<RecordCountResult> counts(User user) {
        SearchResponse searchResponse;
        String string = RecordVO.TYPE.getName();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.indexName()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"owner", (Object)user.getId())).size(0).aggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)string).field(string)).subAggregation((AggregationBuilder)AggregationBuilders.count((String)"count").field(EntityVO.ID.getName()))).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"maxId").field(SINGLE_RECORD_ID))));
        try {
            searchResponse = this.client.search(searchRequest, this.requestOptions);
        }
        catch (IOException iOException) {
            throw new UnexpectedDataAccessException((Throwable)iOException);
        }
        this.processResponse(searchResponse);
        return ((Terms)searchResponse.getAggregations().get(string)).getBuckets().stream().map(this::toRecordCountResult).collect(Collectors.toList());
    }

    public String indexName() {
        return INDEX;
    }

    @Override
    public String indexVersion() {
        return VERSION;
    }

    @Override
    protected void fillSource(Record record, SourceAccessor sourceAccessor) {
        RecordType recordType = record.getType();
        User user = null;
        if (recordType.getResultsLayout() == RecordTypeResultsLayout.SINGLE_FORM) {
            sourceAccessor.set(SINGLE_RECORD_ID, (Object)record);
        }
        sourceAccessor.set((Property<?, ?>)RecordVO.DISPLAY, (Object)this.getFormatter().format(record));
        sourceAccessor.set((Property<?, ?>)RecordVO.TYPE, (Object)recordType);
        if (record instanceof UserRecord) {
            user = ((UserRecord)record).getUser();
            sourceAccessor.setOwnerUser(user, null);
        }
        sourceAccessor.set((Property<?, ?>)RecordVO.CREATED_BY, (Object)record.getCreatedBy());
        sourceAccessor.set((Property<?, ?>)RecordVO.CREATION_DATE, (Object)record.getCreationDate());
        sourceAccessor.set((Property<?, ?>)RecordVO.MODIFIED_BY, (Object)record.getModifiedBy());
        sourceAccessor.set((Property<?, ?>)RecordVO.LAST_MODIFIED_DATE, (Object)record.getLastModifiedDate());
        sourceAccessor.setCustomValues((BasicUser)user, record, null);
    }

    @Override
    protected ResultsCollector<RecordQuery, RecordVO> resultsCollector(RecordQuery recordQuery) {
        return SimpleResultsCollector.of(this::toRecordVO);
    }

    @Override
    protected List<SortBuilder<?>> toSort(RecordQuery recordQuery) {
        RecordCustomField recordCustomField;
        if (StringHelper.isNotBlank((Object)recordQuery.getKeywords())) {
            return null;
        }
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordQuery.getType());
        ArrayList arrayList = new ArrayList();
        if (recordType instanceof UserRecordType && ((UserRecordType)recordType).isSortByOwner()) {
            arrayList.add((SortBuilder<?>)SortBuilders.fieldSort((String)OpenSearchAccessor.sortFieldName(BasicProfileField.FULL_NAME)));
        }
        RecordCustomField recordCustomField2 = recordCustomField = recordType == null ? null : recordType.getSortField();
        if (recordCustomField != null) {
            String string = SourceAccessor.sortFieldName(recordCustomField);
            if (string != null) {
                arrayList.add(SortBuilders.fieldSort((String)string).order(SortOrder.ASC));
            }
        } else {
            arrayList.add(SortBuilders.fieldSort((String)RecordVO.CREATION_DATE.getName()).order(SortOrder.DESC));
        }
        return arrayList;
    }

    @Override
    protected QueryBuilder toWhere(RecordQuery recordQuery) {
        Collection<Object> collection;
        User user;
        SessionData sessionData = InvocationContext.getSessionData();
        QueryAccessor queryAccessor = new QueryAccessor();
        User user2 = null;
        UserRecordQuery userRecordQuery = null;
        boolean bl = recordQuery instanceof UserRecordQuery;
        boolean bl2 = false;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordQuery.getType());
        Set set = Collections.emptySet();
        if (bl) {
            userRecordQuery = (UserRecordQuery)recordQuery;
            user2 = (User)this.conversionHandler.convert(User.class, (Object)userRecordQuery.getUser());
            set = this.conversionHandler.convertSet(User.class, (Iterable)userRecordQuery.getBrokers());
            bl2 = user2 == null ? set.size() == 1 && set.contains(sessionData.getLoggedUser()) : sessionData.isBrokerOf((BasicUser)user2);
        }
        List list = this.recordFieldHandler.getAllVisibleCustomFieldsForQuery(recordQuery);
        list.removeIf(recordCustomField -> !recordCustomField.isAllowedAsSearchFilter());
        if (recordType == null) {
            if (userRecordQuery != null && userRecordQuery.isSharedRecordFieldSearch()) {
                user = this.recordTypeService.listVisibleSharedRecordTypes();
                collection = this.conversionHandler.convertSet(UserRecordType.class, (Iterable)userRecordQuery.getSharedRecordTypes());
                if (!collection.isEmpty()) {
                    user.retainAll(collection);
                }
                if (user.isEmpty()) {
                    queryAccessor.invalid();
                } else {
                    queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)RecordVO.TYPE.getName(), (Collection)SimpleEntity.uniqueIds(user)));
                }
            } else {
                queryAccessor.invalid();
            }
        } else {
            queryAccessor.filter((QueryBuilder)QueryBuilders.termQuery((String)RecordVO.TYPE.getName(), (Object)recordType.getId()));
        }
        if (StringHelper.isNotBlank((Object)recordQuery.getKeywords())) {
            user = recordType instanceof SystemRecordType ? new ArrayList() : this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.RECORD_KEYWORDS, bl2, null);
            collection = recordType == null ? list.stream().filter(RecordCustomField::isShared).collect(Collectors.toList()) : list;
            HashMap<String, Float> hashMap = new HashMap<String, Float>(this.fieldWeights((Collection<? extends HasValueMatch>)user));
            hashMap.putAll(this.fieldWeights(collection));
            HashSet<String> hashSet = new HashSet<String>(this.exactMatchNames((Collection<HasValueMatch>)user));
            hashSet.addAll(this.exactMatchNames(collection));
            queryAccessor.keywords(recordQuery.getKeywords(), hashMap, hashSet, user.contains(BasicProfileField.PHONE));
        }
        queryAccessor.customFields(RecordCustomField.class, recordQuery.getCustomValues(), recordCustomField -> list.contains(recordCustomField) && (sessionData.isSystem() || recordCustomField.isShowInSearch()));
        if (userRecordQuery != null) {
            user = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.RECORD_FILTER, bl2, null);
            queryAccessor.user((Collection<ProfileField>)user, userRecordQuery.getUserProfileFields(), userRecordQuery.getGroups(), userRecordQuery.getBrokers(), null, null);
            if (user2 != null) {
                queryAccessor.entities("owner", (Collection<? extends SimpleEntity>)CollectionHelper.asSet((Object[])new User[]{user2}));
            }
        }
        user = (User)this.conversionHandler.convert(User.class, (Object)recordQuery.getCreatedBy());
        queryAccessor.entities((Property<?, ?>)RecordVO.CREATED_BY, (Collection<? extends SimpleEntity>)CollectionHelper.asSet((Object[])new User[]{user}));
        queryAccessor.period((Property<?, ?>)RecordVO.CREATION_DATE, (IDatePeriod)recordQuery.getDatePeriod());
        if (recordType == null || recordType.getNature() != RecordTypeNature.SYSTEM) {
            this.visibility(queryAccessor).onlySelf();
        }
        return queryAccessor.queryBuilder();
    }

    private RecordCountResult toRecordCountResult(Terms.Bucket bucket) {
        Max max;
        Aggregations aggregations = bucket.getAggregations();
        RecordCountResult recordCountResult = new RecordCountResult();
        recordCountResult.setTypeId(Long.valueOf(bucket.getKeyAsNumber().longValue()));
        long l = ((ValueCount)aggregations.get("count")).getValue();
        recordCountResult.setCount(l);
        if (l > 0L && (max = (Max)aggregations.get("maxId")) != null) {
            double d = max.getValue();
            recordCountResult.setMaxId(Long.valueOf((long)d));
        }
        return recordCountResult;
    }

    private RecordVO toRecordVO(SearchHit searchHit) {
        List list;
        SystemRecordVO systemRecordVO;
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        RecordType recordType = sourceAccessor.getAsEntity(RecordType.class, (Property<?, ?>)RecordVO.TYPE);
        User user = sourceAccessor.getAsEntity(User.class, "owner");
        if (user == null) {
            systemRecordVO = new SystemRecordVO();
            list = this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)recordType, RecordFieldAction.VIEW);
        } else {
            systemRecordVO = new UserRecordVO();
            list = this.recordFieldHandler.getFieldsByAction((UserRecordType)recordType, (BasicUser)user, RecordFieldAction.VIEW);
        }
        systemRecordVO.setId(Long.valueOf(Long.parseLong(searchHit.getId())));
        systemRecordVO.setDisplay(sourceAccessor.getAsString((Property<?, ?>)RecordVO.DISPLAY));
        if (!list.isEmpty()) {
            List list2 = list.stream().filter(RecordCustomField::isShowInList).collect(Collectors.toList());
            systemRecordVO.setType((RecordTypeVO)this.conversionHandler.cachedEntityFromId(RecordType.class, RecordTypeVO.class, recordType.getId(), true));
            systemRecordVO.setCreatedBy(sourceAccessor.getAsEntityVO(User.class, UserVO.class, (Property<?, ?>)RecordVO.CREATED_BY));
            systemRecordVO.setCreationDate(sourceAccessor.getAsDateTime((Property<?, ?>)RecordVO.CREATION_DATE));
            systemRecordVO.setModifiedBy(sourceAccessor.getAsEntityVO(User.class, UserVO.class, (Property<?, ?>)RecordVO.MODIFIED_BY));
            systemRecordVO.setLastModifiedDate(sourceAccessor.getAsDateTime((Property<?, ?>)RecordVO.LAST_MODIFIED_DATE));
            systemRecordVO.setCustomValues(sourceAccessor.getAsCustomValueVOs(list2));
            if (systemRecordVO instanceof UserRecordVO) {
                UserVO userVO = (UserVO)this.conversionHandler.cachedEntityFromId(User.class, UserVO.class, user.getId(), true);
                ((UserRecordVO)systemRecordVO).setUser(userVO);
            }
        }
        return systemRecordVO;
    }
}

