/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import com.mysema.commons.lang.CloseableIterator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.ChargebackTransfer;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHistoryEntry;
import org.cyclos.impl.banking.ChargebackDescriptionFiller;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.OpenSearchTransSearchHandlerImpl;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.search.opensearch.ResultsCollector;
import org.cyclos.impl.search.opensearch.SourceAccessor;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.BaseTransferQuery;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.TransVO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.model.banking.transferstatus.TransferStatusWithFlowVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.TransformedCloseableIterator;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.Sum;
import org.opensearch.search.aggregations.metrics.ValueCount;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class OpenSearchTransferSearchHandlerImpl
extends OpenSearchTransSearchHandlerImpl<Transfer, AccountHistoriesOverviewQuery, AccountHistoryOverviewEntryVO>
implements TransferSearchHandler {
    private static final String INDEX = "transfers";
    public static final String VERSION = "6";
    private static final String TRANSACTION = "transaction";
    private static final String TRANSACTION_NATURE = "transactionNature";
    private static final String TRANSACTION_TRANSACTION_NUMBER = "transactionTransactionNumber";
    private static final String CHARGED_BACK_BY = "chargedBackBy";
    private static final String CHARGEBACK_OF = "chargebackOf";
    private static final String BOUGHT_VOUCHER_TYPE = "boughtVoucherType";
    private static final String SENT_VOUCHER_TO = "sentVoucherTo";
    private static final String BOUGHT_VOUCHER_TOKENS = "boughtVoucherTokens";
    private static final String VOUCHER_TRANSACTION_NATURE = "voucherTransactionNature";
    private static final String VOUCHER_TRANSACTION_TYPE = "voucherTransactionType";
    @Autowired
    @Lazy
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;

    public OpenSearchTransferSearchHandlerImpl(OpenSearchHandlerImpl openSearchHandlerImpl) {
        super(openSearchHandlerImpl, Transfer.class, QTransfer.transfer);
    }

    public DataIterator<AccountHistoryEntry> exportAccountHistory(AccountHistoryQuery accountHistoryQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        if (account == null) {
            return CloseableIteratorHelper.asDataIterator((CloseableIterator)CloseableIteratorHelper.empty());
        }
        return CloseableIteratorHelper.asDataIterator((CloseableIterator)new TransformedCloseableIterator(this.iterateEntities(accountHistoryQuery, (QueryBuilder)this.getAccountHistoryQuery(accountHistoryQuery, sessionData).queryBuilder(), this.toSort((AbstractTransQuery)accountHistoryQuery)), transfer -> new AccountHistoryEntry(account, transfer, true)));
    }

    public AccountHistoriesOverviewStatusVO getStatus(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        SearchResponse searchResponse;
        QueryAccessor queryAccessor = new QueryAccessor();
        SessionData sessionData = InvocationContext.getSessionData();
        this.appendWhere(sessionData, queryAccessor, (AbstractTransQuery)accountHistoriesOverviewQuery);
        String string = CurrencyAmountDTO.CURRENCY.getName();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.indexName()}).source(new SearchSourceBuilder().query((QueryBuilder)queryAccessor.queryBuilder()).size(0).aggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)string).field(string)).size(5000).subAggregation((AggregationBuilder)AggregationBuilders.count((String)"count").field(EntityVO.ID.getName()))).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"total").field(CurrencyAmountDTO.AMOUNT.getName()))));
        try {
            searchResponse = this.client.search(searchRequest, this.requestOptions);
        }
        catch (IOException iOException) {
            throw new UnexpectedDataAccessException((Throwable)iOException);
        }
        boolean bl = this.processResponse(searchResponse);
        AccountHistoriesOverviewStatusVO accountHistoriesOverviewStatusVO = new AccountHistoriesOverviewStatusVO();
        accountHistoriesOverviewStatusVO.setStatuses(((Terms)searchResponse.getAggregations().get(string)).getBuckets().stream().map(this::toAmountSummaryVO).collect(Collectors.toList()));
        accountHistoriesOverviewStatusVO.setPartialData(bl);
        return accountHistoriesOverviewStatusVO;
    }

    public String indexName() {
        return INDEX;
    }

    @Override
    public String indexVersion() {
        return VERSION;
    }

    public Page<AccountHistoryEntryVO> searchAccountHistory(AccountHistoryQuery accountHistoryQuery) {
        final Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        if (account == null || account.isTransient()) {
            return PageImpl.empty();
        }
        final SessionData sessionData = InvocationContext.getSessionData();
        final List list = this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)accountHistoryQuery);
        final ChargebackDescriptionFiller chargebackDescriptionFiller = this.accountService.newChargebackDescriptionFiller();
        final VOFiller vOFiller = this.userLocatorHandler.newVOFiller();
        ResultsCollector<AccountHistoryQuery, AccountHistoryEntryVO> resultsCollector = new ResultsCollector<AccountHistoryQuery, AccountHistoryEntryVO>(){

            @Override
            public void collect(AccountHistoryQuery accountHistoryQuery, List<AccountHistoryEntryVO> list2, SearchHit searchHit) {
                list2.add(OpenSearchTransferSearchHandlerImpl.this.toAccountHistoryEntryVO(account, (VOFiller<BasicUserVO>)vOFiller, chargebackDescriptionFiller, list, sessionData, searchHit));
            }

            @Override
            public void postProcess(AccountHistoryQuery accountHistoryQuery, List<AccountHistoryEntryVO> list2) {
                vOFiller.fill();
                chargebackDescriptionFiller.fill();
            }
        };
        return this.search(accountHistoryQuery, (QueryBuilder)this.getAccountHistoryQuery(accountHistoryQuery, sessionData).queryBuilder(), this.toSort((AbstractTransQuery)accountHistoryQuery), resultsCollector);
    }

    @Override
    protected void appendWhere(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        super.appendWhere(sessionData, queryAccessor, abstractTransQuery);
        if (abstractTransQuery instanceof BaseTransferQuery) {
            BoolQueryBuilder boolQueryBuilder;
            BaseTransferQuery baseTransferQuery = (BaseTransferQuery)abstractTransQuery;
            Set set = this.conversionHandler.convertSet(TransferStatus.class, (Iterable)baseTransferQuery.getStatuses());
            if (!set.isEmpty()) {
                boolQueryBuilder = QueryBuilders.boolQuery();
                for (TransferStatus transferStatus : set) {
                    boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName(transferStatus), (Object)transferStatus.getId()));
                }
                queryAccessor.filter((QueryBuilder)boolQueryBuilder);
            }
            if (CollectionHelper.isNotEmpty((Iterable)baseTransferQuery.getNatures())) {
                queryAccessor.filter((QueryBuilder)QueryBuilders.termsQuery((String)"nature", (Collection)baseTransferQuery.getNatures()));
            }
            if (baseTransferQuery.getChargedBack() != null) {
                boolQueryBuilder = QueryBuilders.existsQuery((String)CHARGED_BACK_BY);
                if (baseTransferQuery.getChargedBack().booleanValue()) {
                    queryAccessor.filter((QueryBuilder)boolQueryBuilder);
                } else {
                    queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)boolQueryBuilder));
                }
            }
        }
    }

    @Override
    protected void applyOwned(SessionData sessionData, QueryAccessor queryAccessor, AbstractTransQuery abstractTransQuery) {
        AccountHistoryQuery accountHistoryQuery = (AccountHistoryQuery)abstractTransQuery;
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        if (account == null) {
            queryAccessor.invalid();
        }
        QueryBuilder queryBuilder = account.isTransient() ? QueryAccessor.invalidFilter() : QueryBuilders.termQuery((String)this.toName((Property<?, ?>)AccountVO.ID), (Object)account.getId());
        QueryBuilder queryBuilder2 = account.isTransient() ? QueryAccessor.invalidFilter() : QueryBuilders.termQuery((String)this.fromName((Property<?, ?>)AccountVO.ID), (Object)account.getId());
        TransferDirection transferDirection = accountHistoryQuery.getDirection();
        if (transferDirection == TransferDirection.CREDIT) {
            queryAccessor.filter(queryBuilder);
        } else if (transferDirection == TransferDirection.DEBIT) {
            queryAccessor.filter(queryBuilder2);
        } else {
            queryAccessor.filter((QueryBuilder)QueryBuilders.boolQuery().should(queryBuilder2).should(queryBuilder));
        }
        queryAccessor.customFields(TransactionCustomField.class, accountHistoryQuery.getCustomValues(), account.getType().getCustomFieldsForSearch()::contains);
    }

    @Override
    protected void fillSource(Transfer transfer, SourceAccessor sourceAccessor) {
        super.fillSource(transfer, sourceAccessor);
        sourceAccessor.set("nature", (Object)transfer.getTransferNature());
        Transaction transaction = transfer.getTransaction();
        if (transaction != null) {
            sourceAccessor.set(TRANSACTION, (Object)transaction);
            sourceAccessor.set(TRANSACTION_NATURE, (Object)transaction.getNature());
            sourceAccessor.set(TRANSACTION_TRANSACTION_NUMBER, (Object)transaction.getTransactionNumber());
        }
        if (transfer instanceof ChargebackTransfer) {
            sourceAccessor.set(CHARGEBACK_OF, (Object)((ChargebackTransfer)transfer).getChargebackOf());
        }
        sourceAccessor.set(CHARGED_BACK_BY, (Object)transfer.getChargedBackBy());
        for (TransferStatus transferStatus : CollectionHelper.orEmpty((Set)transfer.getStatuses())) {
            sourceAccessor.set(this.fieldName(transferStatus), (Object)transferStatus);
        }
        if (transaction instanceof Payment) {
            VoucherTransaction voucherTransaction;
            TransferStatus transferStatus;
            Payment payment = (Payment)transaction;
            transferStatus = payment.getBoughtVoucherPack();
            if (transferStatus != null) {
                sourceAccessor.set(BOUGHT_VOUCHER_TYPE, (Object)transferStatus.getType());
                sourceAccessor.set(SENT_VOUCHER_TO, (Object)transferStatus.getSentToEmail());
                sourceAccessor.set(BOUGHT_VOUCHER_TOKENS, (Object)transferStatus.getVoucherTokens());
            }
            if ((voucherTransaction = payment.getVoucherTransaction()) != null) {
                sourceAccessor.set(VOUCHER_TRANSACTION_NATURE, (Object)voucherTransaction.getNature());
                sourceAccessor.set(VOUCHER_TRANSACTION_TYPE, (Object)voucherTransaction.getVoucher().getType());
            }
        }
    }

    @Override
    protected ResultsCollector<AccountHistoriesOverviewQuery, AccountHistoryOverviewEntryVO> resultsCollector(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        final SessionData sessionData = InvocationContext.getSessionData();
        final List list = CollectionHelper.sort((Collection)this.transactionCustomFieldService.listVisibleForList((AbstractTransQuery)accountHistoriesOverviewQuery));
        final VOFiller vOFiller = this.userLocatorHandler.newVOFiller();
        return new ResultsCollector<AccountHistoriesOverviewQuery, AccountHistoryOverviewEntryVO>(){

            @Override
            public void collect(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery, List<AccountHistoryOverviewEntryVO> list2, SearchHit searchHit) {
                list2.add(OpenSearchTransferSearchHandlerImpl.this.toAccountHistoryOverviewEntryVO((VOFiller<BasicUserVO>)vOFiller, list, sessionData, searchHit));
            }

            @Override
            public void postProcess(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery, List<AccountHistoryOverviewEntryVO> list2) {
                vOFiller.fill();
            }
        };
    }

    private String fieldName(TransferStatus transferStatus) {
        return OpenSearchAccessor.idSuffix("status." + transferStatus.getFlow().getId());
    }

    private QueryAccessor getAccountHistoryQuery(AccountHistoryQuery accountHistoryQuery, SessionData sessionData) {
        QueryAccessor queryAccessor = new QueryAccessor();
        this.appendWhere(sessionData, queryAccessor, (AbstractTransQuery)accountHistoryQuery);
        return queryAccessor;
    }

    private AccountHistoryEntryVO toAccountHistoryEntryVO(Account account, VOFiller<BasicUserVO> vOFiller, ChargebackDescriptionFiller chargebackDescriptionFiller, List<TransactionCustomField> list, SessionData sessionData, SearchHit searchHit) {
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        CurrencyVO currencyVO = sourceAccessor.getAsEntityVO(Currency.class, CurrencyVO.class, (Property<?, ?>)CurrencyAmountDTO.CURRENCY);
        AccountHistoryEntryVO accountHistoryEntryVO = new AccountHistoryEntryVO();
        accountHistoryEntryVO.setId(Long.valueOf(Long.parseLong(searchHit.getId())));
        TransferNature transferNature = sourceAccessor.getAsEnum(TransferNature.class, "nature");
        if (transferNature == TransferNature.CHARGEBACK) {
            chargebackDescriptionFiller.add(accountHistoryEntryVO);
        }
        accountHistoryEntryVO.setDate(sourceAccessor.getAsDateTime((Property<?, ?>)TransVO.DATE));
        accountHistoryEntryVO.setTransactionNumber(sourceAccessor.getAsString((Property<?, ?>)TransVO.TRANSACTION_NUMBER));
        accountHistoryEntryVO.setType(sourceAccessor.getAsEntityVO(TransferType.class, TransferTypeVO.class, (Property<?, ?>)TransVO.TYPE));
        accountHistoryEntryVO.setAmount(sourceAccessor.getAsBigDecimal((Property<?, ?>)CurrencyAmountDTO.AMOUNT, currencyVO.getPrecision()));
        accountHistoryEntryVO.setTransactionId(sourceAccessor.getAsLong(TRANSACTION));
        accountHistoryEntryVO.setTransactionNature(sourceAccessor.getAsEnum(TransactionNature.class, TRANSACTION_NATURE));
        accountHistoryEntryVO.setTransactionTransactionNumber(sourceAccessor.getAsString(TRANSACTION_TRANSACTION_NUMBER));
        accountHistoryEntryVO.setDescription(sourceAccessor.getAsString((Property<?, ?>)TransactionResultVO.DESCRIPTION));
        accountHistoryEntryVO.setCustomValues(sourceAccessor.getAsCustomValueVOs(list));
        SourceAccessor sourceAccessor2 = sourceAccessor.getAsSource((Property<?, ?>)TransVO.FROM);
        SourceAccessor sourceAccessor3 = sourceAccessor.getAsSource((Property<?, ?>)TransVO.TO);
        if (account.getId().equals(sourceAccessor2.getAsLong((Property<?, ?>)AccountVO.ID))) {
            accountHistoryEntryVO.setRelatedAccount(this.toAccountVO(vOFiller, sessionData, sourceAccessor3));
            accountHistoryEntryVO.setRelatedName(sourceAccessor.getAsString((Property<?, ?>)TransactionResultVO.TO_NAME));
            accountHistoryEntryVO.setAmount(accountHistoryEntryVO.getAmount().negate());
        } else {
            accountHistoryEntryVO.setRelatedAccount(this.toAccountVO(vOFiller, sessionData, sourceAccessor2));
            accountHistoryEntryVO.setRelatedName(sourceAccessor.getAsString((Property<?, ?>)TransactionResultVO.FROM_NAME));
        }
        this.voucherService.fill(accountHistoryEntryVO, sourceAccessor.getAsLong(BOUGHT_VOUCHER_TYPE), sourceAccessor.getAsStringList(BOUGHT_VOUCHER_TOKENS), sourceAccessor.getAsString(SENT_VOUCHER_TO), sourceAccessor.getAsEnum(VoucherTransactionNature.class, VOUCHER_TRANSACTION_NATURE), sourceAccessor.getAsLong(VOUCHER_TRANSACTION_TYPE));
        accountHistoryEntryVO.setStatuses(sourceAccessor.map().keySet().stream().filter(string -> string.startsWith("status.")).map(string -> sourceAccessor.getAsEntityVO(TransferStatus.class, TransferStatusWithFlowVO.class, (String)string)).collect(Collectors.toList()));
        return accountHistoryEntryVO;
    }

    private AccountHistoryOverviewEntryVO toAccountHistoryOverviewEntryVO(VOFiller<BasicUserVO> vOFiller, List<TransactionCustomField> list, SessionData sessionData, SearchHit searchHit) {
        SourceAccessor sourceAccessor = new SourceAccessor(searchHit);
        AccountHistoryOverviewEntryVO accountHistoryOverviewEntryVO = new AccountHistoryOverviewEntryVO();
        accountHistoryOverviewEntryVO.setId(Long.valueOf(Long.parseLong(searchHit.getId())));
        accountHistoryOverviewEntryVO.setDisplay(sourceAccessor.getAsString((Property<?, ?>)TransVO.DISPLAY));
        accountHistoryOverviewEntryVO.setDate(sourceAccessor.getAsDateTime((Property<?, ?>)TransVO.DATE));
        accountHistoryOverviewEntryVO.setTransactionNumber(sourceAccessor.getAsString((Property<?, ?>)TransVO.TRANSACTION_NUMBER));
        accountHistoryOverviewEntryVO.setNature(sourceAccessor.getAsEnum(TransferNature.class, "nature"));
        accountHistoryOverviewEntryVO.setTransactionId(sourceAccessor.getAsLong(TRANSACTION));
        accountHistoryOverviewEntryVO.setTransactionTransactionNumber(sourceAccessor.getAsString(TRANSACTION_TRANSACTION_NUMBER));
        accountHistoryOverviewEntryVO.setType(sourceAccessor.getAsEntityVO(TransferType.class, TransferTypeVO.class, (Property<?, ?>)TransVO.TYPE));
        CurrencyVO currencyVO = sourceAccessor.getAsEntityVO(Currency.class, CurrencyVO.class, (Property<?, ?>)CurrencyAmountDTO.CURRENCY);
        accountHistoryOverviewEntryVO.setCurrencyAmount(ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)sourceAccessor.getAsBigDecimal((Property<?, ?>)CurrencyAmountDTO.AMOUNT, currencyVO.getPrecision())));
        accountHistoryOverviewEntryVO.setFrom(this.toAccountVO(vOFiller, sessionData, sourceAccessor.getAsSource((Property<?, ?>)TransVO.FROM)));
        accountHistoryOverviewEntryVO.setTo(this.toAccountVO(vOFiller, sessionData, sourceAccessor.getAsSource((Property<?, ?>)TransVO.TO)));
        accountHistoryOverviewEntryVO.setStatuses(sourceAccessor.map().keySet().stream().filter(string -> string.startsWith("status.")).map(string -> sourceAccessor.getAsEntityVO(TransferStatus.class, TransferStatusWithFlowVO.class, (String)string)).collect(Collectors.toList()));
        accountHistoryOverviewEntryVO.setFromName(sourceAccessor.getAsString((Property<?, ?>)AccountHistoryOverviewEntryVO.FROM_NAME));
        accountHistoryOverviewEntryVO.setToName(sourceAccessor.getAsString((Property<?, ?>)AccountHistoryOverviewEntryVO.TO_NAME));
        accountHistoryOverviewEntryVO.setCustomValues(sourceAccessor.getAsCustomValueVOs(list));
        return accountHistoryOverviewEntryVO;
    }

    private AmountSummaryVO toAmountSummaryVO(Terms.Bucket bucket) {
        Aggregations aggregations = bucket.getAggregations();
        long l = bucket.getKeyAsNumber().longValue();
        CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.cachedEntityFromId(Currency.class, CurrencyVO.class, Long.valueOf(l), false);
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)new BigDecimal(((Sum)aggregations.get("total")).getValue()), (int)currencyVO.getPrecision());
        int n = (int)((ValueCount)aggregations.get("count")).getValue();
        BigDecimal bigDecimal2 = bigDecimal.divide(new BigDecimal(n), currencyVO.getPrecision(), RoundingMode.HALF_UP);
        return ModelHelper.amountSummary((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2, (int)n, (CurrencyVO)currencyVO);
    }
}

