/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.search.opensearch;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.users.AddressContactInfo;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.LatLong;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.search.opensearch.OpenSearchAccessor;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.NamedEntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.DynamicFieldValueVO;
import org.cyclos.model.system.fields.HasValueMatch;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.AddressNature;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.AddressContactInfoVO;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.Range;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.opensearch.search.SearchHit;

public class SourceAccessor
extends OpenSearchAccessor {
    private Map<String, Object> _map;

    public static SourceAccessor from(GeoLocatedAddress geoLocatedAddress, List<ContactInfoField> list) {
        AddressContactInfo addressContactInfo;
        Object object;
        Object object2;
        if (geoLocatedAddress == null) {
            return null;
        }
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set((Property<?, ?>)EntityVO.ID, (Object)geoLocatedAddress.getId());
        sourceAccessor.set(NamedEntityVO.NAME, (Object)geoLocatedAddress.getName());
        if (geoLocatedAddress.getNature() == AddressNature.USER) {
            object2 = (UserAddress)geoLocatedAddress;
            sourceAccessor.set((Property<?, ?>)UserAddressVO.HIDDEN, (Object)object2.isHidden());
            sourceAccessor.set((Property<?, ?>)UserAddressVO.DEFAULT_ADDRESS, (Object)object2.isDefaultAddress());
        }
        object2 = new ArrayList();
        LatLong latLong = AddressFields.values();
        int n = ((AddressFields[])latLong).length;
        for (int i = 0; i < n; ++i) {
            object = latLong[i];
            String string = AddressHelper.getValue((AddressFields)object, (IAddress)geoLocatedAddress);
            if (StringHelper.isNotBlank((Object)string)) {
                sourceAccessor.set(object.internalName(), (Object)string);
            }
            if (object.queryField() != AddressQueryField.ADDRESS) continue;
            object2.add(string);
        }
        sourceAccessor.set(AddressQueryField.ADDRESS.internalName(), object2);
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getZip())) {
            sourceAccessor.set(SourceAccessor.keywordSuffix(AddressQueryField.ZIP.internalName()), (Object)StringHelper.removeNonAlpha((String)geoLocatedAddress.getZip()));
        }
        if (StringHelper.isNotBlank((Object)geoLocatedAddress.getPoBox())) {
            sourceAccessor.set(SourceAccessor.keywordSuffix(AddressQueryField.PO_BOX.internalName()), (Object)StringHelper.removeNonAlpha((String)geoLocatedAddress.getPoBox()));
        }
        if ((latLong = geoLocatedAddress.getLocation()) != null) {
            List<BigDecimal> list2 = Arrays.asList(latLong.getLongitude(), latLong.getLatitude());
            sourceAccessor.set(GeoLocatedAddressVO.LOCATION.getName(), list2);
        }
        if (geoLocatedAddress instanceof UserAddress && (addressContactInfo = ((UserAddress)geoLocatedAddress).getContactInfo()) != null) {
            AddressContactInfoVO addressContactInfoVO = (AddressContactInfoVO)((ConversionHandler)InvocationContext.bean(ConversionHandler.class)).convert(AddressContactInfoVO.class, (Object)addressContactInfo);
            object = new SourceAccessor();
            ((SourceAccessor)object).set(ContactInfoVO.ID.getName(), (Object)addressContactInfoVO.getId());
            ((SourceAccessor)object).set(ContactInfoVO.EMAIL.getName(), (Object)addressContactInfoVO.getEmail());
            ((SourceAccessor)object).set(ContactInfoVO.MOBILE_PHONE.getName(), (Object)addressContactInfoVO.getMobilePhone());
            ((SourceAccessor)object).set(ContactInfoVO.NORMALIZED_MOBILE_PHONE.getName(), (Object)addressContactInfoVO.getNormalizedMobilePhone());
            ((SourceAccessor)object).set(ContactInfoVO.LAND_LINE_PHONE.getName(), (Object)addressContactInfoVO.getLandLinePhone());
            ((SourceAccessor)object).set(ContactInfoVO.LAND_LINE_EXTENSION.getName(), (Object)addressContactInfoVO.getLandLineExtension());
            ((SourceAccessor)object).set(ContactInfoVO.NORMALIZED_LAND_LINE_PHONE.getName(), (Object)addressContactInfoVO.getNormalizedLandLinePhone());
            ((SourceAccessor)object).setCustomValues((BasicUser)addressContactInfo.getUser(), addressContactInfo, list);
            sourceAccessor.set((Property<?, ?>)UserAddressVO.CONTACT_INFO, object);
        }
        return sourceAccessor;
    }

    public static SourceAccessor from(Image image) {
        if (image == null) {
            return null;
        }
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set((Property<?, ?>)EntityVO.ID, (Object)image.getId());
        sourceAccessor.set((Property<?, ?>)StoredFileVO.CONTENT_TYPE, (Object)image.getContentType());
        sourceAccessor.set((Property<?, ?>)StoredFileVO.LENGTH, (Object)image.getLength());
        sourceAccessor.set((Property<?, ?>)StoredFileVO.LAST_MODIFIED, (Object)image.getLastModified());
        sourceAccessor.set((Property<?, ?>)ImageVO.CONVERTED_TO_JPEG, (Object)image.isConvertedToJpeg());
        sourceAccessor.set((Property<?, ?>)ImageVO.HEIGHT, (Object)image.getHeight());
        sourceAccessor.set((Property<?, ?>)ImageVO.WIDTH, (Object)image.getWidth());
        sourceAccessor.set((Property<?, ?>)ImageVO.KEY, (Object)ImageVOConverter.getKey(image));
        sourceAccessor.set((Property<?, ?>)ImageVO.NATURE, (Object)image.getNature());
        return sourceAccessor;
    }

    public static SourceAccessor from(User user) {
        if (user == null) {
            return null;
        }
        SourceAccessor sourceAccessor = new SourceAccessor();
        sourceAccessor.set((Property<?, ?>)UserVO.ID, (Object)user.getId());
        sourceAccessor.set("displayForManagers", (Object)user.getDisplayForManagers());
        sourceAccessor.set("displayForOthers", (Object)user.getDisplayForOthers());
        sourceAccessor.set((Property<?, ?>)UserVO.IMAGE, (Object)SourceAccessor.from((Image)user.getImage()));
        return sourceAccessor;
    }

    public SourceAccessor() {
    }

    public SourceAccessor(Map<String, Object> map) {
        this._map = map;
    }

    public SourceAccessor(SearchHit searchHit) {
        this(searchHit.getSourceAsMap());
    }

    public UserAddressVO asUserAddressVO(SessionData sessionData, LatLongDTO latLongDTO, List<ContactInfoField> list) {
        SourceAccessor sourceAccessor;
        UserAddressVO userAddressVO = new UserAddressVO();
        userAddressVO.setId(this.getAsLong((Property<?, ?>)EntityVO.ID));
        userAddressVO.setName(this.getAsString(NamedEntityVO.NAME));
        userAddressVO.setHidden(this.getAsBoolean((Property<?, ?>)UserAddressVO.HIDDEN));
        userAddressVO.setDefaultAddress(this.getAsBoolean((Property<?, ?>)UserAddressVO.DEFAULT_ADDRESS));
        for (AddressFields addressFields : AddressFields.values()) {
            String string = this.getAsString(addressFields.internalName());
            if (string == null) continue;
            AddressHelper.setValue((AddressFields)addressFields, (IAddress)userAddressVO, (String)string);
        }
        List<?> list2 = this.getList(GeoLocatedAddressVO.LOCATION.getName());
        if (list2 != null && list2.size() == 2) {
            AddressFields addressFields;
            userAddressVO.setLocated(true);
            BigDecimal bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, list2.get(0));
            BigDecimal bigDecimal2 = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, list2.get(1));
            addressFields = ModelHelper.latLong((BigDecimal)bigDecimal2, (BigDecimal)bigDecimal);
            userAddressVO.setLocation((LatLongDTO)addressFields);
            if (ModelHelper.isValid((LatLongDTO)latLongDTO)) {
                double d = addressFields.getLatitude().doubleValue();
                double d2 = addressFields.getLongitude().doubleValue();
                double d3 = latLongDTO.getLatitude().doubleValue();
                double d4 = latLongDTO.getLongitude().doubleValue();
                userAddressVO.setCurrentDistance(Double.valueOf(AddressHelper.distance((double)d, (double)d2, (double)d3, (double)d4, (DistanceUnit)sessionData.getConfiguration().getDistanceUnit())));
            }
        }
        if ((sourceAccessor = this.getAsSource((Property<?, ?>)UserAddressVO.CONTACT_INFO)) != null && sourceAccessor.getAsLong((Property<?, ?>)AddressContactInfoVO.ID) != null) {
            AddressContactInfoVO addressContactInfoVO = new AddressContactInfoVO();
            addressContactInfoVO.setId(sourceAccessor.getAsLong((Property<?, ?>)AddressContactInfoVO.ID));
            addressContactInfoVO.setEmail(sourceAccessor.getAsString((Property<?, ?>)AddressContactInfoVO.EMAIL));
            addressContactInfoVO.setMobilePhone(sourceAccessor.getAsString((Property<?, ?>)AddressContactInfoVO.MOBILE_PHONE));
            addressContactInfoVO.setNormalizedMobilePhone(sourceAccessor.getAsString((Property<?, ?>)AddressContactInfoVO.NORMALIZED_MOBILE_PHONE));
            addressContactInfoVO.setLandLinePhone(sourceAccessor.getAsString((Property<?, ?>)AddressContactInfoVO.LAND_LINE_PHONE));
            addressContactInfoVO.setLandLineExtension(sourceAccessor.getAsString((Property<?, ?>)AddressContactInfoVO.LAND_LINE_EXTENSION));
            addressContactInfoVO.setNormalizedLandLinePhone(sourceAccessor.getAsString((Property<?, ?>)AddressContactInfoVO.NORMALIZED_LAND_LINE_PHONE));
            addressContactInfoVO.setCustomValues(sourceAccessor.getAsCustomValueVOs(list));
            userAddressVO.setContactInfo(addressContactInfoVO);
        }
        return userAddressVO;
    }

    public BigDecimal getAsBigDecimal(Property<?, ?> property, int n) {
        return this.getAsBigDecimal(property.getName(), n);
    }

    public BigDecimal getAsBigDecimal(String string, int n) {
        BigDecimal bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)this.getSingle(string));
        return BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n);
    }

    public boolean getAsBoolean(Property<?, ?> property) {
        return this.getAsBoolean(property.getName());
    }

    public boolean getAsBoolean(String string) {
        return (Boolean)CoercionHelper.coerce(Boolean.TYPE, (Object)this.getSingle(string));
    }

    public CustomFieldValueVO getAsCustomFieldValueVO(CustomField<?, ?, ?> customField) {
        String string = SourceAccessor.storedFieldName(customField);
        List<?> list = this.getList(string);
        Object object = this.customFieldValueHandler().getValue(customField, list, false);
        if (ObjectHelper.isEmpty((Object)object)) {
            return null;
        }
        CustomFieldValueVO customFieldValueVO = new CustomFieldValueVO();
        customFieldValueVO.setField((CustomFieldVO)this.conversionHandler().convert(CustomFieldVO.class, customField));
        if (customField.getType() == CustomFieldType.DYNAMIC_SELECTION) {
            DynamicFieldValueVO dynamicFieldValueVO = new DynamicFieldValueVO();
            dynamicFieldValueVO.setValue(StringHelper.trimToNull((Object)object));
            dynamicFieldValueVO.setLabel(this.getAsString(SourceAccessor.textSuffix(SourceAccessor.baseName(customField))));
            object = dynamicFieldValueVO;
        }
        this.customFieldValueHandler().setModelValue(customField, object, (ICustomFieldValue)customFieldValueVO);
        return customFieldValueVO;
    }

    public <CF extends CustomField<CF, ?, ?>> List<CustomFieldValueVO> getAsCustomValueVOs(List<CF> list) {
        return list.stream().map(this::getAsCustomFieldValueVO).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Date getAsDate(Property<?, ?> property) {
        return this.getAsDate(property.getName());
    }

    public Date getAsDate(String string) {
        DateTime dateTime = this.getAsDateTime(string);
        return this.conversionHandler().toDate((IDate)dateTime);
    }

    public DatePeriodDTO getAsDatePeriodDTO(Property<?, ?> property) {
        return this.getAsDatePeriodDTO(property.getName());
    }

    public DatePeriodDTO getAsDatePeriodDTO(String string) {
        SourceAccessor sourceAccessor = this.getAsSource(string);
        if (sourceAccessor == null) {
            return null;
        }
        return ModelHelper.datePeriod((DateTime)sourceAccessor.getAsDateTime("begin"), (DateTime)sourceAccessor.getAsDateTime("end"));
    }

    public DateTime getAsDateTime(Property<?, ?> property) {
        return this.getAsDateTime(property.getName());
    }

    public DateTime getAsDateTime(String string) {
        DateTime dateTime = DateTime.parse((String)this.getAsString(string));
        return (DateTime)this.conversionHandler().convert(DateTime.class, this.conversionHandler().convert(Date.class, (Object)dateTime));
    }

    public DecimalRangeDTO getAsDecimalRangeDTO(Property<?, ?> property, int n) {
        return this.getAsDecimalRangeDTO(property.getName(), n);
    }

    public DecimalRangeDTO getAsDecimalRangeDTO(String string, int n) {
        SourceAccessor sourceAccessor = this.getAsSource(string);
        if (sourceAccessor == null) {
            return null;
        }
        return ModelHelper.decimalRange((BigDecimal)sourceAccessor.getAsBigDecimal("min", n), (BigDecimal)sourceAccessor.getAsBigDecimal("max", n));
    }

    public <ET extends SimpleEntity, R extends Collection<ET>> R getAsEntities(Class<ET> clazz, Property<?, ?> property, Supplier<R> supplier) {
        return this.getAsEntities(clazz, property.getName(), supplier);
    }

    public <ET extends SimpleEntity, R extends Collection<ET>> R getAsEntities(Class<ET> clazz, String string, Supplier<R> supplier) {
        List list = CoercionHelper.coerceList(Long.class, this.getList(string));
        return (R)((Collection)list.stream().map(l -> (SimpleEntity)this.entityManagerHandler().find(clazz, l)).collect(Collectors.toCollection(supplier)));
    }

    public <ET extends SimpleEntity> ET getAsEntity(Class<ET> clazz, Property<?, ?> property) {
        return this.getAsEntity(clazz, property.getName());
    }

    public <ET extends SimpleEntity> ET getAsEntity(Class<ET> clazz, String string) {
        Long l = this.getAsLong(string);
        return (ET)(l == null ? null : (SimpleEntity)this.entityManagerHandler().find(clazz, l));
    }

    public <ET extends SimpleEntity, VO extends EntityVO> VO getAsEntityVO(Class<ET> clazz, Class<VO> clazz2, Property<?, ?> property) {
        return this.getAsEntityVO(clazz, clazz2, property.getName());
    }

    public <ET extends SimpleEntity, VO extends EntityVO> VO getAsEntityVO(Class<ET> clazz, Class<VO> clazz2, String string) {
        Long l = this.getAsLong(string);
        return (VO)(l == null ? null : (EntityVO)this.conversionHandler().cachedEntityFromId(clazz, clazz2, l, true));
    }

    public <ET extends SimpleEntity, VO extends EntityVO, R extends Collection<VO>> R getAsEntityVOs(Class<ET> clazz, Class<VO> clazz2, Property<?, ?> property, Supplier<R> supplier) {
        return this.getAsEntityVOs(clazz, clazz2, property.getName(), supplier);
    }

    public <ET extends SimpleEntity, VO extends EntityVO, R extends Collection<VO>> R getAsEntityVOs(Class<ET> clazz, Class<VO> clazz2, String string, Supplier<R> supplier) {
        List list = CoercionHelper.coerceList(Long.class, this.getList(string));
        return (R)((Collection)list.stream().map(l -> (EntityVO)this.conversionHandler().cachedEntityFromId(clazz, clazz2, l, true)).collect(Collectors.toCollection(supplier)));
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> clazz, Property<T, ?> property) {
        return this.getAsEnum(clazz, property.getName());
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> clazz, String string) {
        String string2 = this.getAsString(string);
        return string2 == null ? null : (T)Enum.valueOf(clazz, string2);
    }

    public ImageVO getAsImageVO(Property<?, ?> property) {
        return this.getAsImageVO(property.getName());
    }

    public ImageVO getAsImageVO(String string) {
        SourceAccessor sourceAccessor = this.getAsSource(string);
        if (sourceAccessor == null) {
            return null;
        }
        ImageVO imageVO = new ImageVO();
        imageVO.setId(sourceAccessor.getAsLong((Property<?, ?>)EntityVO.ID));
        imageVO.setContentType(sourceAccessor.getAsString((Property<?, ?>)StoredFileVO.CONTENT_TYPE));
        imageVO.setLength(sourceAccessor.getAsInteger((Property<?, ?>)StoredFileVO.LENGTH).intValue());
        imageVO.setLastModified(sourceAccessor.getAsDateTime((Property<?, ?>)StoredFileVO.LAST_MODIFIED));
        if (imageVO.getLastModified() != null) {
            imageVO.setLastModifiedInMillis(String.valueOf(this.conversionHandler().toDate((IDate)imageVO.getLastModified()).getTime()));
        }
        imageVO.setConvertedToJpeg(sourceAccessor.getAsBoolean((Property<?, ?>)ImageVO.CONVERTED_TO_JPEG));
        imageVO.setHeight(sourceAccessor.getAsInteger((Property<?, ?>)ImageVO.HEIGHT).intValue());
        imageVO.setWidth(sourceAccessor.getAsInteger((Property<?, ?>)ImageVO.WIDTH).intValue());
        imageVO.setKey(sourceAccessor.getAsString((Property<?, ?>)ImageVO.KEY));
        imageVO.setNature(sourceAccessor.getAsEnum((Class)ImageNature.class, (Property)ImageVO.NATURE));
        return imageVO;
    }

    public int getAsInt(Property<?, ?> property) {
        return this.getAsInt(property.getName());
    }

    public int getAsInt(String string) {
        return (Integer)CoercionHelper.coerce(Integer.TYPE, (Object)this.getSingle(string));
    }

    public Integer getAsInteger(Property<?, ?> property) {
        return this.getAsInteger(property.getName());
    }

    public Integer getAsInteger(String string) {
        return (Integer)CoercionHelper.coerce(Integer.class, (Object)this.getSingle(string));
    }

    public IntegerRangeDTO getAsIntegerRangeDTO(Property<?, ?> property) {
        return this.getAsIntegerRangeDTO(property.getName());
    }

    public IntegerRangeDTO getAsIntegerRangeDTO(String string) {
        SourceAccessor sourceAccessor = this.getAsSource(string);
        if (sourceAccessor == null) {
            return null;
        }
        return ModelHelper.integerRange((Integer)sourceAccessor.getAsInteger("min"), (Integer)sourceAccessor.getAsInteger("max"));
    }

    public Long getAsLong(Property<?, ?> property) {
        return this.getAsLong(property.getName());
    }

    public Long getAsLong(String string) {
        return (Long)CoercionHelper.coerce(Long.class, (Object)this.getSingle(string));
    }

    public List<Long> getAsLongList(Property<?, ?> property) {
        return this.getAsLongList(property.getName());
    }

    public List<Long> getAsLongList(String string) {
        return CoercionHelper.coerceList(Long.class, this.getList(string));
    }

    public SourceAccessor getAsSource(Property<?, ?> property) {
        return this.getAsSource(property.getName());
    }

    public SourceAccessor getAsSource(String string) {
        Object object = this.getSingle(string);
        if (object instanceof Map) {
            return new SourceAccessor((Map)object);
        }
        return null;
    }

    public String getAsString(Property<?, ?> property) {
        return this.getAsString(property.getName());
    }

    public String getAsString(String string) {
        return StringHelper.trimToNull((Object)this.getSingle(string));
    }

    public List<String> getAsStringList(Property<?, ?> property) {
        return this.getAsStringList(property.getName());
    }

    public List<String> getAsStringList(String string) {
        return CoercionHelper.coerceList(String.class, this.getList(string));
    }

    public <VO extends UserVO> VO getAsUserVO(Class<VO> clazz, SessionData sessionData, UserServiceLocal userServiceLocal, String string) {
        SourceAccessor sourceAccessor;
        SourceAccessor sourceAccessor2 = sourceAccessor = string == null ? this : this.getAsSource(string);
        if (sourceAccessor == null) {
            return null;
        }
        return (VO)userServiceLocal.toUserVO(clazz, sessionData, sourceAccessor.getAsLong((Property<?, ?>)UserVO.ID), sourceAccessor.getAsString("displayForManagers"), sourceAccessor.getAsString("displayForOthers"), this.getUserBrokerIds(), sourceAccessor.getAsImageVO((Property<?, ?>)UserVO.IMAGE));
    }

    public UserVO getAsUserVO(SessionData sessionData, UserServiceLocal userServiceLocal, Property<UserVO, ?> property) {
        return this.getAsUserVO(sessionData, userServiceLocal, property.getName());
    }

    public UserVO getAsUserVO(SessionData sessionData, UserServiceLocal userServiceLocal, String string) {
        return this.getAsUserVO(UserVO.class, sessionData, userServiceLocal, string);
    }

    public String getUserBrokerIds() {
        Object object = null;
        Long l = this.getAsLong((Property<?, ?>)UserWithFieldsVO.MAIN_BROKER);
        if (l != null) {
            object = l.toString();
            List<Long> list = this.getAsLongList("otherBrokers");
            if (CollectionHelper.isNotEmpty(list)) {
                object = (String)object + "," + StringHelper.join(list, (String)",");
            }
        }
        return object;
    }

    public Map<String, Object> map() {
        if (this._map == null) {
            this._map = new LinkedHashMap<String, Object>();
        }
        return this._map;
    }

    public void set(BasicUser basicUser, Property<?, ?> property, String string, ValueMatch valueMatch, boolean bl) {
        this.set(basicUser, property.getName(), string, valueMatch, bl);
    }

    public void set(BasicUser basicUser, String string, String string2, ValueMatch valueMatch, boolean bl) {
        String string4 = bl ? StringHelper.removeMarkupTags((String)string2) : string2;
        this.set(SourceAccessor.ignoredSuffix(string), (Object)string2);
        if (valueMatch == null) {
            valueMatch = ValueMatch.EXACT;
        }
        switch (valueMatch) {
            case EXACT: {
                this.set(SourceAccessor.keywordSuffix(string), (Object)(string2 == null ? null : string2.toLowerCase()));
                break;
            }
            case TEXT: {
                this.set(SourceAccessor.textSuffix(string), (Object)string2);
                this.set(SourceAccessor.keywordSuffix(string), string4 == null ? null : StringHelper.truncate((String)string4.toLowerCase(), (int)20));
                break;
            }
            case LANGUAGE: {
                SourceAccessor.languageSuffixes(basicUser).forEach(string3 -> this.set(SourceAccessor.suffix(string, string3), (Object)string4));
                this.set(SourceAccessor.keywordSuffix(string), string4 == null ? null : StringHelper.truncate((String)string4.toLowerCase(), (int)20));
            }
        }
    }

    public void set(Property<?, ?> property, Object object) {
        this.set(property.getName(), object);
    }

    public void set(Property<?, ?> property, Object object, boolean bl) {
        this.set(property.getName(), object, bl);
    }

    public void set(String string, Object object) {
        this.set(string, object, false);
    }

    public void set(String string, Object object, boolean bl) {
        if (ObjectHelper.isEmpty((Object)object) && !bl) {
            this.map().remove(string);
        } else {
            this.map().put(string, this.sourceValue(object));
        }
    }

    public <CF extends CustomField<CF, ?, ?>, V extends CustomFieldValue<CF, ?, ?, E>, E extends SimpleEntity> void setCustomValues(BasicUser basicUser, Collection<V> collection, Collection<CF> collection2) {
        boolean bl;
        Map<CustomField, CustomFieldValue> map = CollectionHelper.orEmpty(collection).stream().collect(Collectors.toMap(CustomFieldValue::getField, customFieldValue -> customFieldValue));
        boolean bl2 = bl = collection2 != null;
        if (collection2 == null) {
            collection2 = map.keySet();
        }
        collection2.forEach(customField -> {
            CustomFieldValue customFieldValue = (CustomFieldValue)map.get(customField);
            Object object = this.customFieldValueHandler().getValue(customField, (Object)customFieldValue, false);
            String string = SourceAccessor.baseName((HasValueMatch)customField);
            CustomFieldType customFieldType = customField.getType();
            if (customFieldType.isString()) {
                String string3 = StringHelper.trimToNull((Object)object);
                if (string3 == null) {
                    if (bl) {
                        this.map().put(string, null);
                        this.map().put(SourceAccessor.ignoredSuffix(string), null);
                        this.map().put(SourceAccessor.keywordSuffix(string), null);
                        SourceAccessor.languageSuffixes(basicUser).forEach(string2 -> this.map().put(SourceAccessor.suffix(string, string2), null));
                    }
                } else {
                    boolean bl2 = customFieldType == CustomFieldType.RICH_TEXT;
                    this.set(basicUser, string, string3, customField.getValueMatch(), bl2);
                }
            } else if (customFieldType.isDynamic()) {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                if (!iterator.hasNext()) {
                    if (bl) {
                        this.map().put(SourceAccessor.keywordSuffix(string), null);
                        this.map().put(SourceAccessor.textSuffix(string), null);
                    }
                } else {
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    iterator.forEachRemaining(dynamicFieldValue -> {
                        arrayList.add(dynamicFieldValue.getValue());
                        if (dynamicFieldValue.getLabel() != null) {
                            arrayList2.add(dynamicFieldValue.getLabel());
                        }
                    });
                    this.set(SourceAccessor.keywordSuffix(string), arrayList);
                    this.set(SourceAccessor.textSuffix(string), arrayList2);
                }
            } else {
                String string4 = SourceAccessor.storedFieldName(customField);
                if (string4 != null) {
                    if (object == null) {
                        if (bl) {
                            this.map().put(string4, null);
                        }
                    } else {
                        this.set(string4, object);
                    }
                }
            }
        });
    }

    public <CF extends CustomField<CF, ?, ?>, V extends CustomFieldValue<CF, ?, ?, E>, E extends SimpleEntity> void setCustomValues(BasicUser basicUser, E e, Collection<CF> collection) {
        this.setCustomValues(basicUser, (E)((EntityWithCustomValues)e).getCustomValues(), collection);
    }

    public void setOwnerUser(User user, Collection<UserCustomField> collection) {
        this.set("owner", (Object)user);
        this.set("user", (Object)SourceAccessor.from(user));
        this.setUserFields(user, collection);
    }

    public void setUserFields(User user, Collection<UserCustomField> collection) {
        Object object;
        boolean bl = CollectionHelper.isNotEmpty(collection);
        String string = SourceAccessor.storedFieldName(BasicProfileField.FULL_NAME);
        String string2 = SourceAccessor.sortFieldName(BasicProfileField.FULL_NAME);
        if (user.getName() == null) {
            if (bl) {
                this.map().put(string, null);
                this.map().put(string2, null);
            }
        } else {
            this.set(string, (Object)user.getName());
            this.set(string2, (Object)StringHelper.unaccent((String)user.getName()));
        }
        String string3 = SourceAccessor.storedFieldName(BasicProfileField.LOGIN_NAME);
        if (user.getUsername() == null) {
            if (bl) {
                this.map().put(string3, null);
            }
        } else {
            this.set(string3, (Object)user.getUsername().toLowerCase());
        }
        String string4 = SourceAccessor.storedFieldName(BasicProfileField.EMAIL);
        if (user.getEmail() == null) {
            if (bl) {
                this.map().put(string4, null);
                this.map().put("hideEmail", null);
            }
        } else {
            this.set(string4, (Object)user.getEmail().toLowerCase());
            this.set("hideEmail", (Object)user.isHideEmail());
        }
        this.set("hasProfileImage", (Object)(user.getImageId() != null ? 1 : 0));
        String string5 = SourceAccessor.storedFieldName(BasicProfileField.PHONE);
        this.set(SourceAccessor.privateSuffix(string5), user.getPhones().stream().filter(Phone::isHidden).map(Phone::getNormalizedNumber).collect(Collectors.toList()), bl);
        this.set(SourceAccessor.publicSuffix(string5), user.getPhones().stream().filter(phone -> !phone.isHidden()).map(Phone::getNormalizedNumber).collect(Collectors.toList()), bl);
        String string6 = SourceAccessor.storedFieldName(BasicProfileField.ADDRESS);
        this.set(SourceAccessor.privateSuffix(string6), user.getAddresses().stream().filter(UserAddress::isHidden).map(this::addressText).collect(Collectors.toList()), bl);
        this.set(SourceAccessor.publicSuffix(string6), user.getAddresses().stream().filter(userAddress -> !userAddress.isHidden()).map(this::addressText).collect(Collectors.toList()), bl);
        ConfigurationAccessor configurationAccessor = this.configurationHandler().getAccessor((BasicUser)user);
        AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
        if (accountNumberConfiguration != null && accountNumberConfiguration.isEnabled() && CollectionHelper.isNotEmpty((Map)(object = this.nativeQueryHandler().userAccounts(user, null, true, null)))) {
            this.set(SourceAccessor.storedFieldName(BasicProfileField.ACCOUNT_NUMBER), object.values().stream().map(IAccount::getNumber).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        this.setCustomValues((BasicUser)user, user, collection);
        object = user.getCustomValues().stream().filter(UserCustomFieldValue::isHidden).map(userCustomFieldValue -> userCustomFieldValue.getField().getId()).collect(Collectors.toSet());
        this.set("hiddenCustomProfileFields", object, true);
        this.set("userStatus", (Object)user.getStatus());
        this.set((Property<?, ?>)UserWithFieldsVO.GROUP, (Object)user.getGroup());
        Long l = SimpleEntity.id((SimpleEntity)user.getMainBroker());
        if (l != null) {
            this.set(UserWithFieldsVO.MAIN_BROKER.getName(), (Object)l);
            Set set = user.getBrokerIds().stream().filter(l2 -> !l2.equals(l)).collect(Collectors.toSet());
            this.set("otherBrokers", set, bl);
        } else if (bl) {
            this.set(UserWithFieldsVO.MAIN_BROKER.getName(), null, true);
            this.set("otherBrokers", null, true);
        }
    }

    public String toString() {
        return this.map().toString();
    }

    private String addressText(UserAddress userAddress) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(userAddress.getAddressLine1());
        arrayList.add(userAddress.getAddressLine2());
        arrayList.add(userAddress.getStreet());
        arrayList.add(userAddress.getBuildingNumber());
        arrayList.add(userAddress.getComplement());
        arrayList.add(userAddress.getCity());
        arrayList.add(userAddress.getRegion());
        String string = userAddress.getCountry();
        if (StringHelper.isNotBlank((Object)string)) {
            Locale locale = new Locale("", string);
            SourceAccessor.allLanguages((BasicUser)userAddress.getUser()).stream().map(LocaleHelper::mapLocale).map(locale2 -> locale.getDisplayCountry((Locale)locale2)).collect(Collectors.toSet()).forEach(arrayList::add);
        }
        return arrayList.stream().filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    private List<?> getList(String string) {
        Object object;
        Object object2 = object = this._map == null ? null : this._map.get(string);
        if (object instanceof List) {
            return (List)object;
        }
        return IteratorUtils.toList((Iterator)IteratorUtils.getIterator((Object)object));
    }

    private Object getSingle(String string) {
        Object object;
        Object object2 = object = this._map == null ? null : this._map.get(string);
        if (object instanceof Iterable) {
            object = CollectionHelper.first((Iterable)((Iterable)object));
        }
        return object;
    }

    private Object sourceValue(Object object3) {
        if (object3 == null) {
            return null;
        }
        if (object3 instanceof SourceAccessor) {
            return ((SourceAccessor)object3).map();
        }
        if (object3 instanceof Boolean) {
            return object3;
        }
        if (object3 instanceof CharSequence || object3 instanceof DateTime) {
            return object3.toString();
        }
        if (object3 instanceof Integer || object3 instanceof Long || object3 instanceof BigInteger || object3 instanceof Short || object3 instanceof Byte) {
            return ((Number)object3).longValue();
        }
        if (object3 instanceof Number) {
            return ((Number)object3).doubleValue();
        }
        if (object3 instanceof Enum) {
            return ((Enum)object3).name();
        }
        if (object3 instanceof DatePeriod) {
            DatePeriod datePeriod = (DatePeriod)object3;
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (datePeriod.getBegin() != null) {
                linkedHashMap.put("begin", this.sourceValue(datePeriod.getBegin()));
            }
            if (datePeriod.getEnd() != null) {
                linkedHashMap.put("end", this.sourceValue(datePeriod.getEnd()));
            }
            return linkedHashMap;
        }
        if (object3 instanceof IDatePeriod) {
            IDatePeriod iDatePeriod = (IDatePeriod)object3;
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (iDatePeriod.getBegin() != null) {
                linkedHashMap.put("begin", this.sourceValue(iDatePeriod.getBegin()));
            }
            if (iDatePeriod.getEnd() != null) {
                linkedHashMap.put("end", this.sourceValue(iDatePeriod.getEnd()));
            }
            return linkedHashMap;
        }
        if (object3 instanceof Range) {
            Range range = (Range)object3;
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (range.getMin() != null) {
                linkedHashMap.put("min", this.sourceValue(range.getMin()));
            }
            if (range.getMax() != null) {
                linkedHashMap.put("max", this.sourceValue(range.getMax()));
            }
            return linkedHashMap;
        }
        if (object3 instanceof IDate || object3 instanceof Date || object3 instanceof IDate || object3 instanceof Date) {
            Date date = object3 instanceof DateWrapper ? ((DateWrapper)object3).getDate() : (Date)object3;
            DateTime dateTime = this.conversionHandler().toDateTime(date);
            return dateTime.toString();
        }
        if (object3 instanceof IEntity) {
            return ((IEntity)object3).getId();
        }
        if (object3 instanceof Map) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            ((Map)object3).forEach((object, object2) -> {
                Object object3 = this.sourceValue(object2);
                if (object3 != null) {
                    linkedHashMap.put(object.toString(), object3);
                }
            });
            return linkedHashMap;
        }
        if (object3 instanceof Iterable || object3.getClass().isArray()) {
            Iterable iterable = CollectionHelper.iterable((Iterator)IteratorUtils.getIterator((Object)object3));
            ArrayList arrayList = new ArrayList();
            CollectionHelper.iterable(iterable.iterator()).forEach(object -> {
                Object object2 = this.sourceValue(object);
                if (object2 != null) {
                    arrayList.add(object2);
                }
            });
            return arrayList;
        }
        throw new IllegalStateException("Setting an OpenSearch source value with an unhandled data type: " + object3.getClass().getName() + " (" + String.valueOf(object3) + ")");
    }
}

