/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import org.cyclos.impl.sql.DbLock;
import org.cyclos.impl.sql.DbLockHandler;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class BaseDbLockHandlerImpl
implements DbLockHandler {
    protected static final int VALID_SECONDS = 10;
    protected JdbcTemplate jdbcTemplate;

    public BaseDbLockHandlerImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public final void lock(String string, DbLock dbLock) {
        try {
            if (dbLock == null) {
                this.create(string);
            } else if (!this.update(string, dbLock.getVersion())) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            this.throwAlreadyLocked(dbLock);
        }
    }

    public final DbLock read() {
        DbLock dbLock = this.doRead();
        if (dbLock != null) {
            dbLock.setIsLocked(dbLock.getSeconds() < 10);
        }
        return dbLock;
    }

    public final void sleepUntilTryingAgain(DbLock dbLock) {
        try {
            Thread.sleep((10 - dbLock.getSeconds()) * 1000);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public final void throwAlreadyLocked(DbLock dbLock) {
        Object object = "This database is currently being used by another Cyclos instance";
        if (dbLock != null) {
            object = (String)object + " at " + dbLock.getHost() + ", version " + dbLock.getCyclosVersion();
        }
        throw new IllegalStateException((String)object);
    }

    protected abstract void create(String var1);

    protected abstract DbLock doRead();

    protected abstract boolean update(String var1, int var2);
}

