/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.system.ConfigurationGuestProfileField;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.postgresql.NativeQuery;
import org.cyclos.impl.sql.postgresql.querydsl.StringOperator;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorExpression;
import org.cyclos.impl.sql.postgresql.querytypes.SAcceptedAgreements;
import org.cyclos.impl.sql.postgresql.querytypes.SAccounts;
import org.cyclos.impl.sql.postgresql.querytypes.SAddresses;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBrokerings;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfoEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfoFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfos;
import org.cyclos.impl.sql.postgresql.querytypes.SGeography;
import org.cyclos.impl.sql.postgresql.querytypes.SGroups;
import org.cyclos.impl.sql.postgresql.querytypes.SPendingUserAccounts;
import org.cyclos.impl.sql.postgresql.querytypes.SPhones;
import org.cyclos.impl.sql.postgresql.querytypes.SProducts;
import org.cyclos.impl.sql.postgresql.querytypes.SStoredFiles;
import org.cyclos.impl.sql.postgresql.querytypes.STsQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SUserCustomFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SUserEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SUserLoginStats;
import org.cyclos.impl.sql.postgresql.querytypes.SUsers;
import org.cyclos.impl.sql.postgresql.querytypes.SUsersProducts;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserProductsQueryResult;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.ContactInfoNature;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.GroupVisibility;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractUserNativeQuery<Q extends AbstractUserQuery, P extends UserWithFieldsVO>
extends NativeQuery<Q, User, P> {
    protected List<ProfileField> visibleProfileFields;
    protected List<ProfileField> profileFieldsInList;
    protected Set<ProfileField> projectedProfileFields;
    protected List<ContactInfoField> projectedAddressContactInfoFields;
    protected boolean canViewHidden;
    protected boolean myBrokered;
    protected GroupVisibility groupVisibility;
    private Map<Long, GroupVO> cachedGroupVOs;
    private Map<Long, GroupSetVO> cachedGroupSetVOs;
    protected SUsers u;
    protected SUserLoginStats uls;
    protected SStoredFiles i;
    protected SGroups g;
    protected SGroups gs;
    protected SProducts p;
    protected SUsersProducts up;
    protected SUsers bk;
    protected SPhones ph;
    protected SAccounts acct;
    protected SPendingUserAccounts pacct;
    protected Map<UserCustomField, SUserEnumValues> enumValues = new HashMap<UserCustomField, SUserEnumValues>();
    protected SBrokerings bn;
    protected SGeography geo;
    protected SAddresses addr;
    protected SContactInfos ci;
    protected NumberExpression<BigDecimal> distance;
    protected STsQuery q;
    protected TsVectorExpression tsvectors;
    @Autowired
    protected UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    protected ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    protected ProductServiceLocal productService;

    public AbstractUserNativeQuery(Class<P> clazz, Q q) {
        super(User.class, clazz, q);
    }

    public List<ProfileField> getProfileFieldsInList() {
        return this.profileFieldsInList;
    }

    protected void addNetworkFilter(SQLQuery<?> sQLQuery, SessionData sessionData) {
        Network network = sessionData.getNetwork();
        if (network == null) {
            sQLQuery.where((Predicate)this.u.networkId.isNull());
        } else {
            sQLQuery.where((Predicate)this.u.networkId.eq((Object)network.getId()));
        }
    }

    protected void applyAlphabeticOrderBy(SQLQuery<?> sQLQuery, boolean bl) {
        if (CollectionHelper.isEmpty(this.profileFieldsInList)) {
            StringPath stringPath = this.canViewHidden ? this.u.displayForManagers : this.u.displayForOthers;
            sQLQuery.orderBy((bl ? stringPath.desc() : stringPath.asc()).nullsLast());
            return;
        }
        boolean bl2 = false;
        block4: for (ProfileField profileField : this.profileFieldsInList) {
            UserCustomField userCustomField;
            if (profileField instanceof BasicProfileField) {
                switch ((BasicProfileField)profileField) {
                    case LOGIN_NAME: {
                        sQLQuery.orderBy(bl ? this.u.username.toLowerCase().desc() : this.u.username.toLowerCase().asc());
                        continue block4;
                    }
                    case EMAIL: {
                        sQLQuery.orderBy(bl ? this.u.email.desc() : this.u.email.asc());
                        continue block4;
                    }
                }
                if (bl2) continue;
                userCustomField = Expressions.stringOperation((Operator)StringOperator.IMMUTABLE_UNACCENT, (Expression[])new Expression[]{this.u.name}).toLowerCase();
                sQLQuery.orderBy(bl ? userCustomField.desc() : userCustomField.asc());
                bl2 = true;
                continue;
            }
            if (!(profileField instanceof UserCustomField)) continue;
            userCustomField = (UserCustomField)profileField;
            this.addOrderBy(SUserCustomFieldValues.class, SUserEnumValues.class, (CustomField<?, ?, ?>)userCustomField, this.u.id, bl);
        }
    }

    @Override
    protected RelationalPath<?> doGetMainEntityAlias() {
        return this.u;
    }

    protected Set<Group> getGroupsFilter(SQLQuery<?> sQLQuery, SessionData sessionData) {
        return this.groupsHandler.flattenVOs((Collection)((AbstractUserQuery)this.params).getGroups());
    }

    protected ProfileFieldSearchContext getProfileFieldsContext(boolean bl) {
        return bl ? ProfileFieldSearchContext.USER_FILTER : ProfileFieldSearchContext.USER_KEYWORDS;
    }

    protected boolean handlesAccountJoin() {
        return false;
    }

    protected boolean includeGlobals(Q q) {
        return false;
    }

    @Override
    protected List<Expression<?>> initializeQuery() {
        Pair<TsVectorExpression, BooleanBuilder> pair;
        BasicUser basicUser;
        Set set;
        Object object;
        Object object2;
        Set set2;
        Set set3;
        SQLQuery sQLQuery;
        Object object3;
        Object object4;
        Object object6;
        ProfileField profileField22;
        SQLQuery<?> sQLQuery2;
        DistanceDTO distanceDTO;
        boolean bl;
        ArrayList arrayList = new ArrayList();
        SessionData sessionData = this.getSessionData();
        this.myBrokered = this.isMyBrokered(sessionData);
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        this.groupVisibility = this.groupsHandler.getGroupVisibility(this.myBrokered);
        this.visibleProfileFields = sessionData.isGuest() ? configurationAccessor.getGuestProfileFields().stream().filter(ConfigurationGuestProfileField::isVisible).map(ConfigurationGuestProfileField::getProfileField).collect(Collectors.toList()) : this.profileFieldHandler.getMatchingFields(sessionData.getProducts().product().getUserProfileFields(), QProductUserProfileField.productUserProfileField.visible);
        this.profileFieldsInList = ((AbstractUserQuery)this.params).isIgnoreProfileFieldsInList() ? Collections.emptyList() : this.resolveProfileFieldsInList(sessionData);
        this.projectedProfileFields = new HashSet<ProfileField>(this.profileFieldsInList);
        this.projectedProfileFields.retainAll(this.visibleProfileFields);
        this.canViewHidden = sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
        this.u = new SUsers("u");
        this.g = new SGroups("g");
        this.gs = new SGroups("gs");
        this.p = new SProducts("p");
        this.up = new SUsersProducts("up");
        this.i = new SStoredFiles("i");
        String string = StringHelper.trimToNull((Object)((AbstractUserQuery)this.params).getKeywords());
        if (string != null) {
            this.q = STsQuery.of("query", string);
            arrayList.add((Expression<?>)this.q);
            this.tsvectors = TsVectorExpression.empty();
        }
        if (bl = ModelHelper.isValid((DistanceDTO)(distanceDTO = ((AbstractUserQuery)this.params).getDistance()))) {
            sQLQuery2 = distanceDTO.getLocation();
            this.geo = new SGeography("geo", sQLQuery2.getLatitude(), sQLQuery2.getLongitude());
            arrayList.add((Expression<?>)this.geo);
        }
        sQLQuery2 = this.getQuery();
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery2.from((Expression)this.u)).innerJoin((EntityPath)this.g)).on((Predicate)this.u.userGroupId.eq(this.g.id))).leftJoin((EntityPath)this.gs)).on((Predicate)this.g.groupSetId.eq(this.gs.id))).leftJoin((EntityPath)this.i)).on((Predicate)this.u.imageId.eq(this.i.id));
        DatePeriodDTO datePeriodDTO = ((AbstractUserQuery)this.params).getLastLogin();
        if (datePeriodDTO != null && (datePeriodDTO.getBegin() != null || datePeriodDTO.getEnd() != null)) {
            this.uls = SUserLoginStats.userLoginStats;
            ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.uls)).on((Predicate)this.u.id.eq(this.uls.userId));
        }
        for (ProfileField profileField22 : this.projectedProfileFields) {
            Object object7;
            if (profileField22 instanceof BasicProfileField) {
                switch ((BasicProfileField)profileField22) {
                    case ACCOUNT_NUMBER: {
                        if (this.handlesAccountJoin()) break;
                        this.acct = SAccounts.accounts;
                        object7 = new SAccounts("acct1");
                        ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.acct)).on((Predicate)this.acct.userId.eq(this.u.id).and((Predicate)this.acct.id.eq((Expression)((SQLQuery)new SQLQuery().select((Expression)object7.id.min()).from((Expression)object7)).where(new Predicate[]{object7.userId.eq(this.u.id), object7.active.isTrue(), object7.number.isNotNull(), object7.number.isNotEmpty()}))));
                        this.pacct = SPendingUserAccounts.pendingUserAccounts;
                        object6 = new SPendingUserAccounts("pacct1");
                        ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.pacct)).on((Predicate)this.pacct.userId.eq(this.u.id).and((Predicate)this.pacct.id.eq((Expression)((SQLQuery)new SQLQuery().select((Expression)object6.id.min()).from((Expression)object6)).where(new Predicate[]{object6.userId.eq(this.u.id), object6.active.isNull().or((Predicate)object6.active.isTrue()), object6.number.isNotNull(), object6.number.isNotEmpty()}))));
                        break;
                    }
                    case PHONE: {
                        this.ph = SPhones.phones;
                        object7 = new SPhones("ph1");
                        ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.ph)).on((Predicate)this.ph.userId.eq(this.u.id).and((Predicate)this.ph.id.eq((Expression)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery().select(object7.id).from((Expression)object7)).where(new Predicate[]{object7.userId.eq(this.u.id), this.canViewHidden ? object7.id.isNotNull() : object7.hidden.isFalse()})).orderBy(((NumberExpression)Expressions.cases().when((Predicate)object7.subclass.eq((Object)PhoneNature.MOBILE).and((Predicate)object7.verificationDate.isNotNull())).then((Number)1).when((Predicate)object7.subclass.eq((Object)PhoneNature.MOBILE)).then((Object)2).otherwise((Object)3)).asc())).limit(1L))));
                        break;
                    }
                }
                continue;
            }
            object7 = (UserCustomField)profileField22;
            this.join(SUserCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SUserEnumValues.class, (CustomField<?, ?, ?>)object7, this.u.id);
        }
        boolean bl2 = ((AbstractUserQuery)this.params).isIncludeMainBroker();
        if (bl2) {
            this.bk = new SUsers("bk");
            this.bn = new SBrokerings("bn");
            ((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.bn)).on((Predicate)this.bn.userId.eq(this.u.id).and((Predicate)this.bn.mainBroker.isTrue()).and((Predicate)this.bn.endDate.isNull().or((Predicate)this.bn.endDate.after((Expression)DateTimeExpression.currentTimestamp()))))).leftJoin((EntityPath)this.bk)).on((Predicate)this.bn.brokerId.eq(this.bk.id));
        }
        if ((profileField22 = ((AbstractUserQuery)this.params).getAddressResult()) == null || profileField22 == UserAddressResult.NEAREST_ADDRESS && !bl) {
            profileField22 = UserAddressResult.NO_ADDRESSES;
        }
        boolean bl3 = sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
        if (profileField22 == UserAddressResult.NO_ADDRESSES) {
            this.projectedAddressContactInfoFields = Collections.emptyList();
        } else {
            this.addr = new SAddresses("addr");
            if (bl) {
                this.distance = this.addr.geography.distance(this.geo);
            }
            object6 = new BooleanBuilder((Predicate)this.addr.userId.eq(this.u.id));
            object6.and((Predicate)this.addr.latitude.isNotNull().and((Predicate)this.addr.longitude.isNotNull()));
            if (!bl3) {
                object6.and((Predicate)this.addr.hidden.isFalse());
            }
            switch (1.$SwitchMap$org$cyclos$model$users$addresses$UserAddressResult[profileField22.ordinal()]) {
                case 1: {
                    ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.addr)).on((Predicate)object6);
                    this.ensureSingleAddress(sessionData, sQLQuery2);
                    break;
                }
                case 2: {
                    ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.addr)).on((Predicate)object6.and((Predicate)this.addr.defaultAddress.eq(Boolean.valueOf(true))));
                    break;
                }
                case 3: {
                    ((SQLQuery)sQLQuery2.innerJoin((EntityPath)this.addr)).on((Predicate)object6);
                    break;
                }
                default: {
                    throw new IllegalActionException();
                }
            }
            this.projectedAddressContactInfoFields = this.contactInfoFieldService.listForMap();
            this.ci = SContactInfos.contactInfo;
            ((SQLQuery)sQLQuery2.leftJoin((EntityPath)this.ci)).on((Predicate)this.ci.addressId.eq(this.addr.id).and((Predicate)this.ci.subclass.eq((Object)ContactInfoNature.ADDRESS)));
            for (ContactInfoField object52 : this.projectedAddressContactInfoFields) {
                this.join(SContactInfoFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SContactInfoEnumValues.class, (CustomField<?, ?, ?>)object52, this.ci.id);
            }
        }
        object6 = this.applyUserProfileFieldFilters(this.getProfileFieldsContext(true), this.u, this.myBrokered, ((AbstractUserQuery)this.params).getProfileFields(), this.addr);
        arrayList.addAll((Collection<Expression<?>>)object6);
        if (bl) {
            double d = configurationAccessor.getDistanceUnit().toMeters(distanceDTO.getDistance().doubleValue());
            if (profileField22 != UserAddressResult.NO_ADDRESSES) {
                sQLQuery2.where((Predicate)this.addr.geography.distance(this.geo).lt((Number)d));
            } else {
                object4 = new SAddresses("a1");
                object3 = (SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object4)).where(new Predicate[]{((SAddresses)((Object)object4)).userId.eq(this.u.id), ((SAddresses)((Object)object4)).latitude.isNotNull().and((Predicate)((SAddresses)((Object)object4)).longitude.isNotNull()), bl3 ? ((SAddresses)((Object)object4)).id.isNotNull() : ((SAddresses)((Object)object4)).hidden.isFalse(), ((SAddresses)((Object)object4)).geography.distance(this.geo).loe((Number)d)});
                sQLQuery2.where((Predicate)object3.exists());
            }
        }
        Object object8 = GroupList.USERS;
        if (this.params instanceof UserQuery) {
            UserQuery userQuery = (UserQuery)this.params;
            if (userQuery.isMapDirectory()) {
                object8 = GroupList.DIRECTORY;
            } else if (userQuery.isFromMenu()) {
                object8 = GroupList.MENU;
            } else if (userQuery.isOnlyContacts()) {
                object8 = GroupList.ACCESSIBLE;
            }
        }
        this.visibility(this.u.id, this.g.id).others((GroupList)object8, this.includeGlobals((AbstractUserQuery)this.params));
        Set set4 = this.conversionHandler.convertSet(User.class, (Iterable)((AbstractUserQuery)this.params).getBrokers());
        if (!set4.isEmpty()) {
            object4 = new SBrokerings("bn1");
            object3 = ((AbstractUserQuery)this.params).getOnlyBrokerIsMain();
            sQLQuery2.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object4)).where(new Predicate[]{((SBrokerings)((Object)object4)).userId.eq(this.u.id), ((SBrokerings)((Object)object4)).endDate.isNull().or((Predicate)((SBrokerings)((Object)object4)).endDate.after((Expression)DateTimeExpression.currentTimestamp())), object3 == null ? ((SBrokerings)((Object)object4)).id.isNotNull() : ((SBrokerings)((Object)object4)).mainBroker.eq((Boolean)object3), ((SBrokerings)((Object)object4)).brokerId.in((Collection)SimpleEntity.uniqueIds((Collection)set4))})).exists());
        }
        if ((object4 = ((AbstractUserQuery)this.params).getHasBroker()) != null) {
            object3 = new SBrokerings("bn2");
            sQLQuery = (SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object3)).where(new Predicate[]{((SBrokerings)((Object)object3)).userId.eq(this.u.id), ((SBrokerings)((Object)object3)).endDate.isNull().or((Predicate)((SBrokerings)((Object)object3)).endDate.after((Expression)DateTimeExpression.currentTimestamp()))});
            sQLQuery2.where((Predicate)(((Boolean)object4).booleanValue() ? sQLQuery.exists() : sQLQuery.notExists()));
        }
        if ((object3 = BulkActionServiceLocal.getEmailRequired((AbstractUserQuery)((AbstractUserQuery)this.params))) != null) {
            sQLQuery2.where((Predicate)(((Boolean)object3).booleanValue() ? this.u.email.isNotNull() : this.u.email.isNull()));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set3 = SimpleEntity.uniqueIds(sQLQuery = this.getGroupsFilter(sQLQuery2, sessionData))))) {
            sQLQuery2.where((Predicate)this.g.id.in((Collection)set3));
        }
        this.addNetworkFilter(sQLQuery2, sessionData);
        Set set5 = this.conversionHandler.convertSet(Product.class, (Iterable)((AbstractUserQuery)this.params).getProducts());
        if (!set5.isEmpty()) {
            if (((AbstractUserQuery)this.params).isProductsIndividuallyAssigned()) {
                sQLQuery2.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)this.up)).where(new Predicate[]{this.up.userId.eq(this.u.id), this.up.productId.in((Collection)SimpleEntity.uniqueIds((Collection)set5))})).exists());
            } else {
                set2 = this.productService.productQuery((Collection)set5);
                sQLQuery2.where(AbstractUserNativeQuery.apply((UserProductsQueryResult)set2, this.u));
            }
        }
        if (!(set2 = this.conversionHandler.convertSet(Agreement.class, (Iterable)((AbstractUserQuery)this.params).getAcceptedAgreements())).isEmpty()) {
            object2 = SAcceptedAgreements.acceptedAgreements;
            sQLQuery2.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object2)).where(new Predicate[]{((SAcceptedAgreements)((Object)object2)).userId.eq(this.u.id), ((SAcceptedAgreements)((Object)object2)).agreementId.in((Collection)SimpleEntity.uniqueIds((Collection)set2))})).exists());
        }
        if (!(object2 = this.conversionHandler.convertSet(Agreement.class, (Iterable)((AbstractUserQuery)this.params).getNotAcceptedAgreements())).isEmpty()) {
            object = SAcceptedAgreements.acceptedAgreements;
            sQLQuery2.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object)).where(new Predicate[]{((SAcceptedAgreements)((Object)object)).userId.eq(this.u.id), ((SAcceptedAgreements)((Object)object)).agreementId.in((Collection)SimpleEntity.uniqueIds((Collection)object2))})).notExists());
        }
        if (!(object = this.conversionHandler.convertSet(User.class, (Iterable)((AbstractUserQuery)this.params).getUsersToExclude())).isEmpty()) {
            sQLQuery2.where((Predicate)this.u.id.notIn((Collection)SimpleEntity.uniqueIds((Collection)object)));
        }
        if (!(set = this.conversionHandler.convertSet(User.class, (Iterable)((AbstractUserQuery)this.params).getUsersToInclude())).isEmpty()) {
            sQLQuery2.where((Predicate)this.u.id.in((Collection)SimpleEntity.uniqueIds((Collection)set)));
        }
        if ((basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)((AbstractUserQuery)this.params).getInvitedBy())) != null) {
            sQLQuery2.where((Predicate)this.u.invitedById.eq((Object)basicUser.getId()));
        }
        if (QueryHelper.useParameter((Object)((AbstractUserQuery)this.params).getRoles())) {
            pair = new Pair<TsVectorExpression, BooleanBuilder>();
            block18: for (Role role : ((AbstractUserQuery)this.params).getRoles()) {
                switch (role) {
                    case ADMIN: {
                        pair.or((Predicate)this.g.subclass.eq((Object)BasicGroupNature.ADMIN_GROUP));
                        continue block18;
                    }
                    case GLOBAL_ADMIN: {
                        pair.or((Predicate)this.g.adminGroupType.eq((Object)AdminGroupType.GLOBAL));
                        continue block18;
                    }
                    case NETWORK_ADMIN: {
                        pair.or((Predicate)this.g.adminGroupType.eq((Object)AdminGroupType.NETWORK));
                        continue block18;
                    }
                    case BROKER: {
                        pair.or((Predicate)this.g.subclass.eq((Object)BasicGroupNature.BROKER_GROUP));
                        continue block18;
                    }
                    case MEMBER: {
                        pair.or((Predicate)this.g.subclass.in((Object[])new BasicGroupNature[]{BasicGroupNature.MEMBER_GROUP, BasicGroupNature.BROKER_GROUP}));
                        continue block18;
                    }
                }
                sQLQuery2.where((Predicate)this.u.id.isNull());
            }
            sQLQuery2.where((Predicate)pair);
        }
        this.filterByDatePeriod(((AbstractUserQuery)this.params).getCreated(), (DateTimeExpression<Date>)this.u.creationDate);
        this.filterByDatePeriod(((AbstractUserQuery)this.params).getActivated(), (DateTimeExpression<Date>)this.u.userActivationDate);
        if (this.uls != null) {
            this.filterByDatePeriod(datePeriodDTO, (DateTimeExpression<Date>)this.uls.lastLogin);
        }
        if (this.q != null) {
            pair = this.appendUserProfileFieldKeywords(this.getProfileFieldsContext(false), string, this.tsvectors, this.u, this.myBrokered);
            this.tsvectors = (TsVectorExpression)((Object)pair.getFirst());
            BooleanBuilder booleanBuilder = (BooleanBuilder)pair.getSecond();
            this.applyFullTextFilter(this.tsvectors, this.q, booleanBuilder);
        }
        return arrayList;
    }

    protected boolean isMyBrokered(SessionData sessionData) {
        User user = sessionData.getLoggedUser();
        Set set = this.conversionHandler.convertSet(User.class, (Iterable)((AbstractUserQuery)this.params).getBrokers());
        return sessionData.isBroker() && set.size() == 1 && ((User)CollectionHelper.first((Iterable)set)).equals((Object)user);
    }

    @Override
    protected void resetQuery() {
        super.resetQuery();
        this.u = null;
        this.i = null;
        this.g = null;
        this.p = null;
        this.up = null;
        this.bk = null;
        this.bn = null;
        this.geo = null;
        this.addr = null;
        this.ci = null;
        this.distance = null;
        this.q = null;
        this.tsvectors = null;
        this.enumValues.clear();
    }

    protected List<ProfileField> resolveProfileFieldsInList(SessionData sessionData) {
        return this.profileFieldHandler.getFieldsInUserList(this.isMyBrokered(sessionData));
    }

    private void ensureSingleAddress(SessionData sessionData, SQLQuery<?> sQLQuery) {
        boolean bl = this.isMyBrokered(sessionData);
        boolean bl2 = sessionData.isAdmin() || bl;
        SAddresses sAddresses = new SAddresses("a1");
        SQLQuery sQLQuery2 = (SQLQuery)((SQLQuery)new SQLQuery().select(sAddresses.id).from((Expression)sAddresses)).where(new Predicate[]{sAddresses.userId.eq(this.u.id), sAddresses.latitude.isNotNull().and((Predicate)sAddresses.longitude.isNotNull()), bl2 ? sAddresses.id.isNotNull() : sAddresses.hidden.isFalse()});
        if (this.geo != null) {
            sQLQuery2.orderBy(sAddresses.geography.distance(this.geo).asc());
        }
        sQLQuery2.limit(1L);
        sQLQuery.where((Predicate)this.addr.id.isNull().or((Predicate)this.addr.id.in((SubQueryExpression)sQLQuery2)));
    }

    protected abstract class AbstractUserProjection
    extends NativeQuery.BaseProjection {
        private static final long serialVersionUID = 1L;
        protected DistanceUnit distanceUnit;
        private String accountNumberMask;
        private ConfigurationAccessor configuration;

        public AbstractUserProjection() {
            SessionData sessionData = this.getSessionData();
            this.configuration = sessionData.getConfiguration();
            this.accountNumberMask = this.configuration.getAccountNumberConfiguration() == null ? null : this.configuration.getAccountNumberConfiguration().getMask();
            this.add(new Expression[]{AbstractUserNativeQuery.this.u.userGroupId});
            if (CollectionHelper.isEmpty(AbstractUserNativeQuery.this.projectedProfileFields)) {
                this.addUser(AbstractUserNativeQuery.this.u);
            } else {
                this.add(new Expression[]{AbstractUserNativeQuery.this.u.id});
                this.add(new Expression[]{AbstractUserNativeQuery.this.u.brokerIds});
                for (ProfileField profileField : AbstractUserNativeQuery.this.projectedProfileFields) {
                    if (profileField instanceof BasicProfileField) {
                        switch ((BasicProfileField)profileField) {
                            case LOGIN_NAME: {
                                this.add(new Expression[]{AbstractUserNativeQuery.this.u.username});
                                break;
                            }
                            case FULL_NAME: {
                                this.add(new Expression[]{AbstractUserNativeQuery.this.u.name});
                                break;
                            }
                            case EMAIL: {
                                this.add(new Expression[]{AbstractUserNativeQuery.this.u.email});
                                this.add(new Expression[]{AbstractUserNativeQuery.this.u.userHideEmail});
                                break;
                            }
                            case ACCOUNT_NUMBER: {
                                this.add(new Expression[]{AbstractUserNativeQuery.this.acct.number});
                                this.add(new Expression[]{AbstractUserNativeQuery.this.pacct.number});
                                break;
                            }
                            case PHONE: {
                                this.add(new Expression[]{AbstractUserNativeQuery.this.ph.normalizedNumber});
                                break;
                            }
                        }
                        continue;
                    }
                    UserCustomField userCustomField = (UserCustomField)profileField;
                    this.addCustomFieldValue((CustomField<?, ?, ?>)userCustomField);
                }
            }
            this.addImage(AbstractUserNativeQuery.this.i);
            if (AbstractUserNativeQuery.this.addr != null) {
                this.addAddress(AbstractUserNativeQuery.this.addr, AbstractUserNativeQuery.this.ci, AbstractUserNativeQuery.this.projectedAddressContactInfoFields);
                if (AbstractUserNativeQuery.this.distance != null) {
                    this.add(new Expression[]{AbstractUserNativeQuery.this.distance});
                    this.distanceUnit = this.configuration.getDistanceUnit();
                }
            }
            if (AbstractUserNativeQuery.this.bk != null) {
                this.addUser(AbstractUserNativeQuery.this.bk);
            }
            if (((AbstractUserQuery)AbstractUserNativeQuery.this.params).isIncludeGroup() && AbstractUserNativeQuery.this.groupVisibility == GroupVisibility.GROUP) {
                this.add(new Expression[]{AbstractUserNativeQuery.this.g.id});
            }
            if (((AbstractUserQuery)AbstractUserNativeQuery.this.params).isIncludeGroupSet() && AbstractUserNativeQuery.this.groupVisibility != GroupVisibility.NONE) {
                this.add(new Expression[]{AbstractUserNativeQuery.this.gs.id});
            }
        }

        protected P instantiate() {
            Object object;
            ProfileField profileField;
            Object object2;
            UserWithFieldsVO userWithFieldsVO;
            Long l = (Long)this.get((Expression)AbstractUserNativeQuery.this.u.id);
            if (CollectionHelper.isEmpty(AbstractUserNativeQuery.this.profileFieldsInList)) {
                userWithFieldsVO = (UserWithFieldsVO)AbstractUserNativeQuery.this.userService.toUserVO(this.getType(), this.getSessionData(), l, (String)this.get((Expression)AbstractUserNativeQuery.this.u.displayForManagers), (String)this.get((Expression)AbstractUserNativeQuery.this.u.displayForOthers), (String)this.get((Expression)AbstractUserNativeQuery.this.u.brokerIds), this.getImage(AbstractUserNativeQuery.this.i));
            } else {
                userWithFieldsVO = (UserWithFieldsVO)AbstractUserNativeQuery.this.userService.toUserVO(this.getType(), this.getSessionData(), l, null, null, (String)this.get((Expression)AbstractUserNativeQuery.this.u.brokerIds), this.getImage(AbstractUserNativeQuery.this.i));
                object2 = AbstractUserNativeQuery.this.profileFieldsInList.iterator();
                while (object2.hasNext()) {
                    profileField = object2.next();
                    object = this.get(l, profileField);
                    if (profileField instanceof BasicProfileField) {
                        switch ((BasicProfileField)profileField) {
                            case ACCOUNT_NUMBER: {
                                userWithFieldsVO.setAccountNumber((String)object);
                                break;
                            }
                            case EMAIL: {
                                userWithFieldsVO.setEmail((String)object);
                                break;
                            }
                            case FULL_NAME: {
                                userWithFieldsVO.setName((String)object);
                                break;
                            }
                            case LOGIN_NAME: {
                                userWithFieldsVO.setUsername((String)object);
                                break;
                            }
                            case PHONE: {
                                userWithFieldsVO.setPhone((String)object);
                                break;
                            }
                        }
                        continue;
                    }
                    if (object == null) continue;
                    if (userWithFieldsVO.getCustomValues() == null) {
                        userWithFieldsVO.setCustomValues(new ArrayList());
                    }
                    userWithFieldsVO.getCustomValues().add((CustomFieldValueVO)object);
                }
            }
            if (AbstractUserNativeQuery.this.addr != null) {
                object2 = this.buildAddress(AbstractUserNativeQuery.this.addr, (Long)this.get((Expression)AbstractUserNativeQuery.this.u.userGroupId), AbstractUserNativeQuery.this.distance, this.distanceUnit, AbstractUserNativeQuery.this.projectedAddressContactInfoFields, AbstractUserNativeQuery.this.ci);
                userWithFieldsVO.setAddress((UserAddressVO)object2);
            }
            if (AbstractUserNativeQuery.this.bk != null && this.get((Expression)AbstractUserNativeQuery.this.bk.id) != null) {
                userWithFieldsVO.setMainBroker(AbstractUserNativeQuery.this.userService.toUserVO(this.getSessionData(), (Long)this.get((Expression)AbstractUserNativeQuery.this.bk.id), (String)this.get((Expression)AbstractUserNativeQuery.this.bk.displayForManagers), (String)this.get((Expression)AbstractUserNativeQuery.this.bk.displayForOthers), (String)this.get((Expression)AbstractUserNativeQuery.this.bk.brokerIds), null));
            }
            if (((AbstractUserQuery)AbstractUserNativeQuery.this.params).isIncludeGroup() && AbstractUserNativeQuery.this.groupVisibility == GroupVisibility.GROUP) {
                object2 = (Long)this.get((Expression)AbstractUserNativeQuery.this.g.id);
                if (AbstractUserNativeQuery.this.cachedGroupVOs == null) {
                    AbstractUserNativeQuery.this.cachedGroupVOs = new HashMap<Long, GroupVO>();
                }
                if ((profileField = AbstractUserNativeQuery.this.cachedGroupVOs.get(object2)) == null) {
                    object = (Group)AbstractUserNativeQuery.this.rawEntityManagerHandler.find(Group.class, (Long)object2);
                    profileField = (GroupVO)AbstractUserNativeQuery.this.conversionHandler.convert(GroupVO.class, object);
                    AbstractUserNativeQuery.this.cachedGroupVOs.put((Long)object2, (GroupVO)profileField);
                }
                userWithFieldsVO.setGroup((GroupVO)profileField);
            }
            if (((AbstractUserQuery)AbstractUserNativeQuery.this.params).isIncludeGroupSet() && AbstractUserNativeQuery.this.groupVisibility != GroupVisibility.NONE && (object2 = (Long)this.get((Expression)AbstractUserNativeQuery.this.gs.id)) != null) {
                if (AbstractUserNativeQuery.this.cachedGroupSetVOs == null) {
                    AbstractUserNativeQuery.this.cachedGroupSetVOs = new HashMap<Long, GroupSetVO>();
                }
                if ((profileField = AbstractUserNativeQuery.this.cachedGroupSetVOs.get(object2)) == null) {
                    object = (GroupSet)AbstractUserNativeQuery.this.rawEntityManagerHandler.find(GroupSet.class, (Long)object2);
                    profileField = (GroupSetVO)AbstractUserNativeQuery.this.conversionHandler.convert(GroupSetVO.class, object);
                    AbstractUserNativeQuery.this.cachedGroupSetVOs.put((Long)object2, (GroupSetVO)profileField);
                }
                userWithFieldsVO.setGroupSet((GroupSetVO)profileField);
            }
            return userWithFieldsVO;
        }

        private Object get(Long l, ProfileField profileField) {
            if (!AbstractUserNativeQuery.this.visibleProfileFields.contains(profileField)) {
                return null;
            }
            if (profileField instanceof BasicProfileField) {
                switch ((BasicProfileField)profileField) {
                    case LOGIN_NAME: {
                        return this.get((Expression)AbstractUserNativeQuery.this.u.username);
                    }
                    case FULL_NAME: {
                        return this.get((Expression)AbstractUserNativeQuery.this.u.name);
                    }
                    case EMAIL: {
                        Boolean bl = (Boolean)this.get((Expression)AbstractUserNativeQuery.this.u.userHideEmail);
                        if (!AbstractUserNativeQuery.this.canViewHidden && Boolean.TRUE.equals(bl)) {
                            return null;
                        }
                        return this.get((Expression)AbstractUserNativeQuery.this.u.email);
                    }
                    case ACCOUNT_NUMBER: {
                        String string = (String)ObjectHelper.defaultValue((Object)((String)this.get((Expression)AbstractUserNativeQuery.this.acct.number)), (Object)((String)this.get((Expression)AbstractUserNativeQuery.this.pacct.number)));
                        return MaskHelper.applyMask((String)this.accountNumberMask, (String)string);
                    }
                    case PHONE: {
                        String string = (String)this.get((Expression)AbstractUserNativeQuery.this.ph.normalizedNumber);
                        PhoneNumberDescriptor phoneNumberDescriptor = AbstractUserNativeQuery.this.phoneNumberHandler.parse(string, this.configuration);
                        return phoneNumberDescriptor == null ? string : AbstractUserNativeQuery.this.phoneNumberHandler.format(phoneNumberDescriptor, this.configuration);
                    }
                }
                return null;
            }
            UserCustomField userCustomField = (UserCustomField)profileField;
            return this.getCustomFieldValue(SUserCustomFieldValues.class, SUserEnumValues.class, l, UserCustomFieldValue.class, userCustomField, AbstractUserNativeQuery.this.canViewHidden);
        }
    }
}

