/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.sql.postgresql.NativeQuery;
import org.cyclos.impl.sql.postgresql.querydsl.TsVector;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorExpression;
import org.cyclos.impl.sql.postgresql.querytypes.SAdCustomFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SAdDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SAdEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SAddresses;
import org.cyclos.impl.sql.postgresql.querytypes.SAds;
import org.cyclos.impl.sql.postgresql.querytypes.SAdsAddresses;
import org.cyclos.impl.sql.postgresql.querytypes.SAdsCategories;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBrokerings;
import org.cyclos.impl.sql.postgresql.querytypes.SCurrencies;
import org.cyclos.impl.sql.postgresql.querytypes.SGeography;
import org.cyclos.impl.sql.postgresql.querytypes.SGroups;
import org.cyclos.impl.sql.postgresql.querytypes.SStoredFiles;
import org.cyclos.impl.sql.postgresql.querytypes.STsQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SUsers;
import org.cyclos.impl.sql.postgresql.querytypes.SUsersFavoriteAds;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.UserProductsQueryResult;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.advertisements.AdOrderBy;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.AdvertisementVO;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.users.addresses.AdAddressResult;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class AdvertisementsNativeQuery
extends NativeQuery<BasicAdQuery, BasicAd, BasicAdVO> {
    private SAds ad;
    private SAddresses addr;
    private SUsers u;
    private SStoredFiles ui;
    private SGroups g;
    private STsQuery q;
    private TsVectorExpression tsvectors;
    private SGeography geo;
    private SCurrencies cur;
    private SAdsCategories ac;
    private SUsersFavoriteAds ufa;
    private NumberExpression<BigDecimal> price;
    private SStoredFiles i;
    private NumberExpression<BigDecimal> distance;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private AdServiceSecurity adServiceSecurity;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private BrokeringServiceLocal brokeringService;

    public AdvertisementsNativeQuery(BasicAdQuery basicAdQuery) {
        super(BasicAd.class, BasicAdVO.class, basicAdQuery);
    }

    protected BooleanExpression brokersFilter(Set<User> set) {
        SBrokerings sBrokerings = SBrokerings.brokerings;
        return ((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)sBrokerings)).where(new Predicate[]{sBrokerings.userId.eq(this.u.id), sBrokerings.endDate.isNull().or((Predicate)sBrokerings.endDate.after((Expression)DateTimeExpression.currentTimestamp())), sBrokerings.brokerId.in((Collection)SimpleEntity.ids(set))})).exists();
    }

    @Override
    protected RelationalPath<?> doGetMainEntityAlias() {
        return this.ad;
    }

    @Override
    protected Expression<BasicAdVO> doGetProjection(Integer n) {
        return new AdProjection();
    }

    @Override
    protected List<Expression<?>> initializeQuery() {
        AdOrderBy adOrderBy;
        BooleanBuilder booleanBuilder;
        Pair<BooleanBuilder, STsQuery> pair;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        BooleanBuilder booleanBuilder2;
        Set set;
        UserProductsQueryResult userProductsQueryResult;
        Object object6;
        Collection collection;
        Object object7;
        Object object8;
        Object object9;
        Object object102;
        Pair<TsVectorExpression, BooleanBuilder> pair2;
        Object object11;
        ArrayList arrayList = new ArrayList();
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        User user = basicUser == null ? null : basicUser.getUser();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        Set set2 = this.conversionHandler.convertSet(User.class, (Iterable)((BasicAdQuery)this.params).getBrokers());
        boolean bl = sessionData.isBroker() && set2.size() == 1 && sessionData.getLoggedUser().equals(CollectionHelper.first((Iterable)set2));
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)((BasicAdQuery)this.params).getOwner());
        List list = this.adCustomFieldService.listVisible(user2, sessionData.isAdmin() || bl);
        this.ad = new SAds("ad");
        this.u = new SUsers("u");
        this.ui = new SStoredFiles("ui");
        this.g = new SGroups("g");
        this.cur = new SCurrencies("cur");
        this.ac = new SAdsCategories("ac");
        this.i = new SStoredFiles("i");
        DistanceDTO distanceDTO = ((BasicAdQuery)this.params).getDistance();
        boolean bl2 = ModelHelper.isValid((DistanceDTO)distanceDTO);
        if (bl2) {
            object11 = distanceDTO.getLocation();
            this.geo = new SGeography("geo", object11.getLatitude(), object11.getLongitude());
            arrayList.add((Expression<?>)this.geo);
        }
        if ((object11 = StringHelper.trimToNull((Object)((BasicAdQuery)this.params).getKeywords())) != null) {
            this.q = STsQuery.of("query", (String)object11);
            this.tsvectors = this.ad.nameTsVector.concatenate((Expression<TsVector>)this.ad.descriptionTsVector);
            arrayList.add((Expression<?>)this.q);
        }
        SQLQuery<?> sQLQuery = this.getQuery();
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery.from((Expression)this.ad)).innerJoin((EntityPath)this.u)).on((Predicate)this.ad.ownerId.eq(this.u.id))).leftJoin((EntityPath)this.ui)).on((Predicate)this.u.imageId.eq(this.ui.id))).innerJoin((EntityPath)this.g)).on((Predicate)this.u.userGroupId.eq(this.g.id))).leftJoin((EntityPath)this.cur)).on((Predicate)this.ad.currencyId.eq(this.cur.id))).leftJoin((EntityPath)this.i)).on((Predicate)this.ad.imageId.eq(this.i.id));
        DateTimeExpression dateTimeExpression = DateTimeExpression.currentTimestamp();
        this.price = (NumberExpression)new CaseBuilder().when((Predicate)this.ad.promotionalPrice.isNotNull().and((Predicate)this.ad.beginPromotionalPricePeriod.isNotNull().and((Predicate)this.ad.endPromotionalPricePeriod.isNotNull()).and((Predicate)dateTimeExpression.between(this.ad.beginPromotionalPricePeriod, this.ad.endPromotionalPricePeriod)))).then(this.ad.promotionalPrice).otherwise(this.ad.priceAmount);
        BooleanBuilder booleanBuilder3 = null;
        if (object11 != null) {
            pair2 = this.appendUserProfileFieldKeywords(ProfileFieldSearchContext.AD_KEYWORDS, (String)object11, this.tsvectors, this.u, bl);
            this.tsvectors = (TsVectorExpression)((Object)pair2.getFirst());
            booleanBuilder3 = (BooleanBuilder)pair2.getSecond();
            for (Object object102 : list) {
                if (!object102.getType().isSearchable()) continue;
                object9 = this.join(SAdCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SAdEnumValues.class, (CustomField<?, ?, ?>)object102, this.ad.id);
                this.tsvectors = this.tsvectors.concatenate((Expression<TsVector>)object9.valueTsVector);
            }
        }
        if ((pair2 = ((BasicAdQuery)this.params).getAddressResult()) == null || pair2 == AdAddressResult.NEAREST_ADDRESS && !bl2) {
            pair2 = AdAddressResult.NO_ADDRESSES;
        }
        boolean bl3 = sessionData.hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS);
        if (pair2 != AdAddressResult.NO_ADDRESSES) {
            this.addr = new SAddresses("addr");
            if (bl2) {
                this.distance = this.addr.geography.distance(this.geo);
            }
            object102 = new SAdsAddresses("aa");
            object9 = new BooleanBuilder((Predicate)this.addr.id.eq(((SAdsAddresses)((Object)object102)).addressId));
            object9.and((Predicate)this.addr.latitude.isNotNull().and((Predicate)this.addr.longitude.isNotNull()));
            if (!bl3) {
                object9.and((Predicate)this.addr.hidden.isNull().or((Predicate)this.addr.hidden.isFalse()));
            }
            if (pair2 == AdAddressResult.NEAREST_ADDRESS) {
                ((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery.leftJoin((EntityPath)object102)).on((Predicate)((SAdsAddresses)((Object)object102)).adId.eq(this.ad.id))).leftJoin((EntityPath)this.addr)).on((Predicate)object9);
                object8 = new SAdsAddresses("aa1");
                object7 = new SAddresses("a1");
                sQLQuery.where((Predicate)((SAdsAddresses)((Object)object102)).addressId.isNull().or((Predicate)((SAdsAddresses)((Object)object102)).addressId.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery().select(object7.id).from((Expression)object8)).innerJoin((EntityPath)object7)).on((Predicate)object8.addressId.eq(object7.id))).where(new Predicate[]{object8.adId.eq(this.ad.id), object7.latitude.isNotNull().and((Predicate)object7.longitude.isNotNull()), bl3 ? object7.id.isNotNull() : object7.hidden.isNull().or((Predicate)object7.hidden.isFalse())})).orderBy(object7.geography.distance(this.geo).asc())).limit(1L))));
            } else {
                ((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery.innerJoin((EntityPath)object102)).on((Predicate)((SAdsAddresses)((Object)object102)).adId.eq(this.ad.id))).innerJoin((EntityPath)this.addr)).on((Predicate)object9);
            }
        }
        object102 = ((BasicAdQuery)this.params).getUserProfileFields();
        object9 = this.applyUserProfileFieldFilters(ProfileFieldSearchContext.AD_FILTER, this.u, bl, (Set<BaseValueForSearchDTO>)object102, this.addr);
        arrayList.addAll((Collection<Expression<?>>)object9);
        sQLQuery.where((Predicate)this.ad.deletedDate.isNull());
        object8 = sessionData.getNetwork();
        if (object8 == null) {
            sQLQuery.where((Predicate)this.g.networkId.isNull());
        } else {
            sQLQuery.where((Predicate)this.g.networkId.eq((Object)object8.getId()));
        }
        this.visibility(this.u.id, this.g.id).others(GroupList.ADS);
        object7 = (AdCategory)this.conversionHandler.convert(AdCategory.class, (Object)((BasicAdQuery)this.params).getCategory());
        HashSet<Long> hashSet = new HashSet<Long>();
        if (object7 != null) {
            this.collectCategoryIds(hashSet, Arrays.asList(object7));
        } else {
            collection = this.conversionHandler.convertList(AdCategory.class, (Iterable)this.adCategoryService.listVisible(user));
            this.collectCategoryIds((Set<Long>)hashSet, (List<AdCategory>)collection);
        }
        if (CollectionHelper.isNotEmpty(hashSet)) {
            sQLQuery.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)this.ac)).where(new Predicate[]{this.ac.adId.eq(this.ad.id), this.ac.adCategoryId.in(hashSet)})).exists());
        } else {
            sQLQuery.where((Predicate)this.ad.id.isNull());
        }
        collection = SimpleEntity.uniqueIds((Collection)this.groupsHandler.flattenVOs((Collection)((BasicAdQuery)this.params).getGroups()));
        if (CollectionHelper.isNotEmpty((Iterable)collection)) {
            sQLQuery.where((Predicate)this.g.id.in(collection));
        }
        if (!set2.isEmpty()) {
            sQLQuery.where((Predicate)this.brokersFilter(set2));
        }
        if (user2 != null) {
            sQLQuery.where((Predicate)this.u.id.eq((Object)user2.getId()));
        }
        if (user != null && !user.equals((Object)user2)) {
            sQLQuery.where((Predicate)this.ad.status.ne((Object)AdStatus.DRAFT));
        }
        sQLQuery.where((Predicate)this.u.status.in((Object[])new UserStatus[]{UserStatus.ACTIVE, UserStatus.BLOCKED}));
        AdType adType = ((BasicAdQuery)this.params).getType();
        if (adType != null) {
            sQLQuery.where((Predicate)this.ad.subclass.eq((Object)adType));
            object6 = this.productService.permissionQuery(new Permission[]{adType == AdType.ADVERTISEMENT ? Permission.MY_ADS_ENABLE : Permission.MY_WEB_SHOP_ENABLE});
            sQLQuery.where(AdvertisementsNativeQuery.apply(object6, this.u));
        } else {
            object6 = this.productService.permissionQuery(new Permission[]{Permission.MY_ADS_ENABLE});
            userProductsQueryResult = this.productService.permissionQuery(new Permission[]{Permission.MY_WEB_SHOP_ENABLE});
            sQLQuery.where((Predicate)this.ad.subclass.eq((Object)AdType.ADVERTISEMENT).and(AdvertisementsNativeQuery.apply(object6, this.u)).or((Predicate)this.ad.subclass.eq((Object)AdType.WEB_SHOP).and(AdvertisementsNativeQuery.apply(userProductsQueryResult, this.u))));
        }
        if (((BasicAdQuery)this.params).isHasImages()) {
            sQLQuery.where((Predicate)this.i.id.isNotNull());
        }
        if ((object6 = StringHelper.trimToNull((Object)((BasicAdQuery)this.params).getProductNumber())) != null) {
            sQLQuery.where((Predicate)this.ad.productNumber.equalsIgnoreCase((String)object6));
        }
        if ((userProductsQueryResult = (Currency)this.conversionHandler.convert(Currency.class, (Object)((BasicAdQuery)this.params).getCurrency())) != null) {
            sQLQuery.where((Predicate)this.ad.currencyId.eq((Object)userProductsQueryResult.getId()));
        }
        if (!bl) {
            set = SimpleEntity.uniqueIds((Collection)this.currencyService.listForAds(null));
            booleanBuilder2 = new BooleanBuilder((Predicate)this.ad.currencyId.isNull());
            if (!set.isEmpty()) {
                booleanBuilder2.or((Predicate)this.ad.currencyId.in((Collection)set));
            }
            if (basicUser != null && basicUser.isBroker() && !(object5 = this.brokeringService.listBrokeredIds(user)).isEmpty()) {
                booleanBuilder2.or((Predicate)this.u.id.in((Collection)object5));
            }
            sQLQuery.where(booleanBuilder2.getValue());
        }
        if (QueryHelper.useParameter((Object)(set = ((BasicAdQuery)this.params).getStatuses()))) {
            booleanBuilder2 = new BooleanBuilder();
            for (Object object42 : set) {
                object3 = new BooleanBuilder((Predicate)this.ad.removedFromOwner.eq(Boolean.valueOf(object42 == AdStatus.DISABLED)));
                switch (1.$SwitchMap$org$cyclos$model$marketplace$advertisements$AdStatus[object42.ordinal()]) {
                    case 1: {
                        booleanBuilder2.or((Predicate)object3.and((Predicate)this.ad.endPublicationPeriod.before((Expression)dateTimeExpression)).and((Predicate)this.ad.status.in((Object[])new AdStatus[]{AdStatus.ACTIVE, AdStatus.EXPIRED, AdStatus.SCHEDULED})));
                        break;
                    }
                    case 2: {
                        booleanBuilder2.or((Predicate)object3.and((Predicate)this.ad.beginPublicationPeriod.after((Expression)dateTimeExpression)).and((Predicate)this.ad.status.in((Object[])new AdStatus[]{AdStatus.ACTIVE, AdStatus.EXPIRED, AdStatus.SCHEDULED})));
                        break;
                    }
                    case 3: {
                        booleanBuilder2.or((Predicate)object3.and((Predicate)this.ad.beginPublicationPeriod.before((Expression)dateTimeExpression)).and((Predicate)this.ad.endPublicationPeriod.after((Expression)dateTimeExpression)).and((Predicate)this.ad.status.in((Object[])new AdStatus[]{AdStatus.ACTIVE, AdStatus.EXPIRED, AdStatus.SCHEDULED})));
                        break;
                    }
                    case 4: {
                        booleanBuilder2.or((Predicate)object3);
                        break;
                    }
                    case 5: 
                    case 6: {
                        booleanBuilder2.or((Predicate)object3.and((Predicate)this.ad.status.eq(object42)));
                        break;
                    }
                    case 7: {
                        object2 = new ArrayList<AdType>();
                        if (this.adServiceSecurity.canViewPendings(AdType.ADVERTISEMENT, user2, bl)) {
                            object2.add(AdType.ADVERTISEMENT);
                        }
                        if (this.adServiceSecurity.canViewPendings(AdType.WEB_SHOP, user2, bl)) {
                            object2.add(AdType.WEB_SHOP);
                        }
                        booleanBuilder2.or((Predicate)object3.and((Predicate)(!object2.isEmpty() ? this.ad.subclass.in((Collection)object2) : this.ad.id.isNull())).and((Predicate)this.ad.status.eq(object42)));
                    }
                }
            }
            sQLQuery.where((Predicate)booleanBuilder2);
        }
        if ((booleanBuilder2 = ((BasicAdQuery)this.params).getPublishedSince()) != null && booleanBuilder2.getField() != null && booleanBuilder2.getAmount() != null) {
            object5 = DateHelper.subtract((Date)new Date(), (ITimeInterval)booleanBuilder2);
            object5 = DateHelper.shiftToBegin((Date)object5, (TimeZone)sessionData.getConfiguration().getTimeZone());
            sQLQuery.where((Predicate)this.ad.beginPublicationPeriod.eq(object5).or((Predicate)this.ad.beginPublicationPeriod.after((Comparable)object5)));
        }
        this.filterByDatePeriod(((BasicAdQuery)this.params).getPublicationPeriod(), (DateTimeExpression<Date>)this.ad.beginPublicationPeriod);
        this.filterByDatePeriod(((BasicAdQuery)this.params).getExpirationPeriod(), (DateTimeExpression<Date>)this.ad.endPublicationPeriod);
        object5 = ((BasicAdQuery)this.params).getPriceRange();
        if (object5 != null) {
            object42 = (Currency)this.conversionHandler.convert(Currency.class, (Object)object5.getCurrency());
            if (object42 != null) {
                sQLQuery.where((Predicate)this.ad.currencyId.eq((Object)object42.getId()));
            }
            object3 = object5.getMin();
            object2 = object5.getMax();
            if (object3 != null || object2 != null) {
                if (object3 != null && object2 != null) {
                    sQLQuery.where((Predicate)this.price.between((Number)object3, (Number)object2));
                } else if (object3 != null) {
                    sQLQuery.where((Predicate)this.price.goe((Number)object3));
                } else if (object2 != null) {
                    sQLQuery.where((Predicate)this.price.loe((Number)object2));
                }
            }
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object42 = ((BasicAdQuery)this.params).getAdCustomValues()))) {
            object3 = object42.iterator();
            while (object3.hasNext()) {
                STsQuery sTsQuery;
                object2 = (CustomFieldValueForSearchDTO)object3.next();
                object = (AdCustomField)this.conversionHandler.convert(AdCustomField.class, (Object)object2.getField());
                if (!list.contains(object)) {
                    throw new ValidationException("Invalid advertisement field for search: " + object.getInternalName());
                }
                if (!QueryHelper.useParameter((Object)object2) || (pair = this.getCustomFieldQueryCondition(SAdCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SAdEnumValues.class, (Class<? extends SBaseDynaValues<?>>)SAdDynaValues.class, this.ad.id, (CustomField<?, ?, ?>)object, (CustomFieldValueForSearchDTO)object2)) == null) continue;
                booleanBuilder = (BooleanBuilder)pair.getFirst();
                if (booleanBuilder.hasValue()) {
                    sQLQuery.where((Predicate)booleanBuilder);
                }
                if ((sTsQuery = (STsQuery)((Object)pair.getSecond())) == null) continue;
                arrayList.add((Expression<?>)sTsQuery);
            }
        }
        this.applyFullTextFilter(this.tsvectors, this.q, booleanBuilder3);
        if (bl2) {
            double d = configurationAccessor.getDistanceUnit().toMeters(distanceDTO.getDistance().doubleValue());
            if (pair2 != AdAddressResult.NO_ADDRESSES) {
                sQLQuery.where((Predicate)this.addr.geography.distance(this.geo).lt((Number)d));
            } else {
                object = new SAddresses("a1");
                pair = new Pair<BooleanBuilder, STsQuery>("aa1");
                booleanBuilder = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)pair)).innerJoin((EntityPath)object)).on((Predicate)pair.addressId.eq(object.id))).where(new Predicate[]{pair.adId.eq(this.ad.id), object.latitude.isNotNull().and((Predicate)object.longitude.isNotNull()), bl3 ? object.id.isNotNull() : object.hidden.isFalse(), object.geography.distance(this.geo).loe((Number)d)});
                sQLQuery.where((Predicate)booleanBuilder.exists());
            }
        }
        if (((BasicAdQuery)this.params).getFavoritesFor() != null) {
            User user3 = (User)this.conversionHandler.convert(User.class, (Object)((BasicAdQuery)this.params).getFavoritesFor());
            object2 = new SUsersFavoriteAds("ufa2");
            ((SQLQuery)sQLQuery.join((EntityPath)object2)).on((Predicate)object2.adId.eq(this.ad.id).and((Predicate)object2.userId.eq((Object)user3.getId())));
        }
        if (sessionData.isMember()) {
            this.ufa = new SUsersFavoriteAds("ufa");
            ((SQLQuery)sQLQuery.leftJoin((EntityPath)this.ufa)).on((Predicate)this.ufa.adId.eq(this.ad.id).and((Predicate)this.ufa.userId.eq((Object)basicUser.getId())));
        }
        if ((adOrderBy = (AdOrderBy)ObjectHelper.defaultValue((Object)((BasicAdQuery)this.params).getOrderBy(), (Object)configurationAccessor.getAdsSortOrder())) == AdOrderBy.RELEVANCE && (this.tsvectors == null || this.q == null)) {
            adOrderBy = AdOrderBy.DATE;
        }
        if (adOrderBy == AdOrderBy.DISTANCE && this.distance == null) {
            adOrderBy = AdOrderBy.DATE;
        }
        switch (adOrderBy) {
            case RELEVANCE: {
                sQLQuery.orderBy(new OrderSpecifier[]{this.tsvectors.rank(this.q).desc(), this.ad.name.asc()});
                break;
            }
            case DATE: {
                sQLQuery.orderBy(this.ad.beginPublicationPeriod.coalesce(new Expression[]{this.ad.creationDate}).desc());
                break;
            }
            case DISTANCE: {
                sQLQuery.orderBy(this.distance.asc());
                break;
            }
            case PRICE_HIGHEST: {
                sQLQuery.orderBy(this.price.desc());
                break;
            }
            case PRICE_LOWEST: {
                sQLQuery.orderBy(this.price.asc());
                break;
            }
            case RANDOM: {
                sQLQuery.orderBy(NumberExpression.random().asc());
            }
        }
        return arrayList;
    }

    private void collectCategoryIds(Set<Long> set, List<AdCategory> list) {
        list.forEach(adCategory -> this.doCollectCategoryIds(set, (AdCategory)adCategory));
    }

    private void doCollectCategoryIds(Set<Long> set, AdCategory adCategory) {
        set.add(adCategory.getId());
        for (AdCategory adCategory2 : adCategory.getChildren()) {
            this.doCollectCategoryIds(set, adCategory2);
        }
    }

    private class AdProjection
    extends NativeQuery.BaseProjection {
        private static final long serialVersionUID = 1L;
        private DistanceUnit distanceUnit;

        public AdProjection() {
            super(AdvertisementsNativeQuery.this);
            this.add(new Expression[]{AdvertisementsNativeQuery.this.ad.id, AdvertisementsNativeQuery.this.ad.name, AdvertisementsNativeQuery.this.ad.description, AdvertisementsNativeQuery.this.ad.status, AdvertisementsNativeQuery.this.ad.beginPublicationPeriod, AdvertisementsNativeQuery.this.ad.endPublicationPeriod, AdvertisementsNativeQuery.this.ad.subclass, AdvertisementsNativeQuery.this.ad.stockType, AdvertisementsNativeQuery.this.ad.stockQuantity, AdvertisementsNativeQuery.this.ad.removedFromOwner, AdvertisementsNativeQuery.this.ad.productNumber, AdvertisementsNativeQuery.this.ad.allowDecimal, AdvertisementsNativeQuery.this.ad.minAllowedInCart, AdvertisementsNativeQuery.this.ad.maxAllowedInCart, AdvertisementsNativeQuery.this.ad.deletedDate, AdvertisementsNativeQuery.this.ad.creationDate});
            this.add(new Expression[]{AdvertisementsNativeQuery.this.cur.id});
            this.add(new Expression[]{AdvertisementsNativeQuery.this.u.id, AdvertisementsNativeQuery.this.u.displayForManagers, AdvertisementsNativeQuery.this.u.displayForOthers, AdvertisementsNativeQuery.this.u.brokerIds, AdvertisementsNativeQuery.this.u.userGroupId});
            this.addImage(AdvertisementsNativeQuery.this.ui);
            this.addImage(AdvertisementsNativeQuery.this.i);
            SessionData sessionData = this.getSessionData();
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            if (AdvertisementsNativeQuery.this.addr != null) {
                this.add(new Expression[]{AdvertisementsNativeQuery.this.addr.id, AdvertisementsNativeQuery.this.addr.name, AdvertisementsNativeQuery.this.addr.addressLine1, AdvertisementsNativeQuery.this.addr.addressLine2, AdvertisementsNativeQuery.this.addr.city, AdvertisementsNativeQuery.this.addr.country, AdvertisementsNativeQuery.this.addr.neighborhood, AdvertisementsNativeQuery.this.addr.poBox, AdvertisementsNativeQuery.this.addr.region, AdvertisementsNativeQuery.this.addr.street, AdvertisementsNativeQuery.this.addr.buildingNumber, AdvertisementsNativeQuery.this.addr.complement, AdvertisementsNativeQuery.this.addr.zip, AdvertisementsNativeQuery.this.addr.defaultAddress, AdvertisementsNativeQuery.this.addr.hidden, AdvertisementsNativeQuery.this.addr.latitude, AdvertisementsNativeQuery.this.addr.longitude});
                if (AdvertisementsNativeQuery.this.distance != null) {
                    this.add(new Expression[]{AdvertisementsNativeQuery.this.distance});
                    this.distanceUnit = configurationAccessor.getDistanceUnit();
                }
            }
            if (AdvertisementsNativeQuery.this.ufa != null) {
                this.add(new Expression[]{AdvertisementsNativeQuery.this.ufa.adId});
            }
            if (sessionData.isLoggedIn() || !configurationAccessor.isHideAdPriceToGuests()) {
                this.add(new Expression[]{AdvertisementsNativeQuery.this.ad.priceAmount, AdvertisementsNativeQuery.this.ad.promotionalPrice, AdvertisementsNativeQuery.this.ad.beginPromotionalPricePeriod, AdvertisementsNativeQuery.this.ad.endPromotionalPricePeriod});
            }
        }

        protected BasicAdVO instantiate() {
            AdvertisementVO advertisementVO;
            boolean bl;
            Date date;
            Date date2;
            BigDecimal bigDecimal;
            Object object;
            Object object2;
            SessionData sessionData = this.getSessionData();
            AdType adType = (AdType)this.get((Expression)AdvertisementsNativeQuery.this.ad.subclass);
            UserVO userVO = AdvertisementsNativeQuery.this.userService.toUserVO(sessionData, (Long)this.get((Expression)AdvertisementsNativeQuery.this.u.id), (String)this.get((Expression)AdvertisementsNativeQuery.this.u.displayForManagers), (String)this.get((Expression)AdvertisementsNativeQuery.this.u.displayForOthers), (String)this.get((Expression)AdvertisementsNativeQuery.this.u.brokerIds), this.getImage(AdvertisementsNativeQuery.this.ui));
            Long l = (Long)this.get((Expression)AdvertisementsNativeQuery.this.cur.id);
            if (adType == AdType.WEB_SHOP) {
                object2 = new AdWebShopVO();
                object = (AdWebShopStockType)this.get((Expression)AdvertisementsNativeQuery.this.ad.stockType);
                bigDecimal = (BigDecimal)this.get((Expression)AdvertisementsNativeQuery.this.ad.stockQuantity);
                object2.setInStock(AdWebShop.isInStock((AdWebShopStockType)object, (BigDecimal)bigDecimal));
                object2.setStockType(object);
                object2.setStockQuantity(bigDecimal);
                object2.setProductNumber((String)this.get((Expression)AdvertisementsNativeQuery.this.ad.productNumber));
                object2.setAllowDecimal(((Boolean)this.get((Expression)AdvertisementsNativeQuery.this.ad.allowDecimal)).booleanValue());
                object2.setMinAllowedInCart((BigDecimal)this.get((Expression)AdvertisementsNativeQuery.this.ad.minAllowedInCart));
                object2.setMaxAllowedInCart((BigDecimal)this.get((Expression)AdvertisementsNativeQuery.this.ad.maxAllowedInCart));
                date2 = sessionData.getLoggedUser();
                date = (User)AdvertisementsNativeQuery.this.conversionHandler.convert(User.class, (Object)userVO);
                bl = SimpleEntity.uniqueIds((Collection)AdvertisementsNativeQuery.this.currencyService.listForAds((User)date, false)).contains(l);
                boolean bl2 = date2 != null && object2.isInStock() && sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASE) && !date2.equals(date) && bl;
                object2.setCanAddToCart(bl2);
                advertisementVO = object2;
            } else {
                advertisementVO = new AdvertisementVO();
            }
            if (sessionData.isLoggedIn() || !sessionData.getConfiguration().isHideAdOwnerToGuests()) {
                advertisementVO.setOwner(userVO);
            }
            if (sessionData.isLoggedIn() || !sessionData.getConfiguration().isHideAdPriceToGuests()) {
                object2 = new Date();
                object = null;
                bigDecimal = null;
                if (l != null) {
                    object = (Currency)AdvertisementsNativeQuery.this.rawEntityManagerHandler.find(Currency.class, l);
                    bigDecimal = new CurrencyAmountDTO();
                    bigDecimal.setCurrency((CurrencyVO)AdvertisementsNativeQuery.this.conversionHandler.convert(CurrencyVO.class, object));
                    bigDecimal.setAmount(BigDecimalHelper.round((BigDecimal)((BigDecimal)this.get((Expression)AdvertisementsNativeQuery.this.ad.priceAmount)), (int)object.getPrecision()));
                    advertisementVO.setPrice((CurrencyAmountDTO)bigDecimal);
                }
                date2 = (Date)this.get((Expression)AdvertisementsNativeQuery.this.ad.beginPromotionalPricePeriod);
                date = (Date)this.get((Expression)AdvertisementsNativeQuery.this.ad.endPromotionalPricePeriod);
                bl = date2 != null && date != null && date2.before((Date)object2) && date.after((Date)object2);
                advertisementVO.setPromotionalPrice((BigDecimal)this.get((Expression)AdvertisementsNativeQuery.this.ad.promotionalPrice));
                advertisementVO.setPromotionalPeriodActive(bl);
                if (bl && advertisementVO.getPromotionalPrice() != null) {
                    advertisementVO.setCurrentPrice(advertisementVO.getPromotionalPrice());
                } else {
                    advertisementVO.setCurrentPrice(advertisementVO.getPrice() != null ? advertisementVO.getPrice().getAmount() : null);
                }
            }
            advertisementVO.setId((Long)this.get((Expression)AdvertisementsNativeQuery.this.ad.id));
            advertisementVO.setName((String)this.get((Expression)AdvertisementsNativeQuery.this.ad.name));
            advertisementVO.setDescription((String)this.get((Expression)AdvertisementsNativeQuery.this.ad.description));
            advertisementVO.setType(adType);
            advertisementVO.setCreationDate(AdvertisementsNativeQuery.this.conversionHandler.toDateTime((Date)this.get((Expression)AdvertisementsNativeQuery.this.ad.creationDate)));
            object2 = new DatePeriod((Date)this.get((Expression)AdvertisementsNativeQuery.this.ad.beginPublicationPeriod), (Date)this.get((Expression)AdvertisementsNativeQuery.this.ad.endPublicationPeriod));
            advertisementVO.setPublicationPeriod((DatePeriodDTO)AdvertisementsNativeQuery.this.conversionHandler.convert(DatePeriodDTO.class, object2));
            advertisementVO.setStatus(BasicAd.getActualStatus((DatePeriod)object2, (boolean)((Boolean)this.get((Expression)AdvertisementsNativeQuery.this.ad.removedFromOwner)), (Date)((Date)this.get((Expression)AdvertisementsNativeQuery.this.ad.deletedDate)), (AdStatus)((AdStatus)this.get((Expression)AdvertisementsNativeQuery.this.ad.status))));
            object = (Long)this.get((Expression)AdvertisementsNativeQuery.this.ad.id);
            advertisementVO.setCategories(AdvertisementsNativeQuery.this.adService.getCategories((Long)object));
            advertisementVO.setImage(this.getImage(AdvertisementsNativeQuery.this.i));
            if (AdvertisementsNativeQuery.this.addr != null) {
                advertisementVO.setAddress(this.buildAddress(AdvertisementsNativeQuery.this.addr, (Long)this.get((Expression)AdvertisementsNativeQuery.this.u.userGroupId), AdvertisementsNativeQuery.this.distance, this.distanceUnit, null, null));
            }
            if (((BasicAdQuery)AdvertisementsNativeQuery.this.params).isReturnEditable()) {
                bigDecimal = (User)AdvertisementsNativeQuery.this.rawEntityManagerHandler.find(User.class, (Long)this.get((Expression)AdvertisementsNativeQuery.this.u.id));
                advertisementVO.setEditable(AdvertisementsNativeQuery.this.adServiceSecurity.hasManageAccess(null, advertisementVO.getStatus(), (AdStatus)this.get((Expression)AdvertisementsNativeQuery.this.ad.status), advertisementVO.getType(), (User)bigDecimal));
            }
            advertisementVO.setFavoriteForViewer(AdvertisementsNativeQuery.this.ufa != null && this.get((Expression)AdvertisementsNativeQuery.this.ufa.adId) != null);
            return advertisementVO;
        }
    }
}

