/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.postgresql.NativeQuery;
import org.cyclos.impl.sql.postgresql.querydsl.TsVector;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorExpression;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactCustomFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContactInfoDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SContacts;
import org.cyclos.impl.sql.postgresql.querytypes.STsQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SUsers;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.users.contacts.ContactOrderBy;
import org.cyclos.model.users.contacts.ContactQuery;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ContactsNativeQuery
extends NativeQuery<ContactQuery, Contact, ContactVO> {
    private SContacts c;
    private SUsers u;
    @Autowired
    private ContactCustomFieldServiceLocal contactCustomFieldService;

    public ContactsNativeQuery(ContactQuery contactQuery) {
        super(Contact.class, ContactVO.class, contactQuery);
    }

    @Override
    protected RelationalPath<?> doGetMainEntityAlias() {
        return this.c;
    }

    @Override
    protected Expression<ContactVO> doGetProjection(Integer n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<Expression<?>> initializeQuery() {
        ContactCustomField contactCustomField;
        Pair<TsVectorExpression, BooleanBuilder> pair;
        Object object;
        Object object22;
        ArrayList arrayList = new ArrayList();
        SessionData sessionData = this.getSessionData();
        User user = ((ContactQuery)this.params).getOwner() == null ? sessionData.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)((ContactQuery)this.params).getOwner());
        List list = this.contactCustomFieldService.listVisible(user);
        List list2 = this.contactCustomFieldService.listInSearch(user);
        this.c = SContacts.contacts;
        this.u = SUsers.users;
        SQLQuery<?> sQLQuery = this.getQuery();
        ((SQLQuery)((SQLQuery)sQLQuery.from((Expression)this.c)).innerJoin((EntityPath)this.u)).on((Predicate)this.c.contactId.eq(this.u.id));
        sQLQuery.where((Predicate)this.c.ownerId.eq((Object)user.getId()));
        this.visibility(this.u.id, this.u.userGroupId).others(GroupList.ACCESSIBLE);
        String string = StringHelper.trimToNull((Object)((ContactQuery)this.params).getKeywords());
        STsQuery sTsQuery = null;
        BooleanBuilder booleanBuilder = null;
        TsVectorExpression tsVectorExpression = null;
        if (string != null) {
            sTsQuery = STsQuery.of("query", string);
            arrayList.add((Expression<?>)sTsQuery);
            tsVectorExpression = TsVectorExpression.empty();
        }
        if (sTsQuery != null) {
            for (Object object22 : list) {
                if (!object22.getType().isSearchable()) continue;
                object = this.join(SContactCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SContactEnumValues.class, (CustomField<?, ?, ?>)object22, this.c.id);
                tsVectorExpression = tsVectorExpression.concatenate((Expression<TsVector>)object.valueTsVector);
            }
            pair = this.appendUserProfileFieldKeywords(ProfileFieldSearchContext.USER_KEYWORDS, string, tsVectorExpression, this.u, false);
            tsVectorExpression = (TsVectorExpression)((Object)pair.getFirst());
            booleanBuilder = (BooleanBuilder)pair.getSecond();
        }
        if (CollectionHelper.isNotEmpty((Iterable)(pair = ((ContactQuery)this.params).getCustomValues()))) {
            object22 = pair.iterator();
            while (object22.hasNext()) {
                STsQuery sTsQuery2;
                Pair<BooleanBuilder, STsQuery> pair2;
                object = (CustomFieldValueForSearchDTO)object22.next();
                contactCustomField = (ContactCustomField)this.conversionHandler.convert(ContactCustomField.class, (Object)object.getField());
                if (!list2.contains(contactCustomField)) {
                    throw new ValidationException("Invalid contact field for search: " + contactCustomField.getInternalName());
                }
                if (!QueryHelper.useParameter((Object)object) || (pair2 = this.getCustomFieldQueryCondition(SContactCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SContactEnumValues.class, (Class<? extends SBaseDynaValues<?>>)SContactInfoDynaValues.class, this.c.id, (CustomField<?, ?, ?>)contactCustomField, (CustomFieldValueForSearchDTO)object)) == null) continue;
                BooleanBuilder booleanBuilder2 = (BooleanBuilder)pair2.getFirst();
                if (booleanBuilder2.hasValue()) {
                    sQLQuery.where((Predicate)booleanBuilder2);
                }
                if ((sTsQuery2 = (STsQuery)((Object)pair2.getSecond())) == null) continue;
                arrayList.add((Expression<?>)sTsQuery2);
            }
        }
        if (!(object22 = this.conversionHandler.convertSet(User.class, (Iterable)((ContactQuery)this.params).getUsersToExclude())).isEmpty()) {
            sQLQuery.where((Predicate)this.u.id.notIn((Collection)SimpleEntity.uniqueIds((Collection)object22)));
        }
        sQLQuery.where((Predicate)this.u.status.in(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED)));
        this.applyFullTextFilter(tsVectorExpression, sTsQuery, booleanBuilder);
        object = (ContactOrderBy)ObjectHelper.defaultValue((Object)((ContactQuery)this.params).getOrderBy(), (Object)ContactOrderBy.RELEVANCE);
        if (object == ContactOrderBy.RELEVANCE && (tsVectorExpression == null || sTsQuery == null)) {
            object = ContactOrderBy.ALPHABETICALLY_ASC;
        }
        contactCustomField = sessionData.isAdmin() ? this.u.displayForManagers : this.u.displayForOthers;
        switch (1.$SwitchMap$org$cyclos$model$users$contacts$ContactOrderBy[object.ordinal()]) {
            case 1: {
                sQLQuery.orderBy(new OrderSpecifier[]{tsVectorExpression.rank(sTsQuery).desc(), contactCustomField.asc()});
                break;
            }
            case 2: {
                sQLQuery.orderBy(contactCustomField.asc());
                break;
            }
            case 3: {
                sQLQuery.orderBy(contactCustomField.desc());
            }
        }
        return arrayList;
    }
}

