/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.Expression;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.impl.banking.BuildTransactionQueryParams;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionQueryHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.impl.sql.postgresql.BasePostgresqlEntitySearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlSearchHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PostgresqlTransactionSearchHandlerImpl
extends BasePostgresqlEntitySearchHandlerImpl<Transaction, TransactionOverviewQuery, TransactionResultVO>
implements TransactionSearchHandler {
    @Autowired
    @Lazy
    private TransactionQueryHandler transactionQueryHandler;
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private UserServiceLocal userService;
    @Autowired
    @Lazy
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    @Lazy
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    @Lazy
    private ImageHandler imageHandler;
    @Autowired
    @Lazy
    private AccountHandler accountHandler;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;

    public static TransactionResultVO toResult(SessionData sessionData, InternalAccountOwner internalAccountOwner, Transaction transaction, ConversionHandler conversionHandler, DataTranslationHandler dataTranslationHandler, AbstractTransQuery abstractTransQuery, TransactionCustomFieldServiceLocal transactionCustomFieldServiceLocal) {
        TransactionResultVO transactionResultVO;
        Object object;
        TransferType transferType = transaction.getType();
        Class clazz = TransactionSearchHandler.resultType((TransactionNature)transaction.getNature());
        if (internalAccountOwner != null) {
            object = QTransaction.transaction1;
            transactionResultVO = (TransactionResultVO)conversionHandler.convertExcluding(clazz, (Object)transaction, new Object[]{object.from(), object.fromName, object.to(), object.toName, TransactionResultVO.CUSTOM_VALUES});
            transactionResultVO.setRelated((AccountVO)conversionHandler.convert(AccountVO.class, (Object)transaction.getRelatedAccount(internalAccountOwner)));
            transactionResultVO.setRelatedName(transaction.getRelatedName(internalAccountOwner));
            transactionResultVO.setAmount(transaction.getActualAmount(internalAccountOwner));
        } else {
            transactionResultVO = (TransactionResultVO)conversionHandler.convertExcluding(clazz, (Object)transaction, new Object[]{TransactionResultVO.CUSTOM_VALUES});
            if (sessionData.isMember()) {
                BasePayment basePayment;
                BasicUser basicUser;
                object = transaction.getPerformer();
                if (sessionData.isOwnerOf((BasicUser)object)) {
                    transactionResultVO.setFromOperator((OperatorVO)conversionHandler.convert(OperatorVO.class, object));
                }
                if (transaction instanceof BasePayment && sessionData.isOwnerOf(basicUser = (basePayment = (BasePayment)transaction).getReceiver())) {
                    transactionResultVO.setToOperator((OperatorVO)conversionHandler.convert(OperatorVO.class, (Object)basicUser));
                }
            }
        }
        if (abstractTransQuery != null && transactionCustomFieldServiceLocal != null) {
            object = transactionCustomFieldServiceLocal.listVisibleForList(abstractTransQuery);
            transactionResultVO.setCustomValues(conversionHandler.convertList(CustomFieldValueVO.class, (Iterable)transaction.getCustomValues().stream().filter(arg_0 -> PostgresqlTransactionSearchHandlerImpl.lambda$toResult$0((List)object, arg_0)).collect(Collectors.toList())));
        }
        if (StringHelper.isBlank((Object)transactionResultVO.getDescription())) {
            transactionResultVO.setDescription(dataTranslationHandler.getValue((BaseEntity)transferType, QTransferType.transferType.valueForEmptyDescription));
        }
        return transactionResultVO;
    }

    public PostgresqlTransactionSearchHandlerImpl(PostgresqlSearchHandlerImpl postgresqlSearchHandlerImpl) {
        super(postgresqlSearchHandlerImpl);
    }

    public DataIterator<Transaction> export(TransactionQuery transactionQuery) {
        return this.doExport((BaseTransactionQuery)transactionQuery);
    }

    public DataIterator<Transaction> exportEntities(TransactionOverviewQuery transactionOverviewQuery) {
        return this.doExport((BaseTransactionQuery)transactionOverviewQuery);
    }

    @Deprecated
    public CloseableIterator<Transaction> iterateEntities(TransactionOverviewQuery transactionOverviewQuery) {
        return this.transactionQueryHandler.build((BuildTransQueryParams)new BuildTransactionQueryParams((BaseTransactionQuery)transactionOverviewQuery)).iterate((Expression)this.transactionQueryHandler.getTransactionPath());
    }

    @Deprecated
    public CloseableIterator<Long> iterateIds(TransactionOverviewQuery transactionOverviewQuery) {
        return this.transactionQueryHandler.build((BuildTransQueryParams)new BuildTransactionQueryParams((BaseTransactionQuery)transactionOverviewQuery)).iterate((Expression)this.transactionQueryHandler.getTransactionPath().id);
    }

    public long reindex() {
        return 0L;
    }

    public Page<TransactionResultVO> search(TransactionOverviewQuery transactionOverviewQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        return PageImpl.transformed(this.doSearch((BaseTransactionQuery)transactionOverviewQuery), transaction -> this.toResult(sessionData, null, (Transaction)transaction, (AbstractTransQuery)transactionOverviewQuery));
    }

    public Page<Transaction> searchEntities(TransactionOverviewQuery transactionOverviewQuery) {
        return this.doSearch((BaseTransactionQuery)transactionOverviewQuery);
    }

    public Page<TransactionResultVO> searchTransactions(TransactionQuery transactionQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        InternalAccountOwner internalAccountOwner = this.accountHandler.locate((AccountOwner)transactionQuery.getOwner()).getInternalAccountOwner();
        return PageImpl.transformed(this.doSearch((BaseTransactionQuery)transactionQuery), transaction -> this.toResult(sessionData, internalAccountOwner, (Transaction)transaction, (AbstractTransQuery)transactionQuery));
    }

    public TransactionResultVO toResult(SessionData sessionData, InternalAccountOwner internalAccountOwner, Transaction transaction, AbstractTransQuery abstractTransQuery) {
        return PostgresqlTransactionSearchHandlerImpl.toResult(sessionData, internalAccountOwner, transaction, this.conversionHandler, this.dataTranslationHandler, abstractTransQuery, this.transactionCustomFieldService);
    }

    private DataIterator<Transaction> doExport(BaseTransactionQuery baseTransactionQuery) {
        return CloseableIteratorHelper.asDataIterator((CloseableIterator)this.transactionQueryHandler.build((BuildTransQueryParams)new BuildTransactionQueryParams(baseTransactionQuery)).export((Expression)this.transactionQueryHandler.getTransactionPath()));
    }

    private Page<Transaction> doSearch(BaseTransactionQuery baseTransactionQuery) {
        return this.transactionQueryHandler.build((BuildTransQueryParams)new BuildTransactionQueryParams(baseTransactionQuery)).page((QueryParameters)baseTransactionQuery, (Expression)this.transactionQueryHandler.getTransactionPath());
    }

    private static /* synthetic */ boolean lambda$toResult$0(List list, TransactionCustomFieldValue transactionCustomFieldValue) {
        return list.contains(transactionCustomFieldValue.getField());
    }
}

