/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QTuple;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.JPAQueryBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.QAccountType;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.QTransferStatus;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.QVoucher;
import org.cyclos.entities.banking.QVoucherPack;
import org.cyclos.entities.banking.QVoucherTransaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserImage;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountHistoryEntry;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.impl.banking.BuildTransferQueryParams;
import org.cyclos.impl.banking.ChargebackDescriptionFiller;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransferQueryHandler;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.impl.sql.postgresql.BasePostgresqlEntitySearchHandlerImpl;
import org.cyclos.impl.sql.postgresql.PostgresqlSearchHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.BaseTransferQuery;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.model.banking.transferstatus.TransferStatusWithFlowVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.TransformedCloseableIterator;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PostgresqlTransferSearchHandlerImpl
extends BasePostgresqlEntitySearchHandlerImpl<Transfer, AccountHistoriesOverviewQuery, AccountHistoryOverviewEntryVO>
implements TransferSearchHandler {
    @Autowired
    @Lazy
    private TransferQueryHandler transferQueryHandler;
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private UserServiceLocal userService;
    @Autowired
    @Lazy
    protected DataTranslationHandler dataTranslationHandler;
    @Autowired
    @Lazy
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    @Lazy
    private ImageHandler imageHandler;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;

    public PostgresqlTransferSearchHandlerImpl(PostgresqlSearchHandlerImpl postgresqlSearchHandlerImpl) {
        super(postgresqlSearchHandlerImpl);
    }

    public DataIterator<AccountHistoryEntry> exportAccountHistory(AccountHistoryQuery accountHistoryQuery) {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        if (account == null) {
            return CloseableIteratorHelper.asDataIterator((CloseableIterator)CloseableIteratorHelper.empty());
        }
        return CloseableIteratorHelper.asDataIterator((CloseableIterator)new TransformedCloseableIterator((Iterator)this.transferQueryHandler.build((BuildTransQueryParams)new BuildTransferQueryParams(account, (BaseTransferQuery)accountHistoryQuery)).export((Expression)this.transferQueryHandler.getTransferPath()), transfer -> new AccountHistoryEntry(account, transfer, true)));
    }

    public DataIterator<Transfer> exportEntities(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        return CloseableIteratorHelper.asDataIterator((CloseableIterator)this.transferQueryHandler.build((BuildTransQueryParams)new BuildTransferQueryParams(null, (BaseTransferQuery)accountHistoriesOverviewQuery)).export((Expression)this.transferQueryHandler.getTransferPath()));
    }

    public AccountHistoriesOverviewStatusVO getStatus(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        AccountHistoriesOverviewStatusVO accountHistoriesOverviewStatusVO = new AccountHistoriesOverviewStatusVO();
        accountHistoriesOverviewStatusVO.setStatuses(new ArrayList());
        QTransfer qTransfer = QTransfer.transfer;
        NumberExpression numberExpression = qTransfer.id.count();
        NumberExpression numberExpression2 = qTransfer.amount.abs().sum();
        DBQuery dBQuery = this.transferQueryHandler.build((BuildTransQueryParams)new BuildTransferQueryParams(null, (BaseTransferQuery)accountHistoriesOverviewQuery));
        NumberPath numberPath = this.transferQueryHandler.getCurrencyPath().id;
        dBQuery.getMetadata().clearOrderBy();
        dBQuery.groupBy((Expression)numberPath);
        List list = dBQuery.list(new Expression[]{numberPath, numberExpression, numberExpression2});
        for (Tuple tuple : list) {
            int n = ((Long)tuple.get((Expression)numberExpression)).intValue();
            Long l = (Long)tuple.get((Expression)numberPath);
            Currency currency = (Currency)this.rawEntityManagerHandler.find(Currency.class, l);
            BigDecimal bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)tuple.get((Expression)numberExpression2)));
            BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)(n == 0 ? BigDecimal.ZERO : bigDecimal.divide(new BigDecimal(n), BigDecimalHelper.MATH_CONTEXT)), (int)currency.getPrecision());
            CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency);
            AmountSummaryVO amountSummaryVO = ModelHelper.amountSummary((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2, (int)n, (CurrencyVO)currencyVO);
            accountHistoriesOverviewStatusVO.getStatuses().add(amountSummaryVO);
        }
        return accountHistoriesOverviewStatusVO;
    }

    @Deprecated
    public CloseableIterator<Transfer> iterateEntities(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        return this.transferQueryHandler.build((BuildTransQueryParams)new BuildTransferQueryParams(null, (BaseTransferQuery)accountHistoriesOverviewQuery)).iterate((Expression)this.transferQueryHandler.getTransferPath());
    }

    @Deprecated
    public CloseableIterator<Long> iterateIds(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        return this.transferQueryHandler.build((BuildTransQueryParams)new BuildTransferQueryParams(null, (BaseTransferQuery)accountHistoriesOverviewQuery)).iterate((Expression)this.transferQueryHandler.getTransferPath().id);
    }

    public long reindex() {
        return 0L;
    }

    public Page<AccountHistoryOverviewEntryVO> search(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        BuildTransferQueryParams buildTransferQueryParams = new BuildTransferQueryParams(null, (BaseTransferQuery)accountHistoriesOverviewQuery);
        buildTransferQueryParams.setStatusFlows(this.accountService.getVisibleFlows(null));
        DBQuery dBQuery = this.transferQueryHandler.build((BuildTransQueryParams)buildTransferQueryParams);
        QTransfer qTransfer = this.transferQueryHandler.getTransferPath();
        QTransferType qTransferType = this.transferQueryHandler.getTransferTypePath();
        QTransaction qTransaction = this.transferQueryHandler.getTransactionPath();
        QCurrency qCurrency = this.transferQueryHandler.getCurrencyPath();
        QAccount qAccount = this.transferQueryHandler.getFromAccountPath();
        QAccountType qAccountType = this.transferQueryHandler.getFromAccountTypePath();
        QAccount qAccount2 = this.transferQueryHandler.getToAccountPath();
        QAccountType qAccountType2 = this.transferQueryHandler.getToAccountTypePath();
        QUser qUser = this.transferQueryHandler.getFromUserPath();
        QUser qUser2 = this.transferQueryHandler.getToUserPath();
        QTuple qTuple = Projections.tuple(this.createProjection(buildTransferQueryParams));
        Page page = QueryHelper.page((JPAQueryBase)dBQuery, (SessionData)sessionData, (QueryParameters)accountHistoriesOverviewQuery, (Expression)qTuple);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        Function<Tuple, AccountHistoryOverviewEntryVO> function = tuple -> {
            AccountHistoryOverviewEntryVO accountHistoryOverviewEntryVO = new AccountHistoryOverviewEntryVO();
            accountHistoryOverviewEntryVO.setId((Long)tuple.get((Expression)qTransfer.id));
            accountHistoryOverviewEntryVO.setTransactionId((Long)tuple.get((Expression)qTransaction.id));
            accountHistoryOverviewEntryVO.setTransactionNumber((String)tuple.get((Expression)qTransfer.transactionNumber));
            Long l = (Long)tuple.get((Expression)qTransferType.id);
            TransferTypeVO transferTypeVO = (TransferTypeVO)hashMap3.get(l);
            if (transferTypeVO == null) {
                transferTypeVO = (TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)this.rawEntityManagerHandler.find(TransferType.class, l));
                hashMap3.put(l, transferTypeVO);
            }
            accountHistoryOverviewEntryVO.setType(transferTypeVO);
            accountHistoryOverviewEntryVO.setDate(this.conversionHandler.toDateTime((Date)tuple.get((Expression)qTransfer.date)));
            Long l2 = (Long)tuple.get((Expression)qCurrency.id);
            CurrencyVO currencyVO = (CurrencyVO)hashMap.get(l2);
            if (currencyVO == null) {
                currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)this.rawEntityManagerHandler.find(Currency.class, l2));
                hashMap.put(l2, currencyVO);
            }
            accountHistoryOverviewEntryVO.setCurrencyAmount(ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)((BigDecimal)tuple.get((Expression)qTransfer.amount))));
            accountHistoryOverviewEntryVO.setFrom(this.toAccountVO(sessionData, (Long)tuple.get((Expression)qAccount.id), (String)tuple.get((Expression)qAccount.number), (Long)tuple.get((Expression)qUser.id), (Long)tuple.get((Expression)qAccountType.id), hashMap2));
            accountHistoryOverviewEntryVO.setTo(this.toAccountVO(sessionData, (Long)tuple.get((Expression)qAccount2.id), (String)tuple.get((Expression)qAccount2.number), (Long)tuple.get((Expression)qUser2.id), (Long)tuple.get((Expression)qAccountType2.id), hashMap2));
            accountHistoryOverviewEntryVO.setFromName((String)tuple.get((Expression)qTransaction.fromName));
            accountHistoryOverviewEntryVO.setToName((String)tuple.get((Expression)qTransaction.toName));
            accountHistoryOverviewEntryVO.setStatuses(this.resolveStatuses(buildTransferQueryParams, (Tuple)tuple, hashMap4));
            accountHistoryOverviewEntryVO.setCustomValues(this.resolveCustomFieldValues(buildTransferQueryParams, (Tuple)tuple, hashMap5));
            return accountHistoryOverviewEntryVO;
        };
        return PageImpl.transformed((Page)page, function);
    }

    public Page<AccountHistoryEntryVO> searchAccountHistory(AccountHistoryQuery accountHistoryQuery) {
        SessionData sessionData = InvocationContext.getSessionData();
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        if (account == null || account.isTransient()) {
            return PageImpl.empty();
        }
        BuildTransferQueryParams buildTransferQueryParams = new BuildTransferQueryParams(account, (BaseTransferQuery)accountHistoryQuery);
        buildTransferQueryParams.setStatusFlows(this.accountService.getVisibleFlows(account));
        buildTransferQueryParams.setIncludeImage(accountHistoryQuery.isUsersWithImage());
        Page page = this.transferQueryHandler.build((BuildTransQueryParams)buildTransferQueryParams).page((QueryParameters)accountHistoryQuery, (Expression)Projections.tuple(this.createProjection(buildTransferQueryParams)));
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        ChargebackDescriptionFiller chargebackDescriptionFiller = this.accountService.newChargebackDescriptionFiller();
        Page page2 = PageImpl.transformed((Page)page, tuple -> this.createHistoryEntryVO(sessionData, buildTransferQueryParams, accountHistoryQuery, account, (Tuple)tuple, hashMap, hashMap2, hashMap3, chargebackDescriptionFiller));
        chargebackDescriptionFiller.fill();
        return page2;
    }

    public Page<Transfer> searchEntities(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        BuildTransferQueryParams buildTransferQueryParams = new BuildTransferQueryParams(null, (BaseTransferQuery)accountHistoriesOverviewQuery);
        buildTransferQueryParams.setStatusFlows(this.accountService.getVisibleFlows(null));
        DBQuery dBQuery = this.transferQueryHandler.build((BuildTransQueryParams)buildTransferQueryParams);
        return dBQuery.page((QueryParameters)accountHistoriesOverviewQuery, (Expression)this.transferQueryHandler.getTransferPath());
    }

    private AccountHistoryEntryVO createHistoryEntryVO(SessionData sessionData, BuildTransferQueryParams buildTransferQueryParams, AccountHistoryQuery accountHistoryQuery, Account account, Tuple tuple, Map<Long, TransferTypeVO> map, Map<Long, CustomFieldVO> map2, Map<Long, TransferStatusWithFlowVO> map3, ChargebackDescriptionFiller chargebackDescriptionFiller) {
        Object object;
        SystemAccountOwner systemAccountOwner;
        QUserImage qUserImage;
        String string;
        AccountTypeNature accountTypeNature;
        Long l2;
        String string2;
        String string3;
        String string4;
        Long l3;
        String string5;
        Long l4;
        Language language = sessionData.getConfiguration().getLanguage();
        QTransfer qTransfer = this.transferQueryHandler.getTransferPath();
        QTransaction qTransaction = this.transferQueryHandler.getTransactionPath();
        QTransferType qTransferType = this.transferQueryHandler.getTransferTypePath();
        QAccount qAccount = this.transferQueryHandler.getFromAccountPath();
        QAccountType qAccountType = this.transferQueryHandler.getFromAccountTypePath();
        QUser qUser = this.transferQueryHandler.getFromUserPath();
        QAccount qAccount2 = this.transferQueryHandler.getToAccountPath();
        QAccountType qAccountType2 = this.transferQueryHandler.getToAccountTypePath();
        QUser qUser2 = this.transferQueryHandler.getToUserPath();
        QVoucherPack qVoucherPack = this.transferQueryHandler.getBuyVoucherPackPath();
        QVoucher qVoucher = this.transferQueryHandler.getSentVoucherPath();
        QVoucherTransaction qVoucherTransaction = this.transferQueryHandler.getVoucherTransactionPath();
        QVoucherPack qVoucherPack2 = this.transferQueryHandler.getVoucherTransactionPackPath();
        TransferNature transferNature = (TransferNature)tuple.get((Expression)qTransfer.nature);
        AccountHistoryEntryVO accountHistoryEntryVO = new AccountHistoryEntryVO();
        accountHistoryEntryVO.setId((Long)tuple.get((Expression)qTransfer.id));
        if (transferNature == TransferNature.CHARGEBACK) {
            chargebackDescriptionFiller.add(accountHistoryEntryVO);
        }
        Long l5 = (Long)tuple.get((Expression)qAccount.id);
        boolean bl = account.getId().equals(l5);
        BigDecimal bigDecimal = (BigDecimal)tuple.get((Expression)qTransfer.amount);
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)account.getCurrency().getPrecision());
        accountHistoryEntryVO.setAmount(bigDecimal);
        accountHistoryEntryVO.setDate(this.conversionHandler.toDateTime((Date)tuple.get((Expression)qTransfer.date)));
        String string6 = PropertyHelper.getPropertyName((Path)QTransferType.transferType.valueForEmptyDescription);
        TransferTypeVO transferTypeVO = map.computeIfAbsent((Long)tuple.get((Expression)qTransferType.id), l -> {
            TransferType transferType = (TransferType)this.rawEntityManagerHandler.find(TransferType.class, l);
            TransferTypeVO transferTypeVO = (TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)transferType);
            transferTypeVO.setAttribute(string6, (Object)this.dataTranslationHandler.getValue(language, (BaseEntity)transferType, QTransferType.transferType.valueForEmptyDescription));
            return transferTypeVO;
        });
        accountHistoryEntryVO.setType(transferTypeVO);
        String string7 = (String)tuple.get((Expression)qTransaction.description);
        if (StringHelper.isBlank((Object)string7)) {
            string7 = (String)transferTypeVO.getAttribute(string6);
        }
        accountHistoryEntryVO.setDescription(string7);
        accountHistoryEntryVO.setTransactionNumber((String)tuple.get((Expression)qTransfer.transactionNumber));
        accountHistoryEntryVO.setTransactionId((Long)tuple.get((Expression)qTransaction.id));
        accountHistoryEntryVO.setTransactionNature((TransactionNature)tuple.get((Expression)qTransaction.nature));
        accountHistoryEntryVO.setTransactionTransactionNumber((String)tuple.get((Expression)qTransaction.transactionNumber));
        if (bl) {
            l4 = (Long)tuple.get((Expression)qAccount2.id);
            string5 = (String)tuple.get((Expression)qAccount2.number);
            l3 = (Long)tuple.get((Expression)qUser2.id);
            string4 = (String)tuple.get((Expression)qUser2.displayForManagers);
            string3 = (String)tuple.get((Expression)qUser2.displayForOthers);
            string2 = (String)tuple.get((Expression)qUser2.brokerIds);
            l2 = (Long)tuple.get((Expression)qAccountType2.id);
            accountTypeNature = (AccountTypeNature)tuple.get((Expression)qAccountType2.nature);
            string = (String)tuple.get((Expression)qTransaction.toName);
            qUserImage = this.transferQueryHandler.getToUserImagePath();
        } else {
            l4 = (Long)tuple.get((Expression)qAccount.id);
            string5 = (String)tuple.get((Expression)qAccount.number);
            l3 = (Long)tuple.get((Expression)qUser.id);
            string4 = (String)tuple.get((Expression)qUser.displayForManagers);
            string3 = (String)tuple.get((Expression)qUser.displayForOthers);
            string2 = (String)tuple.get((Expression)qUser.brokerIds);
            l2 = (Long)tuple.get((Expression)qAccountType.id);
            accountTypeNature = (AccountTypeNature)tuple.get((Expression)qAccountType.nature);
            string = (String)tuple.get((Expression)qTransaction.fromName);
            qUserImage = this.transferQueryHandler.getFromUserImagePath();
        }
        AccountVO accountVO = new AccountVO();
        accountVO.setId(l4);
        AccountNumberConfiguration accountNumberConfiguration = sessionData.getConfiguration().getAccountNumberConfiguration();
        if (accountNumberConfiguration != null && accountNumberConfiguration.isEnabled()) {
            accountVO.setNumber(MaskHelper.applyMask((String)accountNumberConfiguration.getMask(), (String)string5));
        }
        AccountType accountType = (AccountType)this.rawEntityManagerHandler.find(AccountType.class, l2);
        accountVO.setType((AccountTypeVO)this.conversionHandler.convert(AccountTypeVO.class, (Object)accountType));
        if (accountTypeNature == AccountTypeNature.SYSTEM) {
            systemAccountOwner = SystemAccountOwner.instance();
        } else {
            object = null;
            if (accountHistoryQuery.isUsersWithImage()) {
                object = this.imageHandler.build(tuple, qUserImage._super._super);
            }
            systemAccountOwner = this.userService.toUserVO(sessionData, l3, string4, string3, string2, object);
        }
        accountVO.setOwner((InternalAccountOwner)systemAccountOwner);
        accountHistoryEntryVO.setRelatedAccount(accountVO);
        accountHistoryEntryVO.setRelatedName(string);
        this.voucherService.fill(accountHistoryEntryVO, (Long)tuple.get((Expression)qVoucherPack.typeId), StringHelper.splitTrimming((String)((String)tuple.get((Expression)qVoucherPack.voucherTokens)), (String)","), (String)tuple.get((Expression)qVoucher.email), (VoucherTransactionNature)tuple.get((Expression)qVoucherTransaction.nature), (Long)tuple.get((Expression)qVoucherPack2.typeId));
        accountHistoryEntryVO.setCustomValues(this.resolveCustomFieldValues(buildTransferQueryParams, tuple, map2));
        object = this.resolveStatuses(buildTransferQueryParams, tuple, map3);
        accountHistoryEntryVO.setStatuses((List)object);
        return accountHistoryEntryVO;
    }

    private Expression<?>[] createProjection(BuildTransferQueryParams buildTransferQueryParams) {
        QTransfer qTransfer = this.transferQueryHandler.getTransferPath();
        QTransaction qTransaction = this.transferQueryHandler.getTransactionPath();
        QTransferType qTransferType = this.transferQueryHandler.getTransferTypePath();
        QAccount qAccount = this.transferQueryHandler.getFromAccountPath();
        QAccountType qAccountType = this.transferQueryHandler.getFromAccountTypePath();
        QUser qUser = this.transferQueryHandler.getFromUserPath();
        QAccount qAccount2 = this.transferQueryHandler.getToAccountPath();
        QAccountType qAccountType2 = this.transferQueryHandler.getToAccountTypePath();
        QUser qUser2 = this.transferQueryHandler.getToUserPath();
        QCurrency qCurrency = this.transferQueryHandler.getCurrencyPath();
        QVoucherPack qVoucherPack = this.transferQueryHandler.getBuyVoucherPackPath();
        QVoucher qVoucher = this.transferQueryHandler.getSentVoucherPath();
        QVoucherTransaction qVoucherTransaction = this.transferQueryHandler.getVoucherTransactionPath();
        QVoucherPack qVoucherPack2 = this.transferQueryHandler.getVoucherTransactionPackPath();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(qTransfer.id, qTransferType.id, qTransfer.amount, qCurrency.id, qTransfer.date, qTransfer.nature, qTransfer.transactionNumber, qTransaction.description, qTransaction.id, qTransaction.nature, qTransaction.transactionNumber, qTransaction.fromName, qTransaction.toName, qAccount.id, qAccount.number, qAccountType.id, qAccountType.nature, qUser.id, qUser.displayForManagers, qUser.displayForOthers, qUser.brokerIds, qAccount2.id, qAccount2.number, qAccountType2.id, qAccountType2.nature, qUser2.id, qUser2.displayForManagers, qUser2.displayForOthers, qUser2.brokerIds));
        arrayList.addAll(Arrays.asList(qVoucherPack.typeId, qVoucherPack.voucherTokens, qVoucher.email, qVoucherTransaction.nature, qVoucherPack2.typeId));
        for (Map.Entry entry : buildTransferQueryParams.getFieldValuePaths()) {
            TransactionCustomField transactionCustomField = (TransactionCustomField)entry.getKey();
            QTransactionCustomFieldValue qTransactionCustomFieldValue = (QTransactionCustomFieldValue)entry.getValue();
            arrayList.addAll(this.customFieldValueHandler.getProjectionPaths((CustomField)transactionCustomField, qTransactionCustomFieldValue._super));
        }
        for (Map.Entry entry : buildTransferQueryParams.getStatusPaths()) {
            arrayList.add(((QTransferStatus)entry.getValue()).id);
        }
        boolean bl = false;
        if (buildTransferQueryParams.getParams() instanceof AccountHistoryQuery) {
            bl = ((AccountHistoryQuery)buildTransferQueryParams.getParams()).isUsersWithImage();
        }
        if (bl) {
            Arrays.asList(this.transferQueryHandler.getFromUserImagePath(), this.transferQueryHandler.getToUserImagePath()).stream().filter(Objects::nonNull).forEach(qUserImage -> arrayList.addAll(this.imageHandler.projection(qUserImage._super._super)));
        }
        return arrayList.toArray(new Expression[arrayList.size()]);
    }

    private List<CustomFieldValueVO> resolveCustomFieldValues(BuildTransferQueryParams buildTransferQueryParams, Tuple tuple, Map<Long, CustomFieldVO> map) {
        Set set = buildTransferQueryParams.getFieldValuePaths();
        if (CollectionHelper.isEmpty((Iterable)set)) {
            return Collections.emptyList();
        }
        ArrayList<CustomFieldValueVO> arrayList = new ArrayList<CustomFieldValueVO>();
        for (Map.Entry entry : set) {
            TransactionCustomField transactionCustomField = (TransactionCustomField)entry.getKey();
            QTransactionCustomFieldValue qTransactionCustomFieldValue = (QTransactionCustomFieldValue)entry.getValue();
            TransactionCustomFieldValue transactionCustomFieldValue = (TransactionCustomFieldValue)this.customFieldValueHandler.buildFieldValue((CustomField)transactionCustomField, TransactionCustomFieldValue.class, qTransactionCustomFieldValue._super, tuple);
            if (transactionCustomFieldValue == null) continue;
            CustomFieldValueVO customFieldValueVO = (CustomFieldValueVO)this.conversionHandler.convertExcluding(CustomFieldValueVO.class, (Object)transactionCustomFieldValue, new Object[]{CustomFieldValueVO.FIELD});
            CustomFieldVO customFieldVO = map.get(transactionCustomField.getId());
            if (customFieldVO == null) {
                customFieldVO = (CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)transactionCustomField);
                map.put(transactionCustomField.getId(), customFieldVO);
            }
            customFieldValueVO.setField(customFieldVO);
            arrayList.add(customFieldValueVO);
        }
        return arrayList;
    }

    private List<TransferStatusWithFlowVO> resolveStatuses(BuildTransferQueryParams buildTransferQueryParams, Tuple tuple, Map<Long, TransferStatusWithFlowVO> map) {
        List<TransferStatusWithFlowVO> list;
        Set set = buildTransferQueryParams.getStatusPaths();
        if (CollectionHelper.isEmpty((Iterable)set)) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList();
            for (Map.Entry entry : set) {
                Long l = (Long)tuple.get((Expression)((QTransferStatus)entry.getValue()).id);
                if (l == null) continue;
                TransferStatusWithFlowVO transferStatusWithFlowVO = map.get(l);
                if (transferStatusWithFlowVO == null) {
                    TransferStatus transferStatus = (TransferStatus)this.rawEntityManagerHandler.find(TransferStatus.class, l);
                    transferStatusWithFlowVO = (TransferStatusWithFlowVO)this.conversionHandler.convert(TransferStatusWithFlowVO.class, (Object)transferStatus);
                    map.put(l, transferStatusWithFlowVO);
                }
                list.add(transferStatusWithFlowVO);
            }
        }
        return list;
    }

    private AccountVO toAccountVO(SessionData sessionData, Long l, String string, Long l2, Long l3, Map<Long, AccountTypeVO> map) {
        AccountNumberConfiguration accountNumberConfiguration;
        if (l == null) {
            return null;
        }
        AccountVO accountVO = new AccountVO();
        accountVO.setId(l);
        if (StringHelper.isNotBlank((Object)string) && (accountNumberConfiguration = sessionData.getConfiguration().getAccountNumberConfiguration()) != null && accountNumberConfiguration.isEnabled()) {
            accountVO.setNumber(MaskHelper.applyMask((String)accountNumberConfiguration.getMask(), (String)string));
        }
        if (l2 == null) {
            accountVO.setOwner((InternalAccountOwner)SystemAccountOwner.instance());
        } else {
            accountVO.setOwner((InternalAccountOwner)this.conversionHandler.convert(UserVO.class, (Object)this.rawEntityManagerHandler.find(User.class, l2)));
        }
        accountNumberConfiguration = map.get(l3);
        if (accountNumberConfiguration == null) {
            accountNumberConfiguration = (AccountTypeVO)this.conversionHandler.convert(AccountTypeVO.class, (Object)this.rawEntityManagerHandler.find(AccountType.class, l3));
            map.put(l3, (AccountTypeVO)accountNumberConfiguration);
        }
        accountVO.setType((AccountTypeVO)accountNumberConfiguration);
        return accountVO;
    }
}

