/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.postgresql.NativeQuery;
import org.cyclos.impl.sql.postgresql.querydsl.TsVector;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorExpression;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBaseEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SBrokerings;
import org.cyclos.impl.sql.postgresql.querytypes.SGroups;
import org.cyclos.impl.sql.postgresql.querytypes.SRecordCustomFieldValues;
import org.cyclos.impl.sql.postgresql.querytypes.SRecordDynaValues;
import org.cyclos.impl.sql.postgresql.querytypes.SRecordEnumValues;
import org.cyclos.impl.sql.postgresql.querytypes.SRecordTypes;
import org.cyclos.impl.sql.postgresql.querytypes.SRecords;
import org.cyclos.impl.sql.postgresql.querytypes.STsQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SUsers;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class RecordsNativeQuery
extends NativeQuery<RecordQuery, Record, RecordVO> {
    private SRecords r;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RecordFieldHandler recordFieldHandler;

    public RecordsNativeQuery(RecordQuery recordQuery) {
        super(Record.class, RecordVO.class, recordQuery);
    }

    @Override
    protected RelationalPath<?> doGetMainEntityAlias() {
        return this.r;
    }

    @Override
    protected Expression<RecordVO> doGetProjection(Integer n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<Expression<?>> initializeQuery() {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Network network;
        ArrayList arrayList = new ArrayList();
        SessionData sessionData = this.getSessionData();
        User user = null;
        Set set = null;
        UserRecordQuery userRecordQuery = null;
        boolean bl = this.params instanceof UserRecordQuery;
        boolean bl2 = false;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)((RecordQuery)this.params).getType());
        Set set2 = Collections.emptySet();
        if (bl) {
            userRecordQuery = (UserRecordQuery)this.params;
            user = (User)this.conversionHandler.convert(User.class, (Object)userRecordQuery.getUser());
            set = userRecordQuery.getUserStatuses();
            set2 = this.conversionHandler.convertSet(User.class, (Iterable)userRecordQuery.getBrokers());
            bl2 = user == null ? set2.size() == 1 && set2.contains(sessionData.getLoggedUser()) : sessionData.isBrokerOf((BasicUser)user);
        }
        List list = this.recordFieldHandler.getAllVisibleCustomFieldsForQuery((RecordQuery)this.params);
        list.removeIf(recordCustomField -> !recordCustomField.isAllowedAsSearchFilter());
        SQLQuery<?> sQLQuery = this.getQuery();
        this.r = SRecords.records;
        SRecordTypes sRecordTypes = SRecordTypes.recordTypes;
        ((SQLQuery)((SQLQuery)sQLQuery.from((Expression)this.r)).innerJoin((EntityPath)sRecordTypes)).on((Predicate)this.r.typeId.eq(sRecordTypes.id));
        String string = StringHelper.trimToNull((Object)((RecordQuery)this.params).getKeywords());
        STsQuery sTsQuery = null;
        TsVectorExpression tsVectorExpression = null;
        if (string != null) {
            sTsQuery = STsQuery.of("query", string);
            arrayList.add((Expression<?>)sTsQuery);
            tsVectorExpression = TsVectorExpression.empty();
        }
        if ((network = sessionData.getNetwork()) == null) {
            sQLQuery.where((Predicate)sRecordTypes.networkId.isNull());
        } else {
            sQLQuery.where((Predicate)sRecordTypes.networkId.eq((Object)network.getId()));
        }
        if (recordType == null) {
            if (userRecordQuery != null && userRecordQuery.isSharedRecordFieldSearch()) {
                object5 = this.recordTypeService.listVisibleSharedRecordTypes();
                object42 = this.conversionHandler.convertSet(UserRecordType.class, (Iterable)userRecordQuery.getSharedRecordTypes());
                if (CollectionHelper.isNotEmpty((Iterable)object42)) {
                    object5.retainAll((Collection<?>)object42);
                }
                if (object5.isEmpty()) {
                    sQLQuery.where((Predicate)this.r.id.isNull());
                } else {
                    sQLQuery.where((Predicate)this.r.typeId.in((Collection)SimpleEntity.uniqueIds((Collection)object5)));
                }
            } else {
                sQLQuery.where((Predicate)this.r.id.isNull());
            }
        } else {
            sQLQuery.where((Predicate)this.r.typeId.eq((Object)recordType.getId()));
        }
        if (sTsQuery != null) {
            for (Object object42 : list) {
                if (!object42.getType().isSearchable()) continue;
                object3 = this.join(SRecordCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SRecordEnumValues.class, (CustomField<?, ?, ?>)object42, this.r.id);
                tsVectorExpression = tsVectorExpression.concatenate((Expression<TsVector>)((SRecordCustomFieldValues)((Object)object3)).valueTsVector);
            }
        }
        object5 = null;
        if (bl) {
            object42 = SUsers.users;
            object3 = SGroups.groups;
            ((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery.innerJoin((EntityPath)object42)).on((Predicate)this.r.userId.eq(((SUsers)((Object)object42)).id))).innerJoin((EntityPath)object3)).on((Predicate)((SUsers)((Object)object42)).userGroupId.eq(object3.id));
            if (sTsQuery != null) {
                object2 = this.appendUserProfileFieldKeywords(ProfileFieldSearchContext.RECORD_KEYWORDS, string, tsVectorExpression, (SUsers)((Object)object42), bl2);
                tsVectorExpression = (TsVectorExpression)((Object)object2.getFirst());
                object5 = (BooleanBuilder)object2.getSecond();
            }
            if (CollectionHelper.isNotEmpty((Iterable)set)) {
                sQLQuery.where((Predicate)((SUsers)((Object)object42)).status.in((Collection)set));
            }
            if (user != null) {
                sQLQuery.where((Predicate)((SUsers)((Object)object42)).id.eq((Object)user.getId()));
            }
            if (!(object2 = SimpleEntity.uniqueIds((Collection)this.groupsHandler.flattenVOs((Collection)userRecordQuery.getGroups()))).isEmpty()) {
                sQLQuery.where((Predicate)object3.id.in((Collection)object2));
            }
            if (CollectionHelper.isNotEmpty((Iterable)set2)) {
                object = SBrokerings.brokerings;
                sQLQuery.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)object)).where(new Predicate[]{object.userId.eq(((SUsers)((Object)object42)).id), object.endDate.isNull().or((Predicate)object.endDate.after((Expression)DateTimeExpression.currentTimestamp())), object.brokerId.in((Collection)SimpleEntity.uniqueIds((Collection)set2))})).exists());
            }
            this.visibility(((SUsers)((Object)object42)).id, object3.id).onlySelf();
            object = this.applyUserProfileFieldFilters(ProfileFieldSearchContext.RECORD_FILTER, (SUsers)((Object)object42), bl2, userRecordQuery.getUserProfileFields(), null);
            arrayList.addAll((Collection<Expression<?>>)object);
        }
        if ((object42 = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)((RecordQuery)this.params).getDatePeriod())) != null) {
            object3 = object42.getBegin();
            if (object3 != null) {
                sQLQuery.where((Predicate)this.r.creationDate.goe((Comparable)object3));
            }
            if ((object2 = object42.getEnd()) != null) {
                sQLQuery.where((Predicate)this.r.creationDate.lt((Comparable)object2));
            }
        }
        if ((object3 = (User)this.conversionHandler.convert(User.class, (Object)((RecordQuery)this.params).getCreatedBy())) != null) {
            sQLQuery.where((Predicate)this.r.createdById.eq((Object)object3.getId()));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object2 = ((RecordQuery)this.params).getCustomValues()))) {
            object = object2.iterator();
            while (object.hasNext()) {
                STsQuery sTsQuery2;
                Pair<BooleanBuilder, STsQuery> pair;
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO = (CustomFieldValueForSearchDTO)object.next();
                CustomFieldVO customFieldVO = customFieldValueForSearchDTO.getField();
                RecordCustomField recordCustomField2 = list.stream().filter(recordCustomField -> recordCustomField.getId().equals(customFieldVO.getId()) || recordCustomField.getInternalName().equals(ModelHelper.unqualifyInternalName((IInternalNamedEntity)customFieldVO))).findFirst().orElse(null);
                if (recordCustomField2 == null || !sessionData.isSystem() && !recordCustomField2.isShowInSearch() || !QueryHelper.useParameter((Object)customFieldValueForSearchDTO) || (pair = this.getCustomFieldQueryCondition(SRecordCustomFieldValues.class, (Class<? extends SBaseEnumValues<?>>)SRecordEnumValues.class, (Class<? extends SBaseDynaValues<?>>)SRecordDynaValues.class, this.r.id, (CustomField<?, ?, ?>)recordCustomField2, customFieldValueForSearchDTO)) == null) continue;
                BooleanBuilder booleanBuilder = (BooleanBuilder)pair.getFirst();
                if (booleanBuilder.hasValue()) {
                    sQLQuery.where((Predicate)booleanBuilder);
                }
                if ((sTsQuery2 = (STsQuery)((Object)pair.getSecond())) == null) continue;
                arrayList.add((Expression<?>)sTsQuery2);
            }
        }
        this.applyFullTextFilter(tsVectorExpression, sTsQuery, (BooleanBuilder)object5);
        if (tsVectorExpression == null || sTsQuery == null) {
            if (recordType instanceof UserRecordType && ((UserRecordType)recordType).isSortByOwner()) {
                sQLQuery.orderBy(SUsers.users.displayForManagers.asc());
            }
            RecordCustomField recordCustomField3 = object = recordType == null ? null : recordType.getSortField();
            if (object == null) {
                sQLQuery.orderBy(this.r.creationDate.desc());
            } else {
                boolean bl3 = object.getType() == CustomFieldType.BOOLEAN;
                this.addOrderBy(SRecordCustomFieldValues.class, SRecordEnumValues.class, (CustomField<?, ?, ?>)object, this.r.id, bl3);
            }
        } else {
            sQLQuery.orderBy(new OrderSpecifier[]{tsVectorExpression.rank(sTsQuery).desc(), this.r.creationDate.desc()});
        }
        return arrayList;
    }
}

