/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.postgresql.AbstractUserNativeQuery;
import org.cyclos.impl.sql.postgresql.querytypes.SBrokerings;
import org.cyclos.impl.sql.postgresql.querytypes.SContacts;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.utils.ObjectHelper;

public class UserNativeQuery
extends AbstractUserNativeQuery<UserQuery, UserWithFieldsVO> {
    public UserNativeQuery(UserQuery userQuery) {
        super(UserWithFieldsVO.class, userQuery);
    }

    @Override
    protected void addNetworkFilter(SQLQuery<?> sQLQuery, SessionData sessionData) {
        Network network = sessionData.getNetwork();
        if (network == null) {
            sQLQuery.where((Predicate)this.u.networkId.isNull());
        } else if (((UserQuery)this.params).isIncludeGlobal()) {
            sQLQuery.where((Predicate)this.u.networkId.eq((Object)network.getId()).or((Predicate)this.u.networkId.isNull()));
        } else {
            sQLQuery.where((Predicate)this.u.networkId.eq((Object)network.getId()));
        }
    }

    @Override
    protected Expression<UserWithFieldsVO> doGetProjection(Integer n) {
        return new UserProjection();
    }

    @Override
    protected ProfileFieldSearchContext getProfileFieldsContext(boolean bl) {
        if (((UserQuery)this.params).isMapDirectory()) {
            return bl ? ProfileFieldSearchContext.MAP_DIRECTORY_FILTER : ProfileFieldSearchContext.MAP_DIRECTORY_KEYWORDS;
        }
        return super.getProfileFieldsContext(bl);
    }

    @Override
    protected boolean includeGlobals(UserQuery userQuery) {
        return userQuery.isIncludeGlobal();
    }

    @Override
    protected List<Expression<?>> initializeQuery() {
        Boolean bl;
        RelationalPathBase relationalPathBase;
        List<Expression<?>> list = super.initializeQuery();
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        SQLQuery<?> sQLQuery = this.getQuery();
        User user2 = (User)ObjectHelper.defaultValue((Object)((User)this.conversionHandler.convert(User.class, (Object)((UserQuery)this.params).getContactsOwner())), (Object)user);
        if (user2 != null && (((UserQuery)this.params).isExcludeContacts() || ((UserQuery)this.params).isOnlyContacts())) {
            if (((UserQuery)this.params).isExcludeContacts() && ((UserQuery)this.params).isOnlyContacts()) {
                sQLQuery.where((Predicate)this.u.id.isNull());
            } else {
                relationalPathBase = SContacts.contacts;
                bl = (SQLQuery)((SQLQuery)new SQLQuery().from((Expression)relationalPathBase)).where(new Predicate[]{relationalPathBase.ownerId.eq((Object)user2.getId()), relationalPathBase.contactId.eq(this.u.id)});
                sQLQuery.where((Predicate)(((UserQuery)this.params).isExcludeContacts() ? bl.notExists() : bl.exists()));
            }
        }
        if (QueryHelper.useParameter((Object)((UserQuery)this.params).getExcludeBrokeredBy())) {
            relationalPathBase = new SBrokerings("bn1");
            bl = ((UserQuery)this.params).getOnlyBrokerIsMain();
            sQLQuery.where((Predicate)((SQLQuery)((SQLQuery)new SQLQuery().from((Expression)relationalPathBase)).where(new Predicate[]{relationalPathBase.userId.eq(this.u.id), relationalPathBase.endDate.isNull().or((Predicate)relationalPathBase.endDate.after((Expression)DateTimeExpression.currentTimestamp())), bl == null ? relationalPathBase.id.isNotNull() : relationalPathBase.mainBroker.eq(bl), relationalPathBase.brokerId.eq((Object)((UserQuery)this.params).getExcludeBrokeredBy().getId())})).notExists());
        }
        if (QueryHelper.useParameter((Object)((UserQuery)this.params).getUserStatus())) {
            sQLQuery.where((Predicate)this.u.status.in((Collection)((UserQuery)this.params).getUserStatus()));
        }
        if ((relationalPathBase = (UserOrderBy)ObjectHelper.defaultValue((Object)((UserQuery)this.params).getOrderBy(), (Object)sessionData.getConfiguration().getUsersSortOrder())) == UserOrderBy.RELEVANCE && (this.tsvectors == null || this.q == null)) {
            relationalPathBase = UserOrderBy.CREATION_DATE;
        }
        if (relationalPathBase == UserOrderBy.DISTANCE && this.distance == null) {
            relationalPathBase = UserOrderBy.CREATION_DATE;
        }
        switch (1.$SwitchMap$org$cyclos$model$users$users$UserOrderBy[relationalPathBase.ordinal()]) {
            case 1: {
                sQLQuery.orderBy(this.tsvectors.rank(this.q).desc());
                this.applyAlphabeticOrderBy(sQLQuery, false);
                break;
            }
            case 2: {
                sQLQuery.orderBy(this.u.creationDate.desc());
                break;
            }
            case 3: {
                sQLQuery.orderBy(this.distance.asc());
                break;
            }
            case 4: 
            case 5: {
                boolean bl2 = relationalPathBase == UserOrderBy.ALPHABETICALLY_DESC;
                this.applyAlphabeticOrderBy(sQLQuery, bl2);
                break;
            }
            case 6: {
                sQLQuery.orderBy(NumberExpression.random().asc());
            }
        }
        return list;
    }

    @Override
    protected List<ProfileField> resolveProfileFieldsInList(SessionData sessionData) {
        if (((UserQuery)this.params).isMapDirectory()) {
            return this.profileFieldHandler.getFieldsInMapResult(this.isMyBrokered(sessionData));
        }
        return super.resolveProfileFieldsInList(sessionData);
    }

    protected class UserProjection
    extends AbstractUserNativeQuery.AbstractUserProjection {
        private static final long serialVersionUID = 1L;

        protected UserProjection() {
            super(UserNativeQuery.this);
        }
    }
}

