/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql.querydsl;

import com.querydsl.core.types.Operator;
import com.querydsl.sql.PostgreSQLTemplates;
import org.cyclos.entities.utils.queryextensions.CustomOperator;
import org.cyclos.impl.sql.postgresql.querydsl.GeographyOperator;
import org.cyclos.impl.sql.postgresql.querydsl.StringOperator;
import org.cyclos.impl.sql.postgresql.querydsl.TsQueryOperator;
import org.cyclos.impl.sql.postgresql.querydsl.TsVectorOperator;

public class CustomPostgresTemplates
extends PostgreSQLTemplates {
    public CustomPostgresTemplates() {
        this.add(TsVectorOperator.FULL_TEXT_SEARCH, "{0} @@ {1}");
        this.add(TsVectorOperator.EMPTY, "to_tsvector('')");
        this.add(TsVectorOperator.CONCATENATE, "{0} || coalesce({1}, to_tsvector(''))");
        this.add(TsVectorOperator.RANK, "ts_rank({0}, {1})");
        this.add(TsVectorOperator.GET_ADDRESSES_TSVECTOR, "cy_get_addresses_tsvector({0}, {1})");
        this.add(TsQueryOperator.TO_TSQUERY, "to_tsquery('unaccent'::regconfig, {0})");
        this.add(GeographyOperator.DISTANCE, "ST_Distance({0}, {1})");
        this.add((Operator)CustomOperator.ACCOUNT_BALANCE1, "cy_account_balance({0})");
        this.add(StringOperator.IMMUTABLE_UNACCENT, "cy_immutable_unaccent({0})");
    }

    protected boolean requiresQuotes(String string, boolean bl) {
        if (string.contains("to_tsquery") || string.contains("to_geography")) {
            return false;
        }
        return super.requiresQuotes(string, bl);
    }
}

