/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.storage.DelayedSaveStoredFileContentAction;
import org.cyclos.impl.storage.DelayedStoredFileContentAction;
import org.cyclos.impl.storage.SaveStoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentManager;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.model.StoredFileException;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class FsStoredFileContentManagerImpl
implements StoredFileContentManager {
    private static final String ROOT_DIR_PROPERTY = "rootDir";
    private static final String MAX_SUB_DIRS = "maxSubDirs";
    private static final String DEFAULT_MAX_SUB_DIRS = "100";
    private static final Logger logger = LogManager.getLogger(FsStoredFileContentManagerImpl.class);
    @Autowired
    private CyclosProperties cyclosProperties;
    private File rootDir;
    private int maxSubDirs;

    public SaveStoredFileContentAction copy(String string, final Object object) {
        final String string2 = this.newRelativeFilePath(string);
        return new DelayedSaveStoredFileContentAction(string2, string2){

            public void confirm() {
                FsStoredFileContentManagerImpl.this.doCopy((String)object, string2);
            }
        };
    }

    public String getKey(StoredFile storedFile) throws StoredFileException {
        return (String)this.getMetadata(storedFile);
    }

    public Object getMetadata(StoredFile storedFile) throws StoredFileException {
        return storedFile.getMetadata();
    }

    public SerializableInputStream open(Object object) {
        try {
            SerializableInputStream serializableInputStream = new SerializableInputStream(this.toFile((String)object));
            serializableInputStream.file();
            return serializableInputStream;
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error retrieving file from %s", object), (Throwable)exception);
        }
    }

    public StoredFileContentAction remove(final Object object) {
        try {
            return new DelayedStoredFileContentAction(){

                public void confirm() {
                    FsStoredFileContentManagerImpl.this.toFile((String)object).delete();
                }
            };
        }
        catch (Exception exception) {
            throw new StoredFileException(String.format("Error removing file %s", object), (Throwable)exception);
        }
    }

    public boolean requiresPersistentStoredFileToSetMetadata() {
        return false;
    }

    public void setMetadata(StoredFile storedFile, Object object) throws StoredFileException {
        storedFile.setMetadata((String)object);
    }

    public SaveStoredFileContentAction store(String string, SerializableInputStream serializableInputStream) {
        final String string2 = this.newRelativeFilePath(string);
        this.doCopy((InputStream)serializableInputStream, string2);
        return new SaveStoredFileContentAction(){

            public void cancel() {
                FsStoredFileContentManagerImpl.this.toFile(string2).delete();
            }

            public void confirm() {
            }

            public String key() {
                return this.metadata().toString();
            }

            public Object metadata() {
                return string2;
            }
        };
    }

    public boolean supportStorageDirectories() {
        return true;
    }

    public void testConnection() throws StoredFileException {
        if (!this.rootDir.canWrite()) {
            throw new StoredFileException("Write permission not allowed to: " + String.valueOf(this.rootDir));
        }
    }

    private void doCopy(InputStream inputStream, String string) throws StoredFileException {
        File file = this.toFile(string);
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        }
        catch (IOException iOException) {
            throw new StoredFileException(String.format("Error copying from stream to '%s'", file), (Throwable)iOException);
        }
    }

    private void doCopy(String string, String string2) throws StoredFileException {
        File file = this.toFile(string);
        File file2 = this.toFile(string2);
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new StoredFileException(String.format("Error copying from '%s' to '%s'", file, file2), (Throwable)iOException);
        }
    }

    @PostConstruct
    private void initialize() {
        Properties properties = this.cyclosProperties.getStoredFileContentManagerProperties();
        String string2 = properties.getProperty(ROOT_DIR_PROPERTY);
        this.rootDir = string2 == null ? null : this.cyclosProperties.resolveFile(string2);
        this.maxSubDirs = Integer.parseInt(properties.getProperty(MAX_SUB_DIRS, DEFAULT_MAX_SUB_DIRS));
        logger.info(String.format("Initializing content manager: <alias=%s, rootDir=%s, maxSubDirs=%s>", CyclosProperties.getStoredFileContentManagerAlias((String)this.getClass().getName()), this.rootDir, this.maxSubDirs));
        this.initializeDirectory(this.rootDir);
        StoredFileHandler.getStorageDirectories((CyclosProperties)this.cyclosProperties).stream().map(string -> new File(this.rootDir, (String)string)).forEach(this::initializeDirectory);
    }

    private void initializeDirectory(File file) {
        if (file == null) {
            throw new IllegalStateException(String.format("Error initializing stored file content manager. Missing property: %s", ROOT_DIR_PROPERTY));
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new IllegalStateException(String.format("Error initializing stored file content manager. Read permission not allowed to: %s", file));
            }
            if (!file.canWrite()) {
                throw new IllegalStateException(String.format("Error initializing stored file content manager. Write permission not allowed to: %s", file));
            }
        } else if (!file.mkdirs()) {
            throw new IllegalStateException(String.format("Error initializing stored file content manager. Can not create the directory at: %s", file));
        }
    }

    private String newRelativeFilePath(String string) {
        String string2 = String.valueOf((int)(Math.random() + (double)this.maxSubDirs));
        if (StringHelper.isNotBlank((Object)string)) {
            return Paths.get(string, string2, UUID.randomUUID().toString()).toFile().getPath();
        }
        return Paths.get(string2, UUID.randomUUID().toString()).toFile().getPath();
    }

    private File toFile(String string) {
        return new File(this.rootDir, string);
    }
}

