/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdImage;
import org.cyclos.entities.marketplace.Advertisement;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.AdImportedFile;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedImage;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.marketplace.AdImageServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseWithFieldsImportHandlerImpl;
import org.cyclos.impl.system.ImportHandler;
import org.cyclos.impl.system.ImportWithImageHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdDataParams;
import org.cyclos.model.marketplace.advertisements.AdDetailsData;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.imports.AdImportField;
import org.cyclos.model.system.imports.AdImportedFileDTO;
import org.cyclos.model.system.imports.AdImportedFileData;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdImportHandlerImpl
extends BaseWithFieldsImportHandlerImpl<AdCustomField, CustomFieldValueDTO, AdImportedFileDTO, AdImportedFileData, AdImportedFile, Advertisement>
implements ImportWithImageHandler<AdImportedFileDTO, AdImportedFileData, AdImportedFile, Advertisement> {
    private static final Set<String> REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{AdImportField.USER.getName(), AdImportField.TITLE.getName(), AdImportField.DESCRIPTION.getName(), AdImportField.CATEGORIES.getName()}));
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private AdImageServiceLocal adImageService;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;

    public AdImportHandlerImpl() {
        super(AdCustomField.class, CustomFieldValueDTO.class, (ImportField[])AdImportField.values());
    }

    public Predicate<String> getAllowedImportFieldsPredicate(AdImportedFile adImportedFile) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getImportFieldNames(this.adCustomFieldService.listVisible(null, true)));
        for (AdImportField adImportField : AdImportField.values()) {
            arrayList.add(adImportField.getName());
        }
        return string -> arrayList.contains(string);
    }

    public AdImportedFileData getData(AdImportedFile adImportedFile) {
        AdImportedFileData adImportedFileData = new AdImportedFileData();
        adImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(AdImportedFileDTO.class, (Object)adImportedFile)));
        if (adImportedFile.isTransient()) {
            List list = this.currencyService.listForAds(null, false);
            adImportedFileData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)list));
        }
        return adImportedFileData;
    }

    public Class<Advertisement> getEntityClass() {
        return Advertisement.class;
    }

    public ImportedField getImagesField(AdImportedFile adImportedFile) {
        return adImportedFile.getField(AdImportField.IMAGES.getName());
    }

    public Class<AdImportedFile> getImportedFileClass() {
        return AdImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.ADS_IMPORT;
    }

    public Set<String> getMissingRequiredFields(AdImportedFile adImportedFile, List<String> list) {
        return Set.copyOf(CollectionUtils.subtract(REQUIRED_HEADERS, list));
    }

    public Object instantiateContext() {
        return new HashMap();
    }

    public AdImportedFile newImportedFile(AdImportedFileDTO adImportedFileDTO) {
        AdImportedFile adImportedFile = new AdImportedFile();
        adImportedFile.setCurrency((Currency)this.conversionHandler.convert(Currency.class, (Object)adImportedFileDTO.getCurrency()));
        return adImportedFile;
    }

    public void processImportedImages(Advertisement advertisement, List<ImportedImage> list) {
        for (ImportedImage importedImage : list) {
            AdImage adImage = (AdImage)this.conversionHandler.convertExcluding(AdImage.class, (Object)importedImage, new Object[]{"category"});
            this.storedFileHandler.copy((StoredFile)importedImage, (StoredFile)adImage);
            this.adImageService.addImage((BasicAd)advertisement, adImage);
            adImage.setName(new File(importedImage.getName()).getName());
        }
    }

    public Advertisement processImportedLine(ImportedLine importedLine, Object object) {
        BasicAdDTO basicAdDTO = this.convertToDTO(importedLine, object);
        ImportHandler.markAsImported((EntityDTO)basicAdDTO);
        Long l = this.adService.save((EntityDTO)basicAdDTO);
        return (Advertisement)this.find(l);
    }

    public Validator resolveValidator(AdImportedFileDTO adImportedFileDTO) {
        Validator validator = new Validator();
        if (adImportedFileDTO.isTransient()) {
            validator.property((Property)AdImportedFileDTO.CURRENCY, SystemKeys.Imports.CURRENCY).required();
        }
        return validator;
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) {
        BasicAdDTO basicAdDTO = this.convertToDTO(importedLine, object);
        ImportHandler.markAsImported((EntityDTO)basicAdDTO);
        this.adService.validate((EntityDTO)basicAdDTO);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(AdImportedFile adImportedFile) {
        return Arrays.asList(AdImportField.TITLE, AdImportField.USER, AdImportField.CATEGORIES);
    }

    private BasicAdDTO convertToDTO(ImportedLine importedLine, Object object) {
        String string;
        DateTime dateTime;
        DatePeriodDTO datePeriodDTO;
        User user = (User)this.locateUser(importedLine.getValue((ImportField)AdImportField.USER));
        AdDataParams adDataParams = new AdDataParams();
        adDataParams.setType(AdType.ADVERTISEMENT);
        if (user != null) {
            adDataParams.setUser(new UserLocatorVO(user.getId()));
        }
        AdDetailsData adDetailsData = (AdDetailsData)this.adService.getDataForNew((Object)adDataParams);
        BasicAdDTO basicAdDTO = (BasicAdDTO)adDetailsData.getDto();
        DateTime dateTime2 = this.parseDateTime(importedLine.getValue((ImportField)AdImportField.CREATION_DATE));
        if (dateTime2 == null) {
            dateTime2 = this.conversionHandler.toDateTime(DateHelper.now());
        }
        basicAdDTO.setCreationDate(dateTime2);
        basicAdDTO.setDescription(importedLine.getValue((ImportField)AdImportField.DESCRIPTION));
        basicAdDTO.setName(importedLine.getValue((ImportField)AdImportField.TITLE));
        String string2 = importedLine.getValue((ImportField)AdImportField.STATUS);
        if (StringHelper.isNotBlank((Object)string2)) {
            basicAdDTO.setStatus((AdStatus)CoercionHelper.coerce(AdStatus.class, (Object)string2.toUpperCase()));
        }
        if ((datePeriodDTO = basicAdDTO.getPublicationPeriod()) == null) {
            datePeriodDTO = new DatePeriodDTO();
        }
        if ((dateTime = this.parseDateTime(importedLine.getValue((ImportField)AdImportField.PUBLICATION_BEGIN))) != null) {
            datePeriodDTO.setBegin(dateTime);
        } else if (datePeriodDTO.getBegin() == null) {
            datePeriodDTO.setBegin(dateTime2);
        }
        DateTime dateTime3 = this.parseDateTime(importedLine.getValue((ImportField)AdImportField.PUBLICATION_END));
        if (dateTime3 != null) {
            datePeriodDTO.setEnd(dateTime3);
        }
        basicAdDTO.setPublicationPeriod(datePeriodDTO);
        AdImportedFile adImportedFile = (AdImportedFile)importedLine.getImportedFile();
        Currency currency = adImportedFile.getCurrency();
        String string3 = importedLine.getValue((ImportField)AdImportField.PRICE);
        if (StringHelper.isNotBlank((Object)string3)) {
            string = this.parseAmount(string3, currency);
            basicAdDTO.setPrice((CurrencyAmountDTO)string);
        }
        if (StringHelper.isNotBlank((Object)(string = importedLine.getValue((ImportField)AdImportField.PROMOTIONAL_PRICE)))) {
            DatePeriodDTO datePeriodDTO2 = new DatePeriodDTO();
            datePeriodDTO2.setBegin(this.parseDateTime(importedLine.getValue((ImportField)AdImportField.PROMOTIONAL_PERIOD_BEGIN)));
            datePeriodDTO2.setEnd(this.parseDateTime(importedLine.getValue((ImportField)AdImportField.PROMOTIONAL_PERIOD_END)));
            basicAdDTO.setPromotionalPeriod(datePeriodDTO2);
            CurrencyAmountDTO currencyAmountDTO = this.parseAmount(string, currency);
            basicAdDTO.setPromotionalPrice(currencyAmountDTO.getAmount());
        }
        this.setCustomFieldValues(importedLine, basicAdDTO);
        this.setCategories(importedLine, basicAdDTO, object);
        return basicAdDTO;
    }

    private void setCategories(ImportedLine importedLine, BasicAdDTO basicAdDTO, Object hashMap) {
        String string = importedLine.getValue((ImportField)AdImportField.CATEGORIES);
        basicAdDTO.setCategories(new HashSet());
        if (StringHelper.isNotBlank((Object)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\s*,\\s*")) {
                Map map;
                AdCategoryVO adCategoryVO;
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                if ((adCategoryVO = (AdCategoryVO)(map = (Map)hashMap).get(string2)) != null) {
                    basicAdDTO.getCategories().add(adCategoryVO);
                    continue;
                }
                String[] stringArray2 = string2.split("\\>");
                AdCategoryVO adCategoryVO2 = null;
                Object object = "";
                for (String string3 : stringArray2) {
                    adCategoryVO = (AdCategoryVO)map.get(object = (String)object + string3);
                    if (adCategoryVO == null) {
                        adCategoryVO = this.adCategoryService.findByParentAndInternalName(adCategoryVO2, string3);
                        if (adCategoryVO == null) {
                            throw new ValidationException(this.translationHandler.message(MarketplaceKeys.Advertisements.ERROR_INVALID_CATEGORY, new Object[]{string3}));
                        }
                        map.put(object, adCategoryVO);
                    }
                    adCategoryVO2 = adCategoryVO;
                    object = (String)object + ">";
                }
                basicAdDTO.getCategories().add(adCategoryVO);
            }
        }
    }
}

