/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.List;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.system.ICategorizedImage;
import org.cyclos.entities.system.Image;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.BaseCategorizedImageServiceLocal;
import org.cyclos.impl.system.BaseImageServiceImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.ImagesListData;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseCategorizedImageServiceImpl<I extends Image, C extends BaseEntity, A extends EntityPath<I>, NP extends IEntity>
extends BaseImageServiceImpl<I, A, NP>
implements BaseCategorizedImageServiceLocal<I, C, NP> {
    @Autowired
    protected BeanHandler beanHandler;
    protected final Class<C> categoryType;
    protected final EntityPath<C> categoryPath;
    @Autowired
    protected LockHandler lockHandler;

    public BaseCategorizedImageServiceImpl(ImageNature imageNature, Class<I> clazz, Class<C> clazz2, A a, EntityPath<C> entityPath) {
        super(imageNature, clazz, a);
        this.categoryType = clazz2;
        this.categoryPath = entityPath;
    }

    public ImagesListData getListData(NP NP) throws FrameworkException {
        C c = this.toCategory(NP);
        ImagesListData imagesListData = new ImagesListData();
        int n = this.resolveMaxImages(c);
        List<ImageVO> list = this.list(NP);
        imagesListData.setMaxImages(Integer.valueOf(n));
        imagesListData.setRequired(this.isRequired(c));
        imagesListData.setCanManage(this.isCategoryActive(c));
        imagesListData.setCanCreate(imagesListData.isCanManage() && (n < 0 || n > list.size()));
        imagesListData.setImages(list);
        return imagesListData;
    }

    public List<ImageVO> list(NP NP) throws FrameworkException {
        C c = this.toCategory(NP);
        List<I> list = this.listByCategory(c);
        return this.conversionHandler.convertList(ImageVO.class, list);
    }

    public List<I> listByCategory(C c) {
        NumberPath numberPath = (NumberPath)FieldHelper.get(this.categoryPath, (String)"id");
        DBQuery dBQuery = (DBQuery)this.from(this.$).where((Predicate)numberPath.eq((Object)c.getId()));
        this.customizeListByCategoryQuery(dBQuery, c);
        return dBQuery.list((Expression)this.$);
    }

    @Override
    public I newImage(NP NP) {
        C c = this.toCategory(NP);
        if (!this.isCategoryActive(c)) {
            throw new IllegalActionException();
        }
        Image image = (Image)this.beanHandler.instantiate(this.imageType);
        ((ICategorizedImage)image).setCategory(c);
        return (I)image;
    }

    public int removeAll(C c) {
        this.lock(c);
        NumberPath numberPath = (NumberPath)FieldHelper.get((Object)this.$, (String)"id");
        NumberPath numberPath2 = (NumberPath)FieldHelper.get(this.categoryPath, (String)"id");
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where((Predicate)numberPath2.eq((Object)c.getId()))).iterate((Expression)numberPath);
        return (int)this.processBatch(closeableIterator, this::remove);
    }

    @Override
    public ImageVO save(NP NP, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        C c = this.toCategory(NP);
        if (!this.isCategoryActive(c)) {
            throw new IllegalActionException();
        }
        this.lock(c);
        return super.save(NP, string, serializableInputStream, string2);
    }

    protected int count(C c) throws FrameworkException {
        NumberPath numberPath = (NumberPath)FieldHelper.get((Object)this.$, (String)"id");
        NumberPath numberPath2 = (NumberPath)FieldHelper.get(this.categoryPath, (String)"id");
        return ((DBQuery)this.from(this.$).where((Predicate)numberPath2.eq((Object)c.getId()))).count(numberPath);
    }

    protected void customizeListByCategoryQuery(DBQuery<?> dBQuery, C c) {
    }

    protected C findCategory(Long l) {
        return (C)((BaseEntity)this.find(this.categoryType, l));
    }

    protected abstract boolean isCategoryActive(C var1);

    protected boolean isRequired(C c) {
        return false;
    }

    protected void lock(C c) {
        this.lockHandler.lock(LockType.IMAGE_OWNER.key(String.valueOf(this.nature) + "_" + c.getId()));
    }

    @Override
    protected void remove(IEntity iEntity) {
        if (this.imageType.isInstance(iEntity)) {
            String string = PropertyHelper.getPropertyName(this.categoryPath);
            BaseEntity baseEntity = (BaseEntity)InvocationContext.wrap((Object)iEntity).getPropertyValue(string);
            if (!this.isCategoryActive(baseEntity)) {
                throw new IllegalActionException();
            }
            this.lock(baseEntity);
        }
        super.remove(iEntity);
    }

    protected abstract int resolveMaxImages(C var1);

    protected C toCategory(NP NP) {
        return (C)((BaseEntity)this.conversionHandler.convert(this.categoryType, NP));
    }

    @Override
    protected void validateMaxImages(C c) throws MaxItemsException {
        this.lock(c);
        int n = this.resolveMaxImages(c);
        if (n >= 0) {
            if (n == 1) {
                this.removeAll(c);
            } else {
                int n2 = this.count(c);
                if (n2 >= n) {
                    throw new MaxItemsException(this.message(GeneralKeys.Errors.MAX_NUMBER_OF_IMAGES, n), n);
                }
            }
        }
    }

    @Override
    protected void validateMaxImages(NP NP) throws MaxItemsException {
        this.validateMaxImages((NP)this.toCategory(NP));
    }
}

