/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.utils.Dimensions;
import org.cyclos.entities.utils.FileSize;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseImageServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseImageServiceImpl<I extends Image, A extends EntityPath<I>, NP>
extends BaseServiceImpl
implements BaseImageServiceLocal<I, NP> {
    protected final ImageNature nature;
    protected final Class<I> imageType;
    protected final A $;
    @Autowired
    protected ImageHandler imageHandler;
    @Autowired
    protected StoredFileHandler storedFileHandler;

    public BaseImageServiceImpl(ImageNature imageNature, Class<I> clazz, A a) {
        this.nature = imageNature;
        this.imageType = clazz;
        this.$ = a;
    }

    public I find(Long l) {
        return (I)((Image)this.find(this.imageType, l));
    }

    public I findByKey(String string) {
        if (string == null || string.length() < 64) {
            throw new EntityNotFoundException();
        }
        StringPath stringPath = (StringPath)FieldHelper.get(this.$, (String)"key");
        string = StringUtils.left((String)string, (int)64);
        return (I)((Image)((DBQuery)this.from(new EntityPath[]{this.$}).where((Predicate)stringPath.eq((Object)string))).requiredUniqueResult(this.$));
    }

    public ImageNature getImageNature() {
        return this.nature;
    }

    public abstract I newImage(NP var1);

    public SerializableInputStream readContent(Long l) {
        I i = this.find(l);
        return this.storedFileHandler.getContent(i);
    }

    public SerializableInputStream readContentByKey(String string) {
        I i = this.findByKey(string);
        return this.storedFileHandler.getContent(i);
    }

    public final void remove(Long l) {
        I i = this.find(l);
        this.onBeforeRemove(i);
        this.storedFileHandler.remove(i.getId().longValue());
        this.onAfterRemove(i);
    }

    public void removeAll(Collection<Long> collection) throws FrameworkException {
        collection.forEach(this::remove);
    }

    public ImageVO save(NP NP, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        this.validateMaxImages(NP);
        I i = this.newImage(NP);
        this.setImageName(string, i);
        this.setDataAndPersist(i, serializableInputStream, string2);
        this.onAfterSave(i);
        return (ImageVO)this.conversionHandler.convert(ImageVO.class, i);
    }

    public void saveName(Long l, String string) throws FrameworkException {
        I i = this.find(l);
        this.setImageName(string, i);
    }

    protected final boolean isKeepOriginalContent() {
        return this.getImageNature().keepOriginalContent();
    }

    protected void onAfterRemove(I i) {
    }

    protected void onAfterSave(I i) {
    }

    protected void onBeforeRemove(I i) {
    }

    protected void setDataAndPersist(I i, SerializableInputStream serializableInputStream, String string) {
        ReadImageData readImageData = null;
        try {
            ServerImageHelper.ImageType imageType = ServerImageHelper.ImageType.getByContentType((String)string);
            readImageData = this.readImage(serializableInputStream, imageType);
            this.setData(i, readImageData, imageType);
            if (i.isTransient()) {
                this.persist((IEntity)i);
            }
            this.flush();
            this.refresh(i);
        }
        catch (CyclosException cyclosException) {
            throw cyclosException;
        }
        catch (Exception exception) {
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID_IMAGE, new Object[0]));
        }
    }

    protected void setImageName(String string, I i) {
        i.setName(StringHelper.emptyIfNull((String)StringHelper.truncate((String)string, (int)100)));
    }

    protected void validateMaxImages(NP NP) throws MaxItemsException {
    }

    private BufferedImage loadImage(File file, ServerImageHelper.ImageType imageType) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                throw new Exception();
            }
            return bufferedImage;
        }
        catch (Exception exception) {
            this.throwInvalidImageError(file, imageType, exception);
            return null;
        }
    }

    private BufferedImage processEXIFMetadata(File file, ServerImageHelper.ImageType imageType) {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)file);
            ExifIFD0Directory exifIFD0Directory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (exifIFD0Directory != null && exifIFD0Directory.containsTag(274)) {
                int n = exifIFD0Directory.getInt(274);
                switch (n) {
                    case 1: {
                        return null;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 7: {
                        return null;
                    }
                    case 3: {
                        return this.rotateImage(this.loadImage(file, imageType), Math.toRadians(180.0));
                    }
                    case 6: {
                        return this.rotateImage(this.loadImage(file, imageType), Math.toRadians(90.0));
                    }
                    case 8: {
                        return this.rotateImage(this.loadImage(file, imageType), Math.toRadians(270.0));
                    }
                }
                this.getLogger().warn("Unknown image orientation " + n + " for image type " + String.valueOf(imageType));
                return null;
            }
            return null;
        }
        catch (ImageProcessingException | MetadataException | IOException throwable) {
            this.getLogger().debug("Error rotating image with type: " + String.valueOf(imageType), throwable);
            return null;
        }
    }

    private ReadImageData readImage(SerializableInputStream serializableInputStream, ServerImageHelper.ImageType imageType) throws IOException {
        Dimension dimension;
        if (serializableInputStream == null) {
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID_IMAGE, new Object[0]));
        }
        File file = serializableInputStream.file();
        IOHelper.close((Closeable)serializableInputStream);
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        Dimensions dimensions = configurationAccessor.getMaxImageDimensions();
        BufferedImage bufferedImage = this.processEXIFMetadata(file, imageType);
        if (bufferedImage != null) {
            dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)imageType, (File)file, (int)configurationAccessor.getJpegQuality());
        } else {
            dimension = this.readImageSize(file, imageType);
        }
        if (!this.isKeepOriginalContent()) {
            FileSize fileSize;
            if (dimension.getWidth() > (double)dimensions.getWidth().intValue() || dimension.getHeight() > (double)dimensions.getHeight().intValue()) {
                if (bufferedImage == null) {
                    bufferedImage = this.loadImage(file, imageType);
                }
                bufferedImage = this.resizeImage(bufferedImage, dimensions);
                ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)imageType, (File)file, (int)configurationAccessor.getJpegQuality());
            }
            if (imageType == ServerImageHelper.ImageType.PNG && (fileSize = configurationAccessor.getMaxPngSize()) != null && fileSize.isValid()) {
                long l = fileSize.getSize() * fileSize.getUnit().getBytes();
                if (file.length() > l) {
                    if (bufferedImage == null) {
                        bufferedImage = this.loadImage(file, imageType);
                    }
                    imageType = ServerImageHelper.ImageType.JPEG;
                    ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)imageType, (File)file, (int)configurationAccessor.getJpegQuality());
                }
            }
            if (bufferedImage != null) {
                dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            }
        }
        return new ReadImageData((int)dimension.getWidth(), (int)dimension.getHeight(), file, imageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dimension readImageSize(File file, ServerImageHelper.ImageType imageType) {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) throw new Exception();
            ImageReader imageReader = iterator.next();
            try {
                imageReader.setInput(imageInputStream);
                Dimension dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
                return dimension;
            }
            finally {
                imageReader.dispose();
            }
        }
        catch (Exception exception) {
            this.throwInvalidImageError(file, imageType, exception);
            return null;
        }
    }

    private BufferedImage resizeImage(BufferedImage bufferedImage, Dimensions dimensions) throws IOException {
        int n = dimensions.getWidth();
        int n2 = dimensions.getHeight();
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        if (n3 <= n2 && n4 <= n) {
            return bufferedImage;
        }
        return ServerImageHelper.resize((BufferedImage)bufferedImage, (Dimension)new Dimension(dimensions.getWidth(), dimensions.getHeight()));
    }

    private BufferedImage rotateImage(BufferedImage bufferedImage, double d) {
        double d2 = Math.abs(Math.sin(d));
        double d3 = Math.abs(Math.cos(d));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)Math.floor((double)n * d3 + (double)n2 * d2);
        int n4 = (int)Math.floor((double)n2 * d3 + (double)n * d2);
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate((n3 - n) / 2, (n4 - n2) / 2);
        graphics2D.rotate(d, n / 2, n2 / 2);
        graphics2D.drawRenderedImage(bufferedImage, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private void setData(I i, ReadImageData readImageData, ServerImageHelper.ImageType imageType) throws IOException {
        i.setKey(this.imageHandler.newKey());
        i.setLastModified(DateHelper.now());
        i.setWidth(readImageData.width);
        i.setHeight(readImageData.height);
        i.setLength(Integer.valueOf((int)readImageData.file.length()));
        i.setContentType(readImageData.imageType.getContentType());
        i.setConvertedToJpeg(readImageData.imageType == ServerImageHelper.ImageType.JPEG && !readImageData.imageType.equals((Object)imageType));
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(readImageData.file);){
            this.storedFileHandler.save(i, serializableInputStream);
        }
    }

    private void throwInvalidImageError(File file, ServerImageHelper.ImageType imageType, Exception exception) {
        file.delete();
        throw new ValidationException(this.message(GeneralKeys.Errors.INVALID_IMAGE, new Object[0]));
    }

    private static class ReadImageData {
        private int width;
        private int height;
        private File file;
        private ServerImageHelper.ImageType imageType;

        public ReadImageData(int n, int n2, File file, ServerImageHelper.ImageType imageType) {
            this.width = n;
            this.height = n2;
            this.file = file;
            this.imageType = imageType;
        }
    }
}

