/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.OwnedImage;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseCategorizedImageServiceImpl;
import org.cyclos.impl.system.BaseOwnedImageServiceLocal;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseOwnedImageServiceImpl<O extends BaseEntity, I extends OwnedImage<O>, A extends EntityPath<I>, NP extends IEntity>
extends BaseCategorizedImageServiceImpl<I, O, A, NP>
implements BaseOwnedImageServiceLocal<O, I, NP> {
    @Autowired
    protected BeanHandler beanHandler;
    @Autowired
    protected TempImageServiceLocal tempImageService;

    public BaseOwnedImageServiceImpl(ImageNature imageNature, Class<O> clazz, Class<I> clazz2, A a, EntityPathBase<O> entityPathBase) {
        super(imageNature, clazz2, clazz, a, entityPathBase);
    }

    public Long importTempImage(O o, TempImage tempImage) {
        return (Long)CollectionHelper.first(this.importTempImages(o, Arrays.asList(tempImage)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Long> importTempImages(O o, List<TempImage> list) {
        if (CollectionHelper.isEmpty(list)) {
            return Collections.emptyList();
        }
        this.lock(o);
        int n = this.resolveMaxImages(o);
        if (n == 1) {
            if (list.size() != 1) throw new MaxItemsException(n);
            this.removeAll(o);
        } else {
            List list2 = this.listByCategory(o);
            if (list2.size() + list.size() > n) {
                throw new MaxItemsException(n);
            }
        }
        int n2 = this.newOrder(o);
        ArrayList<OwnedImage> arrayList = new ArrayList<OwnedImage>(list.size());
        for (TempImage tempImage : list) {
            OwnedImage ownedImage = (OwnedImage)this.conversionHandler.convert(this.imageType, (Object)tempImage);
            ownedImage.setCategory(o);
            ownedImage.setOrder(n2++);
            this.tempImageService.move(tempImage, (StoredFile)ownedImage);
            this.physicallyAddImage(o, ownedImage);
            arrayList.add(ownedImage);
        }
        this.flush();
        return SimpleEntity.ids(arrayList);
    }

    @Override
    public I newImage(NP NP) {
        OwnedImage ownedImage = (OwnedImage)super.newImage(NP);
        ownedImage.setOrder(this.count(ownedImage.getCategory()));
        return (I)ownedImage;
    }

    @Override
    public int removeAll(O o) {
        this.lock(o);
        List list = ((ImageOwner)o).getImages();
        this.setFirstImage(null, o, () -> true);
        this.flush();
        Set set = SimpleEntity.uniqueIds((Collection)list);
        set.forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
        return set.size();
    }

    public final void saveOrder(NP NP, List<ImageVO> list) throws FrameworkException {
        Object c = this.toCategory(NP);
        this.lock(c);
        List list2 = this.listByCategory(c);
        List list3 = this.conversionHandler.convertList(this.imageType, list);
        for (int i = 0; i < list3.size(); ++i) {
            OwnedImage ownedImage2 = (OwnedImage)list3.get(i);
            if (!c.equals((Object)ownedImage2.getCategory())) {
                throw new IllegalActionException();
            }
            ownedImage2.setOrder(i);
        }
        ((ImageOwner)c).setImages(list3);
        this.setFirstImage((OwnedImage)CollectionHelper.first((Iterable)list3), c, () -> true);
        this.onOrderChanged(c);
        Predicate<OwnedImage> predicate = list3::contains;
        list2.stream().filter(predicate.negate()).forEach(ownedImage -> this.remove(ownedImage.getId()));
    }

    @Override
    protected void customizeListByCategoryQuery(DBQuery<?> dBQuery, O o) {
        NumberPath numberPath = (NumberPath)FieldHelper.get((Object)this.$, (String)"order");
        dBQuery.orderBy(numberPath.asc());
    }

    protected void doAddImage(O o, I i) {
        this.validateMaxImages(o);
        i.setCategory(o);
        i.setKey(this.imageHandler.newKey());
        i.setOrder(this.newOrder(o));
        this.physicallyAddImage(o, i);
    }

    @Override
    protected boolean isCategoryActive(O o) {
        return true;
    }

    protected abstract boolean isTempValid(O var1, TempImage var2);

    protected int newOrder(O o) {
        return CollectionHelper.orEmpty((List)((ImageOwner)o).getImages()).stream().mapToInt(OwnedImage::getOrder).max().orElse(0) + 1;
    }

    @Override
    protected void onAfterRemove(I i) {
        BaseEntity baseEntity = i.getCategory();
        ((ImageOwner)baseEntity).getImages().remove(i);
        this.setFirstImage((OwnedImage)CollectionHelper.first((Iterable)((ImageOwner)baseEntity).getImages()), baseEntity, () -> true);
    }

    @Override
    protected void onAfterSave(I i) {
        BaseEntity baseEntity = i.getCategory();
        this.physicallyAddImage(baseEntity, i);
    }

    @Override
    protected void onBeforeRemove(I i) {
        BaseEntity baseEntity = i.getCategory();
        this.setFirstImage(null, baseEntity, () -> i.equals((Object)((ImageOwner)baseEntity).getImage()));
    }

    protected void onOrderChanged(O o) {
    }

    protected void physicallyAddImage(O o, I i) {
        ArrayList<I> arrayList = ((ImageOwner)o).getImages();
        if (arrayList == null) {
            arrayList = new ArrayList<I>();
            ((ImageOwner)o).setImages(arrayList);
        }
        if (!arrayList.contains(i)) {
            arrayList.add(i);
        }
        this.setFirstImage(i, o, () -> ((ImageOwner)o).getImage() == null);
    }

    protected void setFirstImage(I i, O object, Supplier<Boolean> supplier) {
        if (supplier.get().booleanValue()) {
            this.lock(object);
            this.flush();
            object = (BaseEntity)this.entityManagerHandler.refresh(object);
            if (supplier.get().booleanValue()) {
                ((ImageOwner)object).setImage(i);
            }
        }
    }
}

