/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.impl.system.BaseImportHandlerImpl;
import org.cyclos.impl.system.ImportHelper;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.StringHelper;

public abstract class BaseWithFieldsImportHandlerImpl<CF extends CustomField<?, ?, ?>, DTO extends CustomFieldValueDTO, IFDTO extends ImportedFileDTO, IFD extends ImportedFileData, IF extends ImportedFile, E extends SimpleEntity>
extends BaseImportHandlerImpl<IFDTO, IFD, IF, E> {
    protected static final String CUSTOM_FIELD_PRIVATE_IMPORT_SUFFIX = ".private";
    protected static final String CUSTOM_FIELD_IMPORT_PREFIX = "field.";
    private Class<? extends CF> customFieldClass;
    private Class<? extends DTO> customFieldValueDTOClass;

    BaseWithFieldsImportHandlerImpl(Class<? extends CF> clazz, Class<? extends DTO> clazz2, ImportField[] importFieldArray) {
        super(importFieldArray);
        this.customFieldClass = clazz;
        this.customFieldValueDTOClass = clazz2;
    }

    @Override
    public String fieldName(ImportedField importedField) {
        String string = importedField.getFieldName();
        if (string.startsWith(CUSTOM_FIELD_IMPORT_PREFIX)) {
            CustomField customField;
            String string2 = StringHelper.removeStart((String)string, (String)CUSTOM_FIELD_IMPORT_PREFIX);
            boolean bl = string2.endsWith(CUSTOM_FIELD_PRIVATE_IMPORT_SUFFIX);
            if (bl) {
                string2 = StringHelper.removeEnd((String)string, (String)CUSTOM_FIELD_PRIVATE_IMPORT_SUFFIX);
            }
            try {
                customField = (CustomField)this.entityManagerHandler.find(this.customFieldClass, string2);
            }
            catch (Exception exception) {
                return string;
            }
            String string3 = this.getTranslatedName((NamedEntity)customField);
            if (bl) {
                string3 = this.message(SystemKeys.Imports.IS_HIDDEN, string3);
            }
            return string3;
        }
        return super.fieldName(importedField);
    }

    protected Collection<CF> getCustomFields(ImportedLine importedLine, List<ImportedLineValue> list) {
        if (list == null) {
            list = importedLine.getValues();
        }
        return ImportHelper.getFieldValuesForPrefix(importedLine, CUSTOM_FIELD_IMPORT_PREFIX).keySet().stream().filter(string -> !string.endsWith(CUSTOM_FIELD_PRIVATE_IMPORT_SUFFIX)).map(string -> (CustomField)this.entityManagerHandler.find(this.customFieldClass, string)).collect(Collectors.toSet());
    }

    protected DTO getCustomFieldValueDto(Object object, CF CF, ImportedLine importedLine) {
        CustomFieldValueDTO customFieldValueDTO = (CustomFieldValueDTO)ClassHelper.instantiate(this.customFieldValueDTOClass);
        this.customFieldValueHandler.setModelValue(CF, object, (ICustomFieldValue)customFieldValueDTO);
        return (DTO)customFieldValueDTO;
    }

    protected Map<String, String> getCustomFieldValues(ImportedLine importedLine) {
        return ImportHelper.getFieldValuesForPrefix(importedLine, CUSTOM_FIELD_IMPORT_PREFIX);
    }

    protected String getImportFieldName(CF CF) {
        return CUSTOM_FIELD_IMPORT_PREFIX + CF.getInternalName();
    }

    protected List<String> getImportFieldNames(Collection<CF> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CustomField customField : collection) {
            arrayList.add(this.getImportFieldName(customField));
        }
        return arrayList;
    }

    protected String getPrivateImportFieldName(CF CF) {
        return this.getImportFieldName(CF) + CUSTOM_FIELD_PRIVATE_IMPORT_SUFFIX;
    }

    protected Collection<String> getPrivateImportFieldNames(List<CF> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CustomField customField : list) {
            arrayList.add(this.getPrivateImportFieldName(customField));
        }
        return arrayList;
    }

    protected Object parseCustomFieldValue(ImportedLine importedLine, CF CF) {
        String string = importedLine.getValue(this.getImportFieldName(CF));
        if (StringHelper.isNotBlank((Object)string)) {
            try {
                return this.customFieldValueHandler.getValue(CF, (Object)string, true, this.getFormatter());
            }
            catch (Exception exception) {
                this.throwValidationException(exception, CF, string);
            }
        }
        return null;
    }

    protected void setCustomFieldValues(ImportedLine importedLine, List<ImportedLineValue> list, ModelWithCustomValues<DTO> modelWithCustomValues) {
        modelWithCustomValues.setCustomValues(new ArrayList());
        this.getCustomFields(importedLine, list).stream().forEach(customField -> {
            Object object = this.parseCustomFieldValue(importedLine, customField);
            if (object != null) {
                DTO DTO = this.getCustomFieldValueDto(object, customField, importedLine);
                modelWithCustomValues.getCustomValues().add(DTO);
            }
        });
    }

    protected void setCustomFieldValues(ImportedLine importedLine, ModelWithCustomValues<DTO> modelWithCustomValues) {
        this.setCustomFieldValues(importedLine, null, modelWithCustomValues);
    }

    private void throwValidationException(Exception exception, CF CF, Object object) {
        String string = this.message(SystemKeys.Imports.ERROR_INVALID_VALUE, object);
        switch (CF.getType()) {
            case BOOLEAN: {
                string = this.message(SystemKeys.Imports.ERROR_INVALID_BOOLEAN_VALUE, object);
                break;
            }
            case DATE: {
                string = this.message(SystemKeys.Imports.ERROR_DATE_CONVERSION, object, this.getFormatter().getDatePattern());
                break;
            }
            case DECIMAL: 
            case INTEGER: {
                string = this.message(SystemKeys.Imports.ERROR_INVALID_NUMBER_FORMAT, object);
                break;
            }
            case MULTI_SELECTION: 
            case SINGLE_SELECTION: 
            case DYNAMIC_SELECTION: {
                string = this.message(SystemKeys.Imports.ERROR_POSSIBLE_VALUE_NOT_FOUND, object, this.getTranslatedName((NamedEntity)CF));
                break;
            }
            case RICH_TEXT: 
            case STRING: 
            case TEXT: 
            case URL: {
                break;
            }
            case LINKED_ENTITY: {
                if (CF.getLinkedEntityType() == LinkedEntityType.USER) {
                    string = this.message(SystemKeys.Imports.INVALID_USER, object);
                    break;
                }
                string = this.message(SystemKeys.Imports.INVALID_ENTITY, object);
                break;
            }
        }
        throw new ValidationException(string);
    }
}

