/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.dsl.StringPath;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.contentmanagement.BaseHelpContent;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.StaticContentServiceLocal;
import org.cyclos.impl.system.ChannelConfigurationCacheKey;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationAccessorCacheKey;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.Property;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.contentmanagement.staticcontents.HelpContentDefinitionType;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.UserSearchInMenuMode;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.ApplicationContext;

public class ConfigurationAccessorInvocationHandlerImpl
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EQUALS = "equals";
    private static final String HASH_CODE = "hashCode";
    private static final String TO_STRING = "toString";
    private static final String GET_PROXY_CLASS = "getProxyClass";
    private static final String GET_CONFIGURATION = "getConfiguration";
    private static final String GET_CHANNEL_CONFIGURATION = "getChannelConfiguration";
    private static final String GET_LOG_CONFIGURATION = "getLogConfiguration";
    private static final String GET_PASSWORDS = "getPasswords";
    private static final String IS_TOTP_ENABLED = "isTotpEnabled";
    private static final String IS_FIREBASE_PRIVATE_KEY_SET = "isFirebasePrivateKeySet";
    private static final String IS_MAP_SERVER_API_KEY_SET = "isMapServerApiKeySet";
    private static final String GET_ACCESS_PASSWORDS = "getAccessPasswords";
    private static final String GET_LANGUAGE = "getLanguage";
    private static final String GET_ALLOWED_LANGUAGES = "getAllowedLanguages";
    private static final String GET_CONFIGURATION_FOR = "getConfigurationFor";
    private static final String GET_NAME_LABEL = "getNameLabel";
    private static final String GET_NAME = "getName";
    private static final String GET_APPLICATION_NAME = "getApplicationName";
    private static final String GET_APPLICATION_USERNAME = "getApplicationUsername";
    private static final String API_URL = "apiUrl";
    private static final String FULL_URL = "fullUrl";
    private static final String FULL_URLS = "fullUrls";
    private static final String DEFINED_PROPERTIES = "definedProperties";
    private static final String LOCKED_PROPERTIES = "lockedProperties";
    private static final String CHANNELS = "channels";
    private static final String WITH_LANGUAGE = "withLanguage";
    private static final List<String> DIRECT_PROPERTIES = Arrays.asList(ConfigurationDTO.NAME.getName(), ConfigurationDTO.DESCRIPTION.getName(), ConfigurationDTO.PATH.getName());
    private static final List<String> ACCUMULATIVE_COLLECTIONS = Arrays.asList("channels", "definedProperties", "lockedProperties");
    private static final Map<String, StringPath> TRANSLATABLE_PROPERTIES = new HashMap<String, StringPath>();
    private final ApplicationContext applicationContext;
    private final Long networkId;
    private final List<Long> configurationPathIds;
    private final Long configurationId;
    private final List<String> locales;
    private final Set<Long> additionalLanguages;
    private final Cache<ConfigurationAccessorCacheKey, AccessorCacheValue> cache;
    private final Cache<ChannelConfigurationCacheKey, AccessorCacheValue> channelConfigurationCache;
    private final DataTranslationHandler dataTranslationHandler;
    private final RawEntityManagerHandler rawEntityManagerHandler;

    public static ConfigurationAccessor newAccessor(ApplicationContext applicationContext, Long l, List<Long> list, Set<Long> set, List<String> list2) {
        return ConfigurationAccessorInvocationHandlerImpl.newProxy(new ConfigurationAccessorInvocationHandlerImpl(applicationContext, l, list, set, list2));
    }

    private static ConfigurationAccessor newProxy(InvocationHandler invocationHandler) {
        return (ConfigurationAccessor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ConfigurationAccessor.class}, invocationHandler);
    }

    private static ConfigurationAccessor withLanguage(ConfigurationAccessor configurationAccessor, Language language) {
        if (configurationAccessor.getLanguage().equals((Object)language)) {
            return configurationAccessor;
        }
        return ConfigurationAccessorInvocationHandlerImpl.newProxy((object, method, objectArray) -> {
            if (method.getName().equals(GET_LANGUAGE)) {
                return language;
            }
            return method.invoke((Object)configurationAccessor, objectArray);
        });
    }

    private ConfigurationAccessorInvocationHandlerImpl(ApplicationContext applicationContext, Long l, List<Long> list, Set<Long> set, List<String> list2) {
        this.applicationContext = applicationContext;
        this.networkId = l;
        this.configurationPathIds = list;
        this.configurationId = (Long)CollectionHelper.first(list);
        this.locales = list2;
        this.additionalLanguages = set;
        CacheHandler cacheHandler = (CacheHandler)applicationContext.getBean(CacheHandler.class);
        this.cache = cacheHandler.getCache(CacheType.CONFIGURATION_ACCESSOR);
        this.channelConfigurationCache = cacheHandler.getCache(CacheType.CHANNEL_CONFIGURATION);
        this.dataTranslationHandler = (DataTranslationHandler)applicationContext.getBean(DataTranslationHandler.class);
        this.rawEntityManagerHandler = (RawEntityManagerHandler)applicationContext.getBean(RawEntityManagerHandler.class);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string;
        String string2;
        switch (string2 = method.getName()) {
            case "equals": {
                return this.equals(objectArray[0]);
            }
            case "hashCode": {
                return this.hashCode();
            }
            case "toString": {
                return this.toString();
            }
            case "getConfiguration": {
                return this.getConfiguration();
            }
            case "getProxyClass": {
                return ConfigurationAccessor.class;
            }
            case "getLanguage": {
                return this.getLanguage();
            }
            case "getAllowedLanguages": {
                return this.getAllowedLanguages();
            }
            case "withLanguage": {
                return ConfigurationAccessorInvocationHandlerImpl.withLanguage((ConfigurationAccessor)object, (Language)objectArray[0]);
            }
            case "getChannelConfiguration": {
                Channel channel = (Channel)objectArray[0];
                ChannelConfigurationCacheKey channelConfigurationCacheKey = new ChannelConfigurationCacheKey(this.networkId, channel.getId(), this.configurationPathIds);
                AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.channelConfigurationCache.get((Serializable)channelConfigurationCacheKey, () -> AccessorCacheValue.create((Object)this.getChannelConfiguration(channel)));
                return accessorCacheValue.unwrap(this.applicationContext);
            }
            case "getConfigurationFor": {
                String string3 = (String)objectArray[0];
                ConfigurationAccessorCacheKey configurationAccessorCacheKey = new ConfigurationAccessorCacheKey(this.networkId, this.configurationPathIds, "getConfigurationFor_" + string3);
                AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)configurationAccessorCacheKey, () -> AccessorCacheValue.create((Object)this.getConfigurationFor(string3)));
                return accessorCacheValue.unwrap(this.applicationContext);
            }
        }
        if (TRANSLATABLE_PROPERTIES.containsKey(string2)) {
            string = PropertyHelper.getPropertyName((Method)method);
            Configuration configuration = DIRECT_PROPERTIES.contains(string) ? this.getConfiguration() : ((ConfigurationAccessor)object).getConfigurationFor(PropertyHelper.getPropertyName((Method)method));
            return this.dataTranslationHandler.getValue((BaseEntity)configuration, TRANSLATABLE_PROPERTIES.get(string2));
        }
        string = new ConfigurationAccessorCacheKey(this.networkId, this.configurationPathIds, string2);
        AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)((Object)string), () -> {
            Object object2 = GET_LOG_CONFIGURATION.equals(string2) ? this.getLogConfiguration(object) : (GET_PASSWORDS.equals(string2) ? this.getPasswords(false) : (GET_ACCESS_PASSWORDS.equals(string2) ? this.getPasswords(true) : (IS_TOTP_ENABLED.equals(string2) ? Boolean.valueOf(this.isTotpEnabled()) : (IS_FIREBASE_PRIVATE_KEY_SET.equals(string2) ? Boolean.valueOf(this.isPropertySet((Property<?, ConfigurationDTO>)ConfigurationDTO.FIREBASE_PRIVATE_KEY)) : (IS_MAP_SERVER_API_KEY_SET.equals(string2) ? Boolean.valueOf(this.isPropertySet((Property<?, ConfigurationDTO>)ConfigurationDTO.MAP_SERVER_API_KEY)) : this.getValue(method))))));
            return AccessorCacheValue.create((Object)object2);
        });
        return accessorCacheValue.unwrap(this.applicationContext);
    }

    public String toString() {
        return "ConfigurationAccessor#" + this.configurationId;
    }

    private ChannelConfiguration emptyChannelConfiguration(Configuration configuration, Channel channel, boolean bl, boolean bl2) {
        SmsChannelConfiguration smsChannelConfiguration = channel.isSms() ? new SmsChannelConfiguration() : new ChannelConfiguration();
        smsChannelConfiguration.setConfiguration(configuration);
        smsChannelConfiguration.setChannel(channel);
        smsChannelConfiguration.setDefined(true);
        smsChannelConfiguration.setLocked(bl);
        smsChannelConfiguration.setCanBeDefined(bl2);
        return smsChannelConfiguration;
    }

    private Object geDefaultValue(String string) {
        if (API_URL.equals(string)) {
            return this.getFullUrl(true) + "/api";
        }
        if (ConfigurationDTO.USER_SEARCH_IN_MENU_MODE.getName().equals(string)) {
            return UserSearchInMenuMode.ALL_IN_USER_SEARCH;
        }
        return null;
    }

    private Collection<?> getAccumulativeCollection(String string, Class<?> clazz) {
        Object object;
        HashSet hashSet = new HashSet();
        for (Configuration configuration = this.getConfiguration(); configuration != null; configuration = configuration.getParent()) {
            object = InvocationContext.wrap((Object)configuration);
            HashSet hashSet2 = (HashSet)object.getPropertyValue(string);
            if (hashSet2 == null) continue;
            if (LOCKED_PROPERTIES.equals(string)) {
                hashSet2 = new HashSet(hashSet2);
                hashSet2.retainAll((Collection)object.getPropertyValue(DEFINED_PROPERTIES));
            }
            hashSet.addAll(hashSet2);
        }
        if (List.class.isAssignableFrom(clazz)) {
            object = new ArrayList(hashSet);
            try {
                Collections.sort(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }
        return hashSet;
    }

    private Set<Language> getAllowedLanguages() {
        Set set = (Set)this.getValue(ConfigurationDTO.ALLOWED_LANGUAGES.getName(), HashSet.class);
        if (this.additionalLanguages != null) {
            this.additionalLanguages.stream().map(l -> (Language)this.rawEntityManagerHandler.find(Language.class, l)).filter(language -> !set.stream().anyMatch(language2 -> language2.getTemplate() == language.getTemplate())).forEach(set::add);
        }
        return set;
    }

    private ChannelConfiguration getChannelConfiguration(Channel channel) {
        ChannelConfiguration channelConfiguration;
        Configuration configuration = this.getConfiguration();
        List list = ((ConfigurationHandler)this.applicationContext.getBean(ConfigurationHandler.class)).getAncestors(configuration);
        int n = list.size();
        if (n > 1) {
            Iterator iterator = list.listIterator(n);
            while (iterator.hasPrevious()) {
                Configuration configuration2 = (Configuration)iterator.previous();
                channelConfiguration = configuration2.getChannelConfiguration(channel);
                if (configuration2.equals((Object)configuration)) break;
                if (channelConfiguration == null || !channelConfiguration.isDefined() || !channelConfiguration.isLocked()) continue;
                if (channelConfiguration.isEnabled()) {
                    return channelConfiguration;
                }
                return this.emptyChannelConfiguration(channelConfiguration.getConfiguration(), channel, channelConfiguration.isLocked(), false);
            }
        }
        for (Configuration configuration2 : list) {
            channelConfiguration = configuration2.getChannelConfiguration(channel);
            if (channelConfiguration == null || !channelConfiguration.isDefined()) continue;
            if (channelConfiguration.isEnabled()) {
                return channelConfiguration;
            }
            return this.emptyChannelConfiguration(channelConfiguration.getConfiguration(), channel, channelConfiguration.isLocked(), true);
        }
        return this.emptyChannelConfiguration(configuration, channel, false, true);
    }

    private Configuration getConfiguration() {
        return (Configuration)this.rawEntityManagerHandler.find(Configuration.class, this.configurationId);
    }

    private Configuration getConfigurationFor(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Configuration property can not be null");
        }
        Set set = ((ConfigurationHandler)this.applicationContext.getBean(ConfigurationHandler.class)).getConfigurableProperties();
        boolean bl = set.contains(string);
        if (bl) {
            Pair<Configuration, Object> pair = this.getDefined(string);
            return pair == null ? null : (Configuration)pair.getFirst();
        }
        throw new IllegalArgumentException("Invalid property: " + string + ". The configuration can be obtained only from configurable properties");
    }

    private Pair<Configuration, Object> getDefined(String string) {
        boolean bl;
        Configuration configuration = this.getConfiguration();
        List list = ((ConfigurationHandler)this.applicationContext.getBean(ConfigurationHandler.class)).getAncestors(configuration);
        Iterator iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            Configuration configuration2 = (Configuration)iterator.previous();
            bl = configuration2.getDefinedProperties().contains(string) && configuration2.getLockedProperties().contains(string);
            if (!bl) continue;
            configuration = configuration2;
            list = ((ConfigurationHandler)this.applicationContext.getBean(ConfigurationHandler.class)).getAncestors(configuration);
            break;
        }
        for (Configuration configuration2 : list) {
            bl = configuration2.getParent() == null;
            boolean bl2 = configuration2.getDefinedProperties().contains(string);
            if (!bl && !bl2) continue;
            return Pair.create((Object)configuration2, (Object)InvocationContext.wrap((Object)configuration2).getPropertyValue(string));
        }
        return null;
    }

    private Object getFirstAvailable(String string) {
        for (Configuration configuration = this.getConfiguration(); configuration != null; configuration = configuration.getParent()) {
            Object object = InvocationContext.wrap((Object)configuration).getPropertyValue(string);
            boolean bl = false;
            if (object instanceof BaseHelpContent) {
                BaseHelpContent baseHelpContent = (BaseHelpContent)object;
                if (HelpContentDefinitionType.ORIGINAL == baseHelpContent.getDefinitionType()) {
                    bl = true;
                    StaticContentServiceLocal staticContentServiceLocal = (StaticContentServiceLocal)this.applicationContext.getBean(StaticContentServiceLocal.class);
                    String string2 = staticContentServiceLocal.readOriginalHelp(baseHelpContent.getNature());
                    baseHelpContent.setOriginalContent(string2);
                } else {
                    bl = ((BaseHelpContent)object).isCustomized();
                }
            } else {
                bl = object instanceof BaseStaticContent ? ((BaseStaticContent)object).isCustomized() : ObjectHelper.isNotEmpty((Object)object);
            }
            if (!bl) continue;
            return object;
        }
        return null;
    }

    private Object getFixedValue(String string) {
        Object object;
        Object object2;
        if (ConfigurationDTO.EMAIL_VALIDATION.getName().equals(string) ? Boolean.FALSE.equals(object2 = this.getValue(ConfigurationDTO.EMAIL_REQUIRED.getName(), ConfigurationDTO.EMAIL_REQUIRED.getType())) : ConfigurationDTO.GROUPS_FOR_USER_SEARCH_IN_MENU.getName().equals(string) && !UserSearchInMenuMode.SPECIFIC_GROUPS.equals(object = this.getValue(ConfigurationDTO.USER_SEARCH_IN_MENU_MODE.getName(), ConfigurationDTO.USER_SEARCH_IN_MENU_MODE.getType()))) {
            return Collections.emptySet();
        }
        return null;
    }

    private String getFullUrl(boolean bl) {
        String string;
        Configuration configuration = this.getConfiguration();
        String string2 = StringUtils.removeEnd((String)StringHelper.trimToNull((Object)this.getValue(ConfigurationDTO.ROOT_URL.getName(), String.class)), (String)"/");
        boolean bl2 = !Objects.equals(string2, string = StringUtils.removeEnd((String)this.getGlobalDefault().getRootUrl(), (String)"/"));
        String string3 = StringUtils.removeEnd((String)StringHelper.removeStart((String)StringHelper.trimToNull((Object)configuration.getPath()), (String)"/"), (String)"/");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        if (!bl2 || configuration.isGlobal() && configuration.isDefaultConfig()) {
            Network network = configuration.getNetwork();
            if (network == null) {
                stringBuilder.append('/').append("global");
            } else {
                boolean bl3;
                boolean bl4 = bl3 = bl && network.isDefaultNetwork();
                if (!bl3) {
                    stringBuilder.append('/').append(network.getInternalName());
                }
            }
        }
        if (string3 != null) {
            stringBuilder.append('/').append(string3);
        }
        return stringBuilder.toString();
    }

    private Set<String> getFullUrls() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(this.getFullUrl(true));
        linkedHashSet.add(this.getFullUrl(false));
        return linkedHashSet;
    }

    private Configuration getGlobalDefault() {
        Configuration configuration = this.getConfiguration();
        while (configuration.getParent() != null) {
            configuration = configuration.getParent();
        }
        return configuration;
    }

    private Language getLanguage() {
        Set<Language> set = this.getAllowedLanguages();
        set.add((Language)this.getValue(ConfigurationDTO.DEFAULT_LANGUAGE.getName(), Language.class));
        if (set.isEmpty()) {
            List list = ((LanguageServiceLocal)InvocationContext.bean(LanguageServiceLocal.class)).listAll();
            if (list.isEmpty()) {
                throw new IllegalStateException("No languages found!");
            }
            for (Language language : list) {
                if (language.getTemplate() != BuiltinLanguage.EN) continue;
                return language;
            }
            return (Language)CollectionHelper.first((Iterable)list);
        }
        if (set.size() == 1) {
            return (Language)CollectionHelper.first(set);
        }
        List list = LocaleHelper.toLocales(this.locales);
        for (Locale locale : list) {
            BuiltinLanguage builtinLanguage = LocaleHelper.mapLocale((Locale)locale);
            if (builtinLanguage == null) continue;
            for (Language language : set) {
                if (!language.getTemplate().equals((Object)builtinLanguage)) continue;
                return language;
            }
        }
        return (Language)this.getValue(ConfigurationDTO.DEFAULT_LANGUAGE.getName(), Language.class);
    }

    private LogConfiguration getLogConfiguration(Object object) {
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(LogConfiguration.class);
        for (PropertyDescriptor propertyDescriptor : beanWrapperImpl.getPropertyDescriptors()) {
            try {
                String string = propertyDescriptor.getName();
                Object object2 = this.getValue(string, propertyDescriptor.getPropertyType());
                beanWrapperImpl.setPropertyValue(string, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (LogConfiguration)beanWrapperImpl.getWrappedInstance();
    }

    private List<PasswordType> getPasswords(boolean bl) {
        List list = (List)this.getValue(CHANNELS, List.class);
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return Collections.emptyList();
        }
        EnumSet<CredentialUsage> enumSet = bl ? EnumSet.of(CredentialUsage.ACCESS) : EnumSet.allOf(CredentialUsage.class);
        HashSet<PasswordType> hashSet = new HashSet<PasswordType>();
        for (Channel channel : list) {
            ChannelConfiguration channelConfiguration = this.getChannelConfiguration(channel);
            if (channelConfiguration == null) continue;
            for (CredentialUsage credentialUsage : enumSet) {
                PasswordType passwordType = channelConfiguration.getCredentials(credentialUsage).getPassword();
                if (passwordType == null) continue;
                hashSet.add(passwordType);
            }
        }
        return CollectionHelper.sort(hashSet);
    }

    private Object getValue(Method method) {
        String string = PropertyHelper.getPropertyName((Method)method);
        Class<?> clazz = method.getReturnType();
        return this.getValue(string, clazz);
    }

    private Object getValue(String string, Class<?> clazz) {
        Object object;
        Object object2 = null;
        if (ACCUMULATIVE_COLLECTIONS.contains(string)) {
            Collection<?> collection = this.getAccumulativeCollection(string, clazz);
            if (CHANNELS.equals(string)) {
                List list = (List)collection;
                list.removeIf(channel -> {
                    ChannelConfiguration channelConfiguration = this.getChannelConfiguration((Channel)channel);
                    return channelConfiguration == null || !channelConfiguration.isEnabled();
                });
            }
            return collection;
        }
        if (DIRECT_PROPERTIES.contains(string)) {
            return InvocationContext.wrap((Object)this.getConfiguration()).getPropertyValue(string);
        }
        if (FULL_URL.equals(string)) {
            return this.getFullUrl(true);
        }
        if (FULL_URLS.equals(string)) {
            return this.getFullUrls();
        }
        object2 = this.getFixedValue(string);
        if (object2 != null) {
            return object2;
        }
        Set set = ((ConfigurationHandler)this.applicationContext.getBean(ConfigurationHandler.class)).getConfigurableProperties();
        boolean bl = set.contains(string);
        Object object3 = bl ? ((object = this.getDefined(string)) == null ? null : object.getSecond()) : this.getFirstAvailable(string);
        if (object3 == null) {
            object3 = this.geDefaultValue(string);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            object = CollectionHelper.orEmpty((Collection)((Collection)object3));
            if (Set.class.isAssignableFrom(clazz)) {
                return new HashSet(object);
            }
            return CollectionHelper.sort(object);
        }
        return CoercionHelper.coerce(clazz, (Object)object3);
    }

    private boolean isPropertySet(Property<?, ConfigurationDTO> property) {
        return StringHelper.isNotBlank((Object)this.getValue(property.getName(), property.getType()));
    }

    private boolean isTotpEnabled() {
        List list = (List)this.getValue(CHANNELS, List.class);
        for (Channel channel : CollectionHelper.orEmpty((List)list)) {
            ChannelConfiguration channelConfiguration = this.getChannelConfiguration(channel);
            if (channelConfiguration == null) continue;
            for (CredentialUsage credentialUsage : EnumSet.allOf(CredentialUsage.class)) {
                if (!channelConfiguration.getCredentials(credentialUsage).isTotp()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        TRANSLATABLE_PROPERTIES.put(GET_NAME_LABEL, QConfiguration.configuration.nameLabel);
        TRANSLATABLE_PROPERTIES.put(GET_NAME, QConfiguration.configuration.name);
        TRANSLATABLE_PROPERTIES.put(GET_APPLICATION_NAME, QConfiguration.configuration.applicationName);
        TRANSLATABLE_PROPERTIES.put(GET_APPLICATION_USERNAME, QConfiguration.configuration.applicationUsername);
    }
}

