/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.conversion.BaseEntityConverter;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldConverter
extends BaseEntityConverter<CustomField<?, ?, ?>> {
    @Autowired
    private RichTextHandler richTextHandler;

    public CustomFieldConverter() {
        super(CustomField.class);
    }

    @Override
    protected void fill(Object object, CustomField<?, ?, ?> customField, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, customField, objectArray, conversionContext);
        if (object instanceof CustomFieldDTO || customField.isTransient()) {
            if (customField.isIgnoreSanitizer()) {
                customField.setDefaultRichTextValue(this.richTextHandler.replaceUrlsByTags(customField.getDefaultRichTextValue()));
            } else {
                customField.setDefaultStringValue(this.richTextHandler.escapeTags(customField.getDefaultStringValue()));
                customField.setDefaultTextValue(this.richTextHandler.escapeTags(customField.getDefaultTextValue()));
                customField.setDefaultRichTextValue(this.richTextHandler.sanitize(customField.getDefaultRichTextValue()));
            }
        }
    }
}

