/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SetPath;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.CustomFieldValueFile;
import org.cyclos.entities.system.CustomFieldValueImage;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.DynamicFieldValue;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ICustomFieldValueStoredFile;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.LinkedEntityTypeMapping;
import org.cyclos.entities.system.QCustomFieldValue;
import org.cyclos.entities.system.QDynamicFieldValue;
import org.cyclos.entities.system.TempFile;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductSystemRecordType;
import org.cyclos.entities.users.QProductUserRecordType;
import org.cyclos.entities.users.QUserCustomFieldValue;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.entities.utils.RawFile;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.CustomFieldValueImageServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.RawFileServiceLocal;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.formatting.BigDecimalFormattable;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.CustomFieldPropertyAccess;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.RequiredValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.transactions.HasTransactionNumber;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldNature;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.DynamicFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.IDynamicFieldValue;
import org.cyclos.model.system.fields.LinkedAdVO;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.system.fields.LinkedRecordVO;
import org.cyclos.model.system.fields.LinkedTransactionVO;
import org.cyclos.model.system.fields.LinkedTransferVO;
import org.cyclos.model.system.fields.LinkedUserVO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.HasDisplay;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.IDecimalRange;
import org.cyclos.model.utils.IIntegerRange;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.Range;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.MethodHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageProducer;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.cyclos.utils.coercion.CoercionException;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldValueHandlerImpl
extends BaseNetworkedHandlerImpl
implements CustomFieldValueHandler {
    private static final String ALLOWED_DYNA_VALUES = "allowedDynaValues";
    private static final Comparator<CustomFieldPossibleValue<?, ?, ?>> POSSIBLE_VALUES_COMPARATOR = Comparator.comparing(customFieldPossibleValue -> customFieldPossibleValue.getCategory(), Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(customFieldPossibleValue -> customFieldPossibleValue.getValue());
    private static final String VALUE_SEPARATOR_REGEX = "\\" + CustomFieldHelper.VALUE_SEPARATOR;
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private TempImageServiceLocal tempImageService;
    @Autowired
    private RawFileServiceLocal tempFileService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private CustomFieldValueImageServiceLocal customFieldValueImageService;

    public void addLengthValidation(Property property, IntegerRange integerRange) {
        if (integerRange != null) {
            Integer n = integerRange.getMin();
            Integer n2 = integerRange.getMax();
            if (n2 != null && n2 == 0) {
                return;
            }
            if (n != null && n2 != null) {
                property.length(n.intValue(), n2.intValue());
            } else if (n != null) {
                property.minLength(n.intValue());
            } else if (n2 != null) {
                property.maxLength(n2.intValue());
            }
        }
    }

    public void addPatternValidation(Property property, String string) {
        if (StringHelper.isNotBlank((Object)string)) {
            property.maskValue(string);
        }
    }

    public Property addValueValidation(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map) {
        return this.addValueValidation(validator, customField, entityPathBase, map, null);
    }

    public Property addValueValidation(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map, LoadValuesScriptFunction loadValuesScriptFunction, String string) {
        return this.doAddValueValidation(validator, customField, entityPathBase, map, loadValuesScriptFunction, string, false);
    }

    public Property addValueValidation(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map, String string) {
        return this.addValueValidation(validator, customField, entityPathBase, map, LoadValuesScriptFunction.ENTITY, string);
    }

    public Property addValueValidationAsProperty(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map, org.cyclos.model.Property<?, ?> property) {
        return this.doAddValueValidation(validator, customField, entityPathBase, map, null, property, false);
    }

    public Property addValueValidationAsPropertyIgnoringRequired(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map, org.cyclos.model.Property<?, ?> property) {
        return this.doAddValueValidation(validator, customField, entityPathBase, map, null, property, true);
    }

    public Property addValueValidationIgnoringRequired(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map) {
        return this.doAddValueValidation(validator, customField, entityPathBase, map, LoadValuesScriptFunction.ENTITY, null, true);
    }

    public void addWordSizeValidation(Property property, CustomField<?, ?, ?> customField) {
        Integer n = customField.getMaxWordSize();
        if (n != null) {
            property.maxWordSize(n.intValue());
        }
    }

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> V buildFieldValue(CF CF, Class<V> clazz, QCustomFieldValue qCustomFieldValue, Tuple tuple) {
        CustomFieldType customFieldType = CF.getType();
        Long l = (Long)tuple.get((Expression)qCustomFieldValue.id);
        if (l == null) {
            return null;
        }
        if (customFieldType.isEnumerated() || customFieldType.isBinary()) {
            return (V)((CustomFieldValue)this.find(clazz, l));
        }
        CustomFieldValue customFieldValue = (CustomFieldValue)ClassHelper.instantiate(clazz);
        FieldHelper.set((Object)customFieldValue, (String)EntityDTO.ID.getName(), (Object)l);
        FieldHelper.set((Object)customFieldValue, (String)EntityDTO.VERSION.getName(), (Object)tuple.get((Expression)qCustomFieldValue.version));
        FieldHelper.set((Object)customFieldValue, (String)CustomFieldValueDTO.FIELD.getName(), CF);
        switch (customFieldType) {
            case BOOLEAN: {
                customFieldValue.setBooleanValue((Boolean)tuple.get((Expression)qCustomFieldValue.booleanValue));
                break;
            }
            case DATE: {
                customFieldValue.setDateValue((IDate)DateWrapper.instance((Date)((Date)tuple.get((Expression)qCustomFieldValue.dateValue))));
                break;
            }
            case DECIMAL: {
                customFieldValue.setDecimalValue((BigDecimal)tuple.get((Expression)qCustomFieldValue.decimalValue));
                break;
            }
            case DYNAMIC_SELECTION: {
                customFieldValue.setStringValue((String)tuple.get((Expression)qCustomFieldValue.stringValue));
                customFieldValue.setTextValue((String)tuple.get((Expression)qCustomFieldValue.textValue));
                break;
            }
            case INTEGER: {
                customFieldValue.setIntegerValue((Integer)tuple.get((Expression)qCustomFieldValue.integerValue));
                break;
            }
            case LINKED_ENTITY: {
                customFieldValue.setLinkedEntityId((Long)tuple.get((Expression)qCustomFieldValue.linkedEntityId));
                break;
            }
            case RICH_TEXT: {
                customFieldValue.setRichTextValue((String)tuple.get((Expression)qCustomFieldValue.richTextValue));
                break;
            }
            case STRING: 
            case URL: {
                customFieldValue.setStringValue((String)tuple.get((Expression)qCustomFieldValue.stringValue));
                break;
            }
            case TEXT: {
                customFieldValue.setTextValue((String)tuple.get((Expression)qCustomFieldValue.textValue));
                break;
            }
        }
        return (V)customFieldValue;
    }

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> List<V> cloneCustomValuesData(E e, Collection<V> collection) {
        ArrayList arrayList = new ArrayList();
        CollectionHelper.orEmpty(collection).forEach(customFieldValue -> {
            CustomFieldType customFieldType = customFieldValue.getField().getType();
            CustomFieldValue customFieldValue2 = (CustomFieldValue)ClassHelper.instantiate(customFieldValue.getClass());
            if (CustomFieldType.FILE == customFieldType) {
                List list2 = CollectionHelper.orEmpty((List)customFieldValue.getFileValues()).stream().map(customFieldValueFile -> {
                    RawFileVO rawFileVO = this.tempFileService.saveTemp(null, this.toCustomFieldVO(customFieldValueFile.getCustomFieldValue().getField()), customFieldValueFile.getName(), customFieldValueFile.getContentType(), this.tempFileService.readContent(customFieldValueFile.getId()));
                    return (TempFile)this.tempFileService.findAs(TempFile.class, rawFileVO.getId());
                }).collect(Collectors.toList());
                this.conversionHandler.fillExcluding(customFieldValue, (Object)customFieldValue2, new Object[]{CustomFieldValueDTO.FILE_VALUES});
                customFieldValue2.setRawFiles(list2);
            } else if (CustomFieldType.IMAGE == customFieldType) {
                List list3 = CollectionHelper.orEmpty((List)customFieldValue.getImageValues()).stream().map(customFieldValueImage -> {
                    NewTempImageParams newTempImageParams = new NewTempImageParams();
                    newTempImageParams.setCustomField(this.toCustomFieldVO(customFieldValueImage.getCustomFieldValue().getField()));
                    ImageVO imageVO = this.tempImageService.save((Object)newTempImageParams, customFieldValueImage.getName(), this.customFieldValueImageService.readContent(customFieldValueImage.getId()), customFieldValueImage.getContentType());
                    return (TempImage)this.tempImageService.find(imageVO.getId());
                }).collect(Collectors.toList());
                this.conversionHandler.fillExcluding(customFieldValue, (Object)customFieldValue2, new Object[]{CustomFieldValueDTO.IMAGE_VALUES});
                customFieldValue2.setRawImages(list3);
            } else {
                this.conversionHandler.fill(customFieldValue, (Object)customFieldValue2);
            }
            customFieldValue2.setOwner(e);
            arrayList.add(customFieldValue2);
        });
        return arrayList;
    }

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> void cloneCustomValuesData(ModelWithCustomValues<CustomFieldValueDTO> modelWithCustomValues, Collection<V> collection) {
        collection = this.cloneCustomValuesData((SimpleEntity)null, collection);
        List list = collection.stream().map(customFieldValue -> {
            CustomFieldValueDTO customFieldValueDTO = (CustomFieldValueDTO)this.conversionHandler.convert(CustomFieldValueDTO.class, customFieldValue);
            if (customFieldValue.getField().getType() == CustomFieldType.FILE) {
                customFieldValueDTO.setFileValues(customFieldValue.getRawFiles().stream().map(rawFile -> new RawFileVO(rawFile.getId())).collect(Collectors.toList()));
            } else if (customFieldValue.getField().getType() == CustomFieldType.IMAGE) {
                customFieldValueDTO.setImageValues(customFieldValue.getRawImages().stream().map(image -> new ImageVO(image.getId())).collect(Collectors.toList()));
            }
            return customFieldValueDTO;
        }).collect(Collectors.toList());
        modelWithCustomValues.setCustomValues(list);
    }

    public void fillValuesFromScript(Class<? extends CustomField<?, ?, ?>> clazz, LoadValuesScriptFunction loadValuesScriptFunction, Map<String, ?> map, Collection<? extends CustomFieldDetailedVO> collection) {
        this.fillValuesFromScript(clazz, loadValuesScriptFunction, map, collection, false);
    }

    public void fillValuesFromScript(Class<? extends CustomField<?, ?, ?>> clazz, LoadValuesScriptFunction loadValuesScriptFunction, Map<String, ?> map, Collection<? extends CustomFieldDetailedVO> collection, boolean bl) {
        for (CustomFieldDetailedVO customFieldDetailedVO : collection) {
            CustomField customField = (CustomField)this.conversionHandler.convert(clazz, (Object)customFieldDetailedVO);
            CustomFieldType customFieldType = customField.getType();
            boolean bl2 = loadValuesScriptFunction == LoadValuesScriptFunction.ENTITY || bl ? customFieldType.canHaveLoadValuesScript() : (loadValuesScriptFunction == LoadValuesScriptFunction.FILTER ? customFieldType.canHaveValuesOnSearch() : false);
            if (!bl2) continue;
            List<Object> list = this.getAllowedValues(customField, loadValuesScriptFunction, map);
            if (list != null) {
                customFieldDetailedVO.setHasValuesList(true);
                if (customFieldType.isDynamic()) {
                    customFieldDetailedVO.setDynamicValues(this.conversionHandler.convertList(DynamicFieldValueVO.class, list));
                    continue;
                }
                if (customFieldType.isEnumerated()) {
                    customFieldDetailedVO.setPossibleValues(this.conversionHandler.convertList(CustomFieldPossibleValueVO.class, list));
                    continue;
                }
                if (customFieldType.isString()) {
                    customFieldDetailedVO.setStringValues(list);
                    continue;
                }
                if (customFieldType == CustomFieldType.DATE) {
                    customFieldDetailedVO.setDateValues(this.conversionHandler.convertList(DateTime.class, list));
                    continue;
                }
                if (customFieldType == CustomFieldType.INTEGER) {
                    customFieldDetailedVO.setIntegerValues(list);
                    continue;
                }
                if (customFieldType == CustomFieldType.DECIMAL) {
                    customFieldDetailedVO.setDecimalValues(list);
                    continue;
                }
                if (customFieldType != CustomFieldType.LINKED_ENTITY) continue;
                switch (customField.getLinkedEntityType()) {
                    case ADVERTISEMENT: {
                        customFieldDetailedVO.setAdValues(this.conversionHandler.convertList(BasicAdVO.class, list));
                        break;
                    }
                    case RECORD: {
                        customFieldDetailedVO.setRecordValues(this.conversionHandler.convertList(RecordVO.class, list));
                        break;
                    }
                    case TRANSACTION: {
                        customFieldDetailedVO.setTransactionValues(this.conversionHandler.convertList(TransactionVO.class, list));
                        break;
                    }
                    case TRANSFER: {
                        customFieldDetailedVO.setTransferValues(this.conversionHandler.convertList(TransferVO.class, list));
                        break;
                    }
                    case USER: {
                        customFieldDetailedVO.setUserValues(this.conversionHandler.convertList(UserVO.class, list));
                    }
                }
                continue;
            }
            if (!customFieldType.isEnumerated()) continue;
            customFieldDetailedVO.setHasValuesList(true);
        }
    }

    public String format(FormatterImpl formatterImpl, CustomField<?, ?, ?> customField, Object object) {
        if (object == null) {
            return "";
        }
        CustomFieldType customFieldType = customField.getType();
        switch (customFieldType) {
            case DECIMAL: {
                int n = (Integer)ObjectHelper.defaultValue((Object)customField.getDecimalDigits(), (Object)2);
                BigDecimal bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)object);
                return formatterImpl.format(bigDecimal, n);
            }
            case DATE: {
                Date date = (Date)this.conversionHandler.convert(Date.class, object);
                ZonedDateTime zonedDateTime = DateHelper.toZonedDateTime((Date)date, (TimeZone)this.getSessionData().getConfiguration().getTimeZone());
                if (zonedDateTime.getHour() == 0 && zonedDateTime.getMinute() == 0 && zonedDateTime.getSecond() == 0) {
                    return formatterImpl.formatAsDate(date);
                }
                return formatterImpl.format(date);
            }
            case MULTI_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    return collection.stream().map(arg_0 -> ((FormatterImpl)formatterImpl).format(arg_0)).sorted().collect(Collectors.joining(", "));
                }
                return formatterImpl.format(object);
            }
        }
        return formatterImpl.format(object);
    }

    public CustomField<?, ?, ?> getCustomField(CustomFieldVO customFieldVO) {
        if (customFieldVO == null) {
            return null;
        }
        if (!ModelHelper.isValid((IInternalNamedEntity)customFieldVO) || customFieldVO.getNature() == null) {
            throw new EntityNotFoundException(CustomField.class);
        }
        Class clazz = CustomFieldValueHandler.getCustomFieldClass((CustomFieldNature)customFieldVO.getNature());
        return (CustomField)this.conversionHandler.convert(clazz, (Object)customFieldVO);
    }

    public Object getDefaultValue(CustomField<?, ?, ?> customField) {
        switch (customField.getType()) {
            case BOOLEAN: {
                return customField.getDefaultBooleanValue();
            }
            case DATE: {
                return customField.isDefaultDateToday() ? new Date() : customField.getDefaultDateValue();
            }
            case DECIMAL: {
                return customField.getDefaultDecimalValue();
            }
            case INTEGER: {
                return customField.getDefaultIntegerValue();
            }
            case STRING: 
            case URL: {
                return customField.getDefaultStringValue();
            }
            case TEXT: {
                return customField.getDefaultTextValue();
            }
            case RICH_TEXT: {
                return customField.getDefaultRichTextValue();
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: {
                Set set = CollectionHelper.orEmpty((List)customField.getPossibleValues()).stream().filter(CustomFieldPossibleValue::isDefaultValue).collect(Collectors.toSet());
                if (customField.getType() == CustomFieldType.SINGLE_SELECTION) {
                    return CollectionHelper.first(set);
                }
                return set;
            }
            case DYNAMIC_SELECTION: 
            case LINKED_ENTITY: 
            case DYNAMIC_MULTI_SELECTION: 
            case FILE: 
            case IMAGE: {
                return null;
            }
        }
        throw new IllegalStateException("Unhandled field type for default value: " + String.valueOf(customField.getType()));
    }

    public Set<Path<?>> getProjectionPaths(CustomField<?, ?, ?> customField, QCustomFieldValue qCustomFieldValue) {
        HashSet hashSet = new HashSet();
        hashSet.add((Path<?>)qCustomFieldValue.id);
        hashSet.add((Path<?>)qCustomFieldValue.version);
        switch (customField.getType()) {
            case BOOLEAN: {
                hashSet.add((Path<?>)qCustomFieldValue.booleanValue);
                break;
            }
            case DATE: {
                hashSet.add((Path<?>)qCustomFieldValue.dateValue);
                break;
            }
            case DECIMAL: {
                hashSet.add((Path<?>)qCustomFieldValue.decimalValue);
                break;
            }
            case DYNAMIC_SELECTION: {
                hashSet.add((Path<?>)qCustomFieldValue.stringValue);
                hashSet.add((Path<?>)qCustomFieldValue.textValue);
                break;
            }
            case INTEGER: {
                hashSet.add((Path<?>)qCustomFieldValue.integerValue);
                break;
            }
            case LINKED_ENTITY: {
                hashSet.add((Path<?>)qCustomFieldValue.linkedEntityId);
                break;
            }
            case RICH_TEXT: {
                hashSet.add((Path<?>)qCustomFieldValue.richTextValue);
                break;
            }
            case STRING: 
            case URL: {
                hashSet.add((Path<?>)qCustomFieldValue.stringValue);
                break;
            }
            case TEXT: {
                hashSet.add((Path<?>)qCustomFieldValue.textValue);
                break;
            }
        }
        return hashSet;
    }

    public Object getValue(CustomField<?, ?, ?> customField, Object object, boolean bl) {
        return this.getValue(customField, object, bl, null);
    }

    public Object getValue(CustomField<?, ?, ?> customField, Object simpleEntity, boolean bl, FormatterImpl formatterImpl) {
        Object object;
        Object object2;
        CustomFieldType customFieldType = customField.getType();
        Map map = null;
        if (!customFieldType.hasMultipleValues()) {
            if (simpleEntity instanceof Iterable) {
                simpleEntity = CollectionHelper.first((Iterable)((Iterable)simpleEntity));
            } else if (simpleEntity instanceof Object[]) {
                object2 = (CustomFieldValue)simpleEntity;
                CustomFieldValue customFieldValue = simpleEntity = ((Object[])object2).length == 0 ? null : object2[0];
            }
        }
        if (simpleEntity instanceof CustomFieldValueDTO) {
            object2 = (CustomFieldValue)simpleEntity;
            object = object2.getReferenceValue();
            map = (Map)object2.getAttribute(ALLOWED_DYNA_VALUES);
            if (object != null) {
                simpleEntity = object;
            }
        }
        if (simpleEntity instanceof ICustomFieldValue) {
            if (simpleEntity instanceof CustomFieldValue) {
                object2 = (CustomFieldValue)simpleEntity;
                if (customField.getType() == CustomFieldType.FILE ? (object = object2.getRawFiles()) != null : customField.getType() == CustomFieldType.IMAGE && (object = object2.getRawImages()) != null) {
                    return object;
                }
            }
            simpleEntity = CustomFieldHelper.getCustomFieldValue((CustomFieldType)customFieldType, (ICustomFieldValue)((ICustomFieldValue)simpleEntity));
        }
        if (simpleEntity == null) {
            return null;
        }
        if (simpleEntity instanceof CharSequence || customFieldType.isString()) {
            return this.doResolveReference(customField, simpleEntity.toString(), true, bl, formatterImpl, null, map);
        }
        object2 = customField.getPossibleValueClass();
        switch (customFieldType) {
            case RICH_TEXT: 
            case STRING: 
            case URL: 
            case TEXT: {
                throw new IllegalStateException();
            }
            case BOOLEAN: {
                return simpleEntity instanceof Boolean ? simpleEntity : CoercionHelper.coerce(Boolean.TYPE, (Object)simpleEntity);
            }
            case INTEGER: {
                return simpleEntity instanceof Number ? Integer.valueOf(((Number)simpleEntity).intValue()) : CoercionHelper.coerce(Integer.class, (Object)simpleEntity);
            }
            case DECIMAL: {
                object = simpleEntity instanceof BigDecimal ? (BigDecimal)simpleEntity : (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)simpleEntity);
                return this.applyDecimalDigits(customField, (BigDecimal)object);
            }
            case DATE: {
                return simpleEntity instanceof Date ? simpleEntity : this.conversionHandler.convert(Date.class, (Object)simpleEntity);
            }
            case SINGLE_SELECTION: {
                return ((Class)object2).isInstance(simpleEntity) ? simpleEntity : this.toPossibleValue(customField, simpleEntity);
            }
            case MULTI_SELECTION: {
                TreeSet treeSet = new TreeSet(POSSIBLE_VALUES_COMPARATOR);
                Iterator iterator = IteratorUtils.getIterator((Object)simpleEntity);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    treeSet.add((CustomFieldPossibleValue<?, ?, ?>)(((Class)object2).isInstance(e) ? e : this.toPossibleValue(customField, e)));
                }
                return treeSet;
            }
            case DYNAMIC_SELECTION: {
                return this.toDynamicFieldValue(simpleEntity);
            }
            case DYNAMIC_MULTI_SELECTION: {
                return CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)simpleEntity)).map(this::toDynamicFieldValue).sorted().collect(Collectors.toSet());
            }
            case LINKED_ENTITY: {
                Class<? extends SimpleEntity> clazz = this.getEntityType(customField.getLinkedEntityType());
                return clazz.isInstance(simpleEntity) ? simpleEntity : this.toLinkedEntity(customField.getLinkedEntityType(), simpleEntity, true);
            }
            case FILE: {
                return this.getFileValues(customField, simpleEntity);
            }
            case IMAGE: {
                return this.getImageValues(customField, simpleEntity);
            }
        }
        throw new IllegalStateException("Unhandled custom field type: " + String.valueOf(customFieldType) + " when getting the value of " + String.valueOf(customField));
    }

    public Object getValueForSearch(CustomField<?, ?, ?> customField, Object object2, boolean bl) {
        Object object3;
        CustomFieldType customFieldType = customField.getType();
        if (object2 instanceof BaseValueForSearchDTO) {
            object3 = (BaseValueForSearchDTO)object2;
            object2 = ModelHelper.getFirstNonEmpty((Bean)object3, (Collection)SEARCH_PROPERTIES);
        }
        if (object2 == null) {
            return null;
        }
        switch (customFieldType) {
            case STRING: {
                if (bl && StringHelper.isNotBlank((Object)customField.getPattern())) {
                    return StringHelper.trimToNull((Object)MaskHelper.removeMask((String)customField.getPattern(), (String)object2.toString()));
                }
            }
            case RICH_TEXT: 
            case URL: 
            case TEXT: {
                return object2.toString();
            }
            case BOOLEAN: {
                return object2 instanceof Boolean ? object2 : CoercionHelper.coerce(Boolean.TYPE, (Object)object2);
            }
            case INTEGER: {
                object3 = null;
                Integer n = null;
                if (object2 instanceof IIntegerRange) {
                    IIntegerRange iIntegerRange = (IIntegerRange)object2;
                    object3 = (Integer)iIntegerRange.getMin();
                    n = (Integer)iIntegerRange.getMax();
                } else if (object2 instanceof Number) {
                    n = ((Number)object2).intValue();
                    object3 = n;
                } else {
                    String[] stringArray = object2.toString().split(VALUE_SEPARATOR_REGEX);
                    if (stringArray != null && stringArray.length > 0) {
                        object3 = (Integer)CoercionHelper.coerce(Integer.class, (Object)stringArray[0]);
                    }
                    if (stringArray != null && stringArray.length > 1) {
                        n = (Integer)CoercionHelper.coerce(Integer.class, (Object)stringArray[1]);
                    }
                }
                return object3 == null && n == null ? null : new IntegerRange((Integer)object3, n);
            }
            case DECIMAL: {
                object3 = null;
                BigDecimal bigDecimal = null;
                if (object2 instanceof IDecimalRange) {
                    IDecimalRange iDecimalRange = (IDecimalRange)object2;
                    object3 = (BigDecimal)iDecimalRange.getMin();
                    bigDecimal = (BigDecimal)iDecimalRange.getMax();
                } else if (object2 instanceof Number) {
                    bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)object2);
                    object3 = bigDecimal;
                } else {
                    String[] stringArray = object2.toString().split(VALUE_SEPARATOR_REGEX);
                    if (stringArray != null && stringArray.length > 0) {
                        object3 = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)stringArray[0]);
                    }
                    if (stringArray != null && stringArray.length > 1) {
                        bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)stringArray[1]);
                    }
                }
                return object3 == null && bigDecimal == null ? null : new DecimalRange(this.applyDecimalDigits(customField, (BigDecimal)object3), this.applyDecimalDigits(customField, bigDecimal));
            }
            case DATE: {
                object3 = null;
                DateWrapper dateWrapper = null;
                if (object2 instanceof IDatePeriod) {
                    IDatePeriod iDatePeriod = (IDatePeriod)object2;
                    object3 = iDatePeriod.getBegin();
                    dateWrapper = iDatePeriod.getEnd();
                } else if (object2 instanceof Date) {
                    dateWrapper = DateWrapper.instance((Date)((Date)object2));
                    object3 = dateWrapper;
                } else if (object2 instanceof IDate) {
                    dateWrapper = (IDate)object2;
                    object3 = dateWrapper;
                } else {
                    String[] stringArray = object2.toString().split(VALUE_SEPARATOR_REGEX);
                    if (stringArray != null && stringArray.length > 0) {
                        object3 = DateTime.parse((String)stringArray[0]);
                    }
                    if (stringArray != null && stringArray.length > 1) {
                        dateWrapper = DateTime.parse((String)stringArray[1]);
                    }
                }
                return object3 == null && dateWrapper == null ? null : new DatePeriod(this.conversionHandler.toDate((IDate)object3), this.conversionHandler.toDate((IDate)dateWrapper));
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: {
                if (object2 instanceof CharSequence) {
                    object2 = StringHelper.split((String)object2.toString(), (String)CustomFieldHelper.VALUE_SEPARATOR);
                }
                return (object3 = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object2)).map(object -> bl ? this.toPossibleValue(customField, object).getId() : this.toPossibleValue(customField, object)).collect(Collectors.toSet())).isEmpty() ? null : object3;
            }
            case DYNAMIC_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                Object object4;
                if (object2 instanceof CharSequence) {
                    if (!(object2 = object2.toString()).equals(object4 = ModelHelper.locatorText((String)((String)object2)))) {
                        return StringHelper.trimToNull((Object)object4);
                    }
                    object2 = StringHelper.splitTrimming((String)((String)object2), (String)CustomFieldHelper.VALUE_SEPARATOR);
                }
                return (object4 = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object2)).map(object -> {
                    if (object instanceof DynamicFieldValueVO) {
                        DynamicFieldValueVO dynamicFieldValueVO = (DynamicFieldValueVO)object;
                        return bl ? dynamicFieldValueVO.getValue() : dynamicFieldValueVO.getLabel();
                    }
                    if (object instanceof Map) {
                        return ((Map)object).get(bl ? DynamicFieldValueVO.VALUE.getName() : DynamicFieldValueVO.LABEL.getName());
                    }
                    return StringHelper.trimToNull((Object)object);
                }).filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty() ? null : object4;
            }
            case LINKED_ENTITY: {
                Set set;
                if (object2 instanceof CharSequence) {
                    object2 = object2.toString();
                    object2 = StringHelper.splitTrimming((String)((String)object2), (String)CustomFieldHelper.VALUE_SEPARATOR);
                }
                return (set = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object2)).map(object -> bl ? this.toLinkedEntity(customField.getLinkedEntityType(), object, true).getId() : this.toLinkedEntity(customField.getLinkedEntityType(), object, true)).collect(Collectors.toSet())).isEmpty() ? null : set;
            }
            case FILE: 
            case IMAGE: {
                return null;
            }
        }
        throw new IllegalStateException("Unhandled custom field type: " + String.valueOf(customFieldType) + " when getting the value of " + String.valueOf(customField));
    }

    public Class<?> getValueType(CustomField<?, ?, ?> customField) {
        switch (customField.getType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case DATE: {
                return Date.class;
            }
            case DYNAMIC_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                return DynamicFieldValue.class;
            }
            case FILE: {
                return RawFile.class;
            }
            case IMAGE: {
                return Image.class;
            }
            case LINKED_ENTITY: {
                return this.getEntityType(customField.getLinkedEntityType());
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: {
                return CustomFieldPossibleValue.class;
            }
            case RICH_TEXT: 
            case STRING: 
            case URL: 
            case TEXT: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled field type: " + String.valueOf(customField.getType()));
    }

    public void processAfterSave(EntityWithCustomValues<?, ?, ?, ?> entityWithCustomValues) {
        CollectionHelper.orEmpty((Collection)entityWithCustomValues.getCustomValues()).stream().filter(customFieldValue -> !customFieldValue.isSkipRawData()).forEach(this::processAfterSave);
    }

    public Predicate queryFilter(EntityPath<? extends CustomFieldValue<?, ?, ?, ?>> entityPath, CustomField<?, ?, ?> customField, CustomFieldValueForSearchDTO customFieldValueForSearchDTO) {
        QCustomFieldValue qCustomFieldValue = (QCustomFieldValue)FieldHelper.get(entityPath, (String)"_super");
        Object object = this.getValueForSearch(customField, customFieldValueForSearchDTO, true);
        if (object == null) {
            return null;
        }
        switch (customField.getType()) {
            case BOOLEAN: {
                return qCustomFieldValue.booleanValue.eq((Boolean)object);
            }
            case DATE: {
                return qCustomFieldValue.dateValue.period((DatePeriod)object);
            }
            case DECIMAL: {
                return qCustomFieldValue.decimalValue.range((DecimalRange)object);
            }
            case INTEGER: {
                return qCustomFieldValue.integerValue.range((IntegerRange)object);
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: {
                Set set = (Set)object;
                Set set2 = CollectionHelper.orEmpty((List)customField.getPossibleValues()).stream().filter(customFieldPossibleValue -> set.contains(customFieldPossibleValue.getId())).collect(Collectors.toSet());
                if (customField.getType() == CustomFieldType.MULTI_SELECTION) {
                    SetPath setPath = (SetPath)FieldHelper.get(entityPath, (String)PropertyHelper.getPropertyName((Path)QUserCustomFieldValue.userCustomFieldValue.enumeratedValues));
                    BooleanBuilder booleanBuilder = new BooleanBuilder();
                    for (CustomFieldPossibleValue customFieldPossibleValue2 : set2) {
                        booleanBuilder.or((Predicate)setPath.contains((Object)customFieldPossibleValue2));
                    }
                    return booleanBuilder;
                }
                EntityPathBase entityPathBase = (EntityPathBase)MethodHelper.invoke(entityPath, (String)PropertyHelper.getPropertyName((Path)QUserCustomFieldValue.userCustomFieldValue.enumeratedValue()), (Object[])new Object[0]);
                return entityPathBase.in(set2);
            }
            case STRING: {
                if (customField.getValueMatch() == ValueMatch.EXACT) {
                    return qCustomFieldValue.stringValue.equalsIgnoreCase((String)object);
                }
                return qCustomFieldValue.stringValue.containsIgnoreCase((String)object);
            }
            case URL: {
                return qCustomFieldValue.stringValue.containsIgnoreCase((String)object);
            }
            case TEXT: {
                return qCustomFieldValue.textValue.containsIgnoreCase((String)object);
            }
            case RICH_TEXT: {
                return qCustomFieldValue.richTextValue.containsIgnoreCase((String)object);
            }
            case DYNAMIC_SELECTION: {
                if (object instanceof Collection) {
                    return qCustomFieldValue.stringValue.toLowerCase().in((Collection)object);
                }
                return qCustomFieldValue.textValue.containsIgnoreCase((String)object);
            }
            case DYNAMIC_MULTI_SELECTION: {
                if (object instanceof Collection) {
                    Set set = ((Collection)object).stream().map(StringHelper::trimToNull).filter(Objects::nonNull).map(String::toLowerCase).collect(Collectors.toSet());
                    SetPath setPath = (SetPath)FieldHelper.get(entityPath, (String)PropertyHelper.getPropertyName((Path)QUserCustomFieldValue.userCustomFieldValue.dynamicValues));
                    return ((QDynamicFieldValue)setPath.any()).value.toLowerCase().in(set);
                }
                return qCustomFieldValue.textValue.containsIgnoreCase((String)object);
            }
            case LINKED_ENTITY: {
                Collection collection = (Collection)object;
                return qCustomFieldValue.linkedEntityId.in(collection);
            }
            case FILE: 
            case IMAGE: {
                return null;
            }
        }
        throw new IllegalStateException("Unhandled custom field type: " + String.valueOf(customField.getType()));
    }

    public void remove(CustomFieldValue<?, ?, ?, ?> customFieldValue) {
        this.doRemove(customFieldValue, true);
    }

    public void removeAll(EntityWithCustomValues<?, ?, ?, ?> entityWithCustomValues) {
        for (CustomFieldValue customFieldValue : CollectionHelper.orEmpty((Collection)entityWithCustomValues.getCustomValues())) {
            this.remove(customFieldValue);
        }
    }

    public Set<CustomFieldValueForSearchDTO> resolveDefaultSearchValues(Collection<CustomFieldDetailedVO> collection) {
        HashSet<CustomFieldValueForSearchDTO> hashSet = new HashSet<CustomFieldValueForSearchDTO>();
        CollectionHelper.orEmpty(collection).forEach(customFieldDetailedVO -> {
            Set set;
            if (customFieldDetailedVO.getType().isEnumerated() && CollectionHelper.isNotEmpty(set = customFieldDetailedVO.getPossibleValues().stream().filter(CustomFieldPossibleValueVO::isDefaultOnSearch).collect(Collectors.toSet()))) {
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO = new CustomFieldValueForSearchDTO();
                customFieldValueForSearchDTO.setField((CustomFieldVO)customFieldDetailedVO);
                customFieldValueForSearchDTO.setEnumeratedValues(set);
                hashSet.add(customFieldValueForSearchDTO);
            }
        });
        return hashSet;
    }

    public Object resolveReference(CustomField<?, ?, ?> customField, String string, boolean bl, boolean bl2, FormatterImpl formatterImpl, String string2) {
        return this.doResolveReference(customField, string, bl, bl2, formatterImpl, string2, null);
    }

    public <DTO extends CustomFieldValueDTO> List<DTO> resolveValues(Class<? extends CustomField<?, ?, ?>> clazz, Collection<DTO> collection) {
        if (collection == null) {
            return null;
        }
        TreeMap<CustomField, CustomFieldValueDTO> treeMap = new TreeMap<CustomField, CustomFieldValueDTO>();
        for (CustomFieldValueDTO customFieldValueDTO : collection) {
            CustomField customField;
            try {
                customField = (CustomField)this.conversionHandler.convert(clazz, (Object)customFieldValueDTO.getField());
            }
            catch (EntityNotFoundException entityNotFoundException) {
                String string;
                if (clazz.getSimpleName().equals(entityNotFoundException.getEntityType()) && StringHelper.isNotBlank((Object)(string = customFieldValueDTO.getField().getInternalName()))) {
                    entityNotFoundException.setId(null);
                    entityNotFoundException.setKey(string);
                }
                throw entityNotFoundException;
            }
            Object object = this.getValue(customField, customFieldValueDTO, false);
            this.setModelValue((CustomField<?, ?, ?>)customField, object, (ICustomFieldValue<?, ?, ?, ?>)customFieldValueDTO);
            treeMap.put(customField, customFieldValueDTO);
        }
        return new ArrayList(treeMap.values());
    }

    public void setCustomValues(BasicUser basicUser, Collection<UserCustomField> collection, Collection<UserCustomField> collection2, Collection<UserCustomField> collection3, Collection<UserCustomFieldValueDTO> collection4) {
        this.doSetCustomValues(basicUser, collection, collection2, collection3, collection4);
    }

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> void setCustomValues(E e, Collection<CF> collection, Collection<CF> collection2, Collection<CustomFieldValueDTO> collection3) {
        this.doSetCustomValues(e, collection, collection2, null, collection3);
    }

    public void setDefaultValue(CustomFieldDetailedVO customFieldDetailedVO, Object object2) {
        switch (customFieldDetailedVO.getType()) {
            case STRING: 
            case URL: {
                customFieldDetailedVO.setDefaultStringValue(object2 == null ? null : object2.toString());
                break;
            }
            case TEXT: {
                customFieldDetailedVO.setDefaultTextValue(object2 == null ? null : object2.toString());
                break;
            }
            case RICH_TEXT: {
                customFieldDetailedVO.setDefaultRichTextValue(object2 == null ? null : object2.toString());
                break;
            }
            case BOOLEAN: {
                customFieldDetailedVO.setDefaultBooleanValue(Boolean.valueOf(Boolean.TRUE.equals(object2)));
                break;
            }
            case DATE: {
                customFieldDetailedVO.setDefaultDateValue((DateTime)this.conversionHandler.convert(DateTime.class, object2));
                break;
            }
            case DECIMAL: {
                customFieldDetailedVO.setDefaultDecimalValue((BigDecimal)this.conversionHandler.convert(BigDecimal.class, object2));
                break;
            }
            case INTEGER: {
                customFieldDetailedVO.setDefaultIntegerValue((Integer)this.conversionHandler.convert(Integer.class, object2));
                break;
            }
            case SINGLE_SELECTION: {
                for (CustomFieldPossibleValueVO customFieldPossibleValueVO : CollectionHelper.orEmpty((List)customFieldDetailedVO.getPossibleValues())) {
                    boolean bl = this.isSamePossibleValue(customFieldPossibleValueVO, object2);
                    customFieldPossibleValueVO.setDefaultValue(bl);
                }
                break;
            }
            case MULTI_SELECTION: {
                for (CustomFieldPossibleValueVO customFieldPossibleValueVO : CollectionHelper.orEmpty((List)customFieldDetailedVO.getPossibleValues())) {
                    boolean bl = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object2)).anyMatch(object -> this.isSamePossibleValue(customFieldPossibleValueVO, object));
                    customFieldPossibleValueVO.setDefaultValue(bl);
                }
                break;
            }
            case DYNAMIC_SELECTION: {
                for (DynamicFieldValueVO dynamicFieldValueVO : CollectionHelper.orEmpty((List)customFieldDetailedVO.getDynamicValues())) {
                    dynamicFieldValueVO.setDefaultValue(object2 != null && object2.equals(dynamicFieldValueVO.getValue()));
                }
                break;
            }
            case DYNAMIC_MULTI_SELECTION: {
                for (DynamicFieldValueVO dynamicFieldValueVO : CollectionHelper.orEmpty((List)customFieldDetailedVO.getDynamicValues())) {
                    boolean bl = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object2)).anyMatch(object -> this.isSameDynamicValue((IDynamicFieldValue)dynamicFieldValueVO, object));
                    dynamicFieldValueVO.setDefaultValue(bl);
                }
                break;
            }
            case LINKED_ENTITY: {
                User user;
                if (customFieldDetailedVO.getLinkedEntityType() != LinkedEntityType.USER) break;
                if (object2 instanceof BasicUser) {
                    user = ((BasicUser)object2).getUser();
                } else {
                    UserVO userVO = object2 instanceof Number ? new UserVO(Long.valueOf(((Number)object2).longValue())) : (object2 instanceof CharSequence ? (UserVO)ModelHelper.voFromString(UserVO.class, (String)object2.toString()) : (UserVO)this.conversionHandler.convert(UserVO.class, object2));
                    user = (User)this.conversionHandler.convert(User.class, (Object)userVO);
                }
                customFieldDetailedVO.setDefaultUserValue((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
                break;
            }
        }
    }

    public <DTO extends CustomFieldValueDTO> void setDefaultValues(List<? extends CustomFieldDetailedVO> list, ModelWithCustomValues<DTO> modelWithCustomValues, Function<CustomFieldDetailedVO, DTO> function) {
        Map<ICustomField, CustomFieldValueDTO> map = CollectionHelper.orEmpty((List)modelWithCustomValues.getCustomValues()).stream().collect(Collectors.toMap(ICustomFieldValue::getField, customFieldValueDTO -> customFieldValueDTO));
        List list2 = list.stream().map(customFieldDetailedVO -> (CustomFieldValueDTO)ObjectHelper.defaultValue((Object)((CustomFieldValueDTO)map.get(customFieldDetailedVO)), () -> (CustomFieldValueDTO)CustomFieldHelper.setCustomFieldValue((ICustomFieldValue)((CustomFieldValueDTO)function.apply((CustomFieldDetailedVO)customFieldDetailedVO)), (Object)this.getDefaultValue((CustomFieldDetailedVO)customFieldDetailedVO)))).collect(Collectors.toList());
        modelWithCustomValues.setCustomValues(list2);
    }

    public <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, O>, O extends SimpleEntity> void setDefaultValues(O o, Collection<CF> collection) {
        Collection collection2 = ((EntityWithCustomValues)o).getCustomValues();
        for (CustomField customField : collection) {
            if (CustomFieldHelper.findValue((ICustomField)customField, (Collection)collection2) != null) continue;
            Object object = this.getDefaultValue(customField);
            V v = this.instantiateValue(customField, o);
            this.setCustomFieldValue((CustomFieldValue)v, object, true);
            if (customField instanceof UserCustomField) {
                UserCustomField userCustomField = (UserCustomField)customField;
                UserCustomFieldValue userCustomFieldValue = (UserCustomFieldValue)UserCustomFieldValue.class.cast(v);
                userCustomFieldValue.setHidden(userCustomField.getDefaultVisibility() == FieldVisibility.HIDDEN);
            }
            collection2.add(v);
        }
    }

    public void setModelValue(CustomField<?, ?, ?> customField, Object object, ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue) {
        if (iCustomFieldValue instanceof CustomFieldValueVO) {
            ((CustomFieldValueVO)iCustomFieldValue).setField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, customField));
        } else if (iCustomFieldValue instanceof CustomFieldValueDTO) {
            ((CustomFieldValueDTO)iCustomFieldValue).setField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, customField));
        } else {
            throw new IllegalStateException("Unhandled ICustomFieldValue implementation: " + String.valueOf(iCustomFieldValue.getClass()));
        }
        CustomFieldType customFieldType = customField.getType();
        switch (customFieldType) {
            case STRING: 
            case URL: {
                if (StringHelper.isNotBlank((Object)customField.getPattern())) {
                    object = this.applyAndValidateMask(customField.getPattern(), StringHelper.trimToNull((Object)object), false);
                }
                iCustomFieldValue.setStringValue(StringHelper.trimToNull((Object)object));
                break;
            }
            case TEXT: {
                iCustomFieldValue.setTextValue(StringHelper.trimToNull((Object)object));
                break;
            }
            case RICH_TEXT: {
                iCustomFieldValue.setRichTextValue(this.richTextHandler.replaceTagsByUrls(StringHelper.trimToNull((Object)object)));
                break;
            }
            case BOOLEAN: {
                iCustomFieldValue.setBooleanValue(Boolean.valueOf(Boolean.TRUE.equals(object)));
                break;
            }
            case DATE: {
                iCustomFieldValue.setDateValue((IDate)this.conversionHandler.convert(DateTime.class, object));
                break;
            }
            case DECIMAL: {
                iCustomFieldValue.setDecimalValue((BigDecimal)object);
                break;
            }
            case INTEGER: {
                iCustomFieldValue.setIntegerValue((Integer)object);
                break;
            }
            case DYNAMIC_SELECTION: {
                IDynamicFieldValue iDynamicFieldValue = (IDynamicFieldValue)object;
                iCustomFieldValue.setStringValue(iDynamicFieldValue == null ? null : iDynamicFieldValue.getValue());
                iCustomFieldValue.setTextValue(iDynamicFieldValue == null ? null : iDynamicFieldValue.getLabel());
                break;
            }
            case DYNAMIC_MULTI_SELECTION: {
                Stream stream = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object)).sorted().map(this.conversionHandler.convertingFunction(DynamicFieldValueVO.class, new Object[0]));
                if (iCustomFieldValue instanceof CustomFieldValueDTO) {
                    ((CustomFieldValueDTO)iCustomFieldValue).setDynamicValues(stream.collect(Collectors.toList()));
                    break;
                }
                if (!(iCustomFieldValue instanceof CustomFieldValueVO)) break;
                ((CustomFieldValueVO)iCustomFieldValue).setDynamicValues(stream.collect(Collectors.toList()));
                break;
            }
            case LINKED_ENTITY: {
                iCustomFieldValue.setLinkedEntityValue(object instanceof LinkedEntityVO ? (LinkedEntityVO)object : this.toLinkedEntityVO(customField.getLinkedEntityType(), (SimpleEntity)object));
                break;
            }
            case SINGLE_SELECTION: {
                CustomFieldPossibleValueVO customFieldPossibleValueVO = (CustomFieldPossibleValueVO)this.conversionHandler.convert(CustomFieldPossibleValueVO.class, object);
                if (iCustomFieldValue instanceof CustomFieldValueDTO) {
                    ((CustomFieldValueDTO)iCustomFieldValue).setEnumeratedValue(customFieldPossibleValueVO);
                    break;
                }
                if (!(iCustomFieldValue instanceof CustomFieldValueVO)) break;
                ((CustomFieldValueVO)iCustomFieldValue).setEnumeratedValue(customFieldPossibleValueVO);
                break;
            }
            case MULTI_SELECTION: {
                Stream stream = CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object)).sorted().map(this.conversionHandler.convertingFunction(CustomFieldPossibleValueVO.class, new Object[0]));
                if (iCustomFieldValue instanceof CustomFieldValueDTO) {
                    ((CustomFieldValueDTO)iCustomFieldValue).setEnumeratedValues(stream.collect(Collectors.toList()));
                    break;
                }
                if (!(iCustomFieldValue instanceof CustomFieldValueVO)) break;
                ((CustomFieldValueVO)iCustomFieldValue).setEnumeratedValues(stream.collect(Collectors.toList()));
                break;
            }
            case FILE: {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                List list = CollectionHelper.asStream((Iterator)iterator).map(this.conversionHandler.convertingFunction(RawFileVO.class, new Object[0])).collect(Collectors.toList());
                if (iCustomFieldValue instanceof CustomFieldValueDTO) {
                    ((CustomFieldValueDTO)iCustomFieldValue).setFileValues(list);
                    break;
                }
                if (!(iCustomFieldValue instanceof CustomFieldValueVO)) break;
                ((CustomFieldValueVO)iCustomFieldValue).setFileValues(list);
                break;
            }
            case IMAGE: {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                List list = CollectionHelper.asStream((Iterator)iterator).map(this.conversionHandler.convertingFunction(ImageVO.class, new Object[0])).collect(Collectors.toList());
                if (iCustomFieldValue instanceof CustomFieldValueDTO) {
                    ((CustomFieldValueDTO)iCustomFieldValue).setImageValues(list);
                    break;
                }
                if (!(iCustomFieldValue instanceof CustomFieldValueVO)) break;
                ((CustomFieldValueVO)iCustomFieldValue).setImageValues(list);
            }
        }
        if (iCustomFieldValue instanceof CustomFieldValueDTO) {
            ((CustomFieldValueDTO)iCustomFieldValue).setReferenceValue(null);
        }
    }

    public void sortAndRemoveMissing(List<? extends CustomFieldValueDTO> list, List<? extends IEntity> list2) {
        this.doSortAndRemoveMissingFromVO(list, list2, customFieldValueDTO -> customFieldValueDTO.getField().getId());
    }

    public void sortAndRemoveMissingFromVO(List<? extends CustomFieldValueVO> list, List<? extends IEntity> list2) {
        this.doSortAndRemoveMissingFromVO(list, list2, customFieldValueVO -> customFieldValueVO.getField().getId());
    }

    public List<? extends CustomFieldPossibleValue<?, ?, ?>> toCustomFieldPossibleValues(CustomField<?, ?, ?> customField, Collection<?> collection) {
        if (!customField.getType().isEnumerated()) {
            return Collections.emptyList();
        }
        return CollectionHelper.orEmpty(collection).stream().map(object -> this.toCustomFieldPossibleValue(customField, object)).collect(Collectors.toList());
    }

    public List<SimpleEntity> toLinkedEntityValues(CustomField<?, ?, ?> customField, Collection<?> collection) {
        LinkedEntityType linkedEntityType = customField.getLinkedEntityType();
        if (linkedEntityType == null || collection == null) {
            return Collections.emptyList();
        }
        return collection.stream().map(object -> this.toLinkedEntity(linkedEntityType, object, true)).collect(Collectors.toList());
    }

    public String toReference(CustomField<?, ?, ?> customField, Object object) {
        if (object == null || "".equals(object)) {
            return null;
        }
        CustomFieldValueVO customFieldValueVO = new CustomFieldValueVO();
        customFieldValueVO.setField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, customField));
        switch (customField.getType()) {
            case BOOLEAN: {
                return String.valueOf(Boolean.TRUE.equals(object) || Boolean.parseBoolean(StringHelper.trimToNull((Object)object)));
            }
            case DATE: {
                return StringHelper.trimToNull((Object)this.conversionHandler.convert(DateTime.class, object));
            }
            case DECIMAL: {
                return StringHelper.trimToNull((Object)this.conversionHandler.convert(BigDecimal.class, object));
            }
            case INTEGER: {
                return StringHelper.trimToNull((Object)this.conversionHandler.convert(Integer.class, object));
            }
            case RICH_TEXT: 
            case STRING: 
            case URL: 
            case TEXT: {
                return StringHelper.trimToNull((Object)object);
            }
            case DYNAMIC_SELECTION: {
                DynamicFieldValue dynamicFieldValue = (DynamicFieldValue)this.conversionHandler.convert(DynamicFieldValue.class, object);
                if (dynamicFieldValue.getLabel() == null) {
                    return dynamicFieldValue.getValue();
                }
                return dynamicFieldValue.getValue() + CustomFieldHelper.VALUE_SEPARATOR + dynamicFieldValue.getLabel();
            }
            case DYNAMIC_MULTI_SELECTION: {
                FormatterImpl formatterImpl = this.getFormatter();
                return CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object)).map(this.conversionHandler.convertingFunction(DynamicFieldValueVO.class, new Object[0])).map(arg_0 -> ((FormatterImpl)formatterImpl).format(arg_0)).collect(Collectors.joining(CustomFieldHelper.VALUE_SEPARATOR));
            }
            case LINKED_ENTITY: {
                return this.internalNameOrIdAsReference(object);
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: 
            case FILE: 
            case IMAGE: {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                return CollectionHelper.asStream((Iterator)iterator).map(this::internalNameOrIdAsReference).filter(Objects::nonNull).collect(Collectors.joining(CustomFieldHelper.VALUE_SEPARATOR));
            }
        }
        return null;
    }

    public <CF extends CustomField<CF, ?, ?>> SortedMap<CF, Object> toSearchFiltersMap(Collection<CF> collection, Collection<? extends CustomFieldValueForSearchDTO> collection2, boolean bl) {
        TreeMap treeMap = new TreeMap();
        if (collection2 != null) {
            for (CustomFieldValueForSearchDTO customFieldValueForSearchDTO : collection2) {
                CustomFieldVO customFieldVO = customFieldValueForSearchDTO.getField();
                Optional<Object> optional = Optional.empty();
                if (customFieldVO.getId() != null) {
                    optional = collection.stream().filter(arg_0 -> CustomFieldValueHandlerImpl.lambda$toSearchFiltersMap$23((ICustomField)customFieldVO, arg_0)).findAny();
                } else {
                    String string = ModelHelper.unqualifyInternalName((IInternalNamedEntity)customFieldVO);
                    if (StringHelper.isNotBlank((Object)string)) {
                        optional = collection.stream().filter(customField -> string.equals(customField.getInternalName())).findAny();
                    }
                }
                optional.ifPresent(customField -> {
                    Object object = this.getValueForSearch((CustomField<?, ?, ?>)customField, customFieldValueForSearchDTO, bl);
                    if (ObjectHelper.isNotEmpty((Object)object)) {
                        treeMap.put(customField, object);
                    }
                });
            }
        }
        return treeMap;
    }

    public <CF extends CustomField<CF, ?, ?>> SortedMap<CF, Object> toValuesMap(Collection<CF> collection, Collection<? extends ICustomFieldValue<?, ?, ?, ?>> collection2, boolean bl) {
        TreeMap treeMap = new TreeMap();
        if (collection2 != null) {
            for (ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue : collection2) {
                ICustomField iCustomField = iCustomFieldValue.getField();
                Optional<Object> optional = Optional.empty();
                if (iCustomField.getId() != null) {
                    optional = collection.stream().filter(customField -> customField.getId().equals(iCustomField.getId())).findAny();
                } else {
                    String string = ModelHelper.unqualifyInternalName((IInternalNamedEntity)iCustomField);
                    if (StringHelper.isNotBlank((Object)string)) {
                        optional = collection.stream().filter(customField -> string.equals(customField.getInternalName())).findAny();
                    }
                }
                optional.ifPresent(customField -> {
                    Object object = this.getValue((CustomField<?, ?, ?>)customField, iCustomFieldValue, bl);
                    if (ObjectHelper.isNotEmpty((Object)object)) {
                        treeMap.put(customField, object);
                    }
                });
            }
        }
        return treeMap;
    }

    private String applyAndValidateMask(String string, String string2, boolean bl) {
        try {
            return MaskHelper.applyAndValidateMask((String)string, (String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                throw new CoercionException(string2);
            }
            return string2;
        }
    }

    private BigDecimal applyDecimalDigits(CustomField<?, ?, ?> customField, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        int n = (Integer)ObjectHelper.defaultValue((Object)customField.getDecimalDigits(), (Object)2);
        return BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n);
    }

    private <F extends ICustomFieldValueStoredFile> F checkOwner(CustomFieldValue customFieldValue, F f) {
        if (f.getCustomFieldValue() != null && !customFieldValue.equals((Object)f.getCustomFieldValue())) {
            ValidationResult validationResult = new ValidationResult();
            Long l = this.applicationHandler.getIdMask().apply(f.getId());
            String string = this.message(GeneralKeys.Errors.FILE_ALREADY_IN_USE, l);
            validationResult.addCustomFieldError(customFieldValue.getField().getInternalName(), string);
            throw new ValidationException(validationResult);
        }
        return f;
    }

    private void checkType(Collection<? extends StoredFile> collection, Class<? extends StoredFile> ... classArray) {
        for (StoredFile storedFile : CollectionHelper.orEmpty(collection)) {
            if (Stream.of(classArray).anyMatch(clazz -> clazz.isInstance(storedFile))) continue;
            throw new EntityNotFoundException(classArray[0], storedFile.getId());
        }
    }

    private Property doAddValueValidation(Validator validator, CustomField<?, ?, ?> customField, EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase, Map<String, ?> map, LoadValuesScriptFunction loadValuesScriptFunction, Object object4, boolean bl) {
        if (loadValuesScriptFunction == null) {
            loadValuesScriptFunction = LoadValuesScriptFunction.ENTITY;
        }
        Property property = object4 == null ? validator.customField(customField, this.customFieldValueHandler) : validator.customField(customField, object4, this.customFieldValueHandler);
        if (customField.isRequired() && !bl) {
            property.required();
        }
        switch (customField.getType()) {
            case INTEGER: {
                property.between((Range)customField.getIntegerValueRange());
                break;
            }
            case DECIMAL: {
                DecimalRange decimalRange = customField.getDecimalValueRange();
                if (decimalRange == null) break;
                BigDecimalFormattable bigDecimalFormattable = decimalRange.getMin() == null ? null : new BigDecimalFormattable(decimalRange.getMin(), customField.getDecimalDigits());
                BigDecimalFormattable bigDecimalFormattable2 = decimalRange.getMax() == null ? null : new BigDecimalFormattable(decimalRange.getMax(), customField.getDecimalDigits());
                property.between((Comparable)bigDecimalFormattable, (Comparable)bigDecimalFormattable2);
                break;
            }
            case URL: {
                property.url().maxLength(1000);
                break;
            }
            case DATE: {
                property.date();
                break;
            }
            case DYNAMIC_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                property.add((PropertyValidation)new DynamicValueValidation(map, loadValuesScriptFunction, (CustomFieldPropertyAccess)property.getAccess()));
                break;
            }
            case LINKED_ENTITY: {
                Class clazz = LinkedEntityTypeMapping.getEntityType((LinkedEntityType)customField.getLinkedEntityType());
                property.entity(clazz, (object, object2, simpleEntity) -> {
                    if (customField.getLinkedEntityRecordType() != null && !customField.getLinkedEntityRecordType().equals((Object)((Record)simpleEntity).getType())) {
                        return new ValidationError(GeneralKeys.Errors.INVALID_LINKED_RECORD_TYPE, new Object[]{customField.getLinkedEntityRecordType()});
                    }
                    return null;
                });
                break;
            }
            case FILE: 
            case IMAGE: {
                Integer n = customField.getMaxFiles();
                if (n != null && n > 0) {
                    property.maxElements(n.intValue());
                }
                if (customField.getType() != CustomFieldType.FILE) break;
                Set set = customField.getAllowedMimeTypes();
                List list = StringHelper.splitTrimming((String)customField.getOtherMimeTypes(), (String)"\n");
                Set set2 = ModelHelper.getAllowedMimeTypes((Collection)set, (Collection)list);
                PropertyValidation propertyValidation = (object, object2, object3) -> {
                    Iterator iterator = IteratorUtils.getIterator((Object)object3);
                    while (iterator.hasNext()) {
                        IEntity iEntity = (IEntity)iterator.next();
                        try {
                            TempFile tempFile = this.find(TempFile.class, iEntity.getId());
                            if (set2.contains(tempFile.getContentType())) continue;
                            List list2 = ModelHelper.getFriendlyMimeTypes((Collection)set, (Collection)list, (MessageProducer)this.translationHandler);
                            return new ValidationError(GeneralKeys.Errors.INVALID_FILE, new Object[]{StringHelper.join((Collection)list2, (String)", ")});
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                        }
                    }
                    return null;
                };
                property.add(propertyValidation);
                break;
            }
        }
        if (customField.getLoadValuesScript() != null && !customField.getType().isDynamic()) {
            property.add((PropertyValidation)new ValueAllowedByScriptValidation(map, loadValuesScriptFunction));
        }
        if (customField.isUnique() && entityPathBase != null) {
            property.add((PropertyValidation)new UniqueValidation(entityPathBase));
        }
        this.addLengthValidation(property, customField.getLengthConstraint());
        this.addPatternValidation(property, customField.getPattern());
        this.addWordSizeValidation(property, customField);
        if (customField.getValidationScript() != null) {
            property.add((PropertyValidation)new CustomScriptValidation());
        }
        return property;
    }

    private void doRemove(CustomFieldValue<?, ?, ?, ?> customFieldValue, boolean bl) {
        List list = customFieldValue.getStoredFiles();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            list.stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
            list.clear();
        }
        this.getBaseEntityManagerHandler().remove(customFieldValue);
    }

    private Object doResolveReference(CustomField<?, ?, ?> customField, String string2, boolean bl, boolean bl2, FormatterImpl formatterImpl, String string3, Map<String, ?> map) {
        CustomFieldType customFieldType = customField.getType();
        String string4 = StringHelper.trimToNull((Object)string2);
        if (string4 == null) {
            if (customFieldType == CustomFieldType.BOOLEAN) {
                return false;
            }
            return null;
        }
        if (string3 == null) {
            string3 = formatterImpl == null ? CustomFieldHelper.VALUE_SEPARATOR : ",";
        }
        switch (customFieldType) {
            case STRING: 
            case URL: 
            case TEXT: {
                if (StringHelper.isNotBlank((Object)customField.getPattern())) {
                    return this.applyAndValidateMask(customField.getPattern(), string4, bl2);
                }
                if (!bl2 || customField.isIgnoreSanitizer()) {
                    return string4;
                }
                return this.richTextHandler.escapeTags(string4);
            }
            case RICH_TEXT: {
                if (bl2) {
                    if (customField.isIgnoreSanitizer()) {
                        return this.richTextHandler.replaceUrlsByTags(string4);
                    }
                    return this.richTextHandler.sanitize(string4);
                }
                return string4;
            }
            case BOOLEAN: {
                return CoercionHelper.coerce(Boolean.class, (Object)string4);
            }
            case DATE: {
                if (formatterImpl != null) {
                    try {
                        return formatterImpl.parseTimestamp(string4);
                    }
                    catch (CoercionException coercionException) {
                        try {
                            return formatterImpl.parseDate(string4);
                        }
                        catch (CoercionException coercionException2) {
                            // empty catch block
                        }
                    }
                }
                return this.conversionHandler.convert(Date.class, (Object)string4);
            }
            case DECIMAL: {
                if (formatterImpl != null) {
                    try {
                        return formatterImpl.parseDecimal(string4, customField.getDecimalDigits().intValue());
                    }
                    catch (CoercionException coercionException) {
                        // empty catch block
                    }
                }
                return this.applyDecimalDigits(customField, (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)string4));
            }
            case INTEGER: {
                if (formatterImpl != null) {
                    try {
                        formatterImpl.parseDecimal(string4, 0).intValue();
                    }
                    catch (CoercionException coercionException) {
                        // empty catch block
                    }
                }
                return CoercionHelper.coerce(Integer.class, (Object)string4);
            }
            case DYNAMIC_SELECTION: 
            case DYNAMIC_MULTI_SELECTION: {
                if (map == null) {
                    if (customFieldType == CustomFieldType.DYNAMIC_SELECTION) {
                        String string5 = StringUtils.substringBefore((String)string4, (String)string3);
                        String string6 = StringUtils.substringAfter((String)string4, (String)string3);
                        if (string6.isEmpty()) {
                            string6 = string5;
                        }
                        return new DynamicFieldValue(string5, string6);
                    }
                    return StringHelper.splitTrimming((String)string4, (String)string3).stream().map(string -> new DynamicFieldValue(string, string)).collect(Collectors.toSet());
                }
                if (customFieldType == CustomFieldType.DYNAMIC_SELECTION) {
                    return map.get(StringUtils.substringBefore((String)string4, (String)string3));
                }
                return StringHelper.splitTrimming((String)string4, (String)string3).stream().map(string -> map.get(string)).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            case LINKED_ENTITY: {
                return this.toLinkedEntity(customField.getLinkedEntityType(), string4, bl);
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: {
                Set set = StringHelper.splitTrimming((String)string4, (String)string3).stream().map(string -> {
                    Optional<CustomFieldPossibleValue> optional;
                    if (string == null) {
                        return null;
                    }
                    List list = customField.getPossibleValues();
                    if (formatterImpl != null && (optional = list.stream().filter(customFieldPossibleValue -> customFieldPossibleValue.getValue().equalsIgnoreCase((String)string)).findFirst()).isPresent()) {
                        return optional.get();
                    }
                    optional = list.stream().filter(customFieldPossibleValue -> customFieldPossibleValue.getInternalName() != null && customFieldPossibleValue.getInternalName().equals(string)).findFirst();
                    if (optional.isPresent()) {
                        return optional.get();
                    }
                    CustomFieldPossibleValueVO customFieldPossibleValueVO = (CustomFieldPossibleValueVO)ModelHelper.voFromString(CustomFieldPossibleValueVO.class, (String)string);
                    if (customFieldPossibleValueVO.getId() != null) {
                        customFieldPossibleValueVO.setId(bl ? this.applicationHandler.getIdMask().remove(customFieldPossibleValueVO.getId()) : customFieldPossibleValueVO.getId());
                    }
                    return (CustomFieldPossibleValue)this.conversionHandler.convert(customField.getPossibleValueClass(), (Object)customFieldPossibleValueVO);
                }).filter(Objects::nonNull).filter(customFieldPossibleValue -> customFieldPossibleValue.getField().equals((Object)customField)).collect(Collectors.toSet());
                return customFieldType == CustomFieldType.SINGLE_SELECTION ? CollectionHelper.first(set) : set;
            }
            case FILE: {
                return StringHelper.splitTrimming((String)string4, (String)string3).stream().map(string -> {
                    RawFileVO rawFileVO = (RawFileVO)ModelHelper.voFromString(RawFileVO.class, (String)string);
                    rawFileVO.setId(bl ? this.applicationHandler.getIdMask().remove(rawFileVO.getId()) : rawFileVO.getId());
                    return (RawFile)this.conversionHandler.convert(RawFile.class, (Object)rawFileVO);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case IMAGE: {
                return StringHelper.splitTrimming((String)string4, (String)string3).stream().map(string -> {
                    ImageVO imageVO = (ImageVO)ModelHelper.voFromString(ImageVO.class, (String)string);
                    imageVO.setId(bl ? this.applicationHandler.getIdMask().remove(imageVO.getId()) : imageVO.getId());
                    return (Image)this.conversionHandler.convert(Image.class, (Object)imageVO);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        return null;
    }

    private <CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, V extends CustomFieldValue<CF, C, PV, E>, E extends SimpleEntity> void doSetCustomValues(E e, Collection<CF> collection, Collection<CF> collection2, Collection<CF> collection3, Collection<? extends CustomFieldValueDTO> collection4) {
        CustomFieldVO customFieldVO;
        CustomFieldValue customFieldValue;
        ConversionHandler conversionHandler = this.conversionHandler;
        HashMap<Object, CustomFieldValueDTO> hashMap = new HashMap<Object, CustomFieldValueDTO>();
        Map<String, CustomField> map = collection.stream().collect(Collectors.toMap(ConfigurationEntity::getInternalName, customField -> customField));
        if (collection4 != null) {
            for (CustomFieldValueDTO object2 : collection4) {
                if (object2 == null) continue;
                customFieldValue = null;
                customFieldVO = object2.getField();
                if (customFieldVO == null) continue;
                if (customFieldVO.getId() == null && customFieldVO.getInternalName() != null) {
                    customFieldValue = map.get(customFieldVO.getInternalName());
                }
                if (customFieldValue == null && !collection.contains(customFieldValue = (CustomField)conversionHandler.convert(((EntityWithCustomValues)e).getCustomFieldClass(), (Object)customFieldVO))) {
                    if (customFieldVO.getInternalName() != null) {
                        throw new EntityNotFoundException(((EntityWithCustomValues)e).getCustomFieldClass(), customFieldVO.getInternalName());
                    }
                    throw new EntityNotFoundException(((EntityWithCustomValues)e).getCustomFieldClass(), customFieldVO.getId());
                }
                if (customFieldValue == null) continue;
                hashMap.put(customFieldValue, object2);
            }
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = ((EntityWithCustomValues)e).getCustomValues().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            customFieldValue = (CustomFieldValue)iterator.next();
            customFieldVO = customFieldValue.getField();
            boolean bl2 = collection2 != null && collection2.contains(customFieldVO);
            boolean bl3 = bl = collection3 != null && collection3.contains(customFieldVO);
            if (!collection.contains(customFieldVO)) {
                iterator.remove();
                this.doRemove(customFieldValue, false);
            } else {
                if (!bl2 && !bl) {
                    customFieldValue.setSkipRawData(true);
                    continue;
                }
                CustomFieldValueDTO customFieldValueDTO2 = (CustomFieldValueDTO)hashMap.get(customFieldVO);
                if (customFieldValueDTO2 != null) {
                    Object object;
                    Object object2 = this.getValue((CustomField<?, ?, ?>)customFieldVO, customFieldValueDTO2, false);
                    if (bl2) {
                        this.setCustomFieldValue(customFieldValue, object2, customFieldVO.isIgnoreSanitizer());
                    } else {
                        customFieldValue.setSkipRawData(true);
                        object = this.getValue((CustomField<?, ?, ?>)customFieldVO, customFieldValue, false);
                        if (!Objects.equals(object2, object)) {
                            throw new PermissionDeniedException();
                        }
                    }
                    object = customFieldValue;
                    if (bl && customFieldValueDTO2 instanceof UserCustomFieldValueDTO && object instanceof UserCustomFieldValue) {
                        ((UserCustomFieldValue)object).setHidden(((UserCustomFieldValueDTO)customFieldValueDTO2).isHidden());
                    }
                }
            }
            hashSet.add(customFieldVO);
        }
        hashMap.keySet().removeAll(hashSet);
        hashMap.forEach((customField, customFieldValueDTO) -> {
            Object object;
            boolean bl;
            boolean bl2 = bl = collection3 != null && collection3.contains(customField);
            if (bl && (RequiredValidation.isValid((Object)(object = this.getValue((CustomField<?, ?, ?>)customField, customFieldValueDTO, false))) || this.getDefaultValue((CustomField<?, ?, ?>)customField) != null)) {
                Object v = this.instantiateValue(customField, e);
                this.setCustomFieldValue((CustomFieldValue)v, object, customField.isIgnoreSanitizer());
                Object v2 = v;
                if (customFieldValueDTO instanceof UserCustomFieldValueDTO && v2 instanceof UserCustomFieldValue) {
                    UserCustomField userCustomField = (UserCustomField)customField;
                    boolean bl3 = collection3 != null && collection3.contains(customField);
                    UserCustomFieldValueDTO userCustomFieldValueDTO = (UserCustomFieldValueDTO)customFieldValueDTO;
                    boolean bl4 = bl3 ? userCustomFieldValueDTO.isHidden() : userCustomField.getDefaultVisibility() == FieldVisibility.HIDDEN;
                    ((UserCustomFieldValue)v2).setHidden(bl4);
                }
                ((EntityWithCustomValues)e).getCustomValues().add(v);
            }
        });
        HashSet<CF> hashSet2 = new HashSet<CF>(collection);
        hashSet2.removeAll(hashSet);
        hashSet2.removeAll(hashMap.keySet());
        this.setDefaultValues(e, hashSet2);
    }

    private <T> void doSortAndRemoveMissingFromVO(List<? extends T> list, List<? extends IEntity> list2, Function<T, Long> function) {
        List list3 = list2.stream().map(IEntity::getId).collect(Collectors.toList());
        list.removeIf(object -> !list3.contains(function.apply(object)));
        list.sort((object, object2) -> list3.indexOf(function.apply(object)) - list3.indexOf(function.apply(object2)));
    }

    private List<Object> getAllowedValues(CustomField<?, ?, ?> customField, LoadValuesScriptFunction loadValuesScriptFunction, Map<String, ?> map) {
        CustomFieldType customFieldType = customField.getType();
        if (customField.getLoadValuesScript() == null) {
            if (customFieldType == CustomFieldType.LINKED_ENTITY && customField.getLinkedEntityRecordType() != null && customField.getLinkedEntityRecordType().getNature() == RecordTypeNature.SYSTEM) {
                SystemRecordType systemRecordType = (SystemRecordType)this.conversionHandler.convert(SystemRecordType.class, (Object)customField.getLinkedEntityRecordType());
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.addAll(this.recordService.listSystem(systemRecordType));
                return arrayList;
            }
            return null;
        }
        CustomScript customScript = customField.getLoadValuesScript();
        Object object = this.customScriptService.newAccessor(customScript, customField.getLoadValuesScriptParameters()).bind("field", customField).bindAll(map).run((ScriptFunction)loadValuesScriptFunction);
        if (object == null) {
            return null;
        }
        Class<?> clazz = this.getValueType(customField);
        Iterator iterator = IteratorUtils.getIterator((Object)object);
        List list = CollectionHelper.asStream((Iterator)iterator).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Map<String, CustomFieldPossibleValue> map2 = null;
        for (Object t : list) {
            DynamicFieldValue dynamicFieldValue;
            if (customFieldType.isDynamic()) {
                if (t instanceof String) {
                    dynamicFieldValue = new DynamicFieldValue((String)t);
                } else {
                    dynamicFieldValue = (DynamicFieldValue)this.conversionHandler.convert(DynamicFieldValue.class, t);
                    if (StringHelper.isBlank((Object)dynamicFieldValue.getValue())) {
                        throw new CustomScriptException("Custom script " + String.valueOf(customScript) + " returned a dynamic value with a blank 'value' attribute");
                    }
                }
                arrayList.add(dynamicFieldValue);
                continue;
            }
            if (customFieldType.isEnumerated()) {
                dynamicFieldValue = null;
                if (t instanceof String) {
                    String string;
                    if (map2 == null) {
                        map2 = customField.getPossibleValues().stream().filter(customFieldPossibleValue -> customFieldPossibleValue.getInternalName() != null).collect(Collectors.toMap(CustomFieldPossibleValue::getInternalName, customFieldPossibleValue -> customFieldPossibleValue));
                    }
                    if ((dynamicFieldValue = (CustomFieldPossibleValue)map2.get(string = ModelHelper.unqualifyInternalName((String)((String)t)))) == null) {
                        throw new EntityNotFoundException(CustomFieldPossibleValue.class, string);
                    }
                } else {
                    dynamicFieldValue = (CustomFieldPossibleValue)this.conversionHandler.convert(customField.getPossibleValueClass(), t);
                    if (!customField.equals((Object)dynamicFieldValue.getField())) {
                        throw new ValidationException("Wrong possible value returned for custom field " + customField.getInternalName() + ": " + String.valueOf(t));
                    }
                }
                arrayList.add(dynamicFieldValue);
                continue;
            }
            try {
                arrayList.add(this.conversionHandler.convert(clazz, t));
            }
            catch (EntityNotFoundException entityNotFoundException) {}
        }
        return arrayList;
    }

    private Object getDefaultValue(CustomFieldDetailedVO customFieldDetailedVO) {
        switch (customFieldDetailedVO.getType()) {
            case STRING: 
            case URL: {
                return customFieldDetailedVO.getDefaultStringValue();
            }
            case TEXT: {
                return customFieldDetailedVO.getDefaultTextValue();
            }
            case RICH_TEXT: {
                return customFieldDetailedVO.getDefaultRichTextValue();
            }
            case BOOLEAN: {
                return customFieldDetailedVO.getDefaultBooleanValue();
            }
            case DATE: {
                return customFieldDetailedVO.getDefaultDateValue();
            }
            case DECIMAL: {
                return customFieldDetailedVO.getDefaultDecimalValue();
            }
            case INTEGER: {
                return customFieldDetailedVO.getDefaultIntegerValue();
            }
            case SINGLE_SELECTION: {
                return CollectionHelper.orEmpty((List)customFieldDetailedVO.getPossibleValues()).stream().filter(CustomFieldPossibleValueVO::isDefaultValue).findAny().orElse(null);
            }
            case MULTI_SELECTION: {
                return CollectionHelper.orEmpty((List)customFieldDetailedVO.getPossibleValues()).stream().filter(CustomFieldPossibleValueVO::isDefaultValue).collect(Collectors.toList());
            }
            case DYNAMIC_SELECTION: {
                return CollectionHelper.orEmpty((List)customFieldDetailedVO.getDynamicValues()).stream().filter(DynamicFieldValueVO::isDefaultValue).findAny().orElse(null);
            }
            case DYNAMIC_MULTI_SELECTION: {
                return CollectionHelper.orEmpty((List)customFieldDetailedVO.getDynamicValues()).stream().filter(DynamicFieldValueVO::isDefaultValue).collect(Collectors.toList());
            }
            case LINKED_ENTITY: {
                if (customFieldDetailedVO.getLinkedEntityType() == LinkedEntityType.USER) {
                    return customFieldDetailedVO.getDefaultUserValue();
                }
                return null;
            }
            case FILE: 
            case IMAGE: {
                return null;
            }
        }
        return null;
    }

    private Class<? extends SimpleEntity> getEntityType(LinkedEntityType linkedEntityType) {
        Class<User> clazz = null;
        switch (linkedEntityType) {
            case USER: {
                clazz = User.class;
                break;
            }
            case TRANSACTION: {
                clazz = Transaction.class;
                break;
            }
            case TRANSFER: {
                clazz = Transfer.class;
                break;
            }
            case RECORD: {
                clazz = Record.class;
                break;
            }
            case ADVERTISEMENT: {
                clazz = BasicAd.class;
            }
        }
        if (clazz == null) {
            throw new IllegalStateException("Unhandled linked entity type: " + String.valueOf(linkedEntityType));
        }
        return clazz;
    }

    private List<RawFile> getFileValues(CustomField<?, ?, ?> customField, Object object) {
        Iterator iterator = IteratorUtils.getIterator((Object)object);
        List<RawFile> list = CollectionHelper.asStream((Iterator)iterator).filter(Objects::nonNull).map(this.conversionHandler.convertingFunction(RawFile.class, new Object[0])).collect(Collectors.toList());
        this.checkType(list, CustomFieldValueFile.class, TempFile.class);
        return list;
    }

    private List<Image> getImageValues(CustomField<?, ?, ?> customField, Object object) {
        Iterator iterator = IteratorUtils.getIterator((Object)object);
        List<Image> list = CollectionHelper.asStream((Iterator)iterator).filter(Objects::nonNull).map(this.conversionHandler.convertingFunction(Image.class, new Object[0])).collect(Collectors.toList());
        this.checkType(list, CustomFieldValueImage.class, TempImage.class);
        return list;
    }

    private <CF extends CustomField<CF, ?, ?>, V extends CustomFieldValue<CF, ?, ?, E>, E extends SimpleEntity> V instantiateValue(CF CF, E e) {
        CustomFieldValue customFieldValue = (CustomFieldValue)ClassHelper.instantiate((Class)((EntityWithCustomValues)e).getCustomFieldValueClass());
        customFieldValue.setField(CF);
        customFieldValue.setOwner(e);
        return (V)customFieldValue;
    }

    private String internalNameOrIdAsReference(Object object) {
        Object object2;
        if (object instanceof IInternalNamedEntity && StringHelper.isNotBlank((Object)(object2 = ((IInternalNamedEntity)object).getInternalName()))) {
            return object2;
        }
        object2 = null;
        if (object instanceof IEntity) {
            object2 = ((IEntity)object).getId();
        } else if (object instanceof Number) {
            object2 = ((Number)object).longValue();
        }
        if (object2 != null) {
            return this.applicationHandler.getIdMask().apply((Long)object2).toString();
        }
        return null;
    }

    private boolean isSameDynamicValue(IDynamicFieldValue iDynamicFieldValue, Object object) {
        String string;
        String string2 = string = iDynamicFieldValue == null ? null : iDynamicFieldValue.getValue();
        if (string == null || object == null) {
            return false;
        }
        if (object instanceof String) {
            return string.equals(object);
        }
        if (object instanceof IDynamicFieldValue) {
            return string.equals(((IDynamicFieldValue)object).getValue());
        }
        return false;
    }

    private boolean isSamePossibleValue(CustomFieldPossibleValueVO customFieldPossibleValueVO, Object object) {
        if (customFieldPossibleValueVO == null || object == null) {
            return false;
        }
        if (object instanceof CustomFieldPossibleValue) {
            Long l = ((CustomFieldPossibleValue)object).getId();
            return l.equals(customFieldPossibleValueVO.getId());
        }
        if (object instanceof Long) {
            return object.equals(customFieldPossibleValueVO.getId());
        }
        if (object instanceof String) {
            return object.equals(ModelHelper.unqualifyInternalName((IInternalNamedEntity)customFieldPossibleValueVO));
        }
        return false;
    }

    private void persistStoredFiles(CustomFieldValue customFieldValue) {
        Object object;
        List list = customFieldValue.getRawFiles();
        HashSet hashSet = new HashSet(CollectionHelper.orEmpty((List)customFieldValue.getFileValues()));
        if (customFieldValue.getPreviousValue() instanceof Collection) {
            object = CollectionHelper.filterByType(((Collection)customFieldValue.getPreviousValue()).stream(), CustomFieldValueFile.class);
            object.forEach(hashSet::add);
        }
        object = CollectionHelper.orEmpty((List)list).stream().map(rawFile -> {
            if (rawFile instanceof TempFile) {
                CustomFieldValueFile customFieldValueFile = (CustomFieldValueFile)this.conversionHandler.convert(CustomFieldValueFile.class, rawFile);
                customFieldValueFile.setCustomFieldValue(customFieldValue);
                this.tempFileService.move((TempFile)rawFile, (StoredFile)customFieldValueFile);
                return customFieldValueFile;
            }
            if (rawFile instanceof CustomFieldValueFile) {
                return this.checkOwner(customFieldValue, (CustomFieldValueFile)rawFile);
            }
            throw new EntityNotFoundException(CustomFieldValueFile.class, rawFile.getId());
        }).collect(Collectors.toList());
        for (int i = 0; i < object.size(); ++i) {
            ((CustomFieldValueFile)object.get(i)).setOrder(Integer.valueOf(i));
        }
        customFieldValue.setFileValues((List)object);
        customFieldValue.setRawFiles(null);
        hashSet.removeAll((Collection<?>)object);
        hashSet.stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    private void persistStoredImages(CustomFieldValue customFieldValue) {
        Object object;
        List list = customFieldValue.getRawImages();
        HashSet hashSet = new HashSet(CollectionHelper.orEmpty((List)customFieldValue.getImageValues()));
        if (customFieldValue.getPreviousValue() instanceof Collection) {
            object = CollectionHelper.filterByType(((Collection)customFieldValue.getPreviousValue()).stream(), CustomFieldValueImage.class);
            object.forEach(hashSet::add);
        }
        object = CollectionHelper.orEmpty((List)list).stream().map(image -> {
            if (image instanceof TempImage) {
                CustomFieldValueImage customFieldValueImage = (CustomFieldValueImage)this.conversionHandler.convert(CustomFieldValueImage.class, image);
                customFieldValueImage.setCustomFieldValue(customFieldValue);
                this.tempImageService.move((TempImage)image, (StoredFile)customFieldValueImage);
                return customFieldValueImage;
            }
            if (image instanceof CustomFieldValueImage) {
                return this.checkOwner(customFieldValue, (CustomFieldValueImage)image);
            }
            throw new EntityNotFoundException(CustomFieldValueImage.class, image.getId());
        }).collect(Collectors.toList());
        for (int i = 0; i < object.size(); ++i) {
            ((CustomFieldValueImage)object.get(i)).setOrder(Integer.valueOf(i));
        }
        customFieldValue.setImageValues((List)object);
        customFieldValue.setRawImages(null);
        hashSet.removeAll((Collection<?>)object);
        hashSet.stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    private void processAfterSave(CustomFieldValue<?, ?, ?, ?> customFieldValue) {
        CustomFieldType customFieldType = customFieldValue.getField().getType();
        if (customFieldType == CustomFieldType.FILE) {
            this.persistStoredFiles(customFieldValue);
        } else if (customFieldType == CustomFieldType.IMAGE) {
            this.persistStoredImages(customFieldValue);
        }
    }

    private String removeAndValidateMask(String string, String string2) {
        try {
            return MaskHelper.removeAndValidateMask((String)string, (String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CoercionException(string2);
        }
    }

    private boolean sendLinkedEntityDetails(SimpleEntity simpleEntity) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (simpleEntity instanceof SystemRecord) {
            SystemRecord systemRecord = (SystemRecord)simpleEntity;
            return productsAccessor.admin().getSystemRecordTypes().isSet((Object)((SystemRecordType)systemRecord.getType()), (Path)QProductSystemRecordType.productSystemRecordType.view);
        }
        if (simpleEntity instanceof UserRecord) {
            UserRecord userRecord = (UserRecord)simpleEntity;
            User user = userRecord.getUser();
            UserRecordType userRecordType = (UserRecordType)userRecord.getType();
            return sessionData.isManagerOf((BasicUser)user) && productsAccessor.userManagement().getUserRecordTypes().isSet((Object)userRecordType, (Path)QProductUserRecordType.productUserRecordType.view) || user.equals((Object)sessionData.getLoggedUser()) && productsAccessor.product().getMyRecordTypes().isSet((Object)userRecordType, (Path)QProductMyRecordType.productMyRecordType.view);
        }
        return this.entityManagerHandler.isAccessible((IEntity)simpleEntity);
    }

    private void setCustomFieldValue(CustomFieldValue customFieldValue, Object object, boolean bl) {
        CustomField customField = customFieldValue.getField();
        customFieldValue.setPreviousValue(this.getValue(customFieldValue.getField(), customFieldValue, false));
        customFieldValue.setBooleanValue(null);
        customFieldValue.setDateValue(null);
        customFieldValue.setDecimalValue(null);
        customFieldValue.setIntegerValue(null);
        customFieldValue.setEnumeratedValue(null);
        customFieldValue.setEnumeratedValues(null);
        customFieldValue.setDynamicValues(null);
        customFieldValue.setStringValue(null);
        customFieldValue.setTextValue(null);
        customFieldValue.setRichTextValue(null);
        customFieldValue.setFileValues(null);
        customFieldValue.setImageValues(null);
        customFieldValue.setLinkedEntityId(null);
        switch (customField.getType()) {
            case STRING: {
                String string = (String)object;
                if (!bl) {
                    string = this.richTextHandler.escapeTags(string);
                }
                if (StringHelper.isNotBlank((Object)customField.getPattern())) {
                    string = this.removeAndValidateMask(customField.getPattern(), string);
                }
                customFieldValue.setStringValue(string);
                break;
            }
            case TEXT: {
                String string = (String)object;
                if (!bl) {
                    string = this.richTextHandler.escapeTags(string);
                }
                customFieldValue.setTextValue(string);
                break;
            }
            case RICH_TEXT: {
                String string = (String)object;
                if (bl) {
                    customFieldValue.setRichTextValue(this.richTextHandler.replaceUrlsByTags(string));
                    break;
                }
                customFieldValue.setRichTextValue(this.richTextHandler.sanitize(string));
                break;
            }
            case DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)object;
                customFieldValue.setDecimalValue(this.applyDecimalDigits(customField, bigDecimal));
                break;
            }
            case URL: {
                customFieldValue.setStringValue((String)object);
                break;
            }
            case BOOLEAN: {
                if (object == null) {
                    object = false;
                }
                customFieldValue.setBooleanValue((Boolean)object);
                break;
            }
            case INTEGER: {
                customFieldValue.setIntegerValue((Integer)object);
                break;
            }
            case DATE: {
                Date date = (Date)object;
                customFieldValue.setDateValue((IDate)DateWrapper.instance((Date)date));
                break;
            }
            case SINGLE_SELECTION: {
                CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)object;
                customFieldValue.setEnumeratedValue(customFieldPossibleValue);
                break;
            }
            case MULTI_SELECTION: {
                Collection collection = CollectionHelper.orEmpty((Collection)((Collection)object));
                customFieldValue.setEnumeratedValues(collection instanceof Set ? (Set)collection : new HashSet(collection));
                break;
            }
            case LINKED_ENTITY: {
                SimpleEntity simpleEntity = (SimpleEntity)object;
                if (simpleEntity != null && !this.entityManagerHandler.isAccessible((IEntity)simpleEntity)) {
                    Long l = customFieldValue.getLinkedEntityId();
                    if (!simpleEntity.getId().equals(l)) {
                        throw new EntityNotFoundException(LinkedEntityTypeMapping.getEntityType((LinkedEntityType)customField.getLinkedEntityType()), simpleEntity.getId());
                    }
                }
                customFieldValue.setLinkedEntityId(SimpleEntity.id((SimpleEntity)simpleEntity));
                break;
            }
            case DYNAMIC_SELECTION: {
                DynamicFieldValue dynamicFieldValue = (DynamicFieldValue)object;
                if (dynamicFieldValue == null) break;
                String string = dynamicFieldValue.getValue();
                String string2 = dynamicFieldValue.getLabel();
                if (!bl) {
                    string = this.richTextHandler.escapeTags(string);
                    string2 = this.richTextHandler.escapeTags(string2);
                }
                customFieldValue.setStringValue(string);
                customFieldValue.setTextValue(string2);
                break;
            }
            case DYNAMIC_MULTI_SELECTION: {
                Collection collection = CollectionHelper.orEmpty((Collection)((Collection)object));
                customFieldValue.setDynamicValues(collection instanceof Set ? (Set)collection : new HashSet(collection));
                customFieldValue.setTextValue(collection.stream().map(IDynamicFieldValue::asString).sorted().collect(Collectors.joining("\n")));
                break;
            }
            case FILE: {
                List list = CollectionHelper.orEmpty((List)((List)object));
                Integer n = customField.getMaxFiles();
                if (n != null && n > 0 && n < list.size()) {
                    throw new MaxItemsException(n.intValue());
                }
                customFieldValue.setRawFiles(list);
                break;
            }
            case IMAGE: {
                List list = CollectionHelper.orEmpty((List)((List)object));
                Integer n = customField.getMaxFiles();
                if (n != null && n > 0 && n < list.size()) {
                    throw new MaxItemsException(n.intValue());
                }
                customFieldValue.setRawImages(list);
            }
        }
    }

    private CustomFieldPossibleValue<?, ?, ?> toCustomFieldPossibleValue(CustomField<?, ?, ?> customField, Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IEntity)) {
            CustomFieldPossibleValueVO customFieldPossibleValueVO = (CustomFieldPossibleValueVO)ModelHelper.voFromString(CustomFieldPossibleValueVO.class, (String)object.toString());
            if (customFieldPossibleValueVO.getId() != null) {
                customFieldPossibleValueVO.setId(this.applicationHandler.getIdMask().remove(customFieldPossibleValueVO.getId()));
            }
            CustomFieldHelper.qualifyInternalName((String)customField.getInternalName(), (CustomFieldPossibleValueVO)customFieldPossibleValueVO);
            object = customFieldPossibleValueVO;
        }
        return (CustomFieldPossibleValue)this.conversionHandler.convert(customField.getPossibleValueClass(), object);
    }

    private CustomFieldVO toCustomFieldVO(CustomField<?, ?, ?> customField) {
        CustomFieldVO customFieldVO = new CustomFieldVO(customField.getId());
        customFieldVO.setNature(customField.getNature());
        return customFieldVO;
    }

    private DynamicFieldValue toDynamicFieldValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DynamicFieldValue) {
            return (DynamicFieldValue)object;
        }
        if (object instanceof IDynamicFieldValue) {
            IDynamicFieldValue iDynamicFieldValue = (IDynamicFieldValue)object;
            return new DynamicFieldValue(iDynamicFieldValue.getValue(), iDynamicFieldValue.getLabel());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            String string = StringHelper.trimToNull(map.get(DynamicFieldValueVO.VALUE.getName()));
            String string2 = StringHelper.trimToNull(map.get(DynamicFieldValueVO.LABEL.getName()));
            return string == null ? null : new DynamicFieldValue(string, string2);
        }
        return new DynamicFieldValue(object.toString(), null);
    }

    private SimpleEntity toLinkedEntity(LinkedEntityType linkedEntityType, Object object, boolean bl) {
        Object object2;
        Object object3;
        if (object == null) {
            return null;
        }
        if (object instanceof LinkedEntityVO) {
            object3 = (LinkedEntityVO)object;
            if (object3 instanceof LinkedUserVO) {
                object2 = (LinkedUserVO)object3;
                if (object2.getUser() != null) {
                    object = object2.getUser();
                }
            } else if (object3 instanceof LinkedTransactionVO) {
                object2 = (LinkedTransactionVO)object3;
                if (object2.getTransaction() != null) {
                    object = object2.getTransaction();
                }
            } else if (object3 instanceof LinkedTransferVO) {
                object2 = (LinkedTransferVO)object3;
                if (object2.getTransfer() != null) {
                    object = object2.getTransfer();
                }
            } else if (object3 instanceof LinkedRecordVO) {
                object2 = (LinkedRecordVO)object3;
                if (object2.getRecord() != null) {
                    object = object2.getRecord();
                }
            } else if (object3 instanceof LinkedAdVO && (object2 = (LinkedAdVO)object3).getAd() != null) {
                object = object2.getAd();
            }
            if (object instanceof LinkedEntityVO) {
                object = ObjectHelper.coalesce((Object[])new Serializable[]{object3.getId(), object3.getInternalName()});
            } else if (object instanceof EntityVO && (object2 = (EntityVO)object).getId() == null && object3.getId() != null) {
                object2.setId(object3.getId());
            }
        }
        if (object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof BigInteger) {
            object = ((Number)object).longValue();
        } else if (object instanceof CharSequence) {
            object3 = LinkedEntityTypeMapping.getVoType((LinkedEntityType)linkedEntityType);
            object2 = StringUtils.substringBefore((String)object.toString(), (String)CustomFieldHelper.VALUE_SEPARATOR);
            EntityVO entityVO = ModelHelper.voFromString((Class)object3, (String)object2);
            if (bl && entityVO.getId() != null) {
                entityVO.setId(this.applicationHandler.getIdMask().remove(entityVO.getId()));
            }
            object = entityVO;
        }
        try {
            object3 = object;
            object2 = this.getEntityType(linkedEntityType);
            return (SimpleEntity)this.invokerHandler.runAs(SessionDataFactory.system(), () -> this.lambda$toLinkedEntity$48((Class)object2, object3));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return null;
        }
    }

    private LinkedEntityVO toLinkedEntityVO(LinkedEntityType linkedEntityType, SimpleEntity simpleEntity) {
        String string;
        Bean bean;
        if (simpleEntity == null) {
            return null;
        }
        org.cyclos.model.Property property = LinkedEntityTypeMapping.getLinkedEntityVOProperty((LinkedEntityType)linkedEntityType);
        String string2 = null;
        if (this.sendLinkedEntityDetails(simpleEntity)) {
            bean = (Bean)this.conversionHandler.convertExcluding(property.getType(), (Object)simpleEntity, new Object[]{RecordVO.CUSTOM_VALUES.getName()});
            string = this.getFormatter().format((Object)bean);
            if (bean instanceof HasTransactionNumber) {
                string2 = ((HasTransactionNumber)bean).getTransactionNumber();
            }
        } else {
            bean = (Bean)ClassHelper.instantiate((Class)property.getType());
            string = this.getFormatter().format((Object)simpleEntity);
            if (bean instanceof HasDisplay) {
                ((HasDisplay)bean).setDisplay(string);
            } else if (bean instanceof INamedEntity) {
                ((INamedEntity)bean).setName(string);
            } else {
                throw new IllegalStateException("Cannot set the display on " + String.valueOf(bean.getClass()));
            }
        }
        LinkedEntityVO linkedEntityVO = (LinkedEntityVO)ClassHelper.instantiate((Class)LinkedEntityTypeMapping.getLinkedEntityVOType((LinkedEntityType)linkedEntityType));
        linkedEntityVO.setId(simpleEntity.getId());
        linkedEntityVO.set(property, (Object)bean);
        linkedEntityVO.setInternalName(string2);
        linkedEntityVO.setName(string);
        return linkedEntityVO;
    }

    private CustomFieldPossibleValue<?, ?, ?> toPossibleValue(CustomField<?, ?, ?> customField, Object object) {
        String string;
        if (object instanceof CustomFieldPossibleValueVO && ((CustomFieldPossibleValueVO)object).getId() == null) {
            object = ModelHelper.unqualifyInternalName((IInternalNamedEntity)((CustomFieldPossibleValueVO)object));
        }
        if (object instanceof CharSequence) {
            string = object.toString();
            for (CustomFieldPossibleValue customFieldPossibleValue : customField.getPossibleValues()) {
                if (!string.equals(customFieldPossibleValue.getInternalName())) continue;
                return customFieldPossibleValue;
            }
            try {
                object = this.applicationHandler.getIdMask().remove(Long.parseLong(object.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!customField.equals((Object)(string = (CustomFieldPossibleValue)this.conversionHandler.convert(customField.getPossibleValueClass(), object)).getField())) {
            throw new EntityNotFoundException(CustomFieldPossibleValue.class, string.getId());
        }
        return string;
    }

    private /* synthetic */ SimpleEntity lambda$toLinkedEntity$48(Class clazz, Object object) throws Exception {
        return (SimpleEntity)this.conversionHandler.convert(clazz, object);
    }

    private static /* synthetic */ boolean lambda$toSearchFiltersMap$23(ICustomField iCustomField, CustomField customField) {
        return customField.getId().equals(iCustomField.getId());
    }

    private class DynamicValueValidation
    extends BasePropertyValidation {
        private Map<String, ?> bindings;
        private LoadValuesScriptFunction function;
        private CustomFieldPropertyAccess valuesPropertyAccess;

        public DynamicValueValidation(Map<String, ?> map, LoadValuesScriptFunction loadValuesScriptFunction, CustomFieldPropertyAccess customFieldPropertyAccess) {
            this.bindings = map;
            this.function = loadValuesScriptFunction;
            this.valuesPropertyAccess = customFieldPropertyAccess;
        }

        protected boolean isValid(Object object2, Object object3, Object object4) {
            CustomField customField = (CustomField)object3;
            if (!customField.getType().isDynamic()) {
                return true;
            }
            Map<String, DynamicFieldValue> map = CustomFieldValueHandlerImpl.this.getAllowedValues(customField, this.function, this.bindings).stream().map(DynamicFieldValue.class::cast).collect(Collectors.toMap(DynamicFieldValue::getValue, dynamicFieldValue -> dynamicFieldValue));
            ICustomFieldValue iCustomFieldValue = this.valuesPropertyAccess.findCustomValue(object2);
            if (iCustomFieldValue instanceof Bean) {
                ((Bean)iCustomFieldValue).setAttribute(CustomFieldValueHandlerImpl.ALLOWED_DYNA_VALUES, map);
            }
            return CollectionHelper.asStream((Iterator)IteratorUtils.getIterator((Object)object4)).allMatch(object -> map.containsKey(CustomFieldValueHandlerImpl.this.toDynamicFieldValue(object).getValue()));
        }
    }

    private class ValueAllowedByScriptValidation
    extends BasePropertyValidation {
        private Map<String, ?> bindings;
        private LoadValuesScriptFunction function;

        public ValueAllowedByScriptValidation(Map<String, ?> map, LoadValuesScriptFunction loadValuesScriptFunction) {
            this.bindings = map;
            this.function = loadValuesScriptFunction;
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            CustomField customField = (CustomField)object2;
            CustomScript customScript = customField.getLoadValuesScript();
            if (customScript == null) {
                return true;
            }
            List<Object> list = CustomFieldValueHandlerImpl.this.getAllowedValues(customField, this.function, this.bindings);
            object3 = CustomFieldValueHandlerImpl.this.getValue(customField, object3, false);
            if (customField.getType() == CustomFieldType.MULTI_SELECTION) {
                Collection collection = (Collection)object3;
                return CollectionHelper.isEmpty((Iterable)collection) || list.containsAll(collection);
            }
            return list.contains(object3);
        }
    }

    private class UniqueValidation
    extends BasePropertyValidation {
        private EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> fv;

        public UniqueValidation(EntityPathBase<? extends CustomFieldValue<?, ?, ?, ?>> entityPathBase) {
            super(ValidationErrors.unique());
            this.fv = entityPathBase;
        }

        protected boolean isValid(Object object, Object object2, Object object3) {
            NumberPath numberPath;
            EntityPathBase entityPathBase;
            Long l;
            Object object4;
            CustomField customField = (CustomField)object2;
            EntityPathBase entityPathBase2 = (EntityPathBase)MethodHelper.invoke(this.fv, (String)"field", (Object[])new Object[0]);
            DBQuery dBQuery = CustomFieldValueHandlerImpl.this.from(new EntityPath[]{this.fv});
            dBQuery.where((Predicate)entityPathBase2.eq((Object)customField));
            QCustomFieldValue qCustomFieldValue = new QCustomFieldValue(this.fv);
            switch (customField.getType()) {
                case SINGLE_SELECTION: 
                case MULTI_SELECTION: 
                case BOOLEAN: {
                    return true;
                }
                case DATE: {
                    dBQuery.where((Predicate)qCustomFieldValue.dateValue.eq((Object)((Date)object3)));
                    break;
                }
                case DECIMAL: {
                    dBQuery.where((Predicate)qCustomFieldValue.decimalValue.eq((Object)((BigDecimal)object3)));
                    break;
                }
                case INTEGER: {
                    dBQuery.where((Predicate)qCustomFieldValue.integerValue.eq((Object)((Integer)object3)));
                    break;
                }
                default: {
                    object4 = object3.toString();
                    if (StringHelper.isNotBlank((Object)customField.getPattern())) {
                        object4 = MaskHelper.removeMask((String)customField.getPattern(), (String)object4);
                    }
                    dBQuery.where((Predicate)qCustomFieldValue.stringValue.equalsIgnoreCase((String)object4));
                }
            }
            object4 = customField.getClass().getSimpleName() + "_" + customField.getId() + "_" + String.valueOf(object3);
            CustomFieldValueHandlerImpl.this.lockHandler.lock(LockType.UNIQUE_VALIDATION.key((String)object4));
            Long l2 = l = object instanceof IEntity ? ((IEntity)object).getId() : null;
            if (l != null) {
                entityPathBase = (EntityPathBase)MethodHelper.invoke(this.fv, (String)"owner", (Object[])new Object[0]);
                numberPath = (NumberPath)FieldHelper.get((Object)entityPathBase, (String)"id");
                dBQuery.where((Predicate)numberPath.ne((Object)l));
            }
            if (customField instanceof UserCustomField) {
                entityPathBase = (EntityPathBase)MethodHelper.invoke(this.fv, (String)"owner", (Object[])new Object[0]);
                numberPath = (EnumPath)FieldHelper.get((Object)entityPathBase, (String)"status");
                dBQuery.where((Predicate)numberPath.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED}));
            } else if (customField instanceof AdCustomField) {
                entityPathBase = (EntityPathBase)MethodHelper.invoke(this.fv, (String)"owner", (Object[])new Object[0]);
                numberPath = (DateTimePath)FieldHelper.get((Object)entityPathBase, (String)"deletedDate");
                dBQuery.where((Predicate)numberPath.isNull());
            } else if (customField instanceof TransactionCustomField) {
                entityPathBase = (EntityPathBase)MethodHelper.invoke(this.fv, (String)"owner", (Object[])new Object[0]);
                dBQuery.where((Predicate)entityPathBase.instanceOf(ExternalPayment.class).not());
            }
            return !dBQuery.hasResults();
        }
    }

    private class CustomScriptValidation
    implements PropertyValidation {
        private CustomScriptValidation() {
        }

        public ValidationError validate(Object object, Object object2, Object object3) {
            if (!RequiredValidation.isValid((Object)object3)) {
                return null;
            }
            CustomField customField = (CustomField)object2;
            Object object4 = CustomFieldValueHandlerImpl.this.customScriptService.newAccessor(customField.getValidationScript(), customField.getValidationScriptParameters()).bind("object", object).bind("field", object2).bind("value", object3).run();
            if (Boolean.FALSE.equals(object4)) {
                return ValidationErrors.invalid();
            }
            if (object4 instanceof CharSequence) {
                return ValidationErrors.text((String)object4.toString());
            }
            return null;
        }
    }
}

