/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.scripts.CustomScriptDTO;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<CustomScript, CustomScriptDTO> {
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public Class<CustomScript> getEntityClass() {
        return CustomScript.class;
    }

    public EntityLogType getType() {
        return EntityLogType.CUSTOM_SCRIPT;
    }

    public EntityLogDescriptor<CustomScriptDTO> resolveLogDescriptor(CustomScript customScript) {
        return new EntityLogDescriptor(CustomScriptDTO.class).property(CustomScriptDTO.NAME, GeneralKeys.Ui.NAME).property(CustomScriptDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(CustomScriptDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)CustomScriptDTO.DEPENDENCIES, SystemKeys.Scripts.DEPENDENCIES).property((Property)CustomScriptDTO.PARAMETERS, SystemKeys.Scripts.PARAMETERS).property((Property)CustomScriptDTO.RUN_AS_SYSTEM, SystemKeys.Scripts.RUN_AS_SYSTEM).property((Property)CustomScriptDTO.TYPE, SystemKeys.Scripts.TYPE).ignore((Property)CustomScriptDTO.FUNCTIONS);
    }

    @Override
    protected List<EntityPropertyLog> doOnBeforeLog(CustomScript customScript, CustomScript customScript2, List<EntityPropertyLog> list, EntityLogEvent entityLogEvent) {
        CustomScript customScript3 = (CustomScript)ObjectHelper.defaultValue((Object)customScript2, (Object)customScript);
        Arrays.asList(this.customScriptService.getFunctions(customScript3.getType())).stream().forEach(scriptFunction -> this.addLog((ScriptFunction)scriptFunction, customScript, customScript2, list));
        return list;
    }

    @Override
    protected CustomScript getEntityToViewLog(long l) {
        return this.getLoggedUser().isGlobalAdmin() ? this.find(CustomScript.class, l) : null;
    }

    private void addLog(ScriptFunction scriptFunction, CustomScript customScript, CustomScript customScript2, List<EntityPropertyLog> list) {
        String string;
        String string2 = customScript == null ? null : (String)customScript.getFunctions().get(scriptFunction.name());
        String string3 = string = customScript2 == null ? null : (String)customScript2.getFunctions().get(scriptFunction.name());
        if (!Objects.equals(string2, string)) {
            EntityPropertyLog entityPropertyLog = this.createEntityPropertyLog(this.message(scriptFunction.messageKey(), new Object[0]), CustomScriptDTO.FUNCTIONS.getName(), string2, string);
            entityPropertyLog.setOrder(Integer.valueOf(list.size()));
            list.add(entityPropertyLog);
        }
    }
}

