/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QCustomWebService;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.ServiceInvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.CustomWebServiceContext;
import org.cyclos.impl.system.CustomWebServiceServiceLocal;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.CredentialsNotSuppliedException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.UnauthorizedAddressException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.webservices.CustomWebServiceDTO;
import org.cyclos.model.system.webservices.CustomWebServiceData;
import org.cyclos.model.system.webservices.CustomWebServiceVO;
import org.cyclos.model.system.webservices.HttpMethod;
import org.cyclos.model.system.webservices.RunAs;
import org.cyclos.model.utils.AuthorizationData;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseException;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.access.InvocationData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.MapParameterStorage;
import org.cyclos.utils.Pair;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Service
public class CustomWebServiceServiceImpl
extends CRUDServiceImpl<CustomWebService, QCustomWebService, CustomWebServiceDTO, CustomWebServiceData, Void>
implements CustomWebServiceServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{CustomWebServiceDTO.PASSWORD};
    @Autowired
    private InternetAddressListHandler internetAddressListHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private ServiceInvokerHandler serviceInvokerHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private JsonConverter jsonConverter;
    private Cache<Long, HashMap<String, Long>> cache;
    @Autowired
    private InvokerHandler invokerHandler;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public CustomWebServiceServiceImpl() {
        super(CustomWebService.class, QCustomWebService.customWebService, CustomWebServiceDTO.class);
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.CUSTOM_WS);
    }

    public List<CustomWebServiceVO> list() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QCustomWebService)this.$).name.asc())).list(CustomWebServiceVO.class, (Expression)this.$);
    }

    public List<CustomWebService> listUser() {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QCustomWebService)this.$).runAs.eq((Object)RunAs.USER))).orderBy(((QCustomWebService)this.$).name.asc())).list((Expression)this.$);
    }

    @Override
    public CustomWebService newEntity(Void void_) {
        CustomWebService customWebService = new CustomWebService();
        customWebService.setRunAs(RunAs.USER);
        customWebService.setMethod(HttpMethod.BOTH);
        return customWebService;
    }

    public void prepareContext(CustomWebServiceContext customWebServiceContext, InvocationData invocationData) throws FrameworkException, ResponseException {
        SessionData sessionData;
        RequestInfo requestInfo = invocationData.getRequestData().getRequestInfo();
        customWebServiceContext.setRequest(requestInfo);
        SessionData sessionData2 = this.getSessionData();
        String string = sessionData2.getRemoteAddress();
        RequestData requestData = sessionData2.getRequestData();
        String string2 = StringUtils.substringAfter((String)requestData.getUri(), (String)"run/");
        customWebServiceContext.setPath(string2);
        Network network = sessionData2.getNetwork();
        Pair<CustomWebService, Map<String, String>> pair = this.resolve(string2, this.getMapping(network.getId()));
        CustomWebService customWebService = (CustomWebService)pair.getFirst();
        customWebServiceContext.setCustomWebService(customWebService);
        if (customWebService == null) {
            throw new ResponseException(404);
        }
        Map map = (Map)pair.getSecond();
        customWebServiceContext.setPathVariables(map);
        if (customWebService.isUseIpWhitelist()) {
            this.ensureIpAddressIsWhitelisted(string, customWebService);
        }
        if (customWebService.getMethod() == HttpMethod.GET && !"GET".equalsIgnoreCase(requestInfo.getMethod()) || customWebService.getMethod() == HttpMethod.POST && !"POST".equalsIgnoreCase(requestInfo.getMethod())) {
            throw new ResponseException(405);
        }
        RunAs runAs = customWebService.getRunAs();
        switch (runAs) {
            case GUEST_WITH_AUTHORIZATION: {
                AuthorizationData authorizationData = requestInfo.getAuthorization();
                if (authorizationData == null || !authorizationData.isBasic() || !authorizationData.isValid()) {
                    throw new CredentialsNotSuppliedException();
                }
                if (!authorizationData.getPrincipal().equalsIgnoreCase(customWebService.getUsername()) || !authorizationData.getPassword().equals(customWebService.getPassword())) {
                    throw new LoginException();
                }
            }
            case GUEST: {
                sessionData = SessionDataFactory.guest((RequestData)requestData, (String)invocationData.getChannel());
                break;
            }
            case USER: {
                sessionData = this.serviceInvokerHandler.resolveSessionData(invocationData);
                if (sessionData.unwrap() instanceof UserSessionData) break;
                throw new CredentialsNotSuppliedException();
            }
            default: {
                throw new IllegalStateException("Unhandled RunAs: " + String.valueOf(runAs));
            }
        }
        sessionData.checkConsistency();
        customWebServiceContext.setRunAs(sessionData);
        customWebServiceContext.setLoggedBasicUser(sessionData.getLoggedBasicUser());
    }

    public ResponseInfo run(CustomWebServiceContext customWebServiceContext) throws FrameworkException, ResponseException {
        ResponseInfo responseInfo;
        Object object;
        Object object2;
        SessionData sessionData = customWebServiceContext.getRunAs();
        if (sessionData.isLoggedIn()) {
            object2 = sessionData.getProducts().product().getRunCustomWebServices();
            PermissionHelper.checkContains((Collection)object2, (Object)customWebServiceContext.getCustomWebService());
        }
        object2 = new MapParameterStorage();
        if (CollectionHelper.isNotEmpty((Map)customWebServiceContext.getPathVariables())) {
            object = customWebServiceContext.getPathVariables().entrySet().iterator();
            while (object.hasNext()) {
                responseInfo = object.next();
                object2.setString((String)responseInfo.getKey(), new String[]{(String)responseInfo.getValue()});
            }
        }
        if ((object = this.invokerHandler.runAs(sessionData, () -> this.lambda$run$0(customWebServiceContext, (ParameterStorage)object2))) == null) {
            return new ResponseInfo(200);
        }
        if (object instanceof ResponseInfo) {
            return (ResponseInfo)object;
        }
        if (object instanceof CharSequence) {
            responseInfo = new ResponseInfo(200, object.toString());
            responseInfo.setHeader("Content-Type", ContentType.TEXT.getMimeType());
            responseInfo.setHeader("Content-Encoding", "UTF-8");
            return responseInfo;
        }
        responseInfo = (ResponseInfo)this.conversionHandler.convert(ResponseInfo.class, object);
        if (responseInfo.getStatus() == 0 || StringHelper.isBlank((Object)responseInfo.getStringBody()) && responseInfo.getBinaryBody() == null) {
            responseInfo.setStatus(200);
            responseInfo.setHeader("Content-Type", ContentType.JSON.getMimeType());
            responseInfo.setHeader("Content-Encoding", "UTF-8");
            try {
                responseInfo.setStringBody(this.jsonConverter.writeValueAsString(object));
            }
            catch (JsonGenerationException | JsonMappingException throwable) {
                throw new CustomScriptException("Invalid response returned by " + String.valueOf(customWebServiceContext.getCustomWebService()) + ": " + String.valueOf(object), throwable);
            }
        }
        return responseInfo;
    }

    @Override
    public CustomWebService toEntity(CustomWebServiceDTO customWebServiceDTO) {
        CustomWebService customWebService = (CustomWebService)super.toEntity(customWebServiceDTO);
        if (customWebServiceDTO.getRunAs() == RunAs.GUEST_WITH_AUTHORIZATION && customWebServiceDTO.isPasswordSet()) {
            customWebService.setPassword(customWebServiceDTO.getPassword());
        }
        String string = customWebServiceDTO.isUseIpWhitelist() ? customWebServiceDTO.getIpWhitelist() : null;
        this.internetAddressListHandler.setInternetAddressList((SimpleEntity)customWebService, (Path)((QCustomWebService)this.$).whitelist(), string);
        return customWebService;
    }

    @Override
    protected CustomWebServiceData getData(CustomWebService customWebService) {
        CustomWebServiceData customWebServiceData = new CustomWebServiceData();
        customWebServiceData.setDto((EntityDTO)((CustomWebServiceDTO)this.toDTO(customWebService)));
        customWebServiceData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.CUSTOM_WEB_SERVICE)));
        return customWebServiceData;
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(CustomWebService customWebService) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(CustomWebServiceDTO customWebServiceDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onBeforeRemove(CustomWebService customWebService) {
        this.evictCache();
    }

    @Override
    protected Object onBeforeSave(CustomWebService customWebService, CustomWebService customWebService2) {
        this.evictCache();
        if (customWebService.getRunAs() != RunAs.GUEST_WITH_AUTHORIZATION) {
            customWebService.setPassword(null);
            customWebService.setUsername(null);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomWebService)this.$).network());
    }

    @Override
    protected Validator resolveValidator(CustomWebServiceDTO customWebServiceDTO) {
        Validator validator = new Validator();
        validator.property((Property)CustomWebServiceDTO.METHOD, SystemKeys.WebServices.METHOD).required();
        validator.property((Property)CustomWebServiceDTO.RUN_AS, SystemKeys.WebServices.RUN_AS).required();
        validator.property((Property)CustomWebServiceDTO.SCRIPT, SystemKeys.WebServices.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.CUSTOM_WEB_SERVICE;
            }
        });
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)CustomWebServiceDTO.URL_MAPPINGS, SystemKeys.WebServices.URL_MAPPINGS);
        property.required();
        Map<String, Long> map = this.getMapping(this.getSessionData().getNetwork().getId());
        List<String> list = this.parseMappings(customWebServiceDTO.getUrlMappings());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            Long l = map.get(string);
            if (l == null || l.equals(customWebServiceDTO.getId())) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            property.invalid(new ValidationError(SystemKeys.WebServices.ERROR_UNIQUE_URL_MAPPINGS, new Object[]{StringUtils.join(arrayList, (String)", ")}));
        }
        if (customWebServiceDTO.getRunAs() == RunAs.GUEST_WITH_AUTHORIZATION) {
            if (customWebServiceDTO.isTransient()) {
                validator.property((Property)CustomWebServiceDTO.PASSWORD_SET, SystemKeys.WebServices.PASSWORD_SET).anyOf(new Object[]{true});
            }
            validator.property((Property)CustomWebServiceDTO.USERNAME, SystemKeys.WebServices.USERNAME).required();
            if (customWebServiceDTO.isPasswordSet()) {
                validator.property((Property)CustomWebServiceDTO.PASSWORD, SystemKeys.WebServices.PASSWORD).required();
            }
        }
        if (customWebServiceDTO.isUseIpWhitelist()) {
            validator.property((Property)CustomWebServiceDTO.IP_WHITELIST, SystemKeys.WebServices.IP_WHITELIST).required().internetAddressList();
        }
        return validator;
    }

    private void ensureIpAddressIsWhitelisted(String string, CustomWebService customWebService) {
        if (!this.internetAddressListHandler.isWhitelisted(customWebService.getWhitelist(), string)) {
            throw new UnauthorizedAddressException();
        }
    }

    private void evictCache() {
        Network network = this.getSessionData().getNetwork();
        this.cacheHandler.scheduleEvict(CacheType.CUSTOM_WS, (Serializable)network.getId());
    }

    private Map<String, Long> getMapping(Long l) {
        return (Map)this.cache.get((Serializable)l, () -> {
            HashMap hashMap = new HashMap();
            this.from().stream(new Expression[]{((QCustomWebService)this.$).id, ((QCustomWebService)this.$).urlMappings}).forEach(tuple -> {
                Long l = (Long)tuple.get((Expression)((QCustomWebService)this.$).id);
                this.parseMappings((String)tuple.get((Expression)((QCustomWebService)this.$).urlMappings)).forEach(string -> hashMap.put(string, l));
            });
            return hashMap;
        });
    }

    private List<String> parseMappings(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringHelper.forEachLine((String)string2, (boolean)true, string -> arrayList.add(StringUtils.strip((String)string, (String)"/")));
        return arrayList;
    }

    private Pair<CustomWebService, Map<String, String>> resolve(String string, Map<String, Long> map) {
        Comparator comparator = this.pathMatcher.getPatternComparator(string);
        List list = CollectionHelper.sort(map.keySet(), (Comparator)comparator);
        for (String string2 : list) {
            if (!this.pathMatcher.match(string2, string)) continue;
            Long l = map.get(string2);
            Map map2 = this.pathMatcher.extractUriTemplateVariables(string2, string);
            return Pair.create((Object)((CustomWebService)this.find(l)), (Object)map2);
        }
        return Pair.create(null, null);
    }

    private /* synthetic */ Object lambda$run$0(CustomWebServiceContext customWebServiceContext, ParameterStorage parameterStorage) throws Exception {
        CustomWebService customWebService = customWebServiceContext.getCustomWebService();
        return this.customScriptService.newAccessor(customWebService.getScript(), customWebService.getScriptParameters()).bind("customWebService", (Object)customWebService).bind("request", (Object)customWebServiceContext.getRequest()).bind("path", (Object)customWebServiceContext.getPath()).bind("pathVariables", (Object)parameterStorage).run();
    }
}

