/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.contentmanagement.MenuEntry;
import org.cyclos.entities.contentmanagement.MenuGroup;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.CustomWizardFieldPossibleValue;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.entities.system.EmailVerificationWizardStep;
import org.cyclos.entities.system.FormFieldsWizardStep;
import org.cyclos.entities.system.FormFieldsWizardStepField;
import org.cyclos.entities.system.GroupSelectionWizardStep;
import org.cyclos.entities.system.IdentityProviderWizardStep;
import org.cyclos.entities.system.MenuItemWizard;
import org.cyclos.entities.system.PhoneVerificationWizardStep;
import org.cyclos.entities.system.QCustomWizard;
import org.cyclos.entities.system.QCustomWizardExecution;
import org.cyclos.entities.system.QMenuItemWizard;
import org.cyclos.entities.system.QRegistrationWizard;
import org.cyclos.entities.system.QSystemWizard;
import org.cyclos.entities.system.QUserWizard;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.system.SystemWizard;
import org.cyclos.entities.system.TempCustomFieldValue;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.system.VerificationWizardStep;
import org.cyclos.entities.system.WizardWithChannels;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.InviteToken;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QMemberProductCustomWizard;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.EntityBackedParameterStorage;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.messaging.InviteServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.CustomWizardExecutionStorage;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.CustomWizardStepWithTransitions;
import org.cyclos.impl.system.CustomWizardTransition;
import org.cyclos.impl.system.FormFieldsWizardStepMeta;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.IdentityProviderProfile;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RegisterUserByWizardResult;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.users.UserValidationFields;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.CustomWizardScriptFunction;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.wizards.CustomWizardAction;
import org.cyclos.model.system.wizards.CustomWizardBackParams;
import org.cyclos.model.system.wizards.CustomWizardDTO;
import org.cyclos.model.system.wizards.CustomWizardData;
import org.cyclos.model.system.wizards.CustomWizardExecutionData;
import org.cyclos.model.system.wizards.CustomWizardNature;
import org.cyclos.model.system.wizards.CustomWizardResultType;
import org.cyclos.model.system.wizards.CustomWizardResultVO;
import org.cyclos.model.system.wizards.CustomWizardTransitionParams;
import org.cyclos.model.system.wizards.CustomWizardTransitionVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.system.wizards.CustomWizardVerificationCodeParams;
import org.cyclos.model.system.wizards.DirectWizardDTO;
import org.cyclos.model.system.wizards.MenuItemWizardDTO;
import org.cyclos.model.system.wizards.RegistrationWizardDTO;
import org.cyclos.model.system.wizards.RunCustomWizardConfirmationField;
import org.cyclos.model.system.wizards.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.wizards.StartCustomWizardParams;
import org.cyclos.model.system.wizards.SystemWizardDTO;
import org.cyclos.model.system.wizards.UserWizardDTO;
import org.cyclos.model.system.wizards.WizardWithChannelsDTO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDetailedVO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepFieldDefinitionType;
import org.cyclos.model.system.wizardsteps.CustomWizardStepNature;
import org.cyclos.model.system.wizardsteps.CustomWizardStepVO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepFieldVO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepVO;
import org.cyclos.model.system.wizardsteps.GroupSelectionWizardStepVO;
import org.cyclos.model.system.wizardsteps.IdentityProviderWizardStepVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.fields.UserCustomFieldVO;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.fields.UserCustomFieldValueVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneConfigurationData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.ValidateRegistrationFieldParams;
import org.cyclos.model.utils.AdminMainMenu;
import org.cyclos.model.utils.ProfileManagementSection;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.AddressHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.PublicRegistrationHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomWizardServiceImpl
extends CRUDServiceImpl<CustomWizard, QCustomWizard, CustomWizardDTO, CustomWizardData, CustomWizardNature>
implements CustomWizardServiceLocal {
    private static final QCustomWizardExecution e = QCustomWizardExecution.customWizardExecution;
    private static final BidiMap<Class<? extends CustomWizard>, Class<? extends CustomWizardDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private InviteServiceLocal inviteService;
    @Autowired
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    protected StoredFileHandler storedFileHandler;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentServiceLocal;
    @Autowired
    private OtpHandler otpHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private ImageHandler imageHandler;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private BasicUserServiceLocal basicUserService;

    public CustomWizardServiceImpl() {
        super(CustomWizard.class, QCustomWizard.customWizard, CustomWizardDTO.class);
    }

    public CustomWizardExecutionData back(@NotNull CustomWizardBackParams customWizardBackParams) throws FrameworkException {
        CustomWizardExecution customWizardExecution = this.findExecution(customWizardBackParams.getKey());
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        List<Object> list = customWizardExecutionStorage.getSteps();
        int n = (Integer)ObjectHelper.defaultValue((Object)customWizardBackParams.getSteps(), (Object)1);
        list = n >= list.size() ? Collections.emptyList() : list.subList(0, list.size() - n);
        customWizardExecutionStorage.setSteps(list);
        CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last(list);
        if (customWizardStepWithTransitions == null) {
            throw new IllegalActionException("No current step in the wizard execution");
        }
        CustomWizardStep customWizardStep = customWizardStepWithTransitions.getStep();
        if (customWizardStep instanceof EmailVerificationWizardStep ? customWizardExecutionStorage.getVerifiedEmail() != null : customWizardStep instanceof PhoneVerificationWizardStep && customWizardExecutionStorage.getVerifiedSms() != null) {
            return this.back(customWizardBackParams);
        }
        customWizardExecutionStorage.clearNotification();
        return this.toExecutionData(customWizardExecution, customWizardExecutionStorage, list);
    }

    public void cancel(String string) throws FrameworkException {
        this.delete((EntityPath<?>)e).where(new Predicate[]{CustomWizardServiceImpl.e.key.eq((Object)string)}).execute();
    }

    public CustomWizardExecutionData current(@NotNull String string) throws FrameworkException {
        CustomWizardExecution customWizardExecution = this.findExecution(string);
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        List list = customWizardExecutionStorage.getSteps();
        return this.toExecutionData(customWizardExecution, customWizardExecutionStorage, list);
    }

    public String externalRedirect(@NotNull CustomWizardTransitionParams customWizardTransitionParams) throws FrameworkException {
        CustomWizardExecution customWizardExecution = this.findExecution(customWizardTransitionParams.getKey());
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        List list = customWizardExecutionStorage.getSteps();
        CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last((List)list);
        if (customWizardStepWithTransitions == null) {
            throw new IllegalActionException("No current step in the wizard execution");
        }
        CustomWizardStep customWizardStep = customWizardStepWithTransitions.getStep();
        if (!(customWizardStep instanceof FormFieldsWizardStep) || !((FormFieldsWizardStep)customWizardStep).isExternalRedirect()) {
            throw new IllegalActionException("The current step doesn't allow an external redirect");
        }
        this.storeStepData(customWizardExecution, customWizardExecutionStorage, customWizardStepWithTransitions, customWizardTransitionParams);
        String string = this.linkGeneratorHandler.customWizardExternalRedirect(customWizardExecution, customWizardExecutionStorage);
        CustomWizard customWizard = customWizardExecution.getWizard();
        customWizardExecutionStorage.clearNotification();
        String string2 = null;
        if (customWizard.getScript() != null) {
            string2 = (String)this.script(customWizardExecution).bind("returnUrl", (Object)string).run(String.class, (ScriptFunction)CustomWizardScriptFunction.EXTERNAL_REDIRECT);
        }
        if (StringHelper.isBlank(string2)) {
            throw new CustomScriptException("No external redirect URL returned by the script for wizard " + String.valueOf(customWizard));
        }
        return string2;
    }

    public CustomWizardExecution findExecution(String string) {
        if (string == null) {
            throw new EntityNotFoundException(CustomWizardExecution.class);
        }
        return (CustomWizardExecution)((DBQuery)this.from(new EntityPath[]{e}).where((Predicate)CustomWizardServiceImpl.e.key.eq((Object)string))).requiredUniqueResult((Expression)e);
    }

    public UserGroup getGroup(CustomWizardExecution customWizardExecution) {
        if (customWizardExecution == null || !(customWizardExecution.getWizard() instanceof RegistrationWizard)) {
            return null;
        }
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        try {
            return this.getGroup(customWizardExecutionStorage);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<MenuItemWizard> getRunnableWizardsForMenu() {
        Configuration configuration = this.getConfiguration().getConfiguration();
        EnumSet<ContentItemVisibility> enumSet = EnumSet.of(ContentItemVisibility.ALL, this.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
        ArrayList<MenuItemWizard> arrayList = new ArrayList<MenuItemWizard>();
        List list = this.menuEntryService.list(null, configuration, false, enumSet, false);
        for (MenuEntry menuEntry : list) {
            if (menuEntry instanceof MenuGroup) {
                MenuGroup menuGroup = (MenuGroup)menuEntry;
                for (MenuEntry menuEntry2 : menuGroup.getEntries()) {
                    if (!enumSet.contains(menuEntry2.getVisibility()) || !(menuEntry2 instanceof MenuItem)) continue;
                    this.addWizardIfAvailable(arrayList, menuEntry2);
                }
                continue;
            }
            if (!(menuEntry instanceof MenuItem)) continue;
            this.addWizardIfAvailable(arrayList, menuEntry);
        }
        return CollectionHelper.sort(arrayList);
    }

    public CustomWizardExecutionStorage getStorage(PublicRegistrationDTO publicRegistrationDTO) {
        return (CustomWizardExecutionStorage)publicRegistrationDTO.getAttribute("storage");
    }

    public CustomWizardExecutionData identityProviderCallback(CustomWizardExecution customWizardExecution, CommonProfile commonProfile, IdentityProviderCallbackResult identityProviderCallbackResult) {
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last((List)customWizardExecutionStorage.getSteps());
        if (customWizardStepWithTransitions == null || CollectionHelper.isEmpty((Iterable)customWizardStepWithTransitions.getTransitions())) {
            throw new IllegalActionException("No possible transitions from this wizard step");
        }
        if (!(customWizardStepWithTransitions.getStep() instanceof IdentityProviderWizardStep)) {
            throw new IllegalActionException("The current wizard step isn't identity provider");
        }
        UserGroup userGroup = this.getGroup(customWizardExecutionStorage);
        PublicRegistrationData publicRegistrationData = this.userService.getPublicRegistrationData(new InitialGroupVO(userGroup.getId()), null, null);
        PublicRegistrationHelper.fillFromIdentityProvider((PublicRegistrationData)publicRegistrationData, (IdentityProviderCallbackResult)identityProviderCallbackResult);
        this.ensurePublicRegistrationDto(publicRegistrationData, customWizardExecutionStorage);
        IdentityProvider identityProvider = (IdentityProvider)this.conversionHandler.convert(IdentityProvider.class, (Object)identityProviderCallbackResult.getIdentityProvider());
        customWizardExecutionStorage.setIdentityProviderId(identityProvider.getId());
        customWizardExecutionStorage.setIdentityProviderProfile(IdentityProviderProfile.fromPac4j((CommonProfile)commonProfile));
        if (StringHelper.isNotBlank((Object)commonProfile.getEmail())) {
            customWizardExecutionStorage.setVerifiedEmail(commonProfile.getEmail());
        }
        CustomWizardTransitionParams customWizardTransitionParams = new CustomWizardTransitionParams();
        customWizardTransitionParams.setKey(customWizardExecution.getKey());
        customWizardTransitionParams.setTransition(((CustomWizardTransition)CollectionHelper.first((Iterable)customWizardStepWithTransitions.getTransitions())).getId());
        return this.transition(customWizardTransitionParams);
    }

    public List<CustomWizardResultVO> list() throws FrameworkException {
        List list = ((DBQuery)this.from().orderBy(((QCustomWizard)this.$).order.asc())).list(CustomWizardResultVO.class, (Expression)this.$);
        for (CustomWizardResultVO customWizardResultVO : list) {
            if (customWizardResultVO.getChannels() == null) continue;
            Collections.sort(customWizardResultVO.getChannels());
        }
        return list;
    }

    public List<UserWizard> listForRun(User user) {
        SessionData sessionData = this.getSessionData();
        if (user == null || user.isAdmin()) {
            return Collections.emptyList();
        }
        if (sessionData.isSystem()) {
            return this.listUserWizards();
        }
        BooleanPropertiesHolder booleanPropertiesHolder = this.productsHandler.getAccessor((BasicUser)user).member().getWizards();
        QMemberProductCustomWizard qMemberProductCustomWizard = QMemberProductCustomWizard.memberProductCustomWizard;
        if (user.equals((Object)sessionData.getLoggedUser())) {
            return CollectionHelper.sort((Collection)booleanPropertiesHolder.keysSet((Path)qMemberProductCustomWizard.run));
        }
        if (sessionData.isManagerOf((BasicUser)user)) {
            Set set = booleanPropertiesHolder.keysSet((Path)qMemberProductCustomWizard.enabled);
            List list = sessionData.getProducts().userManagement().getUserWizards();
            list.retainAll(set);
            return list;
        }
        return Collections.emptyList();
    }

    public List<MenuItemWizard> listMenuWizards() {
        QMenuItemWizard qMenuItemWizard = QMenuItemWizard.menuItemWizard;
        return ((DBQuery)this.selectFrom(qMenuItemWizard).orderBy(qMenuItemWizard.order.asc())).fetch();
    }

    public List<RegistrationWizard> listRegistrationWizards() {
        QRegistrationWizard qRegistrationWizard = QRegistrationWizard.registrationWizard;
        return ((DBQuery)this.selectFrom(qRegistrationWizard).orderBy(qRegistrationWizard.order.asc())).fetch();
    }

    public List<SystemWizard> listSystemForRun() {
        return this.getSessionData().getProducts().admin().getSystemWizardsRun();
    }

    public List<SystemWizard> listSystemWizards() {
        QSystemWizard qSystemWizard = QSystemWizard.systemWizard;
        return ((DBQuery)this.selectFrom(qSystemWizard).orderBy(qSystemWizard.order.asc())).fetch();
    }

    public List<UserWizard> listUserWizards() {
        QUserWizard qUserWizard = QUserWizard.userWizard;
        return ((DBQuery)this.selectFrom(qUserWizard).orderBy(qUserWizard.order.asc())).fetch();
    }

    @Override
    public CustomWizard newEntity(CustomWizardNature customWizardNature) {
        WizardWithChannels wizardWithChannels;
        RegistrationWizard registrationWizard = null;
        if (customWizardNature != null) {
            switch (customWizardNature) {
                case REGISTRATION: {
                    registrationWizard = new RegistrationWizard();
                    registrationWizard.setResultType(CustomWizardResultType.REGISTRATION);
                    break;
                }
                case SYSTEM: {
                    wizardWithChannels = new SystemWizard();
                    wizardWithChannels.setAdminMenu(AdminMainMenu.SYSTEM_BANKING);
                    registrationWizard = wizardWithChannels;
                    break;
                }
                case USER: {
                    UserWizard userWizard = new UserWizard();
                    userWizard.setUserMenu(UserMainMenu.BANKING);
                    userWizard.setProfileSection(ProfileManagementSection.ACCOUNTS);
                    registrationWizard = userWizard;
                    break;
                }
                case MENU: {
                    registrationWizard = new MenuItemWizard();
                }
            }
        }
        if (registrationWizard == null) {
            throw new IllegalActionException("Invalid nature: " + String.valueOf(customWizardNature));
        }
        if (registrationWizard instanceof WizardWithChannels) {
            wizardWithChannels = (WizardWithChannels)registrationWizard;
            wizardWithChannels.setChannels(CollectionHelper.asSet((Object[])new Channel[]{this.channelService.getMain(), this.channelService.getWebServices()}));
        }
        if (registrationWizard.getNature().isRelatedToMenu()) {
            registrationWizard.setResultType(CustomWizardResultType.RICH_TEXT);
        }
        return registrationWizard;
    }

    public CustomWizardExecutionData runExternalRedirectCallback(@NotNull RunExternalRedirectCallbackParams runExternalRedirectCallbackParams) throws FrameworkException {
        DirectUserSessionData directUserSessionData;
        CustomWizardExecution customWizardExecution = this.findExecution(runExternalRedirectCallbackParams.getKey());
        if (customWizardExecution.getUser() == null) {
            SessionData sessionData = this.getSessionData();
            directUserSessionData = SessionDataFactory.guest((RequestData)sessionData.getRequestData(), (String)customWizardExecution.getChannel().getInternalName());
        } else {
            directUserSessionData = SessionDataFactory.direct((UserPrincipal)customWizardExecution).channel(customWizardExecution.getChannel().getInternalName()).build();
        }
        return (CustomWizardExecutionData)this.invokerHandler.runAs((SessionData)directUserSessionData, () -> {
            Map map;
            CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
            List list = customWizardExecutionStorage.getSteps();
            CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last((List)list);
            if (customWizardStepWithTransitions == null) {
                throw new IllegalActionException("No current step in the wizard execution");
            }
            CustomWizardStep customWizardStep = customWizardStepWithTransitions.getStep();
            if (!(customWizardStep instanceof FormFieldsWizardStep) || !((FormFieldsWizardStep)customWizardStep).isExternalRedirect()) {
                throw new IllegalActionException("The current step doesn't allow an external redirect");
            }
            if (CollectionHelper.isEmpty((Iterable)customWizardStepWithTransitions.getTransitions())) {
                throw new IllegalActionException("No possible transitions from this wizard step");
            }
            CustomWizard customWizard = customWizardExecution.getWizard();
            Object object = null;
            if (customWizard.getScript() != null) {
                object = this.script(customWizardExecution).bind("request", (Object)runExternalRedirectCallbackParams.getRequest()).run((ScriptFunction)CustomWizardScriptFunction.CALLBACK);
            }
            if (Boolean.FALSE.equals(object)) {
                return this.toExecutionData(customWizardExecution, customWizardExecutionStorage, list);
            }
            customWizardExecutionStorage.setStepExecuted(customWizardStep, true);
            String string = object == null || Boolean.TRUE.equals(object) ? ((CustomWizardTransition)CollectionHelper.first((Iterable)customWizardStepWithTransitions.getTransitions())).getId() : (object instanceof CharSequence ? object.toString() : ((map = (Map)this.conversionHandler.convert(Map.class, object)).containsKey("id") ? map.get("id").toString() : "\u0000"));
            if (!customWizardStepWithTransitions.getTransitions().stream().anyMatch(customWizardTransition -> string.equals(customWizardTransition.getId()))) {
                throw new CustomScriptException("The script for step " + String.valueOf(customWizardStep) + " didn't return a valid transition: " + String.valueOf(object));
            }
            return this.doTransition(customWizardExecution, string, null, false);
        });
    }

    public void sendVerificationCode(@NotNull CustomWizardVerificationCodeParams customWizardVerificationCodeParams) throws FrameworkException {
        CustomWizardExecution customWizardExecution = this.findExecution(customWizardVerificationCodeParams.getKey());
        if (!(customWizardExecution.getWizard() instanceof RegistrationWizard)) {
            throw new IllegalActionException("Expected a registration wizard");
        }
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        UserGroup userGroup = this.getGroup(customWizardExecutionStorage);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)userGroup);
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)CustomWizardVerificationCodeParams.MEDIUM, AccessKeys.Devices.SEND_MEDIUM).required();
        Property property = validator.property((org.cyclos.model.Property)CustomWizardVerificationCodeParams.TO, BankingKeys.Accounts.TO);
        PublicRegistrationDTO publicRegistrationDTO = customWizardExecutionStorage.getRegistration();
        if (customWizardVerificationCodeParams.getMedium() == SendMedium.SMS) {
            property.phoneNumber(configurationAccessor, PhoneNature.MOBILE);
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)CollectionHelper.first((Iterable)publicRegistrationDTO.getMobilePhones());
            if (mobilePhoneDTO == null || StringHelper.isBlank((Object)mobilePhoneDTO.getRawNumber())) {
                property.required();
            } else if (StringHelper.isBlank((Object)customWizardVerificationCodeParams.getTo())) {
                customWizardVerificationCodeParams.setTo(mobilePhoneDTO.getRawNumber());
            }
        } else {
            property.email();
            String string = publicRegistrationDTO.getEmail();
            if (StringHelper.isBlank((Object)string)) {
                property.required();
            } else if (StringHelper.isBlank((Object)customWizardVerificationCodeParams.getTo())) {
                customWizardVerificationCodeParams.setTo(string);
            }
        }
        this.validate(validator, customWizardVerificationCodeParams, "sendVerificationCode");
        this.sendVerificationCode(customWizardExecution, customWizardVerificationCodeParams.getMedium(), customWizardVerificationCodeParams.getTo());
    }

    public CustomWizardExecutionData start(StartCustomWizardParams startCustomWizardParams) throws FrameworkException {
        String string;
        ExternalPayment externalPayment;
        Object object;
        Object object2;
        MenuItem menuItem = (MenuItem)this.conversionHandler.convert(MenuItem.class, (Object)startCustomWizardParams.getMenuItem());
        MenuItemWizard menuItemWizard = menuItem != null ? menuItem.getWizard() : (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)startCustomWizardParams.getWizard());
        User user = null;
        if (menuItemWizard instanceof UserWizard) {
            user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)startCustomWizardParams.getUser());
        }
        SessionData sessionData = this.getSessionData();
        CustomWizardExecution customWizardExecution = new CustomWizardExecution();
        customWizardExecution.setKey(RandomStringUtils.randomAlphanumeric((int)32));
        customWizardExecution.setWizard((CustomWizard)menuItemWizard);
        customWizardExecution.setDate(new Date());
        customWizardExecution.setChannel(sessionData.getChannel());
        customWizardExecution.setRemoteAddress(sessionData.getRemoteAddress());
        customWizardExecution.initFrom((UserPrincipal)sessionData);
        customWizardExecution.setUser(user);
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        if (menuItem != null) {
            customWizardExecutionStorage.setMenuItem(menuItem);
        }
        if (menuItemWizard instanceof RegistrationWizard) {
            customWizardExecutionStorage.setUserAgentId(startCustomWizardParams.getUserAgentId());
            object2 = this.inviteService.inviteToken(startCustomWizardParams.getInviteToken());
            if (object2 != null) {
                customWizardExecutionStorage.setInviteToken(object2);
                customWizardExecutionStorage.setVerifiedEmail(object2.getEmail());
            } else {
                object = startCustomWizardParams.getExternalPaymentToken();
                if (object != null) {
                    customWizardExecutionStorage.setExternalPaymentToken((String)object);
                    externalPayment = this.externalPaymentServiceLocal.findByToken((String)object);
                    string = externalPayment.getToPrincipalType().getInternalName();
                    if (string.equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                        customWizardExecutionStorage.setVerifiedEmail(externalPayment.getToPrincipalValue());
                    } else if (string.equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                        customWizardExecutionStorage.setVerifiedSms(externalPayment.getToPrincipalValue());
                    }
                }
            }
        }
        object2 = null;
        if (menuItemWizard.getScript() != null) {
            object2 = this.script(customWizardExecution).run((ScriptFunction)CustomWizardScriptFunction.START);
        }
        if (object2 == null) {
            object2 = CollectionHelper.first((Iterable)menuItemWizard.getSteps());
        }
        if (object2 == null) {
            throw new IllegalActionException("No initial wizard step for " + String.valueOf(menuItemWizard));
        }
        object = this.toStepWithTransitions(customWizardExecution, object2);
        externalPayment = Collections.singletonList(object);
        customWizardExecutionStorage.setSteps(externalPayment);
        if (menuItemWizard instanceof RegistrationWizard) {
            string = (UserGroup)CollectionHelper.first((Iterable)sessionData.getConfiguration().getPossibleInitialGroups());
            if (string == null) {
                throw new ValidationException(this.message(UsersKeys.Users.INITIAL_GROUP_ERROR_NO_GROUPS, new Object[0]));
            }
            this.ensurePublicRegistrationDto((UserGroup)string, customWizardExecutionStorage);
        }
        this.persist((IEntity)customWizardExecution);
        return this.toExecutionData(customWizardExecution, customWizardExecutionStorage, (List<CustomWizardStepWithTransitions>)externalPayment);
    }

    public CustomWizardExecutionStorage storage(CustomWizardExecution customWizardExecution) {
        CustomWizardExecutionStorage customWizardExecutionStorage = (CustomWizardExecutionStorage)customWizardExecution.getStorage();
        if (customWizardExecutionStorage == null) {
            customWizardExecutionStorage = new CustomWizardExecutionStorage(this.jacksonConfiguration.getObjectMapper(), customWizardExecution, this.conversionHandler);
            customWizardExecution.setStorage((EntityBackedParameterStorage)customWizardExecutionStorage);
        }
        return customWizardExecutionStorage;
    }

    public CustomWizardExecutionData transition(CustomWizardTransitionParams customWizardTransitionParams) throws FrameworkException {
        CustomWizardExecution customWizardExecution = this.findExecution(customWizardTransitionParams.getKey());
        return this.doTransition(customWizardExecution, customWizardTransitionParams.getTransition(), customWizardTransitionParams, false);
    }

    @Override
    protected CustomWizardData getData(CustomWizard customWizard) {
        CustomWizardData customWizardData = new CustomWizardData();
        customWizardData.setNature(customWizard.getNature());
        customWizardData.setDto((EntityDTO)((CustomWizardDTO)this.toDTO(customWizard)));
        customWizardData.setStepNatures(Stream.of(CustomWizardStepNature.values()).filter(customWizardStepNature -> customWizardStepNature.wizardNatures().contains(customWizard.getNature())).collect(Collectors.toList()));
        customWizardData.setSteps(this.conversionHandler.convertList(CustomWizardStepVO.class, (Iterable)customWizard.getSteps()));
        customWizardData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.CUSTOM_WIZARD)));
        if (customWizard.isPersistent()) {
            customWizardData.setCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)customWizard.getCustomFields()));
        }
        if (customWizard instanceof WizardWithChannels) {
            List list = this.channelService.listAll();
            list.removeIf(channel -> !channel.isAllowOperations());
            if (customWizard.getNature() == CustomWizardNature.MENU) {
                list.removeIf(Channel::isMobile);
            }
            customWizardData.setChannels(this.conversionHandler.convertList(ChannelVO.class, (Iterable)list));
        }
        return customWizardData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomWizard)this.$).network());
    }

    @Override
    protected void remove(IEntity iEntity) {
        if (iEntity instanceof CustomWizardExecution) {
            this.removeFiles((CustomWizardExecution)iEntity);
        }
        super.remove(iEntity);
    }

    @Override
    protected Validator resolveValidator(CustomWizardDTO customWizardDTO) {
        Validator validator = new Validator();
        Property property = validator.property((org.cyclos.model.Property)CustomWizardDTO.SCRIPT, SystemKeys.Wizards.SCRIPT);
        Property property2 = validator.property((org.cyclos.model.Property)CustomWizardDTO.RESULT_TYPE, SystemKeys.Wizards.RESULT_TYPE).required();
        if (customWizardDTO instanceof RegistrationWizardDTO) {
            property2.anyOf(new Object[]{CustomWizardResultType.REGISTRATION});
            validator.property((org.cyclos.model.Property)RegistrationWizardDTO.INCOMPLETE_REGISTRATION_NOTIFY_INTERVAL, SystemKeys.Wizards.NOTIFY_ON_INCOMPLETE_REGISTRATION).lessThan((Comparable)new TimeInterval(Integer.valueOf(1), TimeField.MONTHS));
        } else if (customWizardDTO instanceof DirectWizardDTO || customWizardDTO instanceof MenuItemWizardDTO) {
            property.required();
            property2.anyOf(new Object[]{CustomWizardResultType.RICH_TEXT, CustomWizardResultType.PLAIN_TEXT});
        }
        property.entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.CUSTOM_WIZARD;
            }
        });
        if (customWizardDTO instanceof WizardWithChannelsDTO) {
            validator.property((org.cyclos.model.Property)DirectWizardDTO.CHANNELS, SystemKeys.Wizards.CHANNELS).entity(Channel.class, (EntityValidation)new BaseEntityValidation<Channel>(){

                protected boolean isValid(Object object, Object object2, Channel channel) {
                    return channel.isAllowOperations();
                }
            });
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends CustomWizard>, Class<? extends CustomWizardDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void addWizardIfAvailable(List<MenuItemWizard> list, MenuEntry menuEntry) {
        MenuItem menuItem = (MenuItem)menuEntry;
        if (menuItem.getType() == MenuItemType.WIZARD) {
            MenuItemWizard menuItemWizard = menuItem.getWizard();
            list.add(menuItemWizard);
        }
    }

    private CustomWizardStep candidateNextStep(CustomWizardStepWithTransitions customWizardStepWithTransitions, CustomWizardTransition customWizardTransition) {
        CustomWizardStep customWizardStep = null;
        CustomWizard customWizard = customWizardStepWithTransitions.getStep().getWizard();
        if (customWizardTransition != null && !"next".equals(customWizardTransition.getId())) {
            try {
                customWizardStep = this.toStep(customWizard, customWizardTransition.getId());
            }
            catch (CustomScriptException customScriptException) {
                // empty catch block
            }
        }
        if (customWizardStep == null) {
            int n = customWizard.getSteps().indexOf(customWizardStepWithTransitions.getStep());
            if (n < customWizard.getSteps().size() - 1) {
                customWizardStep = (CustomWizardStep)customWizard.getSteps().get(n + 1);
            } else {
                throw new ValidationException("Cannot transition, there's no possible next step");
            }
        }
        return customWizardStep;
    }

    private CredentialInputDTO doGetCredentialInputForRun(CustomWizard customWizard) {
        if (customWizard.isRequireConfirmationCredential()) {
            return this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput();
        }
        return null;
    }

    private CustomWizardExecutionData doTransition(CustomWizardExecution customWizardExecution, String string, CustomWizardTransitionParams customWizardTransitionParams, boolean bl) {
        boolean bl2;
        boolean bl3;
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        List list = customWizardExecutionStorage.getSteps();
        CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last((List)list);
        if (customWizardStepWithTransitions == null) {
            throw new IllegalActionException("No current step in the wizard execution");
        }
        CustomWizardStep customWizardStep = customWizardStepWithTransitions.getStep();
        boolean bl4 = customWizardExecutionStorage.isStepExecuted(customWizardStep);
        if (customWizardStep instanceof FormFieldsWizardStep && (bl3 = ((FormFieldsWizardStep)customWizardStep).isExternalRedirect()) && !bl4 && !bl) {
            throw new IllegalActionException("Cannot transition an external redirect step");
        }
        if (!bl4 && customWizardTransitionParams != null) {
            this.storeStepData(customWizardExecution, customWizardExecutionStorage, customWizardStepWithTransitions, customWizardTransitionParams);
        }
        CustomWizard customWizard = customWizardExecution.getWizard();
        customWizardExecutionStorage.clearNotification();
        boolean bl5 = bl2 = string == null;
        if (bl2) {
            if (CollectionHelper.isNotEmpty((Iterable)customWizardStepWithTransitions.getTransitions())) {
                throw new ValidationException(CustomWizardTransitionParams.TRANSITION.getName(), this.message(GeneralKeys.Errors.REQUIRED, SystemKeys.Wizards.TRANSITION));
            }
            if (customWizard.isRequireConfirmationCredential()) {
                this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(customWizardTransitionParams.getConfirmationPassword(), RunCustomWizardConfirmationField.confirmation((CustomWizardVO)new CustomWizardVO(customWizard.getId())));
            }
            return this.finish(customWizardExecution, customWizardExecutionStorage);
        }
        CustomWizardTransition customWizardTransition2 = CollectionHelper.orEmpty((List)customWizardStepWithTransitions.getTransitions()).stream().filter(customWizardTransition -> string.equals(customWizardTransition.getId())).findFirst().orElseThrow(() -> new ValidationException("Invalid transition: " + string));
        CustomWizardStep customWizardStep2 = this.candidateNextStep(customWizardStepWithTransitions, customWizardTransition2);
        Object object = null;
        if (customWizard.getScript() != null) {
            object = this.script(customWizardExecution).bind("previousStep", (Object)customWizardStep).bind("step", (Object)customWizardStep2).bind("transition", (Object)customWizardTransition2).run((ScriptFunction)CustomWizardScriptFunction.TRANSITION);
        }
        return this.handleTransitionFromScript(object, customWizardExecution, customWizardExecutionStorage, list, customWizardTransition2, customWizardStep2);
    }

    private void ensurePublicRegistrationDto(PublicRegistrationData publicRegistrationData, CustomWizardExecutionStorage customWizardExecutionStorage) {
        PublicRegistrationDTO publicRegistrationDTO = (PublicRegistrationDTO)publicRegistrationData.getDto();
        String string = customWizardExecutionStorage.getUserAgentId();
        publicRegistrationDTO.setUserAgentId(string);
        customWizardExecutionStorage.setRegistration(publicRegistrationDTO);
    }

    private void ensurePublicRegistrationDto(UserGroup userGroup, CustomWizardExecutionStorage customWizardExecutionStorage) {
        InitialGroupVO initialGroupVO = new InitialGroupVO(userGroup.getId());
        InviteToken inviteToken = customWizardExecutionStorage.getInviteToken();
        String string = customWizardExecutionStorage.getExternalPaymentToken();
        PublicRegistrationData publicRegistrationData = this.userService.getPublicRegistrationData(initialGroupVO, inviteToken == null ? null : inviteToken.getToken(), string);
        this.ensurePublicRegistrationDto(publicRegistrationData, customWizardExecutionStorage);
    }

    private void fillParams(CustomWizardExecutionData customWizardExecutionData, CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage, CustomWizardTransitionParams customWizardTransitionParams, FormFieldsWizardStep formFieldsWizardStep, FormFieldsWizardStepMeta formFieldsWizardStepMeta) {
        CustomWizardStepDetailedVO customWizardStepDetailedVO;
        CustomWizard customWizard = customWizardExecution.getWizard();
        UserGroup userGroup = this.getGroupOrNull(customWizardExecutionStorage);
        if (userGroup != null) {
            customWizardTransitionParams.setGroup((GroupVO)this.conversionHandler.convert(GroupVO.class, (Object)userGroup));
        }
        if ((customWizardStepDetailedVO = customWizardExecutionData.getStep()) instanceof FormFieldsWizardStepVO) {
            Object object;
            Object object2;
            FormFieldsWizardStepVO formFieldsWizardStepVO = (FormFieldsWizardStepVO)customWizardStepDetailedVO;
            if (customWizard instanceof RegistrationWizard && (object2 = formFieldsWizardStepVO.getRegistrationData()) != null) {
                Object object3;
                object2.setDto(null);
                object = new PublicRegistrationDTO();
                customWizardExecutionStorage.getRegistration().copyPropertiesTo((Bean)object);
                object.setPasswords(null);
                customWizardTransitionParams.setUser((PublicRegistrationDTO)object);
                String string = customWizardExecutionStorage.getVerifiedEmail();
                if (StringHelper.isNotBlank((Object)string)) {
                    formFieldsWizardStepVO.setVerifiedEmail(string);
                }
                if (StringHelper.isNotBlank((Object)(object3 = customWizardExecutionStorage.getVerifiedSms()))) {
                    formFieldsWizardStepVO.setVerifiedSms((String)object3);
                }
                formFieldsWizardStepVO.setVerificationCodeSeconds(30);
            }
            if ((object2 = formFieldsWizardStepVO.getCustomFields()) == null) {
                object2 = new ArrayList();
                formFieldsWizardStepVO.setCustomFields((List)object2);
            }
            this.customFieldValueHandler.setDefaultValues((List)object2, (ModelWithCustomValues)customWizardTransitionParams);
            customWizardTransitionParams.setCustomValues(new ArrayList());
            object = customWizardExecutionStorage.getCustomValues();
            for (Object object3 : formFieldsWizardStepMeta.getWizardFields(true)) {
                Object object4;
                CustomFieldValueDTO customFieldValueDTO;
                Object object5 = object.get(object3.getInternalName());
                if (object5 == null && (customFieldValueDTO = (CustomFieldDetailedVO)formFieldsWizardStepVO.getCustomFields().stream().filter(arg_0 -> CustomWizardServiceImpl.lambda$fillParams$6((CustomWizardField)object3, arg_0)).findAny().orElse(null)) != null && (object4 = CustomFieldHelper.getDefaultValue((CustomFieldDetailedVO)customFieldValueDTO)) != null) {
                    object5 = this.customFieldValueHandler.getValue((CustomField)object3, object4, false);
                    object.put(object3.getInternalName(), object5);
                    if (InvocationContext.get().getTransactionLevel() == TransactionLevel.READ_WRITE) {
                        customWizardExecutionStorage.setCustomValues((Map)object);
                    }
                }
                if (object5 == null) continue;
                customFieldValueDTO = new CustomFieldValueDTO();
                customFieldValueDTO.setField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, object3));
                this.customFieldValueHandler.setModelValue((CustomField)object3, object5, (ICustomFieldValue)customFieldValueDTO);
                customWizardTransitionParams.getCustomValues().add(customFieldValueDTO);
            }
            formFieldsWizardStepVO.getFields().stream().filter(FormFieldsWizardStepFieldVO::isReadOnly).filter(formFieldsWizardStepFieldVO -> this.hasValue(this.findField(formFieldsWizardStep, (FormFieldsWizardStepFieldVO)formFieldsWizardStepFieldVO), customWizardExecution)).forEach(formFieldsWizardStepFieldVO -> this.fillReadOnlyValue(customWizard, (FormFieldsWizardStepFieldVO)formFieldsWizardStepFieldVO, formFieldsWizardStepMeta, userGroup, customWizardExecutionStorage));
            formFieldsWizardStepVO.getFields().removeIf(formFieldsWizardStepFieldVO -> formFieldsWizardStepFieldVO.isReadOnly() && formFieldsWizardStepFieldVO.getReadOnlyFieldValue() == null && (formFieldsWizardStepFieldVO.getType() != CustomWizardStepFieldDefinitionType.CONTACT_INFO && formFieldsWizardStepFieldVO.getBasicProfileField() != BasicProfileField.ADDRESS || !this.hasValue(this.findField(formFieldsWizardStep, (FormFieldsWizardStepFieldVO)formFieldsWizardStepFieldVO), customWizardExecution)));
        }
    }

    private void fillReadOnlyValue(CustomWizard customWizard, FormFieldsWizardStepFieldVO formFieldsWizardStepFieldVO, FormFieldsWizardStepMeta formFieldsWizardStepMeta, UserGroup userGroup, CustomWizardExecutionStorage customWizardExecutionStorage) {
        CustomFieldValueVO customFieldValueVO = null;
        User user = userGroup == null ? null : new User((Group)userGroup);
        switch (formFieldsWizardStepFieldVO.getType()) {
            case BASIC_PROFILE_FIELD: {
                CustomFieldVO customFieldVO;
                customFieldValueVO = new CustomFieldValueVO();
                CustomFieldType customFieldType = CustomFieldType.STRING;
                switch (formFieldsWizardStepFieldVO.getBasicProfileField()) {
                    case ACCOUNT_NUMBER: {
                        customFieldValueVO = null;
                        break;
                    }
                    case ADDRESS: {
                        break;
                    }
                    case EMAIL: {
                        customFieldValueVO.setStringValue(customWizardExecutionStorage.getRegistration().getEmail());
                        break;
                    }
                    case FULL_NAME: {
                        customFieldValueVO.setStringValue(customWizardExecutionStorage.getRegistration().getName());
                        break;
                    }
                    case IMAGE: {
                        customFieldValueVO.setImageValues(this.imageHandler.resolveImages(customWizardExecutionStorage.getRegistration().getUploadedImages()));
                        customFieldType = CustomFieldType.IMAGE;
                        break;
                    }
                    case LOGIN_NAME: {
                        customFieldValueVO.setStringValue(customWizardExecutionStorage.getRegistration().getUsername());
                        break;
                    }
                    case PHONE: {
                        customFieldVO = null;
                        switch (formFieldsWizardStepFieldVO.getPhoneNature()) {
                            case LANDLINE: {
                                customFieldVO = (Phone)this.conversionHandler.convert(LandLinePhone.class, CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getLandLinePhones()));
                                break;
                            }
                            case MOBILE: {
                                customFieldVO = (Phone)this.conversionHandler.convert(MobilePhone.class, CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getMobilePhones()));
                            }
                        }
                        if (customFieldVO == null) break;
                        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(customFieldVO.getUser());
                        String string = customFieldVO.getRawNumber();
                        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor);
                        if (phoneNumberDescriptor != null) {
                            customFieldVO.setNormalizedNumber(phoneNumberDescriptor.toE164());
                        }
                        customFieldVO.setUser((BasicUser)user);
                        customFieldValueVO.setStringValue(phoneNumberDescriptor == null ? string : phoneNumberDescriptor.toNationalFormat());
                    }
                }
                customFieldVO = new CustomFieldVO();
                customFieldVO.setType(customFieldType);
                customFieldValueVO.setField(customFieldVO);
                break;
            }
            case CUSTOM_PROFILE_FIELD: {
                UserCustomField userCustomField = (UserCustomField)this.entityManagerHandler.find(UserCustomField.class, formFieldsWizardStepFieldVO.getCustomProfileField());
                UserCustomFieldValueDTO userCustomFieldValueDTO = (UserCustomFieldValueDTO)CustomFieldHelper.findValue((ICustomField)userCustomField, (Collection)customWizardExecutionStorage.getRegistration().getCustomValues());
                Object object = this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)userCustomFieldValueDTO, true);
                if (object == null) break;
                UserCustomFieldValue userCustomFieldValue = new UserCustomFieldValue((BasicUser)user, userCustomField);
                CustomFieldHelper.setCustomFieldValue((ICustomFieldValue)userCustomFieldValue, (Object)object);
                userCustomFieldValue.setHidden(userCustomFieldValueDTO.isHidden());
                UserCustomFieldValueVO userCustomFieldValueVO = (UserCustomFieldValueVO)this.conversionHandler.convertExcluding(UserCustomFieldValueVO.class, (Object)userCustomFieldValue, new Object[]{UserCustomFieldValueVO.FIELD});
                userCustomFieldValueVO.setField((UserCustomFieldVO)this.conversionHandler.convert(UserCustomFieldVO.class, (Object)userCustomField));
                customFieldValueVO = userCustomFieldValueVO;
                break;
            }
            case WIZARD_FIELD: {
                Object v = customWizardExecutionStorage.getCustomValues().get(formFieldsWizardStepFieldVO.getWizardField());
                if (v == null) break;
                CustomWizardField customWizardField2 = customWizard.getCustomFields().stream().filter(customWizardField -> customWizardField.getInternalName().equals(formFieldsWizardStepFieldVO.getWizardField())).findAny().get();
                TempCustomFieldValue tempCustomFieldValue = new TempCustomFieldValue(CustomWizardField.class, CustomWizardFieldPossibleValue.class, (CustomField)customWizardField2);
                CustomFieldHelper.setCustomFieldValue((ICustomFieldValue)tempCustomFieldValue, v);
                this.conversionHandler.fill((Object)tempCustomFieldValue, (Object)customFieldValueVO);
                customFieldValueVO = (CustomFieldValueVO)this.conversionHandler.convert(CustomFieldValueVO.class, (Object)tempCustomFieldValue);
                break;
            }
            case CONTACT_INFO: {
                break;
            }
        }
        formFieldsWizardStepFieldVO.setReadOnlyFieldValue(customFieldValueVO);
    }

    private FormFieldsWizardStepField findField(FormFieldsWizardStep formFieldsWizardStep, FormFieldsWizardStepFieldVO formFieldsWizardStepFieldVO) {
        return formFieldsWizardStep.getFields().stream().filter(formFieldsWizardStepField -> this.getIdentity(formFieldsWizardStep, formFieldsWizardStepFieldVO).equals(formFieldsWizardStepField.getIdentity())).findFirst().get();
    }

    private CustomWizardExecutionData finish(CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage) {
        CustomWizard customWizard = customWizardExecution.getWizard();
        CustomWizardExecutionData customWizardExecutionData = new CustomWizardExecutionData();
        customWizardExecutionData.setWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)customWizard));
        PublicRegistrationDTO publicRegistrationDTO = customWizardExecutionStorage.getRegistration();
        customWizardExecutionStorage.clearNotification();
        CustomScriptAccessor customScriptAccessor = this.script(customWizardExecution);
        if (customWizard instanceof RegistrationWizard) {
            customWizardExecutionData.setResultType(CustomWizardResultType.REGISTRATION);
            publicRegistrationDTO.setAttribute("execution", (Object)customWizardExecution);
            publicRegistrationDTO.setAttribute("storage", (Object)customWizardExecutionStorage);
            RegisterUserByWizardResult registerUserByWizardResult = this.userService.registerByWizard(publicRegistrationDTO);
            if (customScriptAccessor != null) {
                customScriptAccessor.bind("user", (Object)registerUserByWizardResult.getUser()).run();
            }
            UserRegistrationResult userRegistrationResult = this.basicUserService.buildRegistrationResult((BasicUser)registerUserByWizardResult.getUser(), registerUserByWizardResult.getGeneratedPasswords());
            customWizardExecutionData.setRegistrationResult(userRegistrationResult);
        } else if (customWizard.getNature().isRelatedToMenu()) {
            customWizardExecutionData.setResultType(customWizard.getResultType());
            Object object = customScriptAccessor.run();
            if (object instanceof CharSequence) {
                customWizardExecutionData.setResultTitle(this.getTranslatedName((NamedEntity)customWizard));
                customWizardExecutionData.setResult(object.toString());
            } else {
                Map map = (Map)this.conversionHandler.convert(Map.class, object);
                String string = map == null ? null : StringHelper.trimToNull(map.get("title"));
                String string2 = map == null ? null : StringHelper.trimToNull(map.get("result"));
                customWizardExecutionData.setResultTitle((String)ObjectHelper.defaultValue((Object)string, (Object)this.getTranslatedName((NamedEntity)customWizard)));
                customWizardExecutionData.setResult(string2);
            }
        }
        this.remove((IEntity)customWizardExecution);
        return customWizardExecutionData;
    }

    private FormFieldsWizardStepMeta getFieldsMetadata(CustomWizardExecution customWizardExecution, FormFieldsWizardStep formFieldsWizardStep) {
        return (FormFieldsWizardStepMeta)InvocationContext.ensure().getAttribute((Object)("wizardFieldsMeta_" + formFieldsWizardStep.getId()), () -> {
            CustomWizardExecutionStorage customWizardExecutionStorage = (CustomWizardExecutionStorage)customWizardExecution.getStorage();
            List list = customWizardExecutionStorage.getSteps();
            FormFieldsWizardStepMeta formFieldsWizardStepMeta = CollectionHelper.filterByType(list.stream().map(CustomWizardStepWithTransitions::getStep), FormFieldsWizardStep.class).filter(formFieldsWizardStep2 -> !formFieldsWizardStep2.equals((Object)formFieldsWizardStep)).map(formFieldsWizardStep -> this.getStepMeta(customWizardExecution, (FormFieldsWizardStep)formFieldsWizardStep)).reduce(new FormFieldsWizardStepMeta(), FormFieldsWizardStepMeta::add);
            FormFieldsWizardStepMeta formFieldsWizardStepMeta2 = this.getStepMeta(customWizardExecution, formFieldsWizardStep);
            return formFieldsWizardStepMeta2.applyPrevious(customWizardExecution, formFieldsWizardStepMeta);
        });
    }

    private UserGroup getGroup(CustomWizardExecutionStorage customWizardExecutionStorage) {
        PublicRegistrationDTO publicRegistrationDTO = customWizardExecutionStorage.getRegistration();
        if (publicRegistrationDTO.getGroup() == null) {
            List list = this.getConfiguration().getPossibleInitialGroups();
            if (list.size() == 1) {
                return (UserGroup)list.get(0);
            }
            throw new ValidationException(CustomWizardTransitionParams.GROUP.getName(), this.message(GeneralKeys.Errors.REQUIRED, UsersKeys.Users.GROUP));
        }
        return (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)publicRegistrationDTO.getGroup());
    }

    private UserGroup getGroupOrNull(CustomWizardExecutionStorage customWizardExecutionStorage) {
        try {
            return this.getGroup(customWizardExecutionStorage);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object getIdentity(FormFieldsWizardStep formFieldsWizardStep, FormFieldsWizardStepFieldVO formFieldsWizardStepFieldVO) {
        if (formFieldsWizardStepFieldVO.getPhoneNature() != null) {
            return formFieldsWizardStepFieldVO.getPhoneNature();
        }
        if (formFieldsWizardStepFieldVO.getBasicProfileField() != null) {
            return formFieldsWizardStepFieldVO.getBasicProfileField();
        }
        if (formFieldsWizardStepFieldVO.getCustomProfileField() != null) {
            return this.entityManagerHandler.find(UserCustomField.class, formFieldsWizardStepFieldVO.getCustomProfileField());
        }
        if (formFieldsWizardStepFieldVO.getWizardField() != null) {
            return formFieldsWizardStep.getWizard().getCustomFields().stream().filter(customWizardField -> customWizardField.getInternalName().equals(formFieldsWizardStepFieldVO.getWizardField())).findFirst().get();
        }
        return formFieldsWizardStepFieldVO.getType();
    }

    private FormFieldsWizardStepMeta getStepMeta(CustomWizardExecution customWizardExecution, FormFieldsWizardStep formFieldsWizardStep) {
        boolean bl = formFieldsWizardStep.getWizard().getNature() == CustomWizardNature.REGISTRATION;
        UserGroup userGroup = bl ? this.getGroup(customWizardExecution) : null;
        ConfigurationAccessor configurationAccessor = userGroup == null ? null : this.configurationHandler.getAccessor((BasicGroup)userGroup);
        ProductsAccessor productsAccessor = userGroup == null ? null : this.productsHandler.getAccessor((BasicGroup)userGroup);
        User user = userGroup == null ? null : new User((Group)userGroup);
        FormFieldsWizardStepMeta formFieldsWizardStepMeta = new FormFieldsWizardStepMeta();
        if (bl && userGroup == null) {
            return formFieldsWizardStepMeta;
        }
        formFieldsWizardStep.getFields().stream().filter(formFieldsWizardStepField -> {
            CustomWizardStepFieldDefinitionType customWizardStepFieldDefinitionType = formFieldsWizardStepField.getType();
            switch (customWizardStepFieldDefinitionType) {
                case BASIC_PROFILE_FIELD: {
                    BasicProfileField basicProfileField = formFieldsWizardStepField.getBasicProfileField();
                    if (basicProfileField == BasicProfileField.LOGIN_NAME && configurationAccessor.isGeneratedUsername()) {
                        return false;
                    }
                    return this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)basicProfileField, ProfileFieldAction.EDIT);
                }
                case CUSTOM_PROFILE_FIELD: {
                    return this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)formFieldsWizardStepField.getCustomProfileField(), ProfileFieldAction.EDIT);
                }
                case PASSWORDS: {
                    return !this.passwordHandler.getPasswordTypesAtRegistration((Group)userGroup, UserRegistration.PUBLIC, PasswordMode.MANUAL).isEmpty();
                }
                case SECURITY_QUESTION: {
                    return configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION;
                }
                case AGREEMENTS: {
                    return !productsAccessor.product().getAgreements().isEmpty();
                }
                case CONTACT_INFO: {
                    return productsAccessor.member().getMaxContactInfos() > 0;
                }
                case CAPTCHA: {
                    CaptchaConfiguration captchaConfiguration = configurationAccessor.getCaptchaConfiguration();
                    return captchaConfiguration != null && captchaConfiguration.isUseOnPublicRegistration();
                }
                case WIZARD_FIELD: {
                    return true;
                }
            }
            throw new IllegalStateException("Unhandled field type: " + String.valueOf(customWizardStepFieldDefinitionType));
        }).forEach(arg_0 -> ((FormFieldsWizardStepMeta)formFieldsWizardStepMeta).add(arg_0));
        return formFieldsWizardStepMeta;
    }

    private Pair<PublicRegistrationData, FormFieldsWizardStepMeta> getStepRegistrationData(CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage, FormFieldsWizardStep formFieldsWizardStep) {
        PhoneConfigurationData phoneConfigurationData;
        if (!(formFieldsWizardStep.getWizard() instanceof RegistrationWizard)) {
            return null;
        }
        UserGroup userGroup = this.getGroup(customWizardExecutionStorage);
        if (userGroup == null) {
            return null;
        }
        InviteToken inviteToken = customWizardExecutionStorage.getInviteToken();
        PublicRegistrationData publicRegistrationData = this.userService.getPublicRegistrationData(new InitialGroupVO(userGroup.getId()), inviteToken == null ? null : inviteToken.getToken(), customWizardExecutionStorage.getExternalPaymentToken());
        FormFieldsWizardStepMeta formFieldsWizardStepMeta = this.getFieldsMetadata(customWizardExecution, formFieldsWizardStep);
        Set set = formFieldsWizardStepMeta.getProfileFields(true);
        Set set2 = formFieldsWizardStepMeta.getPhoneNatures(true);
        publicRegistrationData.getProfileFieldActions().removeIf(userProfileFieldActions -> {
            BasicProfileField basicProfileField = null;
            if (userProfileFieldActions instanceof UserBasicFieldActions) {
                basicProfileField = ((UserBasicFieldActions)userProfileFieldActions).getBasicField();
            } else if (userProfileFieldActions instanceof UserCustomFieldActions) {
                UserCustomFieldDetailedVO userCustomFieldDetailedVO = ((UserCustomFieldActions)userProfileFieldActions).getCustomField();
                userCustomFieldDetailedVO.setSection(null);
                basicProfileField = (ProfileField)this.conversionHandler.convert(UserCustomField.class, (Object)userCustomFieldDetailedVO);
            }
            boolean bl = set.contains(basicProfileField);
            if (bl) {
                boolean bl2 = formFieldsWizardStepMeta.isReadOnly((Object)basicProfileField);
                userProfileFieldActions.setEdit(!bl2);
                userProfileFieldActions.setManagePrivacy(formFieldsWizardStep.isFieldVisibility() && !bl2);
            }
            return !bl;
        });
        if (!set.contains(BasicProfileField.FULL_NAME)) {
            publicRegistrationData.setNameLabel(null);
        }
        if (set2.isEmpty()) {
            publicRegistrationData.setPhoneConfiguration(null);
            publicRegistrationData.setLandLinePhoneData(null);
            publicRegistrationData.setMobilePhoneData(null);
            publicRegistrationData.setCanCreateMobilePhone(false);
            publicRegistrationData.setCanCreateLandlinePhone(false);
        } else {
            phoneConfigurationData = publicRegistrationData.getPhoneConfiguration();
            if (!set2.contains(PhoneNature.MOBILE)) {
                if (phoneConfigurationData != null) {
                    phoneConfigurationData.setMobileRequired(false);
                    phoneConfigurationData.setMobileExample(null);
                }
                publicRegistrationData.setMaxMobilePhones(0);
                publicRegistrationData.setCanCreateMobilePhone(false);
                publicRegistrationData.setMobilePhoneData(null);
            }
            if (!set2.contains(PhoneNature.LANDLINE)) {
                if (phoneConfigurationData != null) {
                    phoneConfigurationData.setExtensionEnabled(false);
                    phoneConfigurationData.setLandLineRequired(false);
                    phoneConfigurationData.setLandLineExample(null);
                }
                publicRegistrationData.setMaxLandLinePhones(0);
                publicRegistrationData.setCanCreateLandlinePhone(false);
                publicRegistrationData.setLandLinePhoneData(null);
            }
        }
        if (!set.contains(BasicProfileField.ADDRESS)) {
            publicRegistrationData.setCanCreateAddress(false);
            publicRegistrationData.setAddressConfiguration(null);
            publicRegistrationData.setAddressData(null);
            publicRegistrationData.setMaxAddresses(0);
        }
        if (!set.contains(BasicProfileField.IMAGE)) {
            publicRegistrationData.setImageRequired(false);
            publicRegistrationData.setCanCreateImages(false);
            publicRegistrationData.setMaxImages(0);
        }
        if (!formFieldsWizardStepMeta.isPasswords()) {
            publicRegistrationData.setPasswordsData(null);
        }
        if (!formFieldsWizardStepMeta.isSecurityQuestion()) {
            publicRegistrationData.setSecurityQuestions(null);
            publicRegistrationData.setRequireSecurityQuestion(false);
        }
        if (!formFieldsWizardStepMeta.isContactInfo()) {
            publicRegistrationData.setMaxContactInfos(0);
            publicRegistrationData.setCanCreateContactInfos(false);
            publicRegistrationData.setContactInfoData(null);
        }
        if (!formFieldsWizardStepMeta.isCaptcha() || customWizardExecutionStorage.isCaptchaValidated()) {
            publicRegistrationData.setCaptchaInput(null);
        }
        if (!formFieldsWizardStepMeta.isAgreements()) {
            publicRegistrationData.setAgreements(null);
        }
        publicRegistrationData.setIdentityProviders(null);
        publicRegistrationData.setNfcTokenTypes(null);
        publicRegistrationData.setConfirmationPasswordInput(null);
        phoneConfigurationData = customWizardExecutionStorage.getRegistration();
        phoneConfigurationData.setUploadedImages(this.imageHandler.resolveImages(phoneConfigurationData.getUploadedImages()));
        this.customFieldValueHandler.resolveValues(UserCustomField.class, (Collection)phoneConfigurationData.getCustomValues());
        CollectionHelper.orEmpty((List)phoneConfigurationData.getContactInfos()).forEach(contactInfoDTO -> {
            this.customFieldValueHandler.resolveValues(ContactInfoField.class, (Collection)contactInfoDTO.getCustomValues());
            contactInfoDTO.setImage(this.imageHandler.resolveImage(contactInfoDTO.getImage()));
        });
        publicRegistrationData.setDto((EntityDTO)phoneConfigurationData);
        return Pair.create((Object)publicRegistrationData, (Object)formFieldsWizardStepMeta);
    }

    private CustomWizardExecutionData handleTransitionFromScript(Object object, CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage, List<CustomWizardStepWithTransitions> list, CustomWizardTransition customWizardTransition, CustomWizardStep customWizardStep) {
        Object object2;
        FormFieldsWizardStep formFieldsWizardStep;
        SessionData sessionData = this.getSessionData();
        CustomWizard customWizard = customWizardExecution.getWizard();
        CustomWizardStepWithTransitions customWizardStepWithTransitions = this.toStepWithTransitions(customWizardExecution, object);
        if (customWizardStepWithTransitions == null) {
            customWizardStepWithTransitions = this.toStepWithTransitions(customWizardExecution, customWizardStep);
        }
        CustomWizardStep customWizardStep2 = customWizardStepWithTransitions.getStep();
        boolean bl = false;
        if (customWizardStep2 instanceof GroupSelectionWizardStep) {
            bl = sessionData.getConfiguration().getPossibleInitialGroups().size() == 1;
        } else if (customWizardStep2 instanceof IdentityProviderWizardStep) {
            bl = !sessionData.getChannelAccessAccessor().getRegistrationWithIdentityProviders().enabled();
        } else if (customWizardStep2 instanceof FormFieldsWizardStep) {
            formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep2;
            if (customWizard instanceof RegistrationWizard && CollectionHelper.isNotEmpty((Iterable)(object2 = formFieldsWizardStep.getGroups()))) {
                UserGroup userGroup = this.getGroup(customWizardExecutionStorage);
                boolean bl2 = bl = !this.groupsHandler.flatten((Collection)object2).contains(userGroup);
            }
            if (!bl && !formFieldsWizardStep.getFields().isEmpty()) {
                object2 = this.getFieldsMetadata(customWizardExecution, formFieldsWizardStep);
                bl = object2.isEmpty();
            }
        } else if (customWizardStep2 instanceof EmailVerificationWizardStep) {
            if (customWizard instanceof RegistrationWizard) {
                formFieldsWizardStep = customWizardExecutionStorage.getRegistration();
                object2 = formFieldsWizardStep.getEmail();
                String string = customWizardExecutionStorage.getVerifiedEmail();
                bl = StringHelper.isBlank((Object)object2) || string != null && string.equals(object2);
                String string2 = customWizardExecutionStorage.getEmailToVerify();
                if (!(bl || string2 != null && string2.equals(object2))) {
                    this.sendVerificationCode(customWizardExecution, SendMedium.EMAIL, (String)object2);
                }
            }
        } else if (customWizardStep2 instanceof PhoneVerificationWizardStep && customWizard instanceof RegistrationWizard) {
            formFieldsWizardStep = this.getGroup(customWizardExecutionStorage);
            object2 = this.configurationHandler.getAccessor((BasicGroup)formFieldsWizardStep);
            PublicRegistrationDTO publicRegistrationDTO = customWizardExecutionStorage.getRegistration();
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)CollectionHelper.first((Iterable)publicRegistrationDTO.getMobilePhones());
            PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(mobilePhoneDTO == null ? null : mobilePhoneDTO.getRawNumber(), (ConfigurationAccessor)object2);
            PhoneNumberDescriptor phoneNumberDescriptor2 = this.phoneNumberHandler.parse(customWizardExecutionStorage.getVerifiedSms(), (ConfigurationAccessor)object2);
            bl = phoneNumberDescriptor == null || this.phoneNumberHandler.equals(phoneNumberDescriptor, phoneNumberDescriptor2);
            PhoneNumberDescriptor phoneNumberDescriptor3 = this.phoneNumberHandler.parse(customWizardExecutionStorage.getSmsToVerify(), (ConfigurationAccessor)object2);
            if (!(bl || phoneNumberDescriptor3 != null && phoneNumberDescriptor3.equals((Object)phoneNumberDescriptor))) {
                this.sendVerificationCode(customWizardExecution, SendMedium.SMS, phoneNumberDescriptor.getRawNumber());
            }
        }
        if (bl) {
            if (CollectionHelper.isEmpty((Iterable)customWizardStepWithTransitions.getTransitions())) {
                throw new ValidationException("Skipping, but there's no possible next step");
            }
            formFieldsWizardStep = (CustomWizardTransition)CollectionHelper.first((Iterable)customWizardStepWithTransitions.getTransitions());
            object2 = this.candidateNextStep(customWizardStepWithTransitions, (CustomWizardTransition)CollectionHelper.first((Iterable)customWizardStepWithTransitions.getTransitions()));
            return this.handleTransitionFromScript(null, customWizardExecution, customWizardExecutionStorage, list, (CustomWizardTransition)formFieldsWizardStep, (CustomWizardStep)object2);
        }
        try {
            list.add(customWizardStepWithTransitions);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            list = new ArrayList<CustomWizardStepWithTransitions>(list);
            list.add(customWizardStepWithTransitions);
        }
        customWizardExecutionStorage.setSteps(list);
        return this.toExecutionData(customWizardExecution, customWizardExecutionStorage, list);
    }

    private boolean hasValue(FormFieldsWizardStepField formFieldsWizardStepField, CustomWizardExecution customWizardExecution) {
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        switch (formFieldsWizardStepField.getType()) {
            case AGREEMENTS: {
                return CollectionHelper.isNotEmpty((Iterable)customWizardExecutionStorage.getRegistration().getAgreements());
            }
            case BASIC_PROFILE_FIELD: {
                switch (formFieldsWizardStepField.getBasicProfileField()) {
                    case ACCOUNT_NUMBER: {
                        return false;
                    }
                    case ADDRESS: {
                        UserAddressDTO userAddressDTO = (UserAddressDTO)CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getAddresses());
                        return StringHelper.isNotBlank((Object)AddressHelper.format((IAddress)userAddressDTO));
                    }
                    case EMAIL: {
                        return StringHelper.isNotBlank((Object)customWizardExecutionStorage.getRegistration().getEmail());
                    }
                    case FULL_NAME: {
                        return StringHelper.isNotBlank((Object)customWizardExecutionStorage.getRegistration().getName());
                    }
                    case IMAGE: {
                        return CollectionHelper.isNotEmpty((Iterable)customWizardExecutionStorage.getRegistration().getUploadedImages());
                    }
                    case LOGIN_NAME: {
                        return StringHelper.isNotBlank((Object)customWizardExecutionStorage.getRegistration().getUsername());
                    }
                    case PHONE: {
                        switch (formFieldsWizardStepField.getPhoneNature()) {
                            case LANDLINE: {
                                LandLinePhoneDTO landLinePhoneDTO = (LandLinePhoneDTO)CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getLandLinePhones());
                                return landLinePhoneDTO != null && StringHelper.isNotBlank((Object)landLinePhoneDTO.getRawNumber());
                            }
                            case MOBILE: {
                                MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getMobilePhones());
                                return mobilePhoneDTO != null && StringHelper.isNotBlank((Object)mobilePhoneDTO.getRawNumber());
                            }
                        }
                    }
                }
                break;
            }
            case CAPTCHA: {
                CaptchaResponseDTO captchaResponseDTO = customWizardExecutionStorage.getRegistration().getCaptchaResponse();
                return captchaResponseDTO != null && StringHelper.isNotBlank((Object)captchaResponseDTO.getResponse());
            }
            case CONTACT_INFO: {
                ContactInfoDTO contactInfoDTO = (ContactInfoDTO)CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getContactInfos());
                return contactInfoDTO != null && StringHelper.isNotBlank((Object)contactInfoDTO.getName());
            }
            case CUSTOM_PROFILE_FIELD: {
                UserCustomFieldValueDTO userCustomFieldValueDTO = (UserCustomFieldValueDTO)CustomFieldHelper.findValue((ICustomField)formFieldsWizardStepField.getCustomProfileField(), (Collection)customWizardExecutionStorage.getRegistration().getCustomValues());
                return ObjectHelper.isNotEmpty((Object)this.customFieldValueHandler.getValue((CustomField)formFieldsWizardStepField.getCustomProfileField(), (Object)userCustomFieldValueDTO, false));
            }
            case PASSWORDS: {
                PasswordRegistrationDTO passwordRegistrationDTO = (PasswordRegistrationDTO)CollectionHelper.first((Iterable)customWizardExecutionStorage.getRegistration().getPasswords());
                return passwordRegistrationDTO != null && StringHelper.isNotBlank((Object)passwordRegistrationDTO.getValue());
            }
            case SECURITY_QUESTION: {
                return StringHelper.isNotBlank((Object)customWizardExecutionStorage.getRegistration().getSecurityAnswer());
            }
            case WIZARD_FIELD: {
                Map map = customWizardExecutionStorage.getCustomValues();
                return map != null && ObjectHelper.isNotEmpty(map.get(formFieldsWizardStepField.getWizardField().getInternalName()));
            }
        }
        return false;
    }

    private boolean isExcluded(CustomWizardExecution customWizardExecution, CustomWizardStep customWizardStep) {
        FormFieldsWizardStep formFieldsWizardStep;
        CustomWizard customWizard = customWizardExecution.getWizard();
        if (customWizard instanceof RegistrationWizard && customWizardStep instanceof FormFieldsWizardStep && CollectionHelper.isNotEmpty((Iterable)(formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep).getGroups())) {
            Set set = this.groupsHandler.flatten((Collection)formFieldsWizardStep.getGroups());
            return !set.contains(this.getGroup(customWizardExecution));
        }
        return false;
    }

    private void maybeVerifyEmail(CustomWizardTransitionParams customWizardTransitionParams, CustomWizardExecution customWizardExecution) {
        if (customWizardTransitionParams.getEmailVerification() != null) {
            CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
            String string = customWizardExecutionStorage.getRegistration().getEmail();
            try {
                this.otpHandler.verify(OtpType.WIZARD_EMAIL, (OtpOwner)customWizardExecution, customWizardTransitionParams.getEmailVerification());
                customWizardExecutionStorage.setVerifiedEmail(string);
            }
            catch (ValidationException validationException) {
                SessionData sessionData = this.getSessionData();
                ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
                Integer n = configurationAccessor.getInvalidUsernameAttempts();
                TimeInterval timeInterval = configurationAccessor.getRemoteAddressBlockTime();
                UserLocatorVO userLocatorVO = new UserLocatorVO((org.cyclos.model.Property)UserLocatorVO.PRINCIPAL, (Object)string);
                userLocatorVO.setPrincipalType(ExistingBuiltInPrincipalType.EMAIL.getInternalName());
                boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_EMAIL_VERIFICATION_AS_GUEST, sessionData.getRemoteAddress(), userLocatorVO, n, timeInterval);
                throw bl ? new RemoteAddressBlockedException() : validationException;
            }
        }
    }

    private void maybeVerifyMobilePhone(CustomWizardTransitionParams customWizardTransitionParams, CustomWizardExecution customWizardExecution) {
        if (customWizardTransitionParams.getSmsVerification() != null) {
            CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
            PublicRegistrationDTO publicRegistrationDTO = customWizardExecutionStorage.getRegistration();
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)CollectionHelper.first((Iterable)publicRegistrationDTO.getMobilePhones());
            String string = mobilePhoneDTO.getRawNumber();
            try {
                this.otpHandler.verify(OtpType.WIZARD_PHONE, (OtpOwner)customWizardExecution, customWizardTransitionParams.getSmsVerification());
                customWizardExecutionStorage.setVerifiedSms(string);
            }
            catch (ValidationException validationException) {
                SessionData sessionData = this.getSessionData();
                ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
                Integer n = configurationAccessor.getInvalidUsernameAttempts();
                TimeInterval timeInterval = configurationAccessor.getRemoteAddressBlockTime();
                UserLocatorVO userLocatorVO = new UserLocatorVO((org.cyclos.model.Property)UserLocatorVO.PRINCIPAL, (Object)string);
                userLocatorVO.setPrincipalType(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName());
                boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_PHONE_VERIFICATION_AS_GUEST, sessionData.getRemoteAddress(), userLocatorVO, n, timeInterval);
                throw bl ? new RemoteAddressBlockedException() : validationException;
            }
        }
    }

    private void removeFiles(CustomWizardExecution customWizardExecution) {
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        Map map = customWizardExecutionStorage.getCustomValues();
        CustomWizard customWizard = customWizardExecution.getWizard();
        customWizard.getCustomFields().stream().filter(customWizardField -> customWizardField.getType().isBinary()).forEach(customWizardField -> {
            Collection collection = CollectionHelper.orEmpty((Collection)((Collection)map.get(customWizardField.getInternalName())));
            collection.forEach(storedFile -> this.storedFileHandler.remove(storedFile.getId().longValue()));
        });
    }

    private CustomScriptAccessor script(CustomWizardExecution customWizardExecution) {
        CustomWizard customWizard = customWizardExecution.getWizard();
        if (customWizard.getScript() == null) {
            return null;
        }
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        List list = customWizardExecutionStorage.getSteps();
        CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last((List)list);
        return this.customScriptService.newAccessor(customWizard.getScript(), customWizard.getScriptParameters()).bind("wizard", (Object)customWizard).bind("steps", (Object)list).bind("step", (Object)(customWizardStepWithTransitions == null ? null : customWizardStepWithTransitions.getStep())).bind("execution", (Object)customWizardExecution).bind("storage", (Object)customWizardExecutionStorage).bind("registration", (Object)customWizardExecutionStorage.getRegistration()).bind("customValues", (Object)customWizardExecutionStorage.getCustomValues()).bind("transition", null).bind("user", (Object)customWizardExecution.getUser()).bind("request", null).bind("returnUrl", null);
    }

    private void sendVerificationCode(CustomWizardExecution customWizardExecution, SendMedium sendMedium, String string) {
        ValidateRegistrationFieldParams validateRegistrationFieldParams;
        String string2;
        String string3;
        PhoneNature phoneNature;
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        UserGroup userGroup = this.getGroup(customWizardExecutionStorage);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)userGroup);
        CustomWizardStepWithTransitions customWizardStepWithTransitions = (CustomWizardStepWithTransitions)CollectionHelper.last((List)customWizardExecutionStorage.getSteps());
        if (customWizardStepWithTransitions == null) {
            throw new IllegalActionException("Expected a form fields step");
        }
        if (sendMedium == SendMedium.SMS) {
            phoneNature = PhoneNature.MOBILE;
            string3 = "mobilePhone";
            string2 = "mobilePhone";
            customWizardExecutionStorage.setSmsToVerify(string);
            string = this.phoneNumberHandler.tryNormalize(string, configurationAccessor);
        } else {
            phoneNature = BasicProfileField.EMAIL;
            string2 = string3 = BasicProfileField.EMAIL.getAlias();
            customWizardExecutionStorage.setEmailToVerify(string);
        }
        if (!(customWizardStepWithTransitions.getStep() instanceof VerificationWizardStep) && !(validateRegistrationFieldParams = this.getFieldsMetadata(customWizardExecution, (FormFieldsWizardStep)customWizardStepWithTransitions.getStep())).has((Object)phoneNature)) {
            throw new IllegalActionException("Expected the current step to contain " + String.valueOf(phoneNature));
        }
        validateRegistrationFieldParams = new ValidateRegistrationFieldParams();
        validateRegistrationFieldParams.setGroup(new GroupVO(userGroup.getId()));
        validateRegistrationFieldParams.setField(string3);
        validateRegistrationFieldParams.setValue(string);
        String string4 = this.userService.validateRegistrationField(validateRegistrationFieldParams);
        if (StringHelper.isNotBlank((Object)string4)) {
            throw new ValidationException(string2, string4);
        }
        this.otpHandler.sendForWizardRegistration(customWizardExecution, configurationAccessor, customWizardExecutionStorage.getRegistration().getName(), sendMedium, string);
    }

    private void storeFormFields(FormFieldsWizardStep formFieldsWizardStep, CustomWizardTransitionParams customWizardTransitionParams, CustomWizardExecution customWizardExecution) {
        Object object;
        Set set;
        Set set2;
        Object object2;
        Object object3;
        Object object4;
        this.validateFormFields(formFieldsWizardStep, customWizardTransitionParams, customWizardExecution);
        CustomWizard customWizard = customWizardExecution.getWizard();
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        boolean bl = customWizard.getNature() == CustomWizardNature.REGISTRATION;
        FormFieldsWizardStepMeta formFieldsWizardStepMeta = this.getFieldsMetadata(customWizardExecution, formFieldsWizardStep);
        if (bl) {
            object4 = this.getGroup(customWizardExecutionStorage);
            object3 = this.configurationHandler.getAccessor((BasicGroup)object4);
            object2 = customWizardTransitionParams.getUser();
            set2 = formFieldsWizardStepMeta.getProfileFields(false);
            set = formFieldsWizardStepMeta.getPhoneNatures(false);
            object = customWizardExecutionStorage.getRegistration();
            for (ProfileField profileField : set2) {
                ArrayList<UserCustomFieldValueDTO> arrayList;
                Object object5;
                if (profileField instanceof BasicProfileField) {
                    switch ((BasicProfileField)profileField) {
                        case FULL_NAME: {
                            object.setName(object2.getName());
                            break;
                        }
                        case LOGIN_NAME: {
                            object.setUsername(object2.getUsername());
                            break;
                        }
                        case EMAIL: {
                            object5 = object2.getEmail();
                            object.setEmail((String)object5);
                            this.maybeVerifyEmail(customWizardTransitionParams, customWizardExecution);
                            break;
                        }
                        case IMAGE: {
                            object.setUploadedImages(object2.getUploadedImages());
                            break;
                        }
                        case PHONE: {
                            if (set.contains(PhoneNature.MOBILE)) {
                                arrayList = object2.getMobilePhones();
                                object.setMobilePhones(arrayList);
                                this.maybeVerifyMobilePhone(customWizardTransitionParams, customWizardExecution);
                            }
                            if (!set.contains(PhoneNature.LANDLINE)) break;
                            object.setLandLinePhones(object2.getLandLinePhones());
                            break;
                        }
                        case ADDRESS: {
                            object.setAddresses(object2.getAddresses());
                            break;
                        }
                    }
                    continue;
                }
                if (!(profileField instanceof UserCustomField)) continue;
                object5 = (UserCustomField)profileField;
                arrayList = object.getCustomValues();
                if (arrayList == null) {
                    arrayList = new ArrayList<UserCustomFieldValueDTO>();
                    object.setCustomValues(arrayList);
                }
                UserCustomFieldValueDTO userCustomFieldValueDTO = (UserCustomFieldValueDTO)CustomFieldHelper.findValue((ICustomField)object5, (Collection)object2.getCustomValues());
                UserCustomFieldValueDTO userCustomFieldValueDTO2 = (UserCustomFieldValueDTO)CustomFieldHelper.findValue((ICustomField)object5, (Collection)object.getCustomValues());
                if (userCustomFieldValueDTO2 != null) {
                    arrayList.remove(userCustomFieldValueDTO2);
                }
                if (userCustomFieldValueDTO == null) continue;
                arrayList.add(userCustomFieldValueDTO);
            }
            if (formFieldsWizardStepMeta.isPasswords()) {
                object.setPasswords(object2.getPasswords());
            }
            if (formFieldsWizardStepMeta.isSecurityQuestion() && object3.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION) {
                object.setSecurityQuestion(object2.getSecurityQuestion());
                object.setSecurityAnswer(object2.getSecurityQuestion() == null ? null : object2.getSecurityAnswer());
            }
            if (formFieldsWizardStepMeta.isAgreements()) {
                object.setAgreements(object2.getAgreements());
            }
            if (formFieldsWizardStepMeta.isContactInfo()) {
                object.setContactInfos(object2.getContactInfos());
            }
            if (formFieldsWizardStepMeta.isCaptcha()) {
                customWizardExecutionStorage.setCaptchaValidated(true);
            }
            customWizardExecutionStorage.setRegistration(object);
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object4 = formFieldsWizardStepMeta.getWizardFields(false)))) {
            object3 = customWizardExecutionStorage.getCustomValues();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                set2 = (CustomWizardField)object2.next();
                object = this.customFieldValueHandler.getValue((CustomField)set2, (Object)(set = (CustomFieldValueDTO)CustomFieldHelper.findValue((ICustomField)set2, (Collection)customWizardTransitionParams.getCustomValues())), true);
                if (object == null) {
                    object3.remove(set2.getInternalName());
                    continue;
                }
                object3.put(set2.getInternalName(), object);
            }
            customWizardExecutionStorage.setCustomValues((Map)object3);
        }
    }

    private void storeStepData(CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage, CustomWizardStepWithTransitions customWizardStepWithTransitions, CustomWizardTransitionParams customWizardTransitionParams) {
        CustomWizardStep customWizardStep = customWizardStepWithTransitions.getStep();
        switch (customWizardStep.getNature()) {
            case GROUP: {
                this.validateAndSetGroup(customWizardTransitionParams, customWizardExecutionStorage);
                break;
            }
            case IDENTITY_PROVIDER: {
                break;
            }
            case FORM_FIELDS: {
                FormFieldsWizardStep formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep;
                this.storeFormFields(formFieldsWizardStep, customWizardTransitionParams, customWizardExecution);
                break;
            }
            case EMAIL_VERIFICATION: {
                this.maybeVerifyEmail(customWizardTransitionParams, customWizardExecution);
                break;
            }
            case PHONE_VERIFICATION: {
                this.maybeVerifyMobilePhone(customWizardTransitionParams, customWizardExecution);
            }
        }
    }

    private CustomWizardExecutionData toExecutionData(CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage, List<CustomWizardStepWithTransitions> list) {
        Object object;
        CustomWizard customWizard = customWizardExecution.getWizard();
        CustomWizardStepWithTransitions customWizardStepWithTransitions2 = (CustomWizardStepWithTransitions)CollectionHelper.last(list);
        CustomWizardStep customWizardStep = customWizardStepWithTransitions2.getStep();
        SessionData sessionData = this.getSessionData();
        CustomWizardTransitionParams customWizardTransitionParams = new CustomWizardTransitionParams();
        customWizardTransitionParams.setKey(customWizardExecution.getKey());
        CustomWizardExecutionData customWizardExecutionData = new CustomWizardExecutionData();
        customWizardExecutionData.setParams(customWizardTransitionParams);
        customWizardExecutionData.setKey(customWizardExecution.getKey());
        customWizardExecutionData.setWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)customWizard));
        customWizardExecutionData.setStep((CustomWizardStepDetailedVO)this.conversionHandler.convert(CustomWizardStepDetailedVO.class, (Object)customWizardStep));
        customWizardExecutionData.setMenuItem((MenuItemVO)this.conversionHandler.convert(MenuItemVO.class, (Object)customWizardExecutionStorage.getMenuItem()));
        customWizardExecutionData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)customWizardExecution.getUser()));
        if (customWizard.isShowProgress()) {
            customWizardExecutionData.setStepNumber(Integer.valueOf(customWizard.getSteps().indexOf(customWizardStep) + 1));
            customWizardExecutionData.setStepCount(Integer.valueOf(customWizard.getSteps().size()));
        }
        customWizardExecutionData.setNotificationLevel(customWizardExecutionStorage.getNotificationLevel());
        customWizardExecutionData.setNotification(customWizardExecutionStorage.getNotificationMessage());
        FormFieldsWizardStepMeta formFieldsWizardStepMeta = null;
        if (customWizardStep instanceof GroupSelectionWizardStep) {
            object = (GroupSelectionWizardStepVO)customWizardExecutionData.getStep();
            object.setGroups(this.groupsHandler.getPossiblePublicInitialGroups());
        } else if (customWizardStep instanceof IdentityProviderWizardStep) {
            object = (IdentityProviderWizardStepVO)customWizardExecutionData.getStep();
            ChannelAccessAccessor channelAccessAccessor = sessionData.getChannelAccessAccessor();
            if (channelAccessAccessor.getRegistrationWithIdentityProviders().enabled()) {
                User user = new User((Group)this.getGroup(customWizardExecutionStorage));
                object.setIdentityProviders(this.conversionHandler.convertList(IdentityProviderVO.class, (Iterable)this.identityProviderService.listEnabled((BasicUser)user)));
            }
        } else if (customWizardStep instanceof FormFieldsWizardStep) {
            List list2;
            Object object2;
            object = (FormFieldsWizardStep)customWizardStep;
            FormFieldsWizardStepVO formFieldsWizardStepVO = (FormFieldsWizardStepVO)customWizardExecutionData.getStep();
            if (customWizard instanceof RegistrationWizard) {
                object2 = this.getStepRegistrationData(customWizardExecution, customWizardExecutionStorage, (FormFieldsWizardStep)object);
                if (object2 != null) {
                    formFieldsWizardStepVO.setRegistrationData((PublicRegistrationData)object2.getFirst());
                    formFieldsWizardStepMeta = (FormFieldsWizardStepMeta)object2.getSecond();
                    list2 = formFieldsWizardStepMeta;
                    formFieldsWizardStepVO.getFields().removeIf(arg_0 -> CustomWizardServiceImpl.lambda$toExecutionData$22((FormFieldsWizardStepMeta)list2, arg_0));
                }
            } else {
                formFieldsWizardStepMeta = this.getFieldsMetadata(customWizardExecution, (FormFieldsWizardStep)object);
            }
            if (formFieldsWizardStepMeta != null) {
                object2 = CollectionHelper.sort((Collection)formFieldsWizardStepMeta.getWizardFields(true));
                list2 = this.conversionHandler.convertList(CustomFieldDetailedVO.class, object2);
                formFieldsWizardStepVO.setCustomFields(list2);
                if (CollectionHelper.isNotEmpty((Iterable)list2)) {
                    User user = customWizard instanceof RegistrationWizard ? new User((Group)this.getGroup(customWizardExecutionStorage)) : customWizardExecution.getUser();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("user", user);
                    hashMap.put("wizard", customWizard);
                    hashMap.put("step", customWizardStep);
                    hashMap.put("execution", customWizardExecution);
                    hashMap.put("storage", customWizardExecutionStorage);
                    this.customFieldValueHandler.fillValuesFromScript(CustomWizardField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list2);
                }
            }
        } else if (customWizardStep instanceof EmailVerificationWizardStep) {
            customWizardExecutionData.setCodeSentToEmail(customWizardExecutionStorage.getEmailToVerify());
        } else if (customWizardStep instanceof PhoneVerificationWizardStep) {
            object = this.configurationHandler.getAccessor((BasicGroup)this.getGroup(customWizardExecutionStorage));
            PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(customWizardExecutionStorage.getSmsToVerify(), (ConfigurationAccessor)object);
            customWizardExecutionData.setCodeSentToPhone(phoneNumberDescriptor == null ? customWizardExecutionStorage.getSmsToVerify() : phoneNumberDescriptor.toNationalFormat());
        }
        customWizardExecutionData.setTransitions(this.conversionHandler.convertList(CustomWizardTransitionVO.class, (Iterable)customWizardStepWithTransitions2.getTransitions()));
        if (list.size() > 1) {
            object = list.subList(0, list.size() - 1);
            customWizardExecutionData.setPath(object.stream().map(customWizardStepWithTransitions -> (CustomWizardStepVO)this.conversionHandler.convert(CustomWizardStepVO.class, (Object)customWizardStepWithTransitions.getStep())).collect(Collectors.toList()));
        } else {
            customWizardExecutionData.setPath(Collections.emptyList());
        }
        object = (CustomWizardStep)this.conversionHandler.convert(CustomWizardStep.class, (Object)customWizardExecutionData.getStep());
        if (object instanceof FormFieldsWizardStep && ((FormFieldsWizardStep)object).isExternalRedirect()) {
            if (customWizardExecutionStorage.isStepExecuted((CustomWizardStep)object)) {
                customWizardExecutionData.setAction(CustomWizardAction.ALREADY_EXECUTED);
            } else {
                customWizardExecutionData.setAction(CustomWizardAction.EXTERNAL_REDIRECT);
                customWizardExecutionData.setTransitions(Collections.emptyList());
            }
        } else if (customWizardExecutionData.getTransitions().isEmpty()) {
            customWizardExecutionData.setAction(CustomWizardAction.FINISH);
            customWizardExecutionData.setConfirmationPasswordInput(this.doGetCredentialInputForRun(customWizard));
        } else {
            customWizardExecutionData.setAction(CustomWizardAction.STEP);
        }
        if (customWizardStep instanceof FormFieldsWizardStep && customWizardExecutionData.getResultType() == null) {
            this.fillParams(customWizardExecutionData, customWizardExecution, customWizardExecutionStorage, customWizardTransitionParams, (FormFieldsWizardStep)customWizardStep, formFieldsWizardStepMeta);
        }
        return customWizardExecutionData;
    }

    private CustomWizardStep toStep(CustomWizard customWizard, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CustomWizardStep && !customWizard.equals((Object)((CustomWizardStep)object).getWizard())) {
            throw new CustomScriptException("Script returned a step of another wizard: " + String.valueOf(object));
        }
        CustomWizardStep customWizardStep2 = customWizard.getSteps().stream().filter(customWizardStep -> object.toString().equals(customWizardStep.getInternalName())).findAny().orElseThrow(() -> new CustomScriptException("Script returned invalid step string: " + String.valueOf(object)));
        return customWizardStep2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CustomWizardStepWithTransitions toStepWithTransitions(CustomWizardExecution customWizardExecution, Object object2) {
        Object object3;
        List<CustomWizardTransition> list;
        CustomWizardStep customWizardStep;
        Object object4;
        CustomWizard customWizard;
        boolean bl;
        CustomWizardStep customWizardStep2;
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            customWizardStep2 = null;
                            bl = false;
                            customWizard = customWizardExecution.getWizard();
                            if (object2 == null) {
                                return null;
                            }
                            if (!(object2 instanceof String)) break block13;
                            customWizardStep2 = this.toStep(customWizard, object2);
                            break block12;
                        }
                        if (!(object2 instanceof CustomWizardStep)) break block14;
                        customWizardStep2 = (CustomWizardStep)object2;
                        break block12;
                    }
                    if (object2 instanceof CustomWizardStepWithTransitions) {
                        object4 = (CustomWizardStepWithTransitions)object2;
                        if (object4.getTransitions() == null) {
                            customWizardStep2 = object4.getStep();
                            break block12;
                        } else {
                            boolean bl2 = object4.getTransitions().size() == 1;
                            object4.getTransitions().forEach(customWizardTransition -> this.toTransition(customWizard, customWizardTransition, bl2));
                            return object4;
                        }
                    }
                    Map map = (Map)this.conversionHandler.convert(Map.class, object2);
                    object4 = new CustomWizardStepWithTransitions();
                    object4.setStep(this.toStep(customWizard, map.get("step")));
                    customWizardStep = (CustomWizardStep)map.get("final");
                    bl = customWizardStep == null ? false : (Boolean)CoercionHelper.coerce(Boolean.TYPE, (Object)customWizardStep);
                    list = map.get("transitions");
                    if (bl) break block15;
                    if (list instanceof Iterable) {
                        object3 = IteratorUtils.toList(((Iterable)list).iterator());
                        boolean bl3 = object3.size() == 1;
                        object4.setTransitions(object3.stream().map(object -> this.toTransition(customWizard, object, bl3)).collect(Collectors.toList()));
                        break block16;
                    } else if (list != null) {
                        object4.setTransitions(Collections.singletonList(this.toTransition(customWizard, list, true)));
                    }
                    break block16;
                }
                if (list != null) {
                    throw new CustomScriptException("A step marked as final can not have transitions");
                }
            }
            if (object4.getTransitions() != null) return object4;
            customWizardStep2 = object4.getStep();
        }
        if (customWizardStep2 == null) {
            throw new CustomScriptException("No wizard step could be resolved from " + String.valueOf(object2));
        }
        object4 = customWizard.getSteps();
        int n = object4.indexOf(customWizardStep2);
        customWizardStep = null;
        if (!bl) {
            list = object4.listIterator(n + 1);
            while (customWizardStep == null && list.hasNext()) {
                customWizardStep = (CustomWizardStep)list.next();
                if (customWizardStep == null || !this.isExcluded(customWizardExecution, customWizardStep)) continue;
                customWizardStep = null;
            }
        }
        if (customWizardStep == null) {
            list = Collections.emptyList();
            return new CustomWizardStepWithTransitions(customWizardStep2, (List)list);
        }
        object3 = customWizardStep2 instanceof IdentityProviderWizardStep ? GeneralKeys.Ui.WIZARD_SKIP : GeneralKeys.Ui.WIZARD_NEXT;
        CustomWizardTransition customWizardTransition2 = new CustomWizardTransition("next", this.message((MessageKey)object3, new Object[0]));
        list = Collections.singletonList(customWizardTransition2);
        return new CustomWizardStepWithTransitions(customWizardStep2, (List)list);
    }

    private CustomWizardTransition toTransition(CustomWizard customWizard, Object object, boolean bl) {
        String string;
        if (object instanceof CharSequence) {
            String string2 = object.toString();
            if ("next".equals(string2)) {
                return new CustomWizardTransition("next", this.message(GeneralKeys.Ui.WIZARD_NEXT, new Object[0]));
            }
            CustomWizardStep customWizardStep = this.toStep(customWizard, object);
            return new CustomWizardTransition(customWizardStep.getInternalName(), this.getTranslatedName((NamedEntity)customWizardStep));
        }
        if (object instanceof CustomWizardStep) {
            CustomWizardStep customWizardStep = this.toStep(customWizard, object);
            return new CustomWizardTransition(customWizardStep.getInternalName(), this.getTranslatedName((NamedEntity)customWizardStep));
        }
        if (object instanceof CustomWizardTransition) {
            return (CustomWizardTransition)object;
        }
        Map map = (Map)this.conversionHandler.convert(Map.class, object);
        CustomWizardStep customWizardStep = this.toStep(customWizard, map.get("step"));
        String string3 = StringHelper.trimToNull(map.get("id"));
        if (string3 == null && customWizardStep != null) {
            string3 = (String)ObjectHelper.defaultValue((Object)customWizardStep.getInternalName(), (Object)"next");
        }
        if ((string = StringHelper.trimToNull(map.get("label"))) == null) {
            string = bl ? this.message(GeneralKeys.Ui.WIZARD_NEXT, new Object[0]) : this.dataTranslationHandler.getName((NamedEntity)customWizardStep);
        }
        return new CustomWizardTransition(string3, string);
    }

    private void validateAndSetGroup(CustomWizardTransitionParams customWizardTransitionParams, CustomWizardExecutionStorage customWizardExecutionStorage) {
        Validator validator = new Validator();
        Property property = validator.property((org.cyclos.model.Property)CustomWizardTransitionParams.GROUP, UsersKeys.Users.GROUP);
        final List list = this.getConfiguration().getPossibleInitialGroups();
        if (list.isEmpty()) {
            property.invalid();
        } else {
            property.entity(UserGroup.class, (EntityValidation)new BaseEntityValidation<UserGroup>(){

                protected boolean isValid(Object object, Object object2, UserGroup userGroup) {
                    return list.contains(userGroup);
                }
            });
            if (list.size() > 1) {
                property.required();
            }
        }
        this.validate(validator, customWizardTransitionParams, "validateAndSetGroup");
        UserGroup userGroup = (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)customWizardTransitionParams.getGroup());
        if (list.size() == 1) {
            userGroup = (UserGroup)CollectionHelper.first((Iterable)list);
        }
        this.ensurePublicRegistrationDto(userGroup, customWizardExecutionStorage);
    }

    private void validateFormFields(FormFieldsWizardStep formFieldsWizardStep, CustomWizardTransitionParams customWizardTransitionParams, CustomWizardExecution customWizardExecution) {
        Set set;
        Object object;
        Object object2;
        CustomWizard customWizard = customWizardExecution.getWizard();
        CustomWizardExecutionStorage customWizardExecutionStorage = this.storage(customWizardExecution);
        Validator validator = new Validator();
        boolean bl = customWizard.getNature() == CustomWizardNature.REGISTRATION;
        UserGroup userGroup = bl ? this.getGroup(customWizardExecutionStorage) : null;
        FormFieldsWizardStepMeta formFieldsWizardStepMeta = this.getFieldsMetadata(customWizardExecution, formFieldsWizardStep);
        if (bl) {
            String string;
            Object object3;
            String string2;
            UserValidationFields userValidationFields;
            object2 = customWizardTransitionParams.getUser();
            object = this.configurationHandler.getAccessor((BasicGroup)userGroup);
            if (object2 == null && !formFieldsWizardStepMeta.isEmpty()) {
                throw new ValidationException(this.message(GeneralKeys.Errors.REQUIRED, UsersKeys.Users.USER));
            }
            set = formFieldsWizardStepMeta.getProfileFields(false);
            Set set2 = formFieldsWizardStepMeta.getPhoneNatures(false);
            object2.setGroup(new GroupVO(userGroup.getId()));
            if (customWizardExecutionStorage.getExternalPaymentToken() != null) {
                object2.setExternalPaymentToken(customWizardExecutionStorage.getExternalPaymentToken());
                userValidationFields = this.externalPaymentServiceLocal.findByToken(customWizardExecutionStorage.getExternalPaymentToken());
                string2 = userValidationFields.getToPrincipalType().getInternalName();
                if (string2.equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                    object2.setEmail(userValidationFields.getToPrincipalValue());
                } else if (string2.equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                    object3 = CollectionHelper.orEmpty((List)object2.getMobilePhones()).stream().filter(arg_0 -> CustomWizardServiceImpl.lambda$validateFormFields$28((ExternalPayment)userValidationFields, arg_0)).findFirst().orElse(new MobilePhoneDTO());
                    object3.setVerified(true);
                    object3.setRawNumber(userValidationFields.getToPrincipalValue());
                    object2.setMobilePhones(Arrays.asList(object3));
                }
            }
            userValidationFields = new UserValidationFields();
            userValidationFields.setProfileFields((Collection)set);
            userValidationFields.setPhoneNatures(set2);
            userValidationFields.setPassword(formFieldsWizardStepMeta.isPasswords());
            userValidationFields.setSecurityQuestion(formFieldsWizardStepMeta.isSecurityQuestion());
            userValidationFields.setAgreements(formFieldsWizardStepMeta.isAgreements());
            userValidationFields.setCaptcha(formFieldsWizardStepMeta.isCaptcha() && !customWizardExecutionStorage.isCaptchaValidated() && customWizardExecutionStorage.getIdentityProviderProfile() == null);
            this.userService.validate((UserDTO)object2, UserRegistration.WIZARD, userValidationFields);
            if (set.contains(BasicProfileField.EMAIL) && formFieldsWizardStepMeta.isRequireEmailVerification()) {
                string2 = validator.property((org.cyclos.model.Property)CustomWizardTransitionParams.EMAIL_VERIFICATION, SystemKeys.Wizards.EXECUTION_EMAIL_VERIFICATION);
                object3 = StringHelper.trim((Object)object2.getEmail());
                if (!((String)object3).equals(customWizardExecutionStorage.getVerifiedEmail())) {
                    string2.required();
                }
                if ((string = StringHelper.trimToNull((Object)customWizardExecutionStorage.getEmailToVerify())) == null || !string.equals(object3)) {
                    string2.invalid();
                }
            }
            if (set2.contains(PhoneNature.MOBILE) && formFieldsWizardStepMeta.isRequirePhoneVerification()) {
                PhoneNumberDescriptor phoneNumberDescriptor;
                string2 = validator.property((org.cyclos.model.Property)CustomWizardTransitionParams.SMS_VERIFICATION, SystemKeys.Wizards.EXECUTION_SMS_VERIFICATION);
                object3 = (MobilePhoneDTO)CollectionHelper.first((Iterable)object2.getMobilePhones());
                string = object3 == null ? null : this.phoneNumberHandler.parse(object3.getRawNumber(), (ConfigurationAccessor)object);
                PhoneNumberDescriptor phoneNumberDescriptor2 = this.phoneNumberHandler.parse(customWizardExecutionStorage.getVerifiedSms(), (ConfigurationAccessor)object);
                if (string != null && !this.phoneNumberHandler.equals((PhoneNumberDescriptor)string, phoneNumberDescriptor2)) {
                    string2.required();
                }
                if ((phoneNumberDescriptor = this.phoneNumberHandler.parse(customWizardExecutionStorage.getSmsToVerify(), (ConfigurationAccessor)object)) == null || string == null || !this.phoneNumberHandler.equals((PhoneNumberDescriptor)string, phoneNumberDescriptor)) {
                    string2.invalid();
                }
            }
        }
        if (CollectionHelper.isNotEmpty((Iterable)(object2 = formFieldsWizardStepMeta.getWizardFields(false)))) {
            object = new HashMap();
            object.put("wizard", customWizard);
            object.put("step", formFieldsWizardStep);
            object.put("execution", customWizardExecution);
            object.put("storage", customWizardExecutionStorage);
            set = bl ? new User((Group)userGroup) : null;
            object.put("user", set);
            for (UserValidationFields userValidationFields : CollectionHelper.sort((Collection)object2)) {
                this.customFieldValueHandler.addValueValidation(validator, (CustomField)userValidationFields, null, (Map)object, CustomWizardTransitionParams.CUSTOM_VALUES.getName());
            }
        }
        if (customWizard.isRequireConfirmationCredential() && customWizardTransitionParams.getTransition() == null) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (org.cyclos.model.Property)CustomWizardTransitionParams.CONFIRMATION_PASSWORD);
        }
        this.validate(validator, customWizardTransitionParams, "validateFormFields");
    }

    private static /* synthetic */ boolean lambda$validateFormFields$28(ExternalPayment externalPayment, MobilePhoneDTO mobilePhoneDTO) {
        return mobilePhoneDTO.getRawNumber().equals(externalPayment.getToPrincipalValue());
    }

    private static /* synthetic */ boolean lambda$toExecutionData$22(FormFieldsWizardStepMeta formFieldsWizardStepMeta, FormFieldsWizardStepFieldVO formFieldsWizardStepFieldVO) {
        return !formFieldsWizardStepMeta.has((Object)formFieldsWizardStepFieldVO);
    }

    private static /* synthetic */ boolean lambda$fillParams$6(CustomWizardField customWizardField, CustomFieldDetailedVO customFieldDetailedVO) {
        return customFieldDetailedVO.getId().equals(customWizardField.getId());
    }

    static {
        SUBCLASS_MAPPINGS.put(RegistrationWizard.class, RegistrationWizardDTO.class);
        SUBCLASS_MAPPINGS.put(SystemWizard.class, SystemWizardDTO.class);
        SUBCLASS_MAPPINGS.put(UserWizard.class, UserWizardDTO.class);
        SUBCLASS_MAPPINGS.put(MenuItemWizard.class, MenuItemWizardDTO.class);
    }
}

