/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.time.StopWatch;
import org.cyclos.db.GenerateDbSchema;
import org.cyclos.entities.DatabaseHistoryLog;
import org.cyclos.entities.utils.EntityBackedParameterStorage;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.DbSchemaInconsistencyParameters;
import org.cyclos.impl.system.SystemMonitorServiceLocal;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.license.api.model.DatabaseUpgradeData;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.stro.dbdiff.DatabaseDiff;
import org.stro.dbdiff.MetadataHandler;
import org.stro.dbdiff.PostgreSQLMetadataHandler;
import org.stro.dbdiff.model.AddedDiffResultDescriptor;
import org.stro.dbdiff.model.DatabaseDiffResult;
import org.stro.dbdiff.model.DatabaseMetadata;

@Component
public class DbSchemaVerificationRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private SystemMonitorServiceLocal systemMonitorService;
    private List<Integer> expectedSchemasVersions;

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.DB_SCHEMA_VERIFICATION;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        PostgreSQLMetadataHandler postgreSQLMetadataHandler = new PostgreSQLMetadataHandler();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        DatabaseMetadata databaseMetadata = (DatabaseMetadata)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, arg_0 -> this.lambda$execute$0((MetadataHandler)postgreSQLMetadataHandler, arg_0));
        stopWatch.stop();
        this.getLogger().info("Database metadata loaded in {}", (Object)stopWatch);
        String string = "/db/" + this.getDbSchemaFileName(databaseMetadata.getProductVersionCode());
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            this.getLogger().warn("JSON file {} containing the expected db schema was not found. Skipping check", (Object)string);
            return 0L;
        }
        DatabaseMetadata databaseMetadata2 = postgreSQLMetadataHandler.loadFromJson(inputStream);
        DatabaseDiffResult databaseDiffResult = new DatabaseDiff(databaseMetadata2, databaseMetadata).diff();
        AddedDiffResultDescriptor addedDiffResultDescriptor = databaseDiffResult.clearAdded();
        Boolean bl = (Boolean)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            EntityBackedParameterStorage entityBackedParameterStorage = this.getStorage();
            DatabaseDiffResult databaseDiffResult2 = (DatabaseDiffResult)entityBackedParameterStorage.getObject("dbDiff");
            if (databaseDiffResult2 != null) {
                MetadataHandler.fillNames((DatabaseDiffResult)databaseDiffResult2);
                if (databaseDiffResult2.equals((Object)databaseDiffResult)) {
                    return false;
                }
            }
            entityBackedParameterStorage.setObject("dbDiff", (Object)databaseDiffResult);
            return true;
        });
        if (!bl.booleanValue() || databaseDiffResult.isEmpty()) {
            if (databaseDiffResult.isEmpty()) {
                this.getLogger().info("Database schema is correct" + (String)(addedDiffResultDescriptor.isEmpty() ? "!" : " but some added objects where found: " + this.toString(addedDiffResultDescriptor)));
            } else {
                this.getLogger().info("Differences between actual and expected schemas were found but they were already notified.");
            }
            return 0L;
        }
        this.getLogger().warn("Differences between actual and expected schemas were found!");
        if (!addedDiffResultDescriptor.isEmpty()) {
            this.getLogger().warn("Ignoring added objects: {}", (Object)this.toString(addedDiffResultDescriptor));
        }
        this.generateAlert(databaseDiffResult, (MetadataHandler)postgreSQLMetadataHandler);
        this.notifyIssueToLicense(() -> this.createDbSchemaInconsistencyParameters(databaseDiffResult, databaseMetadata));
        return 1L;
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    private DbSchemaInconsistencyParameters createDbSchemaInconsistencyParameters(DatabaseDiffResult databaseDiffResult, DatabaseMetadata databaseMetadata) {
        List list = this.systemMonitorService.listAllFailedDatabaseHistoryLogs();
        List list2 = list.stream().map(this::toLicenseDatabaseUpgradeData).collect(Collectors.toList());
        DbSchemaInconsistencyParameters dbSchemaInconsistencyParameters = new DbSchemaInconsistencyParameters(databaseDiffResult, databaseMetadata.getProductVersion(), list2);
        return dbSchemaInconsistencyParameters;
    }

    private void generateAlert(DatabaseDiffResult databaseDiffResult, MetadataHandler metadataHandler) {
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            List list = metadataHandler.ddlGenerator(databaseDiffResult).enableAdd().enableRevert().generate();
            String string = list.stream().collect(Collectors.joining(System.lineSeparator()));
            this.alertService.create(SystemAlertType.INCONSISTENT_DB_SCHEMA, new Object[]{"BEGIN;" + System.lineSeparator() + string + System.lineSeparator() + "COMMIT;"});
            return null;
        });
    }

    private String getDbSchemaFileName(int n) {
        Integer n3 = this.expectedSchemasVersions.stream().dropWhile(n2 -> n2 > n).findFirst().orElse(this.expectedSchemasVersions.get(0));
        return String.format("db-schema%s.json", n3 == GenerateDbSchema.MIN_POSTGRESQL_VERSION_NUM ? "" : "-" + GenerateDbSchema.toServerVersion(n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void initialize() {
        this.expectedSchemasVersions = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("db-schema(-(\\d*))?\\.json");
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            for (Resource resource : pathMatchingResourcePatternResolver.getResources("/db/db-schema*.json")) {
                Matcher matcher = pattern.matcher(resource.getFilename());
                if (!matcher.matches()) continue;
                String string = matcher.group(2);
                this.expectedSchemasVersions.add(StringHelper.isBlank((Object)string) ? GenerateDbSchema.MIN_POSTGRESQL_VERSION_NUM : GenerateDbSchema.toServerVersionNum(string));
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("Error loading db-schema*.json resources. Using default", (Throwable)iOException);
            this.expectedSchemasVersions = Arrays.asList(GenerateDbSchema.MIN_POSTGRESQL_VERSION_NUM);
        }
        finally {
            this.expectedSchemasVersions.sort(Comparator.naturalOrder().reversed());
        }
    }

    private DatabaseUpgradeData toLicenseDatabaseUpgradeData(DatabaseHistoryLog databaseHistoryLog) {
        DatabaseUpgradeData databaseUpgradeData = new DatabaseUpgradeData();
        databaseUpgradeData.setCyclosVersion(databaseHistoryLog.getApplicationVersion());
        databaseUpgradeData.setDate(databaseHistoryLog.getDate());
        databaseUpgradeData.setDbVersion(databaseHistoryLog.getDatabaseVersion());
        databaseUpgradeData.setError(databaseHistoryLog.getError());
        return databaseUpgradeData;
    }

    private String toString(AddedDiffResultDescriptor addedDiffResultDescriptor) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("functions", addedDiffResultDescriptor.getFunctions());
        hashMap.put("sequences", addedDiffResultDescriptor.getSequences());
        hashMap.put("tables", addedDiffResultDescriptor.getTables());
        hashMap.put("views", addedDiffResultDescriptor.getViews());
        return hashMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(entry -> (String)entry.getKey() + " = " + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
    }

    private /* synthetic */ DatabaseMetadata lambda$execute$0(MetadataHandler metadataHandler, TransactionStatus transactionStatus) {
        return metadataHandler.loadFromDatabase(this.jdbcTemplate, GenerateDbSchema.CYCLOS_DB_OPTIONS);
    }
}

