/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.cyclos.db.DatabasePopulator;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QEntityLog;
import org.cyclos.entities.system.QEntityPropertyLog;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.TablePropertyLogDescriptor;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.impl.system.EntityLogHelper;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityActionLog;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogSearchData;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityLogTypeFilter;
import org.cyclos.model.system.entitylogs.EntityPropertyLogOrderBy;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.system.entitylogs.EntityPropertyLogVO;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.recordtypes.SystemRecordTypeVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityLogServiceImpl
extends BaseServiceImpl
implements EntityLogServiceLocal {
    private static final QEntityPropertyLog $ = QEntityPropertyLog.entityPropertyLog;
    @Autowired
    private EntityLogRegistry entityLogRegistry;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private RecordTypeServiceLocal recordTypeServiceLocal;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;

    public FileInfo exportEntityPropertyLogs(@NotNull ExportFormatVO exportFormatVO, @NotNull EntityPropertyLogQuery entityPropertyLogQuery) {
        DataIterator dataIterator = CloseableIteratorHelper.asDataIterator((CloseableIterator)this.toDBQuery(entityPropertyLogQuery).export((Expression)$));
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.ENTITY_LOGS, (QueryParameters)entityPropertyLogQuery, dataIterator);
    }

    public EntityLogSearchData getGeneralSearchData(boolean bl) throws FrameworkException {
        EntityLogSearchData entityLogSearchData = this.createSearchData();
        entityLogSearchData.setRecordTypes(this.conversionHandler.convertList(RecordTypeVO.class, (Iterable)this.recordTypeServiceLocal.listVisibleUserTypes()));
        Set set = EntityLogTypeFilter.filtersByTypes((Set)EntityLogType.getEntityLogTypes((boolean)bl));
        entityLogSearchData.setTypeFilters(set.stream().collect(Collectors.toList()));
        if (this.getSessionData().getNetwork() == null) {
            entityLogSearchData.setNetworks(this.networkService.getManagedNetworks());
        }
        EntityPropertyLogQuery entityPropertyLogQuery = (EntityPropertyLogQuery)entityLogSearchData.getQuery();
        entityPropertyLogQuery.setTypeFilters(set);
        if (!bl) {
            entityPropertyLogQuery.setAsManager(Boolean.valueOf(true));
        }
        return entityLogSearchData;
    }

    public EntityLogSearchData getSearchData(Long l, EntityLogType entityLogType) throws FrameworkException {
        EntityLogSearchData entityLogSearchData = this.createSearchData();
        EntityPropertyLogQuery entityPropertyLogQuery = (EntityPropertyLogQuery)entityLogSearchData.getQuery();
        entityPropertyLogQuery.setEntityId(l);
        if (entityLogType == EntityLogType.USER) {
            List list = this.profileFieldHandler.getFieldsByAction((BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)l), ProfileFieldAction.VIEW);
            Set set = EntityLogTypeFilter.filtersByTypes((Set)CollectionHelper.asSet((Object[])new EntityLogType[]{EntityLogType.USER, EntityLogType.ADDRESS, EntityLogType.PHONE}));
            set.removeIf(entityLogTypeFilter -> entityLogTypeFilter != EntityLogTypeFilter.USER_ACTIONS && entityLogTypeFilter != EntityLogTypeFilter.USER_FIELDS && !list.contains(entityLogTypeFilter.getEntityLogType() == EntityLogType.ADDRESS ? BasicProfileField.ADDRESS : BasicProfileField.PHONE));
            entityPropertyLogQuery.setTypeFilters(set);
            entityLogSearchData.setTypeFilters(set.stream().collect(Collectors.toList()));
        }
        entityPropertyLogQuery.setType(entityLogType);
        entityPropertyLogQuery.setAsManager(Boolean.valueOf(false));
        return entityLogSearchData;
    }

    public EntityLogSearchData getSystemRecordsLogsSearchData(SystemRecordTypeVO systemRecordTypeVO) throws FrameworkException {
        EntityLogSearchData entityLogSearchData = this.createSearchData();
        EntityPropertyLogQuery entityPropertyLogQuery = (EntityPropertyLogQuery)entityLogSearchData.getQuery();
        entityPropertyLogQuery.setTypeFilters(CollectionHelper.asSet((Object[])new EntityLogTypeFilter[]{EntityLogTypeFilter.SYSTEM_RECORD}));
        entityPropertyLogQuery.setRecordType((RecordTypeVO)systemRecordTypeVO);
        return entityLogSearchData;
    }

    public EntityPropertyLogVO load(Long l) {
        EntityPropertyLog entityPropertyLog = this.getSessionData().getNetwork() == null ? (EntityPropertyLog)this.rawEntityManagerHandler.find(EntityPropertyLog.class, l) : this.find(EntityPropertyLog.class, l);
        return (EntityPropertyLogVO)this.conversionHandler.convert(EntityPropertyLogVO.class, (Object)entityPropertyLog);
    }

    public EntityLog log(SimpleEntity simpleEntity, String string, String string2, String string3, String string4, EntityActionLog entityActionLog) {
        Object object;
        String string5;
        EntityLogHandler entityLogHandler = this.entityLogRegistry.getHandler(simpleEntity.getClass());
        EntityPropertyLog entityPropertyLog = new EntityPropertyLog();
        entityPropertyLog.setValues(string3, string4);
        entityPropertyLog.setName(string);
        entityPropertyLog.setPropertyName(string2);
        entityPropertyLog.setOrder(Integer.valueOf(0));
        Long l = null;
        Field field = FieldHelper.getAnnotatedField(simpleEntity.getClass(), OwnerEntity.class);
        String string6 = string5 = field == null ? null : field.getName();
        if (string5 != null && (object = new BeanWrapperImpl((Object)simpleEntity).getPropertyValue(string5)) != null) {
            l = ((SimpleEntity)object).getId();
        }
        object = entityLogHandler.getEntityLogName(simpleEntity, null, EntityLogEvent.UPDATE);
        String string7 = entityLogHandler.getEntityLogNamePrefix(simpleEntity, null);
        return this.log((String)object, string7, simpleEntity.getId(), null, l, entityLogHandler.getRelatedEntityId(simpleEntity), entityLogHandler.getType(), EntityLogEvent.UPDATE, entityActionLog, Arrays.asList(entityPropertyLog), entityLogHandler.isAsManager(simpleEntity));
    }

    public EntityLog log(String string, String string2, long l, Boolean bl, Long l2, Long l3, EntityLogType entityLogType, EntityLogEvent entityLogEvent, EntityActionLog entityActionLog, List<EntityPropertyLog> list, boolean bl2) {
        EntityLog entityLog = this.createEntityLog(list);
        SessionData sessionData = this.getSessionData();
        entityLog.setBy(sessionData.getLoggedBasicUser());
        entityLog.setChannel(sessionData.getChannelName());
        entityLog.setDate(new Date());
        entityLog.setEntityId(l);
        entityLog.setEvent(entityLogEvent);
        entityLog.setName(string);
        entityLog.setNamePrefix(string2);
        entityLog.setNetwork(sessionData.getNetwork());
        entityLog.setOwnerEntityId(l2);
        entityLog.setRelatedEntityId(l3);
        entityLog.setRemoteAddress(sessionData.getRemoteAddress());
        entityLog.setType(entityLogType);
        entityLog.setPrivateEntity(entityLogEvent == EntityLogEvent.DELETE ? bl : null);
        entityLog.setAsManager(bl2);
        entityLog.setEntityActionLog(entityActionLog);
        this.persist((IEntity)entityLog);
        return entityLog;
    }

    public EntityLog logEntity(SimpleEntity simpleEntity, SimpleEntity simpleEntity2, Supplier<String> supplier) {
        SimpleEntity simpleEntity3 = (SimpleEntity)ObjectHelper.defaultValue((Object)simpleEntity2, (Object)simpleEntity);
        if (!this.entityLogRegistry.isLogEnabled(simpleEntity3)) {
            return null;
        }
        List list = this.createPropertyLogs(simpleEntity, simpleEntity2);
        EntityLogEvent entityLogEvent = this.getEntityLogEvent(simpleEntity, simpleEntity2);
        EntityLogHandler entityLogHandler = this.entityLogRegistry.getHandler(simpleEntity3.getClass());
        if (!DatabasePopulator.isInPopulator()) {
            list = entityLogHandler.onBeforeLog(simpleEntity, simpleEntity2, list, entityLogEvent);
        }
        if (CollectionHelper.isNotEmpty(list)) {
            Object object;
            Object object2;
            long l = simpleEntity3.getId();
            Long l2 = null;
            if (supplier == null) {
                object2 = FieldHelper.getAnnotatedField(simpleEntity3.getClass(), OwnerEntity.class);
                supplier = () -> EntityLogServiceImpl.lambda$logEntity$1((Field)object2);
            }
            object2 = null;
            object2 = supplier.get();
            if (object2 != null && (object = new BeanWrapperImpl((Object)simpleEntity3).getPropertyValue((String)object2)) != null) {
                l2 = ((SimpleEntity)object).getId();
            }
            object = entityLogHandler.getEntityLogName(simpleEntity, simpleEntity2, entityLogEvent);
            String string = entityLogHandler.getEntityLogNamePrefix(simpleEntity, simpleEntity2);
            boolean bl = entityLogHandler.isPrivateEntity(simpleEntity);
            return this.log((String)object, string, l, bl, l2, entityLogHandler.getRelatedEntityId(simpleEntity3), entityLogHandler.getType(), entityLogEvent, null, list, entityLogHandler.isAsManager(simpleEntity3));
        }
        return null;
    }

    public void removeAll(BasicUser basicUser) {
        QEntityLog qEntityLog = QEntityLog.entityLog;
        QEntityPropertyLog qEntityPropertyLog = QEntityPropertyLog.entityPropertyLog;
        BooleanExpression booleanExpression = qEntityLog.entityId.eq((Object)basicUser.getId()).and((Predicate)qEntityLog.type.in((Object[])new EntityLogType[]{EntityLogType.USER})).or((Predicate)qEntityLog.ownerEntityId.eq((Object)basicUser.getId()).and((Predicate)qEntityLog.type.in((Object[])new EntityLogType[]{EntityLogType.PHONE, EntityLogType.ADDRESS, EntityLogType.OPERATOR, EntityLogType.USER_RECORD, EntityLogType.TOKEN, EntityLogType.AD})));
        this.entityManagerHandler.delete((EntityPath)qEntityPropertyLog).where(new Predicate[]{qEntityPropertyLog.entityLog().id.in((SubQueryExpression)((JPAQuery)((JPAQuery)new JPAQuery().from((EntityPath)qEntityLog)).where((Predicate)booleanExpression)).select((Expression)qEntityLog.id))}).execute();
        this.entityManagerHandler.delete((EntityPath)qEntityLog).where(new Predicate[]{booleanExpression}).execute();
    }

    public Page<EntityPropertyLogVO> search(EntityPropertyLogQuery entityPropertyLogQuery) {
        DBQuery<?> dBQuery = this.toDBQuery(entityPropertyLogQuery);
        return dBQuery.page(EntityPropertyLogVO.class, (QueryParameters)entityPropertyLogQuery, (Expression)$);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QEntityLog.entityLog.network());
        networkPathRegistry.register(QEntityPropertyLog.entityPropertyLog.entityLog().network());
    }

    private List<EntityPropertyLog> addEntityPropertyLog(String string, String string2, String string3, String string4, Long l, List<EntityPropertyLog> list) {
        EntityPropertyLog entityPropertyLog = new EntityPropertyLog();
        if (l == null) {
            entityPropertyLog.setPropertyName(string2);
        } else {
            entityPropertyLog.setCustomFieldId(l);
        }
        entityPropertyLog.setName(string);
        entityPropertyLog.setOrder(Integer.valueOf(list.size()));
        entityPropertyLog.setValues(string3, string4);
        list.add(entityPropertyLog);
        return list;
    }

    private <E extends SimpleEntity, DTO extends EntityDTO> void addPropertyLog(String string, Object object, Object object2, PropertyAccess propertyAccess, List<EntityPropertyLog> list, E e, E e2, EntityLogHandler<E, DTO> entityLogHandler) {
        FormatterImpl formatterImpl = this.getFormatter();
        if (!entityLogHandler.areEquals(e, e2, propertyAccess, object, object2)) {
            String string2 = this.format(formatterImpl, propertyAccess, object);
            String string3 = this.format(formatterImpl, propertyAccess, object2);
            Object object3 = propertyAccess.getIdentifier();
            Long l = null;
            if (object3 instanceof ICustomField) {
                ICustomField iCustomField = (ICustomField)object3;
                l = iCustomField.getId();
            }
            this.addEntityPropertyLog(string, propertyAccess.getPropertyName(), string2, string3, l, list);
        }
    }

    private <E extends SimpleEntity, DTO extends EntityDTO> void addTablePropertyLog(String string, TablePropertyLogDescriptor<?, ?> tablePropertyLogDescriptor, Collection<?> collection, Collection<?> collection2, List<EntityPropertyLog> list, E e, E e2, EntityLogHandler<E, DTO> entityLogHandler) {
        if (CollectionHelper.isEmpty(collection) && CollectionHelper.isEmpty(collection2)) {
            return;
        }
        FormatterImpl formatterImpl = this.getFormatter();
        PropertyAccess propertyAccess = tablePropertyLogDescriptor.getRowIdAccess();
        Map<Object, String> map = this.getTablePropertyLogValues(tablePropertyLogDescriptor, collection);
        Map<Object, String> map2 = this.getTablePropertyLogValues(tablePropertyLogDescriptor, collection2);
        TablePropertyLogDescriptor tablePropertyLogDescriptor2 = tablePropertyLogDescriptor.getNestedTableDescriptor();
        map.entrySet().stream().forEach(entry -> {
            Object k = entry.getKey();
            Object object = propertyAccess.get(k);
            String string2 = (String)entry.getValue();
            String string3 = string + " - " + formatterImpl.format(object);
            if (map2.containsKey(k)) {
                String string4 = (String)map2.get(k);
                Object object3 = map2.keySet().stream().filter(object2 -> object2.equals(k)).findAny().get();
                this.addTablePropertyRowLog(string3, string2, string4, propertyAccess, k, object3, tablePropertyLogDescriptor2, list, e, e2, entityLogHandler);
                map2.remove(k);
            } else {
                this.addTablePropertyRowLog(string3, StringHelper.trimToNull((Object)string2), null, propertyAccess, k, null, tablePropertyLogDescriptor2, list, e, e2, entityLogHandler);
            }
        });
        map2.entrySet().stream().forEach(entry -> {
            Object k = entry.getKey();
            Object object = propertyAccess.get(k);
            String string2 = (String)entry.getValue();
            String string3 = string + " - " + formatterImpl.format(object);
            this.addTablePropertyRowLog(string3, null, StringHelper.trimToNull((Object)string2), propertyAccess, null, k, tablePropertyLogDescriptor2, list, e, e2, entityLogHandler);
        });
    }

    private <E extends SimpleEntity, DTO extends EntityDTO> void addTablePropertyRowLog(String string, String string2, String string3, PropertyAccess propertyAccess, Object object, Object object2, TablePropertyLogDescriptor<?, ?> tablePropertyLogDescriptor, List<EntityPropertyLog> list, E e, E e2, EntityLogHandler<E, DTO> entityLogHandler) {
        this.addPropertyLog(string, string2, string3, propertyAccess, list, e, e2, entityLogHandler);
        if (tablePropertyLogDescriptor != null) {
            PropertyAccess propertyAccess2 = tablePropertyLogDescriptor.getAccess();
            Collection collection = (Collection)(object == null ? null : propertyAccess2.get(object));
            Collection collection2 = (Collection)(object2 == null ? null : propertyAccess2.get(object2));
            this.addTablePropertyLog(string, tablePropertyLogDescriptor, collection, collection2, list, e, e2, entityLogHandler);
        }
    }

    private EntityLog createEntityLog(List<EntityPropertyLog> list) {
        EntityLog entityLog = new EntityLog();
        for (EntityPropertyLog entityPropertyLog : list) {
            entityPropertyLog.setEntityLog(entityLog);
        }
        entityLog.setPropertyLogs(list);
        return entityLog;
    }

    private <E extends SimpleEntity> List<EntityPropertyLog> createPropertyLogs(E e, E e2) {
        SimpleEntity simpleEntity = (SimpleEntity)ObjectHelper.defaultValue(e2, e);
        if (!this.entityLogRegistry.isLogEnabled(simpleEntity)) {
            return Collections.emptyList();
        }
        if (e == null) {
            return this.addEntityPropertyLog(this.message(SystemKeys.EntityLogs.ENTITY_CREATED, new Object[0]), null, null, null, null, new ArrayList<EntityPropertyLog>());
        }
        if (DatabasePopulator.isInPopulator()) {
            return Collections.emptyList();
        }
        EntityLogHandler entityLogHandler = this.entityLogRegistry.getHandler(simpleEntity.getClass());
        EntityLogDescriptor entityLogDescriptor = entityLogHandler.resolveLogDescriptor(simpleEntity);
        entityLogDescriptor.validate();
        FormatterImpl formatterImpl = this.getFormatter();
        ArrayList<EntityPropertyLog> arrayList = new ArrayList<EntityPropertyLog>();
        for (PropertyLogDescriptor propertyLogDescriptor : entityLogDescriptor.getProperties()) {
            PropertyAccess propertyAccess = propertyLogDescriptor.getAccess();
            String string = formatterImpl.format(ObjectHelper.defaultValue((Object)propertyLogDescriptor.getLabel(), (Object)propertyAccess.getPropertyName()));
            Pair pair = entityLogHandler.getValues(e, e2, propertyLogDescriptor);
            if (pair != null) {
                this.addPropertyLog(string, this.normalizeValue(pair.getFirst()), this.normalizeValue(pair.getSecond()), propertyAccess, arrayList, e, e2, entityLogHandler);
                continue;
            }
            EntityLogHelper entityLogHelper = new EntityLogHelper(propertyAccess, e, e2);
            Object object = entityLogHelper.getOldValue();
            Object object2 = entityLogHelper.getNewValue();
            if (propertyLogDescriptor.isTable()) {
                this.addTablePropertyLog(string, (TablePropertyLogDescriptor)propertyLogDescriptor, (Collection)object, (Collection)object2, arrayList, e, e2, entityLogHandler);
                continue;
            }
            this.addPropertyLog(string, this.normalizeValue(object), this.normalizeValue(object2), propertyAccess, arrayList, e, e2, entityLogHandler);
        }
        return arrayList;
    }

    private EntityPropertyLogQuery createQuery() {
        EntityPropertyLogQuery entityPropertyLogQuery = (EntityPropertyLogQuery)QueryHelper.newQuery(EntityPropertyLogQuery.class);
        entityPropertyLogQuery.setOrderBy(EntityPropertyLogOrderBy.DATE);
        return entityPropertyLogQuery;
    }

    private EntityLogSearchData createSearchData() {
        EntityLogSearchData entityLogSearchData = new EntityLogSearchData();
        entityLogSearchData.setQuery((QueryParameters)this.createQuery());
        entityLogSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.ENTITY_LOGS)));
        return entityLogSearchData;
    }

    private String format(FormatterImpl formatterImpl, PropertyAccess propertyAccess, Object object) {
        Object object2 = propertyAccess.getIdentifier();
        if (object2 instanceof CustomField) {
            CustomField customField = (CustomField)object2;
            return this.customFieldValueHandler.format(formatterImpl, customField, object);
        }
        if (object instanceof CharSequence && PropertyHelper.isSecretProperty((String)propertyAccess.getPropertyName())) {
            return "****";
        }
        if (object instanceof StoredFile) {
            return ((StoredFile)object).getName();
        }
        return formatterImpl.format(object);
    }

    private Comparator<?> getComparator(Collection<?> collection, Comparator<?> comparator) {
        if (comparator != null) {
            return comparator;
        }
        if (CollectionHelper.first(collection) instanceof Comparable) {
            return Comparator.naturalOrder();
        }
        return null;
    }

    private <E extends SimpleEntity> EntityLogEvent getEntityLogEvent(E e, E e2) throws IllegalArgumentException {
        if (ObjectHelper.areAllNulls((Object[])new Object[]{e, e2})) {
            throw new IllegalArgumentException("Can't calculate the property logs: at least oldEntity or newEntity must be not null");
        }
        EntityLogEvent entityLogEvent = e != null && e2 != null ? EntityLogEvent.UPDATE : (e != null ? EntityLogEvent.DELETE : EntityLogEvent.CREATE);
        return entityLogEvent;
    }

    private Map<Object, String> getTablePropertyLogValues(TablePropertyLogDescriptor<?, ?> tablePropertyLogDescriptor, Collection<?> list) {
        FormatterImpl formatterImpl = this.getFormatter();
        PropertyAccess propertyAccess = tablePropertyLogDescriptor.getRowIdAccess();
        Comparator<?> comparator = this.getComparator(list, tablePropertyLogDescriptor.getRowComparator());
        if (comparator != null) {
            list = CollectionHelper.sort(list, Comparator.comparing(object -> propertyAccess.get(object), comparator));
        }
        return CollectionHelper.asStream(list).map(object -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (Pair pair : tablePropertyLogDescriptor.columns()) {
                if (!((Boolean)((PropertyAccess)pair.getFirst()).get(object)).booleanValue()) continue;
                stringBuilder.append(formatterImpl.format(ObjectHelper.defaultValue((Object)pair.getSecond(), (Object)((PropertyAccess)pair.getFirst()).getPropertyName())));
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            return Pair.create((Object)object, (Object)stringBuilder.toString());
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (string, string2) -> string2, LinkedHashMap::new));
    }

    private Object normalizeValue(Object object) {
        if (object instanceof String) {
            return StringHelper.trimToNull((Object)object);
        }
        if (object instanceof Collection && ((Collection)object).isEmpty() || object instanceof Map && ((Map)object).isEmpty()) {
            return null;
        }
        return object;
    }

    private DBQuery<?> toDBQuery(EntityPropertyLogQuery entityPropertyLogQuery) {
        DBQuery dBQuery;
        if (entityPropertyLogQuery.getEntityId() == null ? CollectionHelper.isEmpty((Iterable)entityPropertyLogQuery.getTypeFilters()) : entityPropertyLogQuery.getType() == null) {
            throw new ValidationException();
        }
        if (entityPropertyLogQuery.getEntityId() != null) {
            dBQuery = this.from(new EntityPath[]{$});
            this.entityLogRegistry.getHandler(entityPropertyLogQuery.getType()).applyLogFilters(dBQuery, entityPropertyLogQuery);
        } else {
            BooleanExpression booleanExpression;
            Object object;
            QEntityLog qEntityLog = $.entityLog();
            SessionData sessionData = this.getSessionData();
            if (sessionData.getNetwork() != null) {
                dBQuery = this.from(new EntityPath[]{$});
            } else {
                dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{$});
                if (sessionData.isMultiNetworkAdminInGlobalMode()) {
                    dBQuery.where((Predicate)qEntityLog.network().in((Collection)((AdminGroup)this.getLoggedUser().getGroup()).getManagedNetworks()));
                }
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getNetwork())) {
                dBQuery.where((Predicate)qEntityLog.network().eq((Object)((Network)this.conversionHandler.convert(Network.class, (Object)entityPropertyLogQuery.getNetwork()))));
            }
            if (Boolean.TRUE.equals(entityPropertyLogQuery.getOnlyGlobal()) && sessionData.isGlobalAdmin()) {
                dBQuery.where((Predicate)qEntityLog.network().isNull());
            }
            dBQuery.where((Predicate)qEntityLog.type.in((Collection)EntityLogTypeFilter.typesByFilters((Set)entityPropertyLogQuery.getTypeFilters())));
            EntityLogServiceLocal.applyUserActionsFilters((EntityPropertyLogQuery)entityPropertyLogQuery, (DBQuery)dBQuery);
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getPeriod())) {
                dBQuery.where(qEntityLog.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)entityPropertyLogQuery.getPeriod())));
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getKeywords())) {
                dBQuery.where((Predicate)EntityLogServiceImpl.$.name.containsIgnoreCase(entityPropertyLogQuery.getKeywords()).or((Predicate)qEntityLog.name.containsIgnoreCase(entityPropertyLogQuery.getKeywords())).or((Predicate)qEntityLog.namePrefix.containsIgnoreCase(entityPropertyLogQuery.getKeywords())));
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getEntityName())) {
                dBQuery.where((Predicate)qEntityLog.name.containsIgnoreCase(entityPropertyLogQuery.getEntityName()).or((Predicate)qEntityLog.namePrefix.containsIgnoreCase(entityPropertyLogQuery.getEntityName())));
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getBy())) {
                object = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)entityPropertyLogQuery.getBy());
                booleanExpression = qEntityLog.by().eq(object);
                if (object.isBroker()) {
                    booleanExpression = booleanExpression.or((Predicate)qEntityLog.by().operatorUserId.eq((Object)object.getId()));
                }
                dBQuery.where((Predicate)booleanExpression);
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getEvent())) {
                dBQuery.where((Predicate)qEntityLog.event.eq((Object)entityPropertyLogQuery.getEvent()));
            }
            if (Boolean.TRUE.equals(entityPropertyLogQuery.getAsManager())) {
                dBQuery.where((Predicate)qEntityLog.asManager.eq(Boolean.valueOf(true)));
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getUser())) {
                object = ((BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)entityPropertyLogQuery.getUser())).getId();
                booleanExpression = entityPropertyLogQuery.getUser() instanceof OperatorVO ? EntityLogType.OPERATOR : EntityLogType.USER;
                dBQuery.where((Predicate)qEntityLog.ownerEntityId.eq(object).and((Predicate)qEntityLog.type.in((Collection)EntityLogType.getEntityLogTypes((boolean)false))).or((Predicate)qEntityLog.entityId.eq(object).and((Predicate)qEntityLog.type.eq((Object)booleanExpression))));
            }
            if (QueryHelper.useParameter((Object)entityPropertyLogQuery.getRecordType())) {
                object = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)entityPropertyLogQuery.getRecordType());
                booleanExpression = qEntityLog.type.ne((Object)(object instanceof SystemRecordType ? EntityLogType.SYSTEM_RECORD : EntityLogType.USER_RECORD));
                dBQuery.where((Predicate)booleanExpression.or((Predicate)qEntityLog.relatedEntityId.eq((Object)object.getId())));
            }
            if (EntityPropertyLogOrderBy.DATE == (object = (EntityPropertyLogOrderBy)ObjectHelper.defaultValue((Object)entityPropertyLogQuery.getOrderBy(), (Object)EntityPropertyLogOrderBy.DATE))) {
                dBQuery.orderBy(new OrderSpecifier[]{qEntityLog.date.desc(), EntityLogServiceImpl.$.order.asc(), EntityLogServiceImpl.$.name.asc()});
            } else {
                booleanExpression = new MutableObject((Object)new CaseBuilder().when((Predicate)qEntityLog.type.eq((Object)EntityLogType.ACCOUNT_FEE)).then(this.message(EntityLogType.ACCOUNT_FEE.getMessageKey(), new Object[0])));
                Stream.of(EntityLogType.values()).filter(entityLogType -> entityLogType != EntityLogType.ACCOUNT_FEE).forEach(arg_0 -> this.lambda$toDBQuery$9((MutableObject)booleanExpression, qEntityLog, arg_0));
                StringExpression stringExpression = (StringExpression)((CaseBuilder.Cases)booleanExpression.get()).otherwise((Expression)qEntityLog.type.stringValue());
                dBQuery.orderBy(new OrderSpecifier[]{stringExpression.asc(), qEntityLog.network().name.asc().nullsFirst(), qEntityLog.namePrefix.asc(), qEntityLog.name.asc(), EntityLogServiceImpl.$.name.asc(), qEntityLog.date.desc(), EntityLogServiceImpl.$.order.asc()});
            }
        }
        return dBQuery;
    }

    private /* synthetic */ void lambda$toDBQuery$9(MutableObject mutableObject, QEntityLog qEntityLog, EntityLogType entityLogType) {
        mutableObject.set((Object)((CaseBuilder.Cases)mutableObject.get()).when((Predicate)qEntityLog.type.eq((Object)entityLogType)).then((Object)this.message(entityLogType.getMessageKey(), new Object[0])));
    }

    private static /* synthetic */ String lambda$logEntity$1(Field field) {
        return field == null ? null : field.getName();
    }
}

