/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.NumberExpression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.QChargebackTransfer;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.system.FinancialSubReportsTestableHandler;
import org.cyclos.impl.system.FirstAndLastData;
import org.cyclos.impl.system.ReportSection;
import org.cyclos.impl.system.SubReportsHandler;
import org.cyclos.impl.system.SubReportsHandlerImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FinancialSubReportsHandlerImpl
extends SubReportsHandlerImpl
implements FinancialSubReportsTestableHandler {
    @Autowired
    private AccountServiceLocal accountService;

    public List<ReportSection> data(SystemReportQuery systemReportQuery) {
        List<FirstAndLastData> list = systemReportQuery.isSystemAccounts() ? this.getSystemAccountsData(systemReportQuery) : null;
        List<FirstAndLastData> list2 = systemReportQuery.isUserAccounts() ? this.getUserAccountsData(systemReportQuery) : null;
        ArrayList<ReportSection> arrayList = new ArrayList<ReportSection>(2);
        if (CollectionHelper.isNotEmpty(list)) {
            arrayList.add(new ReportSection((Object)SystemKeys.Reports.SYSTEM_SYSTEM_ACCOUNTS, true, list));
        }
        if (CollectionHelper.isNotEmpty(list2)) {
            arrayList.add(new ReportSection((Object)SystemKeys.Reports.SYSTEM_USER_ACCOUNTS, true, list2));
        }
        return arrayList;
    }

    public CurrencyAmountDTO getBalanceForUserAccountType(UserAccountType userAccountType, Set<? extends Group> set, Date date) {
        return this.getBalanceForUserAccountType(userAccountType, set, null, date);
    }

    public int order() {
        return 4;
    }

    private CurrencyAmountDTO getBalanceForUserAccountType(UserAccountType userAccountType, Set<? extends Group> set, Date date, Date date2) {
        CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
        currencyAmountDTO.setAmount(this.sumUserTransfers(userAccountType, set, date, date2));
        currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)userAccountType.getCurrency()));
        return currencyAmountDTO;
    }

    private List<FirstAndLastData> getSystemAccountsData(SystemReportQuery systemReportQuery) {
        if (systemReportQuery.isSystemAccounts() && this.hasPermission(Permission.SYSTEM_ACCOUNTS_VIEW)) {
            Date date = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
            Date date2 = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.END);
            return this.accountService.listVisible((InternalAccountOwner)SystemAccountOwner.instance()).stream().map(account -> this.toSystemReportFirstAndLastDayVO((Account)account, date, date2)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<FirstAndLastData> getUserAccountsData(SystemReportQuery systemReportQuery) {
        ArrayList<FirstAndLastData> arrayList = new ArrayList<FirstAndLastData>();
        if (systemReportQuery.isUserAccounts() && this.hasPermission(Permission.USER_ACCOUNTS_VIEW)) {
            Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
            Date date = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
            Date date2 = this.getPeriodLimitAsDate(systemReportQuery, SubReportsHandler.PeriodLimit.END);
            List list = this.getSessionData().getProducts().userManagement().getUserAccountsAccess();
            for (UserAccountType userAccountType : list) {
                FirstAndLastData firstAndLastData = new FirstAndLastData();
                firstAndLastData.setLabel(this.message(SystemKeys.Reports.SYSTEM_USER_ACCOUNT_BALANCE, userAccountType));
                firstAndLastData.setFirst(this.getBalanceForUserAccountType(userAccountType, set, null, date));
                firstAndLastData.setLast(this.getBalanceForUserAccountType(userAccountType, set, null, date2));
                arrayList.add(firstAndLastData);
            }
        }
        return arrayList;
    }

    private BigDecimal sumUserTransfers(UserAccountType userAccountType, Set<? extends Group> set, Date date, Date date2) {
        QTransfer qTransfer = QTransfer.transfer;
        QChargebackTransfer qChargebackTransfer = new QChargebackTransfer("cb");
        QAccount qAccount = new QAccount("fa");
        QAccount qAccount2 = new QAccount("ta");
        QUser qUser = new QUser("fu");
        QUser qUser2 = new QUser("tu");
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        DBQuery dBQuery = (DBQuery)this.getBaseMemberQuery(set, true, date2, SubReportsHandlerImpl.QueryType.DBSUBQUERY).where((Predicate)qUserGroupLog.user().eq((Expression)qUser));
        DBQuery dBQuery2 = (DBQuery)this.getBaseMemberQuery(set, true, date2, SubReportsHandlerImpl.QueryType.DBSUBQUERY).where((Predicate)qUserGroupLog.user().eq((Expression)qUser2));
        NumberExpression numberExpression = (NumberExpression)new CaseBuilder().when((Predicate)qAccount.type().eq((Object)userAccountType)).then(qTransfer.amount.negate()).otherwise((Expression)qTransfer.amount);
        return BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qTransfer}).innerJoin((EntityPath)qTransfer.from(), (Path)qAccount)).innerJoin((EntityPath)qTransfer.to(), (Path)qAccount2)).leftJoin((EntityPath)qAccount.user(), (Path)qUser)).leftJoin((EntityPath)qAccount2.user(), (Path)qUser2)).leftJoin((EntityPath)qTransfer.chargedBackBy(), (Path)qChargebackTransfer)).where(new Predicate[]{qAccount.type().eq((Object)userAccountType).and((Predicate)qAccount2.type().eq((Object)userAccountType)).not(), qAccount.type().eq((Object)userAccountType).and((Predicate)dBQuery.exists()).or((Predicate)qAccount2.type().eq((Object)userAccountType).and((Predicate)dBQuery2.exists())), date == null ? qTransfer.id.isNotNull() : qTransfer.date.goe((Comparable)date), qTransfer.date.before((Comparable)date2), qChargebackTransfer.id.isNull().or((Predicate)qChargebackTransfer.date.after((Comparable)date2)), qTransfer.nature.ne((Object)TransferNature.CHARGEBACK)})).singleResult((Expression)numberExpression.sum())));
    }

    private FirstAndLastData toSystemReportFirstAndLastDayVO(Account account, Date date, Date date2) {
        FirstAndLastData firstAndLastData = new FirstAndLastData();
        firstAndLastData.setLabel(this.message(SystemKeys.Reports.SYSTEM_SYSTEM_ACCOUNT_BALANCE, account.getType()));
        firstAndLastData.setFirst(new CurrencyAmount(account.getCurrency(), this.accountService.getBalance(account, date)));
        firstAndLastData.setLast(new CurrencyAmount(account.getCurrency(), this.accountService.getBalance(account, new Date(date2.getTime() + 1L))));
        return firstAndLastData;
    }
}

