/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.entities.users.QUserStatusLog;
import org.cyclos.impl.system.FirstAndLastData;
import org.cyclos.impl.system.GroupSubReportsTestableHandler;
import org.cyclos.impl.system.ReportSection;
import org.cyclos.impl.system.SubReportsHandler;
import org.cyclos.impl.system.SubReportsHandlerImpl;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupSubReportsHandlerImpl
extends SubReportsHandlerImpl
implements GroupSubReportsTestableHandler {
    @Autowired
    private GroupServiceLocal groupService;

    public int countActiveUsers(SystemReportQuery systemReportQuery, SubReportsHandler.PeriodLimit periodLimit) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        DateTime dateTime = this.getPeriodLimit(systemReportQuery, periodLimit);
        return this.getBaseMemberQuery(set, dateTime, SubReportsHandlerImpl.QueryType.DBQUERY).count(GroupSubReportsHandlerImpl.ugl.id);
    }

    public Map<GroupVO, Integer> countGroupUsers(SystemReportQuery systemReportQuery, SubReportsHandler.PeriodLimit periodLimit) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        QUser qUser = QUser.user;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)this.getBaseMemberQuery(set, this.getPeriodLimit(systemReportQuery, periodLimit), SubReportsHandlerImpl.QueryType.DBQUERY).leftJoin((EntityPath)ugl.user(), (Path)qUser)).where((Predicate)GroupSubReportsHandlerImpl.ugl.group().nature.in((Object[])new BasicGroupNature[]{BasicGroupNature.MEMBER_GROUP, BasicGroupNature.BROKER_GROUP}))).groupBy((Expression)GroupSubReportsHandlerImpl.ugl.group().id);
        Map map = dBQuery.map((Expression)GroupSubReportsHandlerImpl.ugl.group().id, (Expression)qUser.id.count());
        LinkedHashMap<GroupVO, Integer> linkedHashMap = new LinkedHashMap<GroupVO, Integer>();
        for (Group group : set) {
            GroupVO groupVO = new GroupVO(group.getId());
            Long l = (Long)map.get(group.getId());
            linkedHashMap.put(groupVO, l == null ? 0 : l.intValue());
        }
        return linkedHashMap;
    }

    public int countRemovedUsers(SystemReportQuery systemReportQuery, SubReportsHandler.PeriodLimit periodLimit) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        Date date = this.conversionHandler.toDate((IDate)this.getPeriodLimit(systemReportQuery, periodLimit));
        QUserStatusLog qUserStatusLog = QUserStatusLog.userStatusLog;
        return ((DBQuery)this.getBaseMemberQuery(set, false, date, SubReportsHandlerImpl.QueryType.DBQUERY).where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qUserStatusLog}).where(new Predicate[]{qUserStatusLog.user().eq((Expression)QUserGroupLog.userGroupLog.user()._super), qUserStatusLog.startDate.lt((Comparable)date), qUserStatusLog.status.in((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).exists())).count(GroupSubReportsHandlerImpl.ugl.id);
    }

    public List<ReportSection> data(SystemReportQuery systemReportQuery) {
        if (systemReportQuery.isUserGroupInfo()) {
            ReportSection reportSection = new ReportSection((Object)SystemKeys.Reports.SYSTEM_USER_GROUP_INFORMATION, true, this.getUserGroupData(systemReportQuery));
            return Collections.singletonList(reportSection);
        }
        return null;
    }

    public int order() {
        return 1;
    }

    private List<FirstAndLastData> getUserGroupData(SystemReportQuery systemReportQuery) {
        ArrayList<FirstAndLastData> arrayList = new ArrayList<FirstAndLastData>();
        FirstAndLastData firstAndLastData = new FirstAndLastData();
        firstAndLastData.setLabel(this.message(SystemKeys.Reports.SYSTEM_NUMBER_OF_ENABLED_USERS, new Object[0]));
        firstAndLastData.setFirst(this.countActiveUsers(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN));
        firstAndLastData.setLast(this.countActiveUsers(systemReportQuery, SubReportsHandler.PeriodLimit.END));
        arrayList.add(firstAndLastData);
        FirstAndLastData firstAndLastData2 = new FirstAndLastData();
        firstAndLastData2.setLabel(this.message(SystemKeys.Reports.SYSTEM_NUMBER_OF_REMOVED_USERS, new Object[0]));
        firstAndLastData2.setFirst(this.countRemovedUsers(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN));
        firstAndLastData2.setLast(this.countRemovedUsers(systemReportQuery, SubReportsHandler.PeriodLimit.END));
        arrayList.add(firstAndLastData2);
        Map<GroupVO, Integer> map = this.countGroupUsers(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Map<GroupVO, Integer> map2 = this.countGroupUsers(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        if (CollectionHelper.isNotEmpty(map)) {
            for (Map.Entry<GroupVO, Integer> entry : map.entrySet()) {
                GroupVO groupVO = entry.getKey();
                Integer n = entry.getValue();
                FirstAndLastData firstAndLastData3 = new FirstAndLastData();
                BasicGroup basicGroup = (BasicGroup)this.groupService.find(groupVO.getId());
                firstAndLastData3.setLabel(this.message(SystemKeys.Reports.SYSTEM_NUMBER_OF_USERS, this.getTranslatedName((NamedEntity)basicGroup)));
                firstAndLastData3.setFirst(n);
                firstAndLastData3.setLast(map2.get(groupVO));
                arrayList.add(firstAndLastData3);
            }
        }
        return arrayList;
    }
}

