/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;

public class ImportHelper {
    public static boolean areAllEmptyValues(ImportedLine importedLine, String string, ImportField ... importFieldArray) {
        for (ImportField importField : importFieldArray) {
            String string2 = importedLine.getValue(importField, string);
            if (!StringHelper.isNotBlank((Object)string2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countNumberOfLines(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new LineNumberReader(inputStreamReader);
            while (((LineNumberReader)bufferedReader).readLine() != null) {
                ++n;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        return n;
    }

    public static Pair<String, String> extractCanonicalFieldAndId(String string) {
        if (string.contains("[")) {
            Pattern pattern = Pattern.compile("(.*)\\[(.*)\\](.*)");
            Matcher matcher = pattern.matcher(string);
            Pair pair = new Pair();
            if (matcher.find()) {
                pair.setFirst((Object)(matcher.group(1) + matcher.group(3)));
                pair.setSecond((Object)matcher.group(2));
                return pair;
            }
            throw new IllegalStateException();
        }
        return new Pair((Object)string, null);
    }

    public static List<String> getFieldIdsForPrefix(ImportedLine importedLine, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImportedLineValue importedLineValue : importedLine.getValues()) {
            ImportedField importedField = importedLineValue.getImportedField();
            if (!importedField.getFieldName().startsWith(string) || arrayList.contains(importedField.getFieldId())) continue;
            arrayList.add(importedField.getFieldId());
        }
        arrayList.sort(Comparator.nullsFirst(String::compareTo));
        return arrayList;
    }

    public static Map<String, String> getFieldValuesForPrefix(ImportedLine importedLine, String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (ImportedLineValue importedLineValue : importedLine.getValues()) {
            String string2 = importedLineValue.getImportedField().getFieldName();
            if (!string2.startsWith(string) || string2.length() <= string.length()) continue;
            String string3 = StringUtils.replace((String)string2, (String)string, (String)"", (int)1);
            linkedHashMap.put(string3, importedLineValue.getValue());
        }
        return linkedHashMap;
    }

    public static <DTO extends Bean> void setFieldValue(ImportedLine importedLine, String string, ImportField importField, DTO DTO, Property<String, DTO> property) {
        ImportHelper.setFieldValue(importedLine, string, importField, DTO, property, null);
    }

    public static <DTO extends Bean> void setFieldValue(ImportedLine importedLine, String string, ImportField importField, DTO DTO, Property<String, DTO> property, String string2) {
        String string3 = importedLine.getValue(importField, string);
        if (StringHelper.isBlank((Object)string3)) {
            if (string2 != null) {
                DTO.set(property, (Object)string2);
            }
        } else {
            DTO.set(property, (Object)string3);
        }
    }
}

