/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.QImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.banking.VoucherTemplateImageServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseImageServiceLocal;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.system.InternalImageServiceLocal;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.StoredFileException;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.utils.StoredFileNature;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalImageServiceImpl
extends BaseServiceImpl
implements InternalImageServiceLocal {
    public static String SYSTEM_IMAGE_URL_TOKEN = "system_image";
    private Map<ImageNature, BaseImageServiceLocal<?, ?>> services;
    @Autowired
    private ThemeImageServiceLocal themeImageService;
    @Autowired
    private VoucherTemplateImageServiceLocal voucherTemplateImageService;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    private BarcodeHandler barcodeHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public Image findByKey(String string) {
        BooleanExpression booleanExpression;
        QImage qImage = QImage.image;
        if (string.startsWith(SYSTEM_IMAGE_URL_TOKEN)) {
            boolean bl = ServerImageHelper.ImageType.hasImageExtension((String)string);
            String string2 = string.substring(SYSTEM_IMAGE_URL_TOKEN.length() + 1, bl ? string.lastIndexOf(".") : string.length());
            booleanExpression = qImage.nature.eq((Object)StoredFileNature.SYSTEM_CUSTOM_IMAGE).and((Predicate)qImage.name.eq((Object)string2));
            if (bl) {
                booleanExpression.and((Predicate)qImage.contentType.eq((Object)ServerImageHelper.ImageType.getByFileName((String)string).getContentType()));
            }
        } else {
            booleanExpression = qImage.key.eq((Object)StringUtils.substringBefore((String)string, (String)"_"));
        }
        Image image = (Image)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qImage}).where((Predicate)booleanExpression)).singleResult((Expression)qImage);
        if (image == null) {
            throw new EntityNotFoundException(Image.class, string);
        }
        return image;
    }

    @PostConstruct
    public void initialize() {
        this.services = new HashMap();
        Collection collection = this.getApplicationContext().getBeansOfType(BaseImageServiceLocal.class).values();
        collection.forEach(baseImageServiceLocal -> this.services.put(baseImageServiceLocal.getImageNature(), (BaseImageServiceLocal<?, ?>)baseImageServiceLocal));
    }

    public ImageVO load(Long l) throws FrameworkException {
        Image image = this.find(Image.class, l);
        return (ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)image);
    }

    public ImageVO loadByKey(String string) throws FrameworkException {
        Image image = this.findByKey(string);
        return (ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)image);
    }

    public SerializableInputStream qrCode(String string, ImageSize imageSize) throws FrameworkException {
        return this.barcodeHandler.qrcode(string, imageSize);
    }

    public SerializableInputStream readConfigurationImage(Long l, ConfigurationImageType configurationImageType) throws FrameworkException {
        return this.configurationImageService.readByConfigurationAndType(l, configurationImageType);
    }

    public SerializableInputStream readContent(Long l) throws FrameworkException {
        Image image = this.find(Image.class, l);
        return this.storedFileHandler.getContent((StoredFile)image);
    }

    public SerializableInputStream readContentByKey(String string) throws FrameworkException {
        Image image = this.findByKey(string);
        return this.storedFileHandler.getContent((StoredFile)image);
    }

    public SerializableInputStream readThemeImage(Long l, ThemeImageType themeImageType, String string) throws FrameworkException {
        byte[] byArray = this.themeImageService.readImageContent(l, themeImageType, string);
        SerializableInputStream serializableInputStream = new SerializableInputStream(byArray);
        try {
            serializableInputStream.forceCopyToFile();
        }
        catch (IOException iOException) {
            throw new StoredFileException((Throwable)iOException);
        }
        return serializableInputStream;
    }

    public SerializableInputStream readVoucherTemplateImage(Long l, String string) throws FrameworkException {
        byte[] byArray = this.voucherTemplateImageService.readImageContent(l, string);
        SerializableInputStream serializableInputStream = new SerializableInputStream(byArray);
        try {
            serializableInputStream.forceCopyToFile();
        }
        catch (IOException iOException) {
            throw new StoredFileException((Throwable)iOException);
        }
        return serializableInputStream;
    }

    public void remove(Long l) throws FrameworkException {
        Image image = this.find(Image.class, l);
        BaseImageServiceLocal<?, ?> baseImageServiceLocal = this.services.get(image.getNature());
        baseImageServiceLocal.remove(l);
    }

    public void removeByKey(String string) throws FrameworkException {
        Image image = this.findByKey(string);
        BaseImageServiceLocal<?, ?> baseImageServiceLocal = this.services.get(image.getNature());
        baseImageServiceLocal.remove(image.getId());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

