/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.net.InetAddress;
import java.util.Date;
import java.util.TimeZone;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.IpAddress;
import org.cyclos.entities.system.IpAddressLog;
import org.cyclos.entities.system.IpGeolocation;
import org.cyclos.entities.system.IpGeolocationConfiguration;
import org.cyclos.entities.system.QIpAddress;
import org.cyclos.entities.system.QIpAddressLog;
import org.cyclos.entities.system.QIpGeolocation;
import org.cyclos.entities.utils.LatLong;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.impl.utils.validation.validations.LatLongValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.ipaddresses.IpAddressDTO;
import org.cyclos.model.system.ipaddresses.IpAddressData;
import org.cyclos.model.system.ipaddresses.IpAddressLogQuery;
import org.cyclos.model.system.ipaddresses.IpAddressLogStatus;
import org.cyclos.model.system.ipaddresses.IpAddressLogVO;
import org.cyclos.model.system.ipaddresses.IpAddressQuery;
import org.cyclos.model.system.ipaddresses.IpAddressStatus;
import org.cyclos.model.system.ipaddresses.IpAddressVO;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.utils.ILatLong;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.IpGeolocationResultDTO;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IpAddressServiceImpl
extends CRUDServiceImpl<IpAddress, QIpAddress, IpAddressDTO, IpAddressData, Void>
implements IpAddressServiceLocal {
    private static final QIpGeolocation geo = QIpGeolocation.ipGeolocation;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LockHandler lockHandler;

    public IpAddressServiceImpl() {
        super(IpAddress.class, QIpAddress.ipAddress, IpAddressDTO.class);
    }

    public boolean block(String string, TimeInterval timeInterval) {
        IpAddress ipAddress;
        if (timeInterval == null || timeInterval.getAmount() == null || timeInterval.getAmount() <= 0) {
            return false;
        }
        this.lockHandler.lock(LockType.IP_ADDRESS.key(string));
        try {
            ipAddress = this.rawFindByAddress(string);
            if (ipAddress.getStatus().isFixed()) {
                return false;
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            ipAddress = new IpAddress();
            ipAddress.setAddress(string);
        }
        ipAddress.setStatus(IpAddressStatus.BLOCKED);
        ipAddress.setBlockedUntil(DateHelper.add((Date)new Date(), (ITimeInterval)timeInterval));
        if (ipAddress.isTransient()) {
            this.persist((IEntity)ipAddress);
        }
        this.log(ipAddress.getAddress(), ipAddress.getStatus());
        return true;
    }

    public IpAddress findByAddress(String string) throws EntityNotFoundException {
        IpAddress ipAddress = this.rawFindByAddress(string);
        if (ipAddress.getStatus() == IpAddressStatus.BLOCKED && ipAddress.getBlockedUntil() != null && ipAddress.getBlockedUntil().before(new Date())) {
            throw new EntityNotFoundException(IpAddress.class);
        }
        return ipAddress;
    }

    public IpGeolocation geolocate(String string) {
        IpGeolocation ipGeolocation;
        InetAddress inetAddress;
        IpGeolocationConfiguration ipGeolocationConfiguration = this.getConfiguration().getIpGeolocationConfiguration();
        if (ipGeolocationConfiguration == null) {
            return null;
        }
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isMulticastAddress()) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        inetAddress = (IpGeolocation)((DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)geo).where(new Predicate[]{IpAddressServiceImpl.geo.address.eq((Object)string), IpAddressServiceImpl.geo.expirationDate.isNull().or(IpAddressServiceImpl.geo.expirationDate.future())})).fetchFirst();
        if (inetAddress != null) {
            return inetAddress;
        }
        CustomScript customScript = ipGeolocationConfiguration.getScript();
        try {
            ipGeolocation = (IpGeolocation)this.customScriptService.newAccessor(customScript, ipGeolocationConfiguration.getScriptParameters()).bind("address", (Object)string).run(IpGeolocation.class);
        }
        catch (Exception exception) {
            this.getLogger().warn("Error on IP geolocation script " + String.valueOf(customScript), (Throwable)exception);
            ipGeolocation = null;
        }
        if (ipGeolocation != null) {
            String string2 = ipGeolocation.getCountry();
            if (string2 != null && !this.localizationService.listCountryCodes().contains(string2)) {
                throw new CustomScriptException("IP geolocation script '" + customScript.getName() + "' returned an invalid country code: '" + string2 + "'");
            }
            LatLong latLong = ipGeolocation.getLocation();
            if (latLong != null && !LatLongValidation.isValid((ILatLong)latLong)) {
                throw new CustomScriptException("IP geolocation script '" + customScript.getName() + "' returned an invalid location: '" + String.valueOf(latLong) + "'");
            }
            ipGeolocation.setAddress(string);
            TimeInterval timeInterval = ipGeolocationConfiguration.getExpiration();
            if (timeInterval != null && timeInterval.isValid()) {
                ipGeolocation.setExpirationDate(DateHelper.add((Date)new Date(), (ITimeInterval)timeInterval));
            } else {
                ipGeolocation.setExpirationDate(null);
            }
            InvocationContext invocationContext = InvocationContext.get();
            if (invocationContext.getTransactionLevel() == TransactionLevel.READ_WRITE) {
                this.nativeQueryHandler.insertIpAddressLocalization(ipGeolocation);
            } else {
                IpGeolocation ipGeolocation2 = ipGeolocation;
                this.invokerHandler.submitAsInParallelTransaction(invocationContext.sessionData(), TransactionLevel.READ_WRITE, transactionStatus -> this.nativeQueryHandler.insertIpAddressLocalization(ipGeolocation2));
            }
        }
        return ipGeolocation;
    }

    public boolean isAllowed(String string) {
        try {
            IpAddress ipAddress = this.rawFindByAddress(string);
            switch (ipAddress.getStatus()) {
                case ALLOWED: {
                    return true;
                }
                case BLOCKED: {
                    return ipAddress.getBlockedUntil() != null && ipAddress.getBlockedUntil().before(new Date());
                }
            }
            return false;
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return true;
        }
    }

    @Override
    public IpAddress newEntity(Void void_) {
        return new IpAddress();
    }

    public long purgeExpiredBlocked() {
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where(new Predicate[]{((QIpAddress)this.$).status.eq((Object)IpAddressStatus.BLOCKED), ((QIpAddress)this.$).blockedUntil.past()})).iterate((Expression)this.$);
        return this.processBatch(closeableIterator, this::remove);
    }

    public Page<IpAddressVO> search(IpAddressQuery ipAddressQuery) {
        IpAddressStatus ipAddressStatus;
        DBQuery dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{this.$});
        String string = StringHelper.trimToNull((Object)ipAddressQuery.getAddress());
        if (string != null) {
            dBQuery.where((Predicate)((QIpAddress)this.$).address.eq((Object)string));
        }
        if ((ipAddressStatus = ipAddressQuery.getStatus()) != null) {
            dBQuery.where((Predicate)((QIpAddress)this.$).status.eq((Object)ipAddressStatus));
        }
        dBQuery.where((Predicate)((QIpAddress)this.$).status.ne((Object)IpAddressStatus.BLOCKED).or(((QIpAddress)this.$).blockedUntil.future()));
        dBQuery.orderBy(((QIpAddress)this.$).address.asc());
        return dBQuery.page(IpAddressVO.class, (QueryParameters)ipAddressQuery, (Expression)this.$);
    }

    public Page<IpAddressLogVO> searchLogs(IpAddressLogQuery ipAddressLogQuery) throws FrameworkException {
        IpAddressLogStatus ipAddressLogStatus;
        QIpAddressLog qIpAddressLog = QIpAddressLog.ipAddressLog;
        DBQuery dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{qIpAddressLog});
        String string = StringHelper.trimToNull((Object)ipAddressLogQuery.getAddress());
        if (string != null) {
            dBQuery.where((Predicate)qIpAddressLog.address.eq((Object)string));
        }
        if ((ipAddressLogStatus = ipAddressLogQuery.getStatus()) != null) {
            dBQuery.where((Predicate)qIpAddressLog.status.eq((Object)ipAddressLogStatus));
        }
        dBQuery.orderBy(qIpAddressLog.date.desc());
        return dBQuery.page(IpAddressLogVO.class, (QueryParameters)ipAddressLogQuery, (Expression)qIpAddressLog);
    }

    @Override
    protected IpAddressData getData(IpAddress ipAddress) {
        IpGeolocation ipGeolocation;
        IpAddressData ipAddressData = new IpAddressData();
        ipAddressData.setDto((EntityDTO)((IpAddressDTO)this.toDTO(ipAddress)));
        if (ipAddress.isPersistent() && (ipGeolocation = this.geolocate(ipAddress.getAddress())) != null) {
            ipAddressData.setGeolocation((IpGeolocationResultDTO)this.conversionHandler.convert(IpGeolocationResultDTO.class, (Object)ipGeolocation));
            if (StringHelper.isNotBlank((Object)ipGeolocation.getCountry())) {
                ipAddressData.setCountryName(this.localizationService.getCountryName(ipGeolocation.getCountry()));
            }
        }
        return ipAddressData;
    }

    @Override
    protected void onAfterRemove(IpAddress ipAddress) {
        this.log(ipAddress.getAddress(), null);
    }

    @Override
    protected void onAfterSave(IpAddress ipAddress, IpAddress ipAddress2, Object object) {
        this.log(ipAddress.getAddress(), ipAddress.getStatus());
    }

    @Override
    protected Object onBeforeSave(IpAddress ipAddress, IpAddress ipAddress2) {
        if (ipAddress.isTransient()) {
            try {
                IpAddress ipAddress3 = this.rawFindByAddress(ipAddress.getAddress());
                if (ipAddress3.getStatus() == IpAddressStatus.BLOCKED) {
                    this.remove(ipAddress3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ipAddress.getStatus() == IpAddressStatus.BLOCKED) {
            if (ipAddress.getBlockedUntil() == null && ipAddress.getBlockTime() != null) {
                ipAddress.setBlockedUntil(DateHelper.add((Date)new Date(), (ITimeInterval)ipAddress.getBlockTime(), (TimeZone)this.getSessionData().getConfiguration().getTimeZone()));
            }
        } else {
            ipAddress.setBlockedUntil(null);
            ipAddress.setBlockTime(null);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    @Override
    protected Validator resolveValidator(IpAddressDTO ipAddressDTO) {
        Validator validator = new Validator();
        validator.property((Property)IpAddressDTO.ADDRESS, SystemKeys.IpAddresses.ADDRESS).ipAddress().required();
        validator.property((Property)IpAddressDTO.COMMENT, SystemKeys.IpAddresses.COMMENT).maxLength(100);
        validator.property((Property)IpAddressDTO.STATUS, SystemKeys.IpAddresses.STATUS).required();
        IpAddressStatus ipAddressStatus = ipAddressDTO.getStatus();
        if (ipAddressStatus != null) {
            if (!ipAddressStatus.allowsAccess() && this.getSessionData().getRemoteAddress().equals(ipAddressDTO.getAddress())) {
                validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.IpAddresses.ERRORS_CANNOT_DENY_OWN_ADDRESS, (Object[])new Object[0]));
            }
            if (ipAddressStatus == IpAddressStatus.BLOCKED) {
                if (ipAddressDTO.getBlockedUntil() == null) {
                    validator.property((Property)IpAddressDTO.BLOCK_TIME, SystemKeys.IpAddresses.BLOCK_TIME).required().timeInterval();
                } else {
                    validator.property((Property)IpAddressDTO.BLOCKED_UNTIL, SystemKeys.IpAddresses.BLOCKED_UNTIL).futureDate();
                }
            }
        }
        return validator;
    }

    private void log(String string, IpAddressStatus ipAddressStatus) {
        this.log(string, ipAddressStatus, null);
    }

    private void log(String string, IpAddressStatus ipAddressStatus, Date date) {
        IpAddressLog ipAddressLog = new IpAddressLog();
        ipAddressLog.setDate((Date)ObjectHelper.defaultValue((Object)date, Date::new));
        ipAddressLog.setAddress(string);
        ipAddressLog.setBy(this.getLoggedBasicUser());
        if (ipAddressStatus == null) {
            ipAddressLog.setStatus(IpAddressLogStatus.RESTORED);
        } else {
            ipAddressLog.setStatus(IpAddressLogStatus.valueOf((String)ipAddressStatus.name()));
        }
        this.persist((IEntity)ipAddressLog);
    }

    private IpAddress rawFindByAddress(String string) throws EntityNotFoundException {
        return (IpAddress)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QIpAddress)this.$).address.eq((Object)string))).requiredUniqueResult((Expression)this.$);
    }
}

