/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.db.DatabasePopulator;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.contentmanagement.MenuEntry;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.MemberGroup;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.TransferFilterServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.contentmanagement.StaticContentServiceLocal;
import org.cyclos.impl.contentmanagement.SystemImageCategoryServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.marketplace.AdCategoryImageServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.messaging.MessageCategoryServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.HelpDeskLogField;
import org.cyclos.impl.system.InitialAdCategories;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.system.RemarkField;
import org.cyclos.impl.users.ContactInfoFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsGroupServiceLocal;
import org.cyclos.impl.users.RecordCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.UserCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.PasswordActionHelper;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.Availability;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.accounttypes.SystemAccountTypeDTO;
import org.cyclos.model.banking.accounttypes.UserAccountTypeDTO;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transferfilters.TransferFilterDTO;
import org.cyclos.model.banking.transfertypes.GeneratedTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.MaturityPolicy;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryVO;
import org.cyclos.model.contentmanagement.contentitems.MenuGroupDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuGroupPosition;
import org.cyclos.model.contentmanagement.contentitems.MenuGroupVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryDTO;
import org.cyclos.model.contentmanagement.staticcontents.GuestHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoggedUserHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentData;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentDataParams;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentNature;
import org.cyclos.model.contentmanagement.themes.ApplyThemesDTO;
import org.cyclos.model.contentmanagement.themes.ThemeDTO;
import org.cyclos.model.contentmanagement.themes.ThemeData;
import org.cyclos.model.contentmanagement.themes.ThemeDataParams;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.categories.AdCategoryDTO;
import org.cyclos.model.marketplace.categories.AdCategoryResultType;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.marketplace.fields.AdCustomFieldDTO;
import org.cyclos.model.messaging.messagecategories.MessageCategoryDTO;
import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.BrokeringNotificationType;
import org.cyclos.model.messaging.notifications.FeedbackAndReferenceNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceBuyerNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceSellerNotificationType;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.ConfigurationData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueDTO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.languages.LanguageDTO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.networks.InitialCustomField;
import org.cyclos.model.system.networks.NetworkInitialAdField;
import org.cyclos.model.system.networks.NetworkInitialAdministrator;
import org.cyclos.model.system.networks.NetworkInitialContactInfoField;
import org.cyclos.model.system.networks.NetworkInitialDataDTO;
import org.cyclos.model.system.networks.NetworkInitialProfileField;
import org.cyclos.model.system.networks.NetworkInitialRecord;
import org.cyclos.model.users.contactinfos.ContactInfoFieldDTO;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.model.users.fields.UserCustomFieldDTO;
import org.cyclos.model.users.groups.AdminGroupDTO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.BrokerGroupDTO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.MemberGroupDTO;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.AdminProductData;
import org.cyclos.model.users.products.BrokerMessagesOperation;
import org.cyclos.model.users.products.BrokerProductDTO;
import org.cyclos.model.users.products.BrokerProductData;
import org.cyclos.model.users.products.MemberProductDTO;
import org.cyclos.model.users.products.MemberProductData;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.products.MyMessagesOperation;
import org.cyclos.model.users.products.MyReferencesOperation;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductMyAdFieldDTO;
import org.cyclos.model.users.products.ProductMyProfileFieldDTO;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ProductRecordFieldDTO;
import org.cyclos.model.users.products.ProductUserAdFieldDTO;
import org.cyclos.model.users.products.ProductUserProfileFieldDTO;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.SpecificConfigurationAccess;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserManagementProductDTO;
import org.cyclos.model.users.products.UserProductNotificationDTO;
import org.cyclos.model.users.products.UserProfileActivity;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.model.users.recordfields.RecordCustomFieldDTO;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.recordtypes.UserRecordTypeDTO;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.references.ReferenceNature;
import org.cyclos.model.users.references.TransactionFeedbackSetting;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.ProfileManagementSection;
import org.cyclos.model.utils.QuickAccessDTO;
import org.cyclos.model.utils.SvgIcon;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.BaseCustomFieldPossibleValueService;
import org.cyclos.services.system.BaseCustomFieldService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class NetworkPopulator {
    private static final Logger LOG = LogManager.getLogger(NetworkPopulator.class);
    public static final int CURRENCY_SCALE = 2;
    private final Network network;
    private final NetworkInitialDataDTO data;
    @Autowired
    private ConfigurationHandler configurationHandler;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private TransferFilterServiceLocal transferFilterService;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    private AdCategoryImageServiceLocal adCategoryImageService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private AdCustomFieldPossibleValueServiceLocal adCustomFieldPossibleValueService;
    @Autowired
    private MessageCategoryServiceLocal messageCategoryService;
    @Autowired
    private SystemImageCategoryServiceLocal systemImageCategoryService;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    private UserCustomFieldPossibleValueServiceLocal userCustomFieldPossibleValueService;
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    private ContactInfoFieldPossibleValueServiceLocal contactInfoFieldPossibleValueService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RecordCustomFieldServiceLocal recordCustomFieldService;
    @Autowired
    private RecordCustomFieldPossibleValueServiceLocal recordCustomPossibleValueService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private ProductsGroupServiceLocal groupProductsService;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private ThemeServiceLocal themeService;
    @Autowired
    private StaticContentServiceLocal staticContentService;
    private Configuration configuration;
    private Language baseLanguage;
    private ConfigurationAccessor configurationAccessor;
    private AdminGroup networkAdministratorsGroup;
    private PasswordType accessPasswordType;
    private ChannelVO mainChannelVO;
    private ChannelVO webServicesChannelVO;
    private ChannelVO mobileChannelVO;
    private ChannelVO ticketChannelVO;
    private ChannelVO posChannelVO;
    private Language language;
    private Currency currency;
    private SystemAccountType unlimitedAccount;
    private SystemAccountType systemAccount;
    private SystemAccountType additionalSystemAccount;
    private UserAccountType userAccount;
    private GeneratedTransferType initialCredit;
    private PaymentTransferType userPayment;
    private AdminGroup accountAdministratorsGroup;
    private MemberGroup usersGroup;
    private BrokerGroup brokersGroup;
    private MemberProduct memberProduct;
    private BrokerProduct brokerProduct;
    private Map<NetworkInitialProfileField, UserCustomField> userCustomFields = new HashMap<NetworkInitialProfileField, UserCustomField>();
    private ContactInfoField contactInfoDescription;
    private RecordType remarks;
    private RecordType helpDeskLog;
    private Map<NetworkInitialAdField, AdCustomField> adCustomFields = new HashMap<NetworkInitialAdField, AdCustomField>();

    public NetworkPopulator(Network network, NetworkInitialDataDTO networkInitialDataDTO) {
        this.network = network;
        this.data = networkInitialDataDTO;
    }

    public void populate() {
        DatabasePopulator.inPopulator();
        this.readData();
        this.configureLocalization();
        this.createAccountConfiguration();
        this.createAdConfiguration();
        this.createCategories();
        this.createUserConfiguration();
        this.configureGuests();
        this.createContent();
        this.createAdministrator();
        this.updateNetworkAdministratorGroup();
    }

    protected void setDefaultQuickAccess(ProductDTO productDTO, QuickAccessType ... quickAccessTypeArray) {
        Stream<Object> stream;
        productDTO.setMyQuickAccessSettingsEnable(true);
        if (CollectionHelper.isEmpty((Object[])quickAccessTypeArray)) {
            Role role = productDTO instanceof AdminProductDTO ? Role.ADMIN : (productDTO instanceof BrokerProductDTO ? Role.BROKER : Role.MEMBER);
            stream = QuickAccessType.getByRole((Role)role).stream();
        } else {
            stream = Stream.of(quickAccessTypeArray);
        }
        productDTO.setDefaultQuickAccess(stream.map(quickAccessType -> new QuickAccessDTO((Property)QuickAccessDTO.TYPE, quickAccessType)).collect(Collectors.toSet()));
    }

    private void addProfileFieldPermissionsToMemberProduct(MemberProductDTO memberProductDTO) {
        ProductMyProfileFieldDTO productMyProfileFieldDTO;
        ArrayList<ProductMyProfileFieldDTO> arrayList = new ArrayList<ProductMyProfileFieldDTO>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        EnumSet<BasicProfileField> enumSet = EnumSet.of(BasicProfileField.LOGIN_NAME, BasicProfileField.FULL_NAME);
        for (BasicProfileField basicProfileField : BasicProfileField.values()) {
            productMyProfileFieldDTO = new ProductMyProfileFieldDTO();
            productMyProfileFieldDTO.setProfileField((ProfileField)basicProfileField);
            productMyProfileFieldDTO.setEnabled(true);
            productMyProfileFieldDTO.setEditable(basicProfileField != BasicProfileField.LOGIN_NAME && basicProfileField != BasicProfileField.FULL_NAME);
            productMyProfileFieldDTO.setVisible(true);
            productMyProfileFieldDTO.setEditableAtRegistration(true);
            productMyProfileFieldDTO.setManagePrivacy(true);
            arrayList.add(productMyProfileFieldDTO);
            boolean bl = enumSet.contains(basicProfileField);
            ProductUserProfileFieldDTO productUserProfileFieldDTO = new ProductUserProfileFieldDTO();
            productUserProfileFieldDTO.setProfileField((ProfileField)basicProfileField);
            productUserProfileFieldDTO.setVisible(true);
            productUserProfileFieldDTO.setUserKeywords(bl);
            productUserProfileFieldDTO.setAdKeywords(bl);
            arrayList2.add(productUserProfileFieldDTO);
        }
        for (UserCustomField userCustomField : this.userCustomFields.values()) {
            BasicProfileField basicProfileField;
            ProductMyProfileFieldDTO productMyProfileFieldDTO2 = new ProductMyProfileFieldDTO();
            basicProfileField = (CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)userCustomField);
            productMyProfileFieldDTO2.setProfileField((ProfileField)basicProfileField);
            productMyProfileFieldDTO2.setEnabled(true);
            productMyProfileFieldDTO2.setEditable(true);
            productMyProfileFieldDTO2.setVisible(true);
            productMyProfileFieldDTO2.setEditableAtRegistration(true);
            productMyProfileFieldDTO2.setManagePrivacy(true);
            arrayList.add(productMyProfileFieldDTO2);
            productMyProfileFieldDTO = new ProductUserProfileFieldDTO();
            productMyProfileFieldDTO.setProfileField((ProfileField)basicProfileField);
            productMyProfileFieldDTO.setVisible(true);
            arrayList2.add(productMyProfileFieldDTO);
        }
        memberProductDTO.setMyProfileFields(arrayList);
        memberProductDTO.setUserProfileFields(arrayList2);
        memberProductDTO.setContactInfoFields(Collections.singleton(new CustomFieldVO(this.contactInfoDescription.getId())));
    }

    private void addUserProfileFieldPermissionsTo(ProductDTO productDTO) {
        boolean bl = productDTO instanceof BrokerProductDTO;
        ArrayList<ProductUserProfileFieldDTO> arrayList = new ArrayList<ProductUserProfileFieldDTO>();
        EnumSet<BasicProfileField> enumSet = EnumSet.of(BasicProfileField.LOGIN_NAME, BasicProfileField.FULL_NAME, BasicProfileField.EMAIL);
        if (bl) {
            for (BasicProfileField object : BasicProfileField.values()) {
                ProductUserProfileFieldDTO productUserProfileFieldDTO = new ProductUserProfileFieldDTO();
                productUserProfileFieldDTO.setProfileField((ProfileField)object);
                productUserProfileFieldDTO.setVisible(true);
                productUserProfileFieldDTO.setEditable(true);
                boolean bl2 = enumSet.contains(object);
                productUserProfileFieldDTO.setUserKeywords(bl2);
                productUserProfileFieldDTO.setAdKeywords(bl2);
                productUserProfileFieldDTO.setRecordKeywords(bl2);
                arrayList.add(productUserProfileFieldDTO);
            }
        }
        for (UserCustomField userCustomField : this.userCustomFields.values()) {
            CustomFieldDetailedVO customFieldDetailedVO = (CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)userCustomField);
            ProductUserProfileFieldDTO productUserProfileFieldDTO = new ProductUserProfileFieldDTO();
            productUserProfileFieldDTO.setProfileField((ProfileField)customFieldDetailedVO);
            productUserProfileFieldDTO.setVisible(true);
            productUserProfileFieldDTO.setEditable(true);
            arrayList.add(productUserProfileFieldDTO);
        }
        productDTO.setUserProfileFields(arrayList);
    }

    private void assignProductsToGroups() {
        ProductVO productVO = new ProductVO(this.memberProduct.getId());
        this.groupProductsService.assign(productVO, (EntityVO)new BasicGroupVO(this.usersGroup.getId()));
        if (this.data.isSetupBrokers()) {
            BasicGroupVO basicGroupVO = new BasicGroupVO(this.brokersGroup.getId());
            this.groupProductsService.assign(productVO, (EntityVO)basicGroupVO);
            this.groupProductsService.assign(new ProductVO(this.brokerProduct.getId()), (EntityVO)basicGroupVO);
        }
    }

    private void configureGuests() {
        ConfigurationData configurationData = (ConfigurationData)this.configurationService.getData(this.configuration.getId());
        ConfigurationDTO configurationDTO = (ConfigurationDTO)configurationData.getDto();
        configurationDTO.setPossibleInitialGroups(this.vos(GroupVO.class, this.usersGroup));
        configurationDTO.setVisibleAdGroups(this.vos(BasicGroupVO.class, this.usersGroup));
        configurationDTO.setAllowViewUserAd(Boolean.valueOf(true));
        configurationDTO.getDefinedProperties().addAll(Arrays.asList(ConfigurationDTO.POSSIBLE_INITIAL_GROUPS.getName(), ConfigurationDTO.VISIBLE_AD_GROUPS.getName(), ConfigurationDTO.ALLOW_VIEW_USER_AD.getName()));
        this.configuration = (Configuration)this.save((CRUDServiceLocal)this.configurationService, (EntityDTO)configurationDTO);
    }

    private void configureLocalization() {
        Object object;
        QConfiguration qConfiguration = QConfiguration.configuration;
        this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.applicationName, (Object)this.network.getName());
        this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.emailName, (Object)this.network.getName());
        this.baseLanguage = this.data.isCustomizeLocalization() ? (Language)this.rawEntityManagerHandler.find(Language.class, this.data.getLanguage().getId()) : this.configurationAccessor.getLanguage();
        if (this.data.isCloneLanguage()) {
            object = new LanguageDTO();
            object.setName(StringHelper.truncate((String)this.message(GeneralKeys.InitialData.LANGUAGE, this.network.getName(), this.baseLanguage.getTemplate().name()), (int)100));
            object.setInternalName(this.network.getInternalName() + "_" + this.baseLanguage.getTemplate().name().toLowerCase());
            object.setParent((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)this.baseLanguage));
            this.language = (Language)this.save((CRUDServiceLocal)this.languageService, (EntityDTO)object);
        } else {
            this.language = this.baseLanguage;
        }
        if (this.data.isCustomizeLocalization()) {
            this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.applicationUsername, (Object)this.message(GeneralKeys.InitialData.CONFIGURATION_APPLICATION_USERNAME, new Object[0]));
        }
        if (this.data.isCustomizeLocalization() || this.data.isCloneLanguage()) {
            object = this.data.isCustomizeLocalization() ? this.data.getCountry() : this.configurationAccessor.getCountry();
            String string = this.data.isCustomizeLocalization() ? this.data.getTimeZoneId() : this.configurationAccessor.getTimeZoneId();
            this.configurationService.setLocalization(this.configuration, (Language)ObjectHelper.defaultValue((Object)this.language, (Object)this.baseLanguage), (String)object, string);
        }
        if (StringHelper.isNotBlank((Object)this.data.getDefaultRegion())) {
            this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.defaultRegion, (Object)this.data.getDefaultRegion());
        }
        if (StringHelper.isNotBlank((Object)this.data.getDefaultCity())) {
            this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.defaultCity, (Object)this.data.getDefaultCity());
        }
    }

    private AdminGroup createAccountAdministrators() {
        AdminGroupDTO adminGroupDTO = new AdminGroupDTO();
        adminGroupDTO.setName(this.message(GeneralKeys.InitialData.GROUP_ACCOUNT_ADMINISTRATORS, new Object[0]));
        adminGroupDTO.setInternalName("accountAdmins");
        adminGroupDTO.setInitialUserStatus(UserStatus.ACTIVE);
        adminGroupDTO.setEnabled(true);
        adminGroupDTO.setCopySystemAdminProfileFields(true);
        AdminGroup adminGroup = (AdminGroup)this.save((CRUDServiceLocal)this.groupService, (EntityDTO)adminGroupDTO);
        adminGroup.getAdminProduct().setUserGroupAccessibility(UserGroupAccessibility.ALL);
        return adminGroup;
    }

    private void createAccountConfiguration() {
        this.createCurrency();
        this.createAccountTypes();
        this.createTransferTypes();
        this.createTransferFilters();
    }

    private void createAccountTypes() {
        SystemAccountTypeDTO systemAccountTypeDTO;
        CurrencyVO currencyVO = new CurrencyVO(this.currency.getId());
        if (StringHelper.isNotBlank((Object)this.data.getUnlimitedAccount())) {
            systemAccountTypeDTO = new SystemAccountTypeDTO();
            systemAccountTypeDTO.setNature(AccountTypeNature.SYSTEM);
            systemAccountTypeDTO.setLimitType(AccountTypeLimitType.UNLIMITED);
            systemAccountTypeDTO.setName(this.data.getUnlimitedAccount());
            systemAccountTypeDTO.setInternalName("debit");
            systemAccountTypeDTO.setCurrency(currencyVO);
            this.unlimitedAccount = (SystemAccountType)this.save((CRUDServiceLocal)this.accountTypeService, (EntityDTO)systemAccountTypeDTO);
        }
        systemAccountTypeDTO = new SystemAccountTypeDTO();
        systemAccountTypeDTO.setNature(AccountTypeNature.SYSTEM);
        systemAccountTypeDTO.setLimitType(AccountTypeLimitType.LIMITED);
        systemAccountTypeDTO.setCreditLimit(BigDecimal.ZERO);
        systemAccountTypeDTO.setName(this.data.getSystemAccount());
        systemAccountTypeDTO.setInternalName("organization");
        systemAccountTypeDTO.setCurrency(currencyVO);
        this.systemAccount = (SystemAccountType)this.save((CRUDServiceLocal)this.accountTypeService, (EntityDTO)systemAccountTypeDTO);
        if (StringHelper.isNotBlank((Object)this.data.getAdditionalSystemAccount())) {
            systemAccountTypeDTO = new SystemAccountTypeDTO();
            systemAccountTypeDTO.setNature(AccountTypeNature.SYSTEM);
            systemAccountTypeDTO.setLimitType(AccountTypeLimitType.LIMITED);
            systemAccountTypeDTO.setCreditLimit(BigDecimal.ZERO);
            systemAccountTypeDTO.setName(this.data.getAdditionalSystemAccount());
            systemAccountTypeDTO.setInternalName("community");
            systemAccountTypeDTO.setCurrency(currencyVO);
            this.additionalSystemAccount = (SystemAccountType)this.save((CRUDServiceLocal)this.accountTypeService, (EntityDTO)systemAccountTypeDTO);
        }
        UserAccountTypeDTO userAccountTypeDTO = new UserAccountTypeDTO();
        userAccountTypeDTO = new UserAccountTypeDTO();
        userAccountTypeDTO.setNature(AccountTypeNature.USER);
        userAccountTypeDTO.setName(this.data.getUserAccount());
        userAccountTypeDTO.setInternalName("user");
        userAccountTypeDTO.setCurrency(currencyVO);
        IntegerRangeDTO integerRangeDTO = null;
        BigDecimal bigDecimal = this.data.getDefaultCreditLimit();
        if (bigDecimal != null && !BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
            int n = bigDecimal.abs().divide(new BigDecimal(5), BigDecimalHelper.MATH_CONTEXT).intValue();
            if (n >= 10) {
                integerRangeDTO = ModelHelper.integerRange((Integer)(-n), (Integer)n);
            }
        } else {
            int n;
            BigDecimal bigDecimal2 = this.data.getInitialCredit();
            if (bigDecimal2 != null && !BigDecimalHelper.isZero((BigDecimal)bigDecimal2) && (n = bigDecimal2.abs().divide(new BigDecimal(5), BigDecimalHelper.MATH_CONTEXT).intValue()) >= 10) {
                integerRangeDTO = ModelHelper.integerRange((Integer)n, (Integer)(n * 2));
            }
        }
        userAccountTypeDTO.setDefaultYellowBalanceRange(integerRangeDTO);
        this.userAccount = (UserAccountType)this.save((CRUDServiceLocal)this.accountTypeService, (EntityDTO)userAccountTypeDTO);
    }

    private void createAdCategories() {
        if (this.data.isCreateAdCategories()) {
            List<InitialAdCategories> list = InitialAdCategories.getParents();
            for (InitialAdCategories initialAdCategories : list) {
                AdCategory adCategory = this.createAdCategory(null, initialAdCategories);
                List<InitialAdCategories> list2 = InitialAdCategories.getChildren(initialAdCategories);
                for (InitialAdCategories initialAdCategories2 : list2) {
                    this.createAdCategory(adCategory, initialAdCategories2);
                }
            }
            QConfiguration qConfiguration = QConfiguration.configuration;
            this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.adCategoriesResultType, (Object)AdCategoryResultType.IMAGE_LIST);
            this.configurationService.setConfiguration(this.configuration, (Path)qConfiguration.adSubCategoriesResults, (Object)6);
        }
    }

    private AdCategory createAdCategory(AdCategory adCategory, InitialAdCategories initialAdCategories) {
        AdCategoryDTO adCategoryDTO = new AdCategoryDTO();
        adCategoryDTO.setParent(adCategory == null ? null : new AdCategoryVO(adCategory.getId()));
        adCategoryDTO.setActive(Boolean.valueOf(true));
        adCategoryDTO.setName(this.message(initialAdCategories.getMessageKey(), new Object[0]));
        adCategoryDTO.setInternalName(initialAdCategories.getInternalName());
        adCategoryDTO.setSvgIcon(initialAdCategories.getSvgIcon());
        adCategoryDTO.setSvgIconColor(initialAdCategories.getSvgIconColor());
        AdCategory adCategory2 = (AdCategory)this.save((CRUDServiceLocal)this.adCategoryService, (EntityDTO)adCategoryDTO);
        String string = initialAdCategories.getImageFileName();
        URL uRL = ResourceHelper.getResource((String)("/adCategoryImages/" + string));
        if (uRL == null) {
            LOG.warn("Expected ad category image not found:" + string);
        } else {
            try (InputStream inputStream = uRL.openStream();){
                this.adCategoryImageService.save((Object)new AdCategoryVO(adCategory2.getId()), string, new SerializableInputStream(inputStream), ContentType.PNG.getMimeType());
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return adCategory2;
    }

    private void createAdConfiguration() {
        this.createAdCategories();
        this.createAdCustomFields();
    }

    private void createAdCustomFields() {
        Set set = this.data.getAdFields();
        if (set != null) {
            for (NetworkInitialAdField networkInitialAdField : set) {
                AdCustomFieldDTO adCustomFieldDTO = new AdCustomFieldDTO();
                adCustomFieldDTO.setSearchVisibility(networkInitialAdField.getSearchVisibility());
                adCustomFieldDTO.setRequired(networkInitialAdField.isRequired());
                AdCustomField adCustomField = (AdCustomField)this.saveCustomField((CustomFieldDTO)adCustomFieldDTO, (InitialCustomField)networkInitialAdField, (BaseCustomFieldService)this.adCustomFieldService, (BaseCustomFieldPossibleValueService)this.adCustomFieldPossibleValueService);
                this.adCustomFields.put(networkInitialAdField, adCustomField);
            }
        }
    }

    private User createAdministrator() {
        NetworkInitialAdministrator networkInitialAdministrator = this.data.getAdministrator();
        if (networkInitialAdministrator == null) {
            return null;
        }
        AdminGroup adminGroup = networkInitialAdministrator == NetworkInitialAdministrator.ACCOUNT ? this.accountAdministratorsGroup : this.networkAdministratorsGroup;
        UserRegistrationDTO userRegistrationDTO = new UserRegistrationDTO();
        userRegistrationDTO.setGroup(new GroupVO(adminGroup.getId()));
        userRegistrationDTO.setUsername(this.data.getAdminUsername());
        userRegistrationDTO.setName(this.data.getAdminName());
        userRegistrationDTO.setEmail(this.data.getAdminEmail());
        userRegistrationDTO.setSkipActivationEmail(true);
        PasswordRegistrationDTO passwordRegistrationDTO = new PasswordRegistrationDTO();
        passwordRegistrationDTO.setAssign(true);
        passwordRegistrationDTO.setValue(this.data.getAdminPassword());
        passwordRegistrationDTO.setType(new PasswordTypeVO(this.accessPasswordType.getId()));
        passwordRegistrationDTO.setConfirmationValue(passwordRegistrationDTO.getValue());
        passwordRegistrationDTO.setForceChange(this.data.isAdminForcePasswordChange());
        userRegistrationDTO.setPasswords(Arrays.asList(passwordRegistrationDTO));
        return this.userService.registerByPopulator(userRegistrationDTO);
    }

    private BrokerGroup createBrokerGroup(MessageKey messageKey) {
        BrokerGroupDTO brokerGroupDTO = new BrokerGroupDTO();
        brokerGroupDTO.setEnabled(true);
        brokerGroupDTO.setName(this.message(messageKey, new Object[0]));
        brokerGroupDTO.setInternalName("brokers");
        brokerGroupDTO.setInitialUserStatus(UserStatus.ACTIVE);
        return (BrokerGroup)this.save((CRUDServiceLocal)this.groupService, (EntityDTO)brokerGroupDTO);
    }

    private void createBrokerProduct() {
        if (!this.data.isSetupBrokers()) {
            return;
        }
        BrokerProductData brokerProductData = (BrokerProductData)this.productService.getDataForNew((Object)ProductNature.BROKER);
        BrokerProductDTO brokerProductDTO = (BrokerProductDTO)brokerProductData.getDto();
        brokerProductDTO.setName(this.message(GeneralKeys.InitialData.PRODUCT_BROKERS, new Object[0]));
        brokerProductDTO.setInternalName("brokers");
        brokerProductDTO.setUserGroupAccessibility(UserGroupAccessibility.ALL);
        this.addUserProfileFieldPermissionsTo((ProductDTO)brokerProductDTO);
        brokerProductDTO.setBlockedUsersManage(true);
        brokerProductDTO.setMyNotificationSettingsEnable(true);
        brokerProductDTO.setMyContactsEnable(true);
        brokerProductDTO.setConnectedUsers(ViewManageOperation.MANAGE);
        brokerProductDTO.setDisabledUsers(ViewManageOperation.MANAGE);
        brokerProductDTO.setRemovedUsers(ViewManageOperation.VIEW);
        brokerProductDTO.setPendingUsers(ViewManageOperation.MANAGE);
        brokerProductDTO.setUserAdvertisements(ViewManageOperation.MANAGE);
        brokerProductDTO.setUserChannelsAccess(ViewManageOperation.MANAGE);
        brokerProductDTO.setUserContactInfoManage(true);
        brokerProductDTO.setBrokerMessages(EnumSet.allOf(BrokerMessagesOperation.class));
        brokerProductDTO.setMaxMessageRecipients(Integer.valueOf(20));
        brokerProductDTO.setUserNotificationSettings(ViewManageOperation.MANAGE);
        brokerProductDTO.setMaxSmsPerMonth(Integer.valueOf(100));
        ReferenceNature referenceNature = this.data.getSetupReferences();
        if (referenceNature == ReferenceNature.GENERAL) {
            brokerProductDTO.setManageReferences(true);
        } else if (referenceNature == ReferenceNature.TRANSACTION_FEEDBACK) {
            brokerProductDTO.setManageTransactionFeedbacks(true);
        }
        for (ProductRecordFieldDTO productRecordFieldDTO : brokerProductDTO.getUserRecordTypeFields()) {
            productRecordFieldDTO.setView(true);
            productRecordFieldDTO.setEdit(this.remarks != null && productRecordFieldDTO.getRecordType().getId().equals(this.remarks.getId()));
        }
        brokerProductDTO.setUserAccountsAccess(new HashSet(brokerProductData.getUserAccounts()));
        brokerProductDTO.setSystemPaymentsAsUser(new HashSet(brokerProductData.getPaymentsAsUserToSystem()));
        brokerProductDTO.setUserPaymentsAsUser(new HashSet(brokerProductData.getPaymentsAsUserToUser()));
        brokerProductDTO.setUserRegistrationGroups(this.vos(BasicGroupVO.class, this.usersGroup));
        this.setDefaultQuickAccess((ProductDTO)brokerProductDTO, QuickAccessType.BROKERED_USERS, QuickAccessType.REGISTER_USER, QuickAccessType.HELP, QuickAccessType.SWITCH_FRONTEND, QuickAccessType.SWITCH_THEME);
        this.enableNotifications(brokerProductDTO.getNotifications(), EnumSet.allOf(BrokeringNotificationType.class));
        PasswordActionHelper.setUserPasswordActions((UserManagementProductDTO)brokerProductDTO);
        this.brokerProduct = (BrokerProduct)this.save((CRUDServiceLocal)this.productService, (EntityDTO)brokerProductDTO);
    }

    private void createCategories() {
        this.createSystemImageCategory();
        this.createMessageCategories();
    }

    private void createContactInfoFields() {
        ContactInfoFieldDTO contactInfoFieldDTO = new ContactInfoFieldDTO();
        this.contactInfoDescription = (ContactInfoField)this.saveCustomField((CustomFieldDTO)contactInfoFieldDTO, (InitialCustomField)NetworkInitialContactInfoField.DESCRIPTION, (BaseCustomFieldService)this.contactInfoFieldService, (BaseCustomFieldPossibleValueService)this.contactInfoFieldPossibleValueService);
    }

    private void createContent() {
        this.createMenuItems();
        this.createStaticContent();
        this.createThemes();
    }

    private void createCurrency() {
        CurrencyDTO currencyDTO = new CurrencyDTO();
        currencyDTO.setName(this.data.getCurrencyName());
        currencyDTO.setInternalName("unit");
        currencyDTO.setSymbol(this.data.getCurrencySymbol());
        currencyDTO.setPrefix(this.data.isCurrencySymbolBefore() ? currencyDTO.getSymbol() + " " : null);
        currencyDTO.setSuffix(this.data.isCurrencySymbolBefore() ? null : " " + currencyDTO.getSymbol());
        currencyDTO.setPrecision(Integer.valueOf(2));
        this.currency = (Currency)this.save((CRUDServiceLocal)this.currencyService, (EntityDTO)currencyDTO);
    }

    private void createGroups() {
        this.accountAdministratorsGroup = this.createAccountAdministrators();
        this.usersGroup = this.createMemberGroup(GeneralKeys.InitialData.GROUP_USERS);
        if (this.data.isSetupBrokers()) {
            this.brokersGroup = this.createBrokerGroup(GeneralKeys.InitialData.GROUP_BROKERS);
        }
    }

    private void createHelpDeskLog() {
        UserRecordTypeDTO userRecordTypeDTO = new UserRecordTypeDTO();
        userRecordTypeDTO.setName(this.message(GeneralKeys.InitialData.RECORD_TYPE_HELP_DESK_LOG, new Object[0]));
        userRecordTypeDTO.setInternalName("helpDeskLog");
        userRecordTypeDTO.setPluralName(this.message(GeneralKeys.InitialData.RECORD_TYPE_HELP_DESK_LOG_PLURAL, new Object[0]));
        userRecordTypeDTO.setResultsLayout(RecordTypeResultsLayout.LIST);
        userRecordTypeDTO.setSvgIcon("headset");
        userRecordTypeDTO.setUserMenu(UserMainMenu.PERSONAL);
        userRecordTypeDTO.setProfileSection(ProfileManagementSection.INFORMATION);
        userRecordTypeDTO.setFieldColumns(1);
        this.helpDeskLog = (RecordType)this.save((CRUDServiceLocal)this.recordTypeService, (EntityDTO)userRecordTypeDTO);
        for (HelpDeskLogField helpDeskLogField : HelpDeskLogField.values()) {
            RecordCustomFieldDTO recordCustomFieldDTO = new RecordCustomFieldDTO();
            recordCustomFieldDTO.setRecordType(new RecordTypeVO(this.helpDeskLog.getId()));
            recordCustomFieldDTO.setShowInSearch(helpDeskLogField.isShowInSearch());
            recordCustomFieldDTO.setShowInList(helpDeskLogField.isShowInList());
            recordCustomFieldDTO.setColspan(1);
            this.saveCustomField((CustomFieldDTO)recordCustomFieldDTO, helpDeskLogField, (BaseCustomFieldService)this.recordCustomFieldService, (BaseCustomFieldPossibleValueService)this.recordCustomPossibleValueService);
        }
        this.helpDeskLog = (RecordType)this.rawEntityManagerHandler.refresh((IEntity)this.helpDeskLog);
    }

    private MemberGroup createMemberGroup(MessageKey messageKey) {
        MemberGroupDTO memberGroupDTO = new MemberGroupDTO();
        memberGroupDTO.setEnabled(true);
        memberGroupDTO.setName(this.message(messageKey, new Object[0]));
        memberGroupDTO.setInternalName("members");
        memberGroupDTO.setInitialUserStatus(UserStatus.ACTIVE);
        return (MemberGroup)this.save((CRUDServiceLocal)this.groupService, (EntityDTO)memberGroupDTO);
    }

    private void createMemberProduct() {
        Object object;
        AdCustomField adCustomField2;
        Object object22;
        MemberProductData memberProductData = (MemberProductData)this.productService.getDataForNew((Object)ProductNature.MEMBER);
        MemberProductDTO memberProductDTO = (MemberProductDTO)memberProductData.getDto();
        memberProductDTO.setName(this.message(GeneralKeys.InitialData.PRODUCT_MEMBERS, new Object[0]));
        memberProductDTO.setInternalName("members");
        memberProductDTO.setUserGroupAccessibility(UserGroupAccessibility.ALL);
        memberProductDTO.setSearchUsersOnGroups(UserGroupAccessibility.ALL);
        memberProductDTO.setViewProfileOnGroups(UserGroupAccessibility.ALL);
        memberProductDTO.setUserDirectoryOnGroups(UserGroupAccessibility.ALL);
        PasswordActionHelper.setMyPasswordActions((ProductDTO)memberProductDTO, (PasswordType)this.accessPasswordType);
        memberProductDTO.setMaxAddresses(Integer.valueOf(1));
        memberProductDTO.setMaxMobilePhones(Integer.valueOf(3));
        memberProductDTO.setMaxLandlinePhones(Integer.valueOf(1));
        memberProductDTO.setMaxProfileImages(Integer.valueOf(3));
        memberProductDTO.setMaxSmsPerMonth(Integer.valueOf(100));
        for (Object object22 : memberProductDTO.getMyRecordTypeFields()) {
            object22.setEnabled(true);
        }
        memberProductDTO.setUserAccount(new AccountTypeWithCurrencyVO(this.userAccount.getId()));
        memberProductDTO.setAccountAccessibility(AccountAccessibility.ALWAYS);
        memberProductDTO.setAccountVisibility(AccountVisibility.ALWAYS_VISIBLE);
        memberProductDTO.setMyTransferFilters(new HashSet(memberProductData.getTransferFilters()));
        if (this.unlimitedAccount != null) {
            memberProductDTO.setInitialCreditType(new TransferTypeVO(this.initialCredit.getId()));
            memberProductDTO.setInitialCredit(this.data.getInitialCredit());
        }
        memberProductDTO.setDefaultCreditLimit(this.data.getDefaultCreditLimit());
        memberProductDTO.setSystemPayments(new HashSet(memberProductData.getSystemPayments()));
        memberProductDTO.setUserPayments(new HashSet(memberProductData.getUserPayments()));
        memberProductDTO.setMyAdsEnable(true);
        memberProductDTO.setMyNotificationSettingsEnable(true);
        memberProductDTO.setMyContactsEnable(true);
        memberProductDTO.setAdInterests(true);
        memberProductDTO.setMyAdsManage(true);
        memberProductDTO.setUserAdsView(true);
        memberProductDTO.setMaxAds(Integer.valueOf(15));
        memberProductDTO.setMaxAdDescriptionSize(Integer.valueOf(2000));
        memberProductDTO.setMaxAdImages(Integer.valueOf(3));
        memberProductDTO.setDefaultAdPublicationTime(ModelHelper.timeInterval((int)3, (TimeField)TimeField.MONTHS));
        memberProductDTO.setMaxAdPublicationTime(ModelHelper.timeInterval((int)12, (TimeField)TimeField.MONTHS));
        ArrayList arrayList = new ArrayList();
        for (AdCustomField adCustomField2 : this.adCustomFields.values()) {
            object = new ProductMyAdFieldDTO();
            object.setCustomField(new CustomFieldVO(adCustomField2.getId()));
            object.setEnable(true);
            object.setView(true);
            object.setManage(true);
            arrayList.add(object);
        }
        memberProductDTO.setMyAdFields((List)arrayList);
        memberProductDTO.setMyMessages(EnumSet.allOf(MyMessagesOperation.class));
        memberProductDTO.setMaxMessageRecipients(Integer.valueOf(5));
        memberProductDTO.setSendMessagesToAdmin(new HashSet(memberProductData.getSendAdminMessages()));
        memberProductDTO.setMaxMessageRecipients(Integer.valueOf(1));
        memberProductDTO.setFwdMessageToEmail(MyMessagesForwardOperation.ENABLED);
        object22 = CollectionHelper.asSet((Object[])new UserProfileActivity[]{UserProfileActivity.ACTIVATION_DATE, UserProfileActivity.ADVERTISEMENTS});
        adCustomField2 = this.data.getSetupReferences();
        if (adCustomField2 == ReferenceNature.GENERAL) {
            memberProductDTO.setMyReferences(EnumSet.allOf(MyReferencesOperation.class));
            object22.add(UserProfileActivity.REFERENCES);
        } else if (adCustomField2 == ReferenceNature.TRANSACTION_FEEDBACK) {
            memberProductDTO.setMyTransactionFeedbacks(EnumSet.allOf(MyReferencesOperation.class));
            object22.add(UserProfileActivity.PAYMENT_FEEDBACK);
        }
        memberProductDTO.setShowActivitiesInProfile((Set)object22);
        this.setDefaultQuickAccess((ProductDTO)memberProductDTO, QuickAccessType.ACCOUNT, QuickAccessType.PAY_USER, QuickAccessType.RECEIVE_QR_PAYMENT, QuickAccessType.CONTACTS, QuickAccessType.SEARCH_USERS, QuickAccessType.SWITCH_THEME, QuickAccessType.SWITCH_FRONTEND, QuickAccessType.HELP);
        memberProductDTO.setFwdMessageToEmail(MyMessagesForwardOperation.ENABLED_AND_DEFAULT);
        object = new HashSet();
        object.add(PersonalNotificationType.PASSWORD_STATUS_CHANGED);
        if (this.isMutualCredit()) {
            object.add(AccountNotificationType.LIMIT_CHANGE);
        }
        object.add(AccountNotificationType.PAYMENT_RECEIVED);
        object.add(MarketplaceSellerNotificationType.AD_QUESTION_CREATED);
        object.add(MarketplaceBuyerNotificationType.AD_QUESTION_ANSWERED);
        object.add(MarketplaceBuyerNotificationType.AD_INTEREST_NOTIFICATION);
        object.add(FeedbackAndReferenceNotificationType.REFERENCE_CREATED);
        object.add(FeedbackAndReferenceNotificationType.REFERENCE_CHANGED);
        this.enableNotifications(memberProductDTO.getNotifications(), (Collection<? extends UserNotificationType>)object);
        this.addProfileFieldPermissionsToMemberProduct(memberProductDTO);
        memberProductDTO.setMyCreateTicketPaymentTypes(Collections.singleton(new TransferTypeVO(this.userPayment.getId())));
        memberProductDTO.setMyApproveTicketPaymentTypes(Collections.singleton(new TransferTypeVO(this.userPayment.getId())));
        this.memberProduct = (MemberProduct)this.save((CRUDServiceLocal)this.productService, (EntityDTO)memberProductDTO);
    }

    private void createMenuItems() {
        if (!this.data.isCreateSampleContentPages()) {
            return;
        }
        ConfigurationVO configurationVO = new ConfigurationVO(this.configuration.getId());
        MenuGroupDTO menuGroupDTO = new MenuGroupDTO();
        menuGroupDTO.setName(this.message(GeneralKeys.InitialData.MENU_ENTRY_GROUP, new Object[0]));
        menuGroupDTO.setVisibility(ContentItemVisibility.ALL);
        menuGroupDTO.setConfiguration(configurationVO);
        menuGroupDTO.setPosition(MenuGroupPosition.HORIZONTAL_MENU);
        menuGroupDTO.setSvgIcon(SvgIcon.INFO_CIRCLE_FILL.icon());
        MenuEntry menuEntry = (MenuEntry)this.save((CRUDServiceLocal)this.menuEntryService, (EntityDTO)menuGroupDTO);
        MenuGroupVO menuGroupVO = new MenuGroupVO(menuEntry.getId());
        for (int i = 1; i <= 3; ++i) {
            MenuItemDTO menuItemDTO = new MenuItemDTO();
            menuItemDTO.setType(MenuItemType.CONTENT);
            menuItemDTO.setConfiguration(configurationVO);
            menuItemDTO.setGroup((MenuEntryVO)menuGroupVO);
            menuItemDTO.setVisibility(ContentItemVisibility.ALL);
            menuItemDTO.setName(this.message(GeneralKeys.InitialData.MENU_ENTRY_TITLE, i));
            menuItemDTO.setTitle(menuItemDTO.getName());
            menuItemDTO.setContent(this.message(GeneralKeys.InitialData.MENU_ENTRY_CONTENT, i));
            this.menuEntryService.save((EntityDTO)menuItemDTO);
        }
    }

    private void createMessageCategories() {
        if (this.data.getMessageCategories() != null) {
            for (String string : this.data.getMessageCategories()) {
                MessageCategoryDTO messageCategoryDTO = new MessageCategoryDTO();
                messageCategoryDTO.setName(string);
                this.messageCategoryService.save((EntityDTO)messageCategoryDTO);
            }
        }
    }

    private void createProducts() {
        this.createMemberProduct();
        this.createBrokerProduct();
        this.assignProductsToGroups();
    }

    private void createRecordTypes() {
        Set set = this.data.getRecords();
        if (set != null) {
            if (set.contains(NetworkInitialRecord.REMARKS)) {
                this.createRemarks();
            }
            if (set.contains(NetworkInitialRecord.HELP_DESK_LOG)) {
                this.createHelpDeskLog();
            }
        }
    }

    private void createRemarks() {
        UserRecordTypeDTO userRecordTypeDTO = new UserRecordTypeDTO();
        userRecordTypeDTO.setInternalName("remark");
        userRecordTypeDTO.setName(this.message(GeneralKeys.InitialData.RECORD_TYPE_REMARKS_SINGULAR, new Object[0]));
        userRecordTypeDTO.setPluralName(this.message(GeneralKeys.InitialData.RECORD_TYPE_REMARKS, new Object[0]));
        userRecordTypeDTO.setResultsLayout(RecordTypeResultsLayout.TILED);
        userRecordTypeDTO.setUserMenu(UserMainMenu.PERSONAL);
        userRecordTypeDTO.setProfileSection(ProfileManagementSection.INFORMATION);
        userRecordTypeDTO.setSvgIcon("chat-left-text");
        userRecordTypeDTO.setFieldColumns(1);
        this.remarks = (RecordType)this.save((CRUDServiceLocal)this.recordTypeService, (EntityDTO)userRecordTypeDTO);
        for (RemarkField remarkField : RemarkField.values()) {
            RecordCustomFieldDTO recordCustomFieldDTO = new RecordCustomFieldDTO();
            recordCustomFieldDTO.setRecordType(new RecordTypeVO(this.remarks.getId()));
            recordCustomFieldDTO.setShowInList(true);
            recordCustomFieldDTO.setColspan(1);
            this.saveCustomField((CustomFieldDTO)recordCustomFieldDTO, remarkField, (BaseCustomFieldService)this.recordCustomFieldService, (BaseCustomFieldPossibleValueService)this.recordCustomPossibleValueService);
        }
        this.remarks = (RecordType)this.rawEntityManagerHandler.refresh((IEntity)this.remarks);
    }

    private void createStaticContent() {
        if (!this.data.isCreateSampleStaticContent()) {
            return;
        }
        StaticContentDataParams staticContentDataParams = new StaticContentDataParams();
        staticContentDataParams.setConfiguration(new ConfigurationVO(this.configuration.getId()));
        staticContentDataParams.setNature(StaticContentNature.LOGGED_USER_HOME);
        StaticContentData staticContentData = (StaticContentData)this.staticContentService.getDataForNew((Object)staticContentDataParams);
        LoggedUserHomeContentDTO loggedUserHomeContentDTO = (LoggedUserHomeContentDTO)staticContentData.getDto();
        loggedUserHomeContentDTO.setCustomized(true);
        loggedUserHomeContentDTO.setTitle(this.message(GeneralKeys.InitialData.STATIC_CONTENT_NETWORK_LOGGED_USER_HOME_TITLE, new Object[0]));
        loggedUserHomeContentDTO.setContent(this.message(GeneralKeys.InitialData.STATIC_CONTENT_NETWORK_LOGGED_USER_HOME_CONTENT, MessageFormat.HTML, new Object[0]));
        this.staticContentService.save((EntityDTO)loggedUserHomeContentDTO);
        staticContentDataParams.setNature(StaticContentNature.GUEST_HOME);
        staticContentData = (StaticContentData)this.staticContentService.getDataForNew((Object)staticContentDataParams);
        GuestHomeContentDTO guestHomeContentDTO = (GuestHomeContentDTO)staticContentData.getDto();
        guestHomeContentDTO.setCustomized(true);
        guestHomeContentDTO.setTitle(this.message(GeneralKeys.InitialData.STATIC_CONTENT_NETWORK_GUEST_HOME_TITLE, this.configuration.getApplicationName()));
        guestHomeContentDTO.setContent(this.message(GeneralKeys.InitialData.STATIC_CONTENT_NETWORK_GUEST_HOME_CONTENT, MessageFormat.HTML, new Object[0]));
        this.staticContentService.save((EntityDTO)guestHomeContentDTO);
    }

    private void createSystemImageCategory() {
        SystemImageCategoryDTO systemImageCategoryDTO = new SystemImageCategoryDTO();
        systemImageCategoryDTO.setName(this.network.getName());
        this.save((CRUDServiceLocal)this.systemImageCategoryService, (EntityDTO)systemImageCategoryDTO);
    }

    private void createThemes() {
        if (!this.data.isCloneThemes()) {
            return;
        }
        Long l = this.configuration.getId();
        ConfigurationVO configurationVO = new ConfigurationVO(l);
        Theme theme = this.configurationAccessor.getUsersTheme();
        Theme theme2 = this.configurationAccessor.getMobileTheme();
        Theme theme3 = this.configurationAccessor.getPayTheme();
        ThemeDataParams themeDataParams = new ThemeDataParams();
        themeDataParams.setConfiguration(configurationVO);
        themeDataParams.setBasedOnId(theme.getId());
        ThemeData themeData = (ThemeData)this.themeService.getDataForNew((Object)themeDataParams);
        ThemeDTO themeDTO = (ThemeDTO)themeData.getDto();
        themeDTO.setName(StringHelper.truncate((String)this.message(GeneralKeys.InitialData.THEME_MAIN, this.network.getName()), (int)100));
        Long l2 = this.themeService.save((EntityDTO)themeDTO);
        ThemeDataParams themeDataParams2 = new ThemeDataParams();
        themeDataParams2.setConfiguration(configurationVO);
        themeDataParams2.setBasedOnId(theme2.getId());
        ThemeData themeData2 = (ThemeData)this.themeService.getDataForNew((Object)themeDataParams2);
        ThemeDTO themeDTO2 = (ThemeDTO)themeData2.getDto();
        themeDTO2.setName(StringHelper.truncate((String)this.message(GeneralKeys.InitialData.THEME_MOBILE, this.network.getName()), (int)100));
        Long l3 = this.themeService.save((EntityDTO)themeDTO2);
        ThemeDataParams themeDataParams3 = new ThemeDataParams();
        themeDataParams3.setConfiguration(configurationVO);
        themeDataParams3.setBasedOnId(theme3.getId());
        ThemeData themeData3 = (ThemeData)this.themeService.getDataForNew((Object)themeDataParams3);
        ThemeDTO themeDTO3 = (ThemeDTO)themeData3.getDto();
        themeDTO3.setName(StringHelper.truncate((String)this.message(GeneralKeys.InitialData.THEME_PAY, this.network.getName()), (int)100));
        Long l4 = this.themeService.save((EntityDTO)themeDTO3);
        ApplyThemesDTO applyThemesDTO = new ApplyThemesDTO();
        applyThemesDTO.setConfiguration(new ConfigurationVO(l));
        applyThemesDTO.setUsersTheme(new ThemeVO(l2));
        applyThemesDTO.setGuestsTheme(new ThemeVO(l2));
        applyThemesDTO.setMobileTheme(new ThemeVO(l3));
        applyThemesDTO.setPayTheme(new ThemeVO(l4));
        this.themeService.applyThemes(applyThemesDTO);
    }

    private void createTransferFilters() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(this.getAllSystemAccountTypes());
        arrayList.add(this.userAccount);
        QTransferType qTransferType = QTransferType.transferType;
        for (AccountType accountType : arrayList) {
            for (AccountTypeNature accountTypeNature : AccountTypeNature.values()) {
                List list = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qTransferType}).where((Predicate)qTransferType.from().eq((Object)accountType).and((Predicate)qTransferType.to().nature.eq((Object)accountTypeNature)).or((Predicate)qTransferType.to().eq((Object)accountType).and((Predicate)qTransferType.from().nature.eq((Object)accountTypeNature))))).list((Expression)qTransferType);
                if (!CollectionHelper.isNotEmpty((Iterable)list)) continue;
                String string = this.message(accountTypeNature == AccountTypeNature.USER ? GeneralKeys.InitialData.TRANSFER_FILTER_USER_PAYMENTS : GeneralKeys.InitialData.TRANSFER_FILTER_SYSTEM_PAYMENTS, new Object[0]);
                TransferFilterDTO transferFilterDTO = new TransferFilterDTO();
                transferFilterDTO.setAccountType(new AccountTypeVO(accountType.getId()));
                transferFilterDTO.setName(string);
                transferFilterDTO.setInternalName(accountTypeNature.name().toLowerCase());
                transferFilterDTO.setTransferTypes(this.vos(TransferTypeVO.class, list));
                this.transferFilterService.save((EntityDTO)transferFilterDTO);
            }
        }
    }

    private void createTransferTypes() {
        Object object;
        SystemAccountType systemAccountType;
        Object object2;
        AccountTypeVO accountTypeVO = new AccountTypeVO(this.userAccount.getId());
        if (this.unlimitedAccount != null) {
            object2 = new GeneratedTransferTypeDTO();
            object2.setName(this.message(GeneralKeys.InitialData.TRANSFER_TYPE_INITIAL_CREDIT, new Object[0]));
            object2.setInternalName("initialCredit");
            object2.setFrom(new AccountTypeVO(this.unlimitedAccount.getId()));
            object2.setTo(accountTypeVO);
            object2.setDescriptionAvailability(Availability.OPTIONAL);
            this.initialCredit = (GeneratedTransferType)this.save((CRUDServiceLocal)this.transferTypeService, (EntityDTO)object2);
        }
        PaymentTransferTypeDTO paymentTransferTypeDTO = new PaymentTransferTypeDTO();
        paymentTransferTypeDTO.setName(this.message(GeneralKeys.InitialData.TRANSFER_TYPE_USER_PAYMENT, new Object[0]));
        paymentTransferTypeDTO.setInternalName("trade");
        paymentTransferTypeDTO.setFrom(accountTypeVO);
        paymentTransferTypeDTO.setTo(accountTypeVO);
        paymentTransferTypeDTO.setEnabled(true);
        paymentTransferTypeDTO.setNotifyPaymentReceived(true);
        paymentTransferTypeDTO.setChannels(CollectionHelper.asSet((Object[])new ChannelVO[]{this.mainChannelVO, this.webServicesChannelVO, this.mobileChannelVO, this.ticketChannelVO, this.posChannelVO}));
        paymentTransferTypeDTO.setMaturityPolicy(MaturityPolicy.ALWAYS);
        paymentTransferTypeDTO.setDescriptionAvailability(Availability.OPTIONAL);
        if (this.data.getSetupReferences() == ReferenceNature.TRANSACTION_FEEDBACK) {
            paymentTransferTypeDTO.setRequiresFeedback(true);
            paymentTransferTypeDTO.setFeedbackSetting(TransactionFeedbackSetting.ALWAYS_REQUIRED);
            paymentTransferTypeDTO.setFeedbackExpirationDays(Integer.valueOf(14));
            paymentTransferTypeDTO.setFeedbackExpirationReminderDays(Integer.valueOf(13));
            paymentTransferTypeDTO.setFeedbackReminderDays(Integer.valueOf(0));
            paymentTransferTypeDTO.setMaxDaysToChangeFeedback(Integer.valueOf(7));
            paymentTransferTypeDTO.setFeedbackReplyExpirationDays(Integer.valueOf(7));
            paymentTransferTypeDTO.setDefaultFeedbackLevel(ReferenceLevel.NA);
            paymentTransferTypeDTO.setDefaultFeedbackComments(this.message(GeneralKeys.InitialData.TRANSFER_TYPE_DEFAULT_TRANSACTION_FEDBACK_COMMENTS, new Object[0]));
        }
        this.userPayment = (PaymentTransferType)this.save((CRUDServiceLocal)this.transferTypeService, (EntityDTO)paymentTransferTypeDTO);
        object2 = this.getAllSystemAccountTypes();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            systemAccountType = (SystemAccountType)iterator.next();
            object = (AccountTypeVO)this.conversionHandler.convert(AccountTypeVO.class, (Object)systemAccountType);
            paymentTransferTypeDTO = new PaymentTransferTypeDTO();
            paymentTransferTypeDTO.setFrom((AccountTypeVO)object);
            paymentTransferTypeDTO.setTo(accountTypeVO);
            paymentTransferTypeDTO.setName(StringHelper.truncate((String)this.message(GeneralKeys.InitialData.TRANSFER_TYPE_SYSTEM_TO_USER, paymentTransferTypeDTO.getFrom().getName(), paymentTransferTypeDTO.getTo().getName()), (int)100));
            paymentTransferTypeDTO.setInternalName("toUser");
            paymentTransferTypeDTO.setEnabled(true);
            paymentTransferTypeDTO.setNotifyPaymentReceived(true);
            paymentTransferTypeDTO.setChannels(CollectionHelper.asSet((Object[])new ChannelVO[]{this.mainChannelVO}));
            paymentTransferTypeDTO.setMaturityPolicy(MaturityPolicy.ALWAYS);
            paymentTransferTypeDTO.setDescriptionAvailability(Availability.OPTIONAL);
            this.save((CRUDServiceLocal)this.transferTypeService, (EntityDTO)paymentTransferTypeDTO);
            paymentTransferTypeDTO = new PaymentTransferTypeDTO();
            paymentTransferTypeDTO.setFrom(accountTypeVO);
            paymentTransferTypeDTO.setTo((AccountTypeVO)object);
            paymentTransferTypeDTO.setName(StringHelper.truncate((String)this.message(GeneralKeys.InitialData.TRANSFER_TYPE_USER_TO_SYSTEM, paymentTransferTypeDTO.getFrom().getName(), paymentTransferTypeDTO.getTo().getName()), (int)100));
            paymentTransferTypeDTO.setInternalName("to" + StringHelper.capitalize((String)systemAccountType.getInternalName()));
            paymentTransferTypeDTO.setEnabled(true);
            paymentTransferTypeDTO.setChannels(CollectionHelper.asSet((Object[])new ChannelVO[]{this.mainChannelVO}));
            paymentTransferTypeDTO.setMaturityPolicy(MaturityPolicy.ALWAYS);
            paymentTransferTypeDTO.setDescriptionAvailability(Availability.OPTIONAL);
            this.save((CRUDServiceLocal)this.transferTypeService, (EntityDTO)paymentTransferTypeDTO);
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            systemAccountType = (SystemAccountType)iterator.next();
            object = object2.iterator();
            while (object.hasNext()) {
                SystemAccountType systemAccountType2 = (SystemAccountType)object.next();
                if (systemAccountType == systemAccountType2) continue;
                AccountTypeVO accountTypeVO2 = new AccountTypeVO(systemAccountType.getId());
                AccountTypeVO accountTypeVO3 = new AccountTypeVO(systemAccountType2.getId());
                paymentTransferTypeDTO = new PaymentTransferTypeDTO();
                paymentTransferTypeDTO.setFrom(accountTypeVO2);
                paymentTransferTypeDTO.setTo(accountTypeVO3);
                String string = this.message(GeneralKeys.InitialData.TRANSFER_TYPE_SYSTEM_TO_SYSTEM, systemAccountType.getName(), systemAccountType2.getName());
                if (string.length() > 100) {
                    string = this.message(GeneralKeys.InitialData.TRANSFER_TYPE_SYSTEM_TO_SYSTEM, systemAccountType.getInternalName(), systemAccountType2.getName());
                }
                paymentTransferTypeDTO.setName(StringHelper.truncate((String)string, (int)100));
                paymentTransferTypeDTO.setInternalName("to" + StringHelper.capitalize((String)systemAccountType2.getInternalName()));
                paymentTransferTypeDTO.setEnabled(true);
                paymentTransferTypeDTO.setChannels(CollectionHelper.asSet((Object[])new ChannelVO[]{this.mainChannelVO}));
                paymentTransferTypeDTO.setMaturityPolicy(MaturityPolicy.ALWAYS);
                paymentTransferTypeDTO.setDescriptionAvailability(Availability.OPTIONAL);
                this.save((CRUDServiceLocal)this.transferTypeService, (EntityDTO)paymentTransferTypeDTO);
            }
        }
    }

    private void createUserConfiguration() {
        this.createGroups();
        this.createUserCustomFields();
        this.createContactInfoFields();
        this.createRecordTypes();
        this.createProducts();
        this.setAdminsPermissions();
    }

    private void createUserCustomFields() {
        Set set = this.data.getProfileFields();
        if (set != null) {
            for (NetworkInitialProfileField networkInitialProfileField : set) {
                UserCustomFieldDTO userCustomFieldDTO = new UserCustomFieldDTO();
                UserCustomField userCustomField = (UserCustomField)this.saveCustomField((CustomFieldDTO)userCustomFieldDTO, (InitialCustomField)networkInitialProfileField, (BaseCustomFieldService)this.userCustomFieldService, (BaseCustomFieldPossibleValueService)this.userCustomFieldPossibleValueService);
                if (networkInitialProfileField.getOidcClaim() != null) {
                    userCustomField.setOidcClaim(networkInitialProfileField.getOidcClaim());
                }
                this.userCustomFields.put(networkInitialProfileField, userCustomField);
            }
        }
    }

    private void enableNotifications(List<UserProductNotificationDTO> list, Collection<? extends UserNotificationType> collection) {
        list.stream().filter(userProductNotificationDTO -> collection.contains(userProductNotificationDTO.getType())).forEach(userProductNotificationDTO -> {
            userProductNotificationDTO.setEnabled(true);
            userProductNotificationDTO.setAllowMail(true);
        });
    }

    private List<SystemAccountType> getAllSystemAccountTypes() {
        ArrayList<SystemAccountType> arrayList = new ArrayList<SystemAccountType>();
        if (this.unlimitedAccount != null) {
            arrayList.add(this.unlimitedAccount);
        }
        arrayList.add(this.systemAccount);
        if (this.additionalSystemAccount != null) {
            arrayList.add(this.additionalSystemAccount);
        }
        return arrayList;
    }

    private boolean isMutualCredit() {
        BigDecimal bigDecimal = this.data.getDefaultCreditLimit();
        return bigDecimal != null && !BigDecimalHelper.isZero((BigDecimal)bigDecimal);
    }

    private String message(MessageKey messageKey, MessageFormat messageFormat, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, this.baseLanguage, messageKey, objectArray);
    }

    private String message(MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(this.baseLanguage, messageKey, objectArray);
    }

    private void readData() {
        this.configuration = this.network.getDefaultConfiguration();
        this.configurationAccessor = this.configurationHandler.getAccessor(this.configuration);
        this.networkAdministratorsGroup = this.network.getAdministrators();
        this.mainChannelVO = new ChannelVO(this.channelService.getMain().getId());
        this.webServicesChannelVO = new ChannelVO(this.channelService.getWebServices().getId());
        this.mobileChannelVO = new ChannelVO(this.channelService.getMobile().getId());
        this.ticketChannelVO = new ChannelVO(this.channelService.getTicket().getId());
        this.posChannelVO = new ChannelVO(this.channelService.getPos().getId());
        Channel channel = InvocationContext.ensure().sessionData().getChannel();
        this.accessPasswordType = this.configurationAccessor.getChannelConfiguration(channel).getAccessPassword();
    }

    private <E extends BaseEntity, DTO extends EntityDTO> E save(CRUDServiceLocal<E, DTO, ?, ?> cRUDServiceLocal, DTO DTO) {
        Long l = cRUDServiceLocal.save(DTO);
        BaseEntity baseEntity = (BaseEntity)cRUDServiceLocal.find(l);
        this.rawEntityManagerHandler.flush();
        return (E)((BaseEntity)this.rawEntityManagerHandler.refresh((IEntity)baseEntity));
    }

    private <DTO extends CustomFieldDTO, CF extends CustomField<?, ?, ?>, T extends Enum<?>> CF saveCustomField(DTO DTO, InitialCustomField initialCustomField, BaseCustomFieldService<DTO, ?, ?> baseCustomFieldService, BaseCustomFieldPossibleValueService baseCustomFieldPossibleValueService) {
        DTO.setName(this.message(initialCustomField.getMessageKey(), new Object[0]));
        DTO.setInternalName(StringHelper.camelize((String)initialCustomField.name()));
        DTO.setType(initialCustomField.getType());
        DTO.setControl(initialCustomField.getControl());
        DTO.setSize(initialCustomField.getSize());
        DTO.setValueMatch(initialCustomField.valueMatch());
        if (DTO instanceof UserCustomFieldDTO) {
            ((UserCustomFieldDTO)DTO).setDefaultVisibility(FieldVisibility.VISIBLE);
        }
        Long l = baseCustomFieldService.save(DTO);
        if (DTO.getType().isEnumerated()) {
            for (Enum enum_ : initialCustomField.getEnumeratedValues()) {
                HasMessageKey hasMessageKey = (HasMessageKey)enum_;
                boolean bl = initialCustomField.isDefaultValue(enum_);
                CustomFieldPossibleValueDTO customFieldPossibleValueDTO = new CustomFieldPossibleValueDTO();
                customFieldPossibleValueDTO.setField(new CustomFieldVO(l));
                customFieldPossibleValueDTO.setValue(this.message(hasMessageKey.getMessageKey(), new Object[0]));
                customFieldPossibleValueDTO.setInternalName(StringHelper.camelize((String)enum_.name()));
                customFieldPossibleValueDTO.setDefaultValue(bl);
                baseCustomFieldPossibleValueService.save((EntityDTO)customFieldPossibleValueDTO);
            }
        }
        return (CF)((CustomField)((CRUDServiceLocal)baseCustomFieldService).find(l));
    }

    private void setAdminsPermissions() {
        AdminProductData adminProductData = (AdminProductData)this.productService.getData(this.accountAdministratorsGroup.getAdminProduct().getId());
        AdminProductDTO adminProductDTO = (AdminProductDTO)adminProductData.getDto();
        this.setPermissions(adminProductData);
        SpecificConfigurationAccess specificConfigurationAccess = this.data.getAccountAdminsSpecificConfigurationAccess();
        if (specificConfigurationAccess != null) {
            switch (specificConfigurationAccess) {
                case MANAGE: {
                    adminProductDTO.setManageSpecificConfigurations(this.vos(ConfigurationVO.class, this.configuration));
                    break;
                }
                case MANAGE_CONTENT: {
                    adminProductDTO.setManageContentSpecificConfigurations(this.vos(ConfigurationVO.class, this.configuration));
                }
            }
        }
        this.productService.save((EntityDTO)adminProductDTO);
        AdminProductData adminProductData2 = (AdminProductData)this.productService.getData(this.networkAdministratorsGroup.getAdminProduct().getId());
        AdminProductDTO adminProductDTO2 = (AdminProductDTO)adminProductData2.getDto();
        this.setPermissions(adminProductData2);
        adminProductDTO2.setOidcClients(ViewManageOperation.MANAGE);
        adminProductDTO2.setConfigurationEntityLog(true);
        adminProductDTO2.setChargebackPaymentsToSystem(new HashSet(adminProductData2.getChargebackPaymentsToSystem()));
        this.productService.save((EntityDTO)adminProductDTO2);
    }

    private void setPermissions(AdminProductData adminProductData) {
        AdminProductDTO adminProductDTO = (AdminProductDTO)adminProductData.getDto();
        this.setDefaultQuickAccess((ProductDTO)adminProductDTO, new QuickAccessType[0]);
        adminProductDTO.setMaxAddresses(Integer.valueOf(3));
        adminProductDTO.setMaxProfileImages(Integer.valueOf(1));
        adminProductDTO.setMaxLandlinePhones(Integer.valueOf(3));
        adminProductDTO.setMaxMobilePhones(Integer.valueOf(3));
        adminProductDTO.setMaxSmsPerMonth(Integer.valueOf(100));
        PasswordActionHelper.setMyPasswordActions((ProductDTO)adminProductDTO, (PasswordType)this.accessPasswordType);
        adminProductDTO.setMyNotificationSettingsEnable(true);
        adminProductDTO.setMyContactsEnable(true);
        adminProductDTO.setAdConfiguration(ViewManageOperation.MANAGE);
        adminProductDTO.setSystemAccounts(new HashSet(adminProductData.getSystemAccounts()));
        adminProductDTO.setSystemToSystemPayments(new HashSet(adminProductData.getSystemToSystemPayments()));
        adminProductDTO.setSystemToUserPayments(new HashSet(adminProductData.getSystemToUserPayments()));
        adminProductDTO.setSystemTransferFilters(new HashSet(adminProductData.getSystemTransferFilters()));
        adminProductDTO.setChargebackPaymentsToUser(new HashSet(adminProductData.getChargebackPaymentsToUser()));
        adminProductDTO.setUserTransferFilters(new HashSet(adminProductData.getUserTransferFilters()));
        adminProductDTO.setViewHiddenProfileFields(true);
        adminProductDTO.setUserRegistration(true);
        adminProductDTO.setUserGroup(ViewManageOperation.MANAGE);
        adminProductDTO.setBlockedUsersManage(true);
        adminProductDTO.setDisabledUsers(ViewManageOperation.MANAGE);
        adminProductDTO.setRemovedUsers(ViewManageOperation.MANAGE);
        adminProductDTO.setPendingUsers(ViewManageOperation.MANAGE);
        adminProductDTO.setUserChannelsAccess(ViewManageOperation.MANAGE);
        adminProductDTO.setUserContactInfoManage(true);
        adminProductDTO.setConnectedUsers(ViewManageOperation.MANAGE);
        ReferenceNature referenceNature = this.data.getSetupReferences();
        adminProductDTO.setManageReferences(false);
        adminProductDTO.setManageTransactionFeedbacks(false);
        if (referenceNature == ReferenceNature.GENERAL) {
            adminProductDTO.setManageReferences(true);
        } else if (referenceNature == ReferenceNature.TRANSACTION_FEEDBACK) {
            adminProductDTO.setManageTransactionFeedbacks(true);
        }
        PasswordActionHelper.setUserPasswordActions((UserManagementProductDTO)adminProductDTO);
        adminProductDTO.setUserAccountsAccess(new HashSet(adminProductData.getUserAccounts()));
        adminProductDTO.setSystemPaymentsAsUser(new HashSet(adminProductData.getPaymentsAsUserToSystem()));
        adminProductDTO.setUserPaymentsAsUser(new HashSet(adminProductData.getPaymentsAsUserToUser()));
        if (this.isMutualCredit()) {
            adminProductDTO.setUserBalanceLimit(ViewManageOperation.MANAGE);
        }
        adminProductDTO.setUserAdvertisements(ViewManageOperation.MANAGE);
        adminProductDTO.setUserNotificationSettings(ViewManageOperation.MANAGE);
        adminProductDTO.setUserQuickAccessSettings(ViewManageOperation.MANAGE);
        for (ProductRecordFieldDTO productRecordFieldDTO : adminProductDTO.getUserRecordTypeFields()) {
            productRecordFieldDTO.setView(true);
            productRecordFieldDTO.setCreate(true);
            productRecordFieldDTO.setEdit(true);
            productRecordFieldDTO.setRemove(true);
        }
        adminProductDTO.setNotifications(true);
        HashSet hashSet = new HashSet(adminProductData.getMessageCategories());
        adminProductDTO.setViewMessagesSentToSysWithCat((Set)hashSet);
        adminProductDTO.setManageMessagesSentToSysWithCat(adminProductDTO.getViewMessagesSentToSysWithCat());
        adminProductDTO.setSendMessagesFromSysWithCat(adminProductDTO.getViewMessagesSentToSysWithCat());
        if (CollectionHelper.isNotEmpty((Iterable)hashSet)) {
            adminProductDTO.setSendMessagesToGroups(true);
            adminProductDTO.setMaxMessageRecipients(Integer.valueOf(1));
        }
        adminProductDTO.setSystemImageCategoriesView(new HashSet(adminProductData.getSystemImageCategoriesToView()));
        adminProductDTO.setSystemImageCategoriesManage(new HashSet(adminProductData.getSystemImageCategoriesToManage()));
        if (this.data.isCloneLanguage()) {
            adminProductDTO.setApplicationTranslation(this.vos(LanguageVO.class, this.language));
        }
        adminProductDTO.setApplicationTranslation(new HashSet(adminProductData.getAppTranslationLanguages()));
        adminProductDTO.setSystemAlerts(true);
        adminProductDTO.setUserAlerts(true);
        adminProductDTO.setErrorLog(ViewManageOperation.MANAGE);
        adminProductDTO.setSystemReports(ViewManageOperation.MANAGE);
        this.addUserProfileFieldPermissionsTo((ProductDTO)adminProductDTO);
    }

    private void updateNetworkAdministratorGroup() {
        AdminProductDTO adminProductDTO = (AdminProductDTO)this.productService.load(this.networkAdministratorsGroup.getAdminProduct().getId());
        for (ProductUserAdFieldDTO productUserAdFieldDTO : adminProductDTO.getUserAdFields()) {
            productUserAdFieldDTO.setView(true);
            productUserAdFieldDTO.setManage(true);
        }
        this.save((CRUDServiceLocal)this.productService, (EntityDTO)adminProductDTO);
    }

    private <VO extends EntityVO> Set<VO> vos(Class<VO> clazz, Iterable<?> iterable) {
        return this.conversionHandler.convertSet(clazz, iterable);
    }

    private <VO extends EntityVO> Set<VO> vos(Class<VO> clazz, Object ... objectArray) {
        return this.vos(clazz, Arrays.asList(objectArray));
    }
}

