/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.CurrencyAmountRange;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TransWrapper;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.banking.VoucherTransactionsVisibility;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.ExportHandler;
import org.cyclos.impl.system.InstallmentReportEntry;
import org.cyclos.impl.system.InternalImageServiceLocal;
import org.cyclos.impl.system.PDFReportHandler;
import org.cyclos.impl.system.ReportParams;
import org.cyclos.impl.system.SystemMonitorSnapshot;
import org.cyclos.impl.system.TransactionReportEntry;
import org.cyclos.impl.system.VoucherReportEntry;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.pdf.PdfHandler;
import org.cyclos.impl.utils.pdf.PdfTemplate;
import org.cyclos.impl.utils.pdf.StreamFactory;
import org.cyclos.impl.utils.thymeleaf.ThymeleafWrappers;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.ReportExecutionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransSearchContext;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryQuery;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryVO;
import org.cyclos.model.banking.accounts.ArchivedTransferVO;
import org.cyclos.model.banking.accounts.ArchivingInfoVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.vouchers.VoucherCreationType;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateDTO;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.monitor.JavaRuntimeData;
import org.cyclos.model.system.monitor.RecurringTaskData;
import org.cyclos.model.system.monitor.ServerData;
import org.cyclos.model.system.monitor.ServerDataPropertiesDiff;
import org.cyclos.model.system.monitor.SystemInformationData;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CacheStatsVO;
import org.cyclos.model.utils.FileSizeUnit;
import org.cyclos.model.utils.IDecimalRange;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.banking.TransferServiceSecurity;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.TransformedCloseableIterator;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.Formatter;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thymeleaf.exceptions.TemplateEngineException;

@Component
public class PDFExportHandlerImpl
extends BaseNetworkedHandlerImpl
implements ExportHandler,
PDFReportHandler {
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    @Lazy
    private AccountServiceLocal accountService;
    @Autowired
    @Lazy
    private TransferServiceLocal transferService;
    @Autowired
    @Lazy
    private TransferServiceSecurity transferServiceSecurity;
    @Autowired
    @Lazy
    private TransactionServiceLocal transactionService;
    @Autowired
    @Lazy
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    @Lazy
    private RecurringPaymentServiceLocal recurringPaymentService;
    @Autowired
    @Lazy
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    @Lazy
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    @Lazy
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    @Lazy
    private InternalImageServiceLocal internalImageService;
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;
    @Autowired
    @Lazy
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;
    @Autowired
    private PdfHandler pdfHandler;
    @Autowired
    private ThymeleafWrappers thymeleafWrappers;
    @Autowired
    @Lazy
    private VoucherServiceSecurity voucherServiceSecurity;
    @Autowired
    @Lazy
    private RichTextHandler richTextHandler;
    @Autowired
    private BeanHandler beanHandler;

    public SerializableInputStream export(ExportHandler.ExportParameters exportParameters) {
        SerializableInputStream serializableInputStream = this.doExport(exportParameters);
        if (exportParameters.getEntities() != null && exportParameters.getEntities().isPartialData()) {
            serializableInputStream.setPartialData(true);
        }
        return serializableInputStream;
    }

    public BuiltInExportFormat getBuiltInFormat() {
        return BuiltInExportFormat.PDF;
    }

    public SerializableInputStream previewVoucher(VoucherType voucherType, VoucherTemplateDTO voucherTemplateDTO) {
        VoucherTemplate voucherTemplate = new VoucherTemplate(voucherTemplateDTO.getId());
        this.conversionHandler.fill((Object)voucherTemplateDTO, (Object)voucherTemplate);
        this.detach((IEntity)voucherType);
        voucherType.setTemplate(voucherTemplate);
        VoucherPack voucherPack = new VoucherPack();
        voucherPack.setAmount(new BigDecimal(10));
        voucherPack.setCreationDate(new Date());
        voucherPack.setExpirationDate(new Date(System.currentTimeMillis() + 86400000L));
        voucherPack.setCount(Integer.valueOf(1));
        voucherPack.setType(voucherType);
        Voucher voucher = new Voucher();
        voucher.setPack(voucherPack);
        voucher.setStatus(VoucherStatus.OPEN);
        String string = voucherType.getConfiguration().getMask();
        voucher.setToken(MaskHelper.generateValue((String)string));
        BigDecimal bigDecimal = voucherType.isAllowPartialRedeems() ? voucherPack.getAmount().divide(new BigDecimal(2)) : voucherPack.getAmount();
        voucher.setBalance(bigDecimal);
        ExportHandler.ExportParameters exportParameters = new ExportHandler.ExportParameters(null, ExportFormatContext.VOUCHER_DETAILS, (Object)voucher, null);
        return this.vouchers(exportParameters, Collections.singletonMap(voucherTemplate, CloseableIteratorHelper.singleton((Object)voucher)));
    }

    public SerializableInputStream systemMonitorReport(SystemMonitorSnapshot systemMonitorSnapshot) {
        SystemInformationData systemInformationData = systemMonitorSnapshot.getSystemInformation();
        boolean bl = systemInformationData.getClusterMembers().stream().map(ServerData::getApplicationCommitId).collect(Collectors.toSet()).size() == 1;
        PdfTemplate pdfTemplate = this.pdfHandler.newTemplate("systemMonitor");
        pdfTemplate.title(SystemKeys.Monitor.HEADING, new Object[0]);
        pdfTemplate.bind("monitorFormatter", (Object)new SystemMonitorFormatter((Formatter)this.getFormatter(), this.translationHandler));
        pdfTemplate.bind("serverDataPropsUtility", (Object)new ServerDataPropertiesDiff(systemInformationData.getClusterMembers()));
        if (bl) {
            ServerData serverData = (ServerData)systemInformationData.getClusterMembers().get(0);
            pdfTemplate.bind("cyclosVersion", (Object)serverData.getApplicationVersion()).bind("cyclosRevision", (Object)serverData.getApplicationCommitId());
        }
        pdfTemplate.bind("summaryData", (Object)systemInformationData);
        pdfTemplate.bind("archivingInfo", (Object)systemInformationData.getArchivingInfo());
        pdfTemplate.bind("recurringTasks", (Object)systemMonitorSnapshot.getRecurringTasks());
        pdfTemplate.bind("backgroundTasks", (Object)systemMonitorSnapshot.getBackgroundTasks());
        pdfTemplate.bind("caches", (Object)systemMonitorSnapshot.getCaches());
        pdfTemplate.bind("databaseUpgrades", (Object)systemMonitorSnapshot.getDatabaseUpgrades());
        pdfTemplate.bind("databaseUpgradesWithError", (Object)systemMonitorSnapshot.getDatabaseUpgrades().stream().anyMatch(databaseUpgradeData -> StringHelper.isNotBlank((Object)databaseUpgradeData.getError())));
        pdfTemplate.bind("errorLogs", (Object)systemMonitorSnapshot.getErrorLogs());
        return pdfTemplate.render();
    }

    public SerializableInputStream systemReport(ReportParams reportParams) {
        return this.pdfHandler.newTemplate("systemReport").title(this.getFormatter().format(reportParams.getTitle())).bind("begin", (Object)reportParams.getBegin()).bind("end", (Object)reportParams.getEnd()).bind("sections", (Object)reportParams.getSections()).render();
    }

    private SerializableInputStream accountHistory(ExportHandler.ExportParameters exportParameters) throws FrameworkException {
        Object object;
        Object object2;
        List list;
        List list2;
        AccountHistoryQuery accountHistoryQuery = (AccountHistoryQuery)exportParameters.getQueryParameters();
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        AccountType accountType = account.getType();
        ArrayList arrayList = new ArrayList(accountType.getCustomFieldsForSearch());
        ArrayList arrayList2 = new ArrayList(accountType.getCustomFieldsForList());
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            list2 = this.transactionCustomFieldService.listVisible((AccountOwner)account.getOwner());
            arrayList.retainAll(list2);
            arrayList2.retainAll(list2);
        }
        if ((list2 = this.accountService.getAccountHistoryStatus(account, accountHistoryQuery)) == null) {
            list2 = new AccountHistoryStatusVO();
        }
        User user = account.getOwner() instanceof User ? (User)account.getOwner() : null;
        Object object3 = null;
        TreeMap treeMap = new TreeMap((profileField, profileField2) -> {
            if (profileField == BasicProfileField.FULL_NAME) {
                return -1;
            }
            if (profileField == BasicProfileField.LOGIN_NAME) {
                return profileField2 == BasicProfileField.FULL_NAME ? 1 : -1;
            }
            return ProfileFieldComparator.getInstance().compare(profileField, profileField2);
        });
        if (user != null) {
            list = this.profileFieldHandler.getVisibleProfileFields((BasicUser)user);
            if (list.contains(object2 = (object = this.getConfiguration()).getProfileFieldInAccountTitle())) {
                object3 = this.profileFieldHandler.getFieldValue((BasicUser)user, (ProfileField)object2);
            }
            if (object3 == null) {
                object3 = user;
            }
            FormatterImpl formatterImpl = this.getFormatter();
            Collection collection = CollectionUtils.intersection((Iterable)list, (Iterable)object.getProfileFieldsInAccount());
            collection.forEach(profileField -> {
                Object object = profileField == BasicProfileField.ACCOUNT_NUMBER ? this.accountHandler.getAccountNumber((IAccount)account) : this.profileFieldHandler.getFieldValue((BasicUser)user, profileField);
                if (StringHelper.isNotBlank((Object)formatterImpl.format(object))) {
                    treeMap.put(profileField, object);
                }
            });
        } else {
            object3 = accountType;
        }
        list = (DecimalRange)this.conversionHandler.convert(DecimalRange.class, (Object)accountHistoryQuery.getAmount());
        object = new TreeMap();
        this.conversionHandler.convertList(TransferStatus.class, (Iterable)accountHistoryQuery.getStatuses()).forEach(arg_0 -> PDFExportHandlerImpl.lambda$accountHistory$4((SortedMap)object, arg_0));
        object2 = new HashMap();
        object2.put("transferFilters", CollectionHelper.sort((Collection)this.conversionHandler.convertList(TransferFilter.class, (Iterable)accountHistoryQuery.getTransferFilters())));
        object2.put("description", accountHistoryQuery.getDescription());
        object2.put("direction", accountHistoryQuery.getDirection());
        object2.put("period", this.conversionHandler.convert(DatePeriod.class, (Object)accountHistoryQuery.getPeriod()));
        object2.put("channels", CollectionHelper.sort((Collection)this.conversionHandler.convertList(Channel.class, (Iterable)accountHistoryQuery.getChannels())));
        object2.put("amount", list == null ? null : new CurrencyAmountRange(account.getCurrency(), (IDecimalRange)list));
        object2.put("user", this.conversionHandler.convert(User.class, (Object)accountHistoryQuery.getUser()));
        object2.put("groups", CollectionHelper.sort((Collection)this.conversionHandler.convertList(BasicGroup.class, (Iterable)accountHistoryQuery.getGroups())));
        object2.put("by", this.conversionHandler.convert(BasicUser.class, (Object)accountHistoryQuery.getBy()));
        object2.put("transactionNumber", accountHistoryQuery.getTransactionNumber());
        object2.put("customValues", this.customFieldValueHandler.toSearchFiltersMap(arrayList, (Collection)accountHistoryQuery.getCustomValues(), true));
        object2.put("statusesByFlow", object);
        return this.pdfHandler.newTemplate("account-history").title(BankingKeys.Accounts.HEADING_PRINT_ACCOUNT_HISTORY, new Object[]{object3}).bind("account", (Object)account).bind("number", (Object)this.accountHandler.getAccountNumber((IAccount)account)).bind("statusFlows", (Object)this.accountService.getVisibleFlows(account)).bind("fieldsForList", arrayList2).bind("ownerFields", treeMap).bind("status", (Object)list2).bind("entries", (Object)exportParameters.getEntities()).bind("filters", object2).landscape(accountType.isPrintHistoryLandscape()).render();
    }

    private SerializableInputStream advertisement(ExportHandler.ExportParameters exportParameters) {
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.isGuest();
        BasicAd basicAd = (BasicAd)exportParameters.getEntity();
        this.detach((IEntity)basicAd);
        User user = basicAd.getOwner();
        if (bl && sessionData.getConfiguration().isHideAdPriceToGuests()) {
            basicAd.setPrice(null);
            basicAd.setPromotionalPrice(null);
        }
        if (bl && sessionData.getConfiguration().isHideAdOwnerToGuests()) {
            basicAd.setOwner(null);
        }
        boolean bl2 = sessionData.manages((BasicUser)user);
        CurrencyAmount currencyAmount = basicAd.isPromotionalPeriodActive() && basicAd.getPromotionalPrice() != null ? new CurrencyAmount(basicAd.getCurrency(), basicAd.getPromotionalPrice()) : null;
        SortedMap sortedMap = this.customFieldValueHandler.toValuesMap((Collection)this.adCustomFieldService.listVisibleFieldEnabledToOwner(user), (Collection)basicAd.getCustomValues(), false);
        return this.pdfHandler.newTemplate("ad").title(basicAd.getName()).bind("ad", (Object)basicAd).bind("productNumber", basicAd instanceof AdWebShop ? ((AdWebShop)basicAd).getProductNumber() : null).bind("promotionalPrice", (Object)currencyAmount).bind("manager", (Object)bl2).bind("customValues", (Object)sortedMap).render();
    }

    private SerializableInputStream archivedAccountHistory(ExportHandler.ExportParameters exportParameters) throws FrameworkException {
        ArchivedAccountHistoryQuery archivedAccountHistoryQuery = (ArchivedAccountHistoryQuery)exportParameters.getQueryParameters();
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)archivedAccountHistoryQuery.getAccount());
        AccountType accountType = account.getType();
        List list = this.transactionCustomFieldService.listVisible((AccountOwner)account.getOwner());
        list.retainAll(accountType.getCustomFieldsForList());
        ArchivedAccountHistoryVO archivedAccountHistoryVO = (ArchivedAccountHistoryVO)exportParameters.getAdditionalData("archivedAccountHistory");
        AccountHistoryStatusVO accountHistoryStatusVO = new AccountHistoryStatusVO();
        accountHistoryStatusVO.setBalanceAtBegin(archivedAccountHistoryVO.getBalanceAtBegin());
        accountHistoryStatusVO.setBalanceAtEnd(archivedAccountHistoryVO.getBalanceAtEnd());
        archivedAccountHistoryQuery.setPageSize(Integer.valueOf(this.getSessionData().getConfiguration().getMaxResults()));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("period", this.conversionHandler.convert(DatePeriod.class, (Object)archivedAccountHistoryQuery.getPeriod()));
        return this.pdfHandler.newTemplate("archived-account-history").title(BankingKeys.Accounts.HEADING_ARCHIVE, new Object[0]).bind("account", (Object)account).bind("archived", (Object)archivedAccountHistoryVO).bind("number", (Object)this.accountHandler.getAccountNumber((IAccount)account)).bind("fieldsForList", (Object)list).bind("entries", (Object)archivedAccountHistoryVO.getEntries()).bind("filters", hashMap).bind("fieldsResolver", (Object)new ArchivedHistoryFieldResolver((Formatter)this.getFormatter())).landscape(accountType.isPrintHistoryLandscape()).render();
    }

    private SerializableInputStream archivedTransfer(ExportHandler.ExportParameters exportParameters) {
        ArchivedTransferVO archivedTransferVO = (ArchivedTransferVO)exportParameters.getEntity();
        Function<AccountVO, Object> function = accountVO -> accountVO.getOwner() instanceof UserVO ? accountVO.getOwner() : accountVO.getType();
        return this.pdfHandler.newTemplate("archived-transfer").title(BankingKeys.Accounts.HEADING_ARCHIVED_TRANSFER, new Object[0]).bind("transfer", (Object)archivedTransferVO).bind("from", function.apply(archivedTransferVO.getFrom())).bind("to", function.apply(archivedTransferVO.getTo())).render();
    }

    private SerializableInputStream customOperation(ExportHandler.ExportParameters exportParameters) {
        CustomOperation customOperation = (CustomOperation)exportParameters.getAdditionalData("customOperation");
        Map map = (Map)exportParameters.getAdditionalData("formParameters");
        List list = (List)exportParameters.getAdditionalData("columns");
        TreeMap treeMap = new TreeMap();
        for (CustomOperationField customOperationField : customOperation.getFormParameters()) {
            Object v = map.get(customOperationField.getInternalName());
            if (ObjectHelper.isEmpty(v)) continue;
            treeMap.put(customOperationField, v);
        }
        return this.pdfHandler.newTemplate("custom-operation").title(this.dataTranslationHandler.getName((NamedEntity)customOperation)).bind("operation", (Object)customOperation).bind("columns", (Object)list).bind("rows", (Object)exportParameters.getEntities()).bind("formParameters", treeMap).render();
    }

    private SerializableInputStream doExport(ExportHandler.ExportParameters exportParameters) {
        try {
            switch (exportParameters.getContext()) {
                case TRANSACTIONS_SEARCH: {
                    return this.transactions(exportParameters);
                }
                case INSTALLMENTS_SEARCH: {
                    return this.installments(exportParameters);
                }
                case ACCOUNT_HISTORY: {
                    return this.accountHistory(exportParameters);
                }
                case ARCHIVED_ACCOUNT_HISTORY: {
                    return this.archivedAccountHistory(exportParameters);
                }
                case ARCHIVED_TRANSFER: {
                    return this.archivedTransfer(exportParameters);
                }
                case TRANS_DETAILS: {
                    return this.payment(exportParameters);
                }
                case USERS_SEARCH: {
                    return this.users(exportParameters);
                }
                case ADVERTISEMENT_DETAILS: {
                    return this.advertisement(exportParameters);
                }
                case ORDER_DETAILS: {
                    return this.order(exportParameters);
                }
                case VOUCHERS_SEARCH: 
                case USER_VOUCHERS_SEARCH: {
                    return this.vouchers(exportParameters, (Map)exportParameters.getAdditionalData("vouchersByTemplate"));
                }
                case VOUCHER_DETAILS: {
                    Voucher voucher = (Voucher)exportParameters.getEntity();
                    return this.vouchers(exportParameters, Collections.singletonMap(voucher.getTemplate(), CloseableIteratorHelper.singleton((Object)voucher)));
                }
                case VOUCHER_TRANSACTION_DETAILS: {
                    return this.voucherTransaction(exportParameters);
                }
                case CUSTOM_OPERATION: {
                    return this.customOperation(exportParameters);
                }
            }
            throw new IllegalStateException("Unsupported PDF export: " + String.valueOf(exportParameters.getContext()));
        }
        catch (TemplateEngineException templateEngineException) {
            throw new ReportExecutionException((Throwable)ObjectHelper.defaultValue((Object)templateEngineException.getCause(), (Object)((Object)templateEngineException)));
        }
    }

    private SerializableInputStream doVoucher(VoucherTemplate voucherTemplate, CloseableIterator<Voucher> closeableIterator, List<VoucherCustomField> list) {
        Pair pair = CloseableIteratorHelper.peekFirst(closeableIterator);
        if (pair.getFirst() == null) {
            return null;
        }
        closeableIterator = (CloseableIterator)pair.getSecond();
        TransformedCloseableIterator transformedCloseableIterator = new TransformedCloseableIterator((Iterator)closeableIterator, voucher -> {
            SortedMap sortedMap = this.customFieldValueHandler.toValuesMap((Collection)list, (Collection)voucher.getPack().getCustomValues(), false);
            SortedMap sortedMap2 = this.customFieldValueHandler.toValuesMap((Collection)list, (Collection)voucher.getCustomValues(), false);
            return new VoucherReportEntry((Voucher)voucher, sortedMap, sortedMap2);
        });
        PdfTemplate pdfTemplate = this.pdfHandler.newTemplate(voucherTemplate.getContent(), voucherTemplate.getStyle()).bind("entries", (Object)transformedCloseableIterator).bind("configuration", (Object)this.getConfiguration()).bindAll(this.richTextHandler.runContentHelperScript((HasContentScript)voucherTemplate, null, null)).noHeader().noFooter();
        if (voucherTemplate.isPersistent()) {
            pdfTemplate.streamFactory(new StreamFactory("templateimage", string -> this.internalImageService.readVoucherTemplateImage(voucherTemplate.getId(), string)));
        }
        try {
            return pdfTemplate.render();
        }
        catch (TemplateEngineException templateEngineException) {
            CyclosException cyclosException = (CyclosException)ExceptionHelper.findCause((Throwable)templateEngineException, CyclosException.class);
            throw cyclosException != null ? cyclosException : templateEngineException;
        }
    }

    private SerializableInputStream installments(ExportHandler.ExportParameters exportParameters) {
        InstallmentQuery installmentQuery = (InstallmentQuery)exportParameters.getQueryParameters();
        InternalAccountOwner internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)installmentQuery.getOwner(), true).getInternalAccountOwner();
        boolean bl = Boolean.TRUE.equals(installmentQuery.getAuthorized());
        List list = this.transactionCustomFieldService.listVisible((AccountOwner)internalAccountOwner);
        TransSearchContext transSearchContext = internalAccountOwner instanceof SystemAccountOwner ? TransSearchContext.SYSTEM_INSTALLMENTS : TransSearchContext.USER_INSTALLMENTS;
        List list2 = list.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInSearch().contains(transSearchContext)).collect(Collectors.toList());
        List list3 = list.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInList().contains(transSearchContext)).collect(Collectors.toList());
        DataIterator dataIterator = exportParameters.getEntities();
        TransformedCloseableIterator transformedCloseableIterator = new TransformedCloseableIterator((Iterator)dataIterator, installment -> new InstallmentReportEntry(bl, (AccountOwner)internalAccountOwner, (Installment)installment));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(CollectionHelper.sort((Collection)installmentQuery.getAuthorizationStatuses()));
        arrayList.remove(TransactionAuthorizationStatus.NA);
        arrayList.addAll(CollectionHelper.sort((Collection)installmentQuery.getStatuses()));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (internalAccountOwner instanceof User) {
            hashMap.put("owner", internalAccountOwner);
        }
        hashMap.put("direction", installmentQuery.getDirection());
        hashMap.put("period", this.conversionHandler.convert(DatePeriod.class, (Object)installmentQuery.getPeriod()));
        hashMap.put("statuses", arrayList);
        hashMap.put("user", this.conversionHandler.convert(User.class, (Object)installmentQuery.getUser()));
        hashMap.put("accountTypes", this.conversionHandler.convertList(AccountType.class, (Iterable)installmentQuery.getAccountTypes()));
        hashMap.put("transactionNumber", installmentQuery.getTransactionNumber());
        hashMap.put("customValues", this.customFieldValueHandler.toSearchFiltersMap(list2, (Collection)installmentQuery.getCustomValues(), true));
        return this.pdfHandler.newTemplate("installments").title(BankingKeys.Transactions.SCHEDULED_PAYMENTS_SEARCH_HEADING, new Object[0]).bind("entries", (Object)transformedCloseableIterator).bind("authorized", (Object)bl).bind("hasStatus", (Object)(CollectionHelper.size(arrayList) != 1 ? 1 : 0)).bind("filters", hashMap).bind("fieldsForList", list3).render();
    }

    private SerializableInputStream order(ExportHandler.ExportParameters exportParameters) {
        return this.pdfHandler.newTemplate("order").title(MarketplaceKeys.WebshopOrders.HEADING_DETAILS, new Object[0]).bind("order", exportParameters.getEntity()).render();
    }

    private SerializableInputStream payment(ExportHandler.ExportParameters exportParameters) {
        MessageKey messageKey;
        Transfer transfer;
        if (exportParameters.getEntity() instanceof Transfer) {
            transfer = (Transfer)exportParameters.getEntity();
            messageKey = BankingKeys.Transfers.HEADING_DETAILS;
        } else {
            transfer = (Transaction)exportParameters.getEntity();
            messageKey = transfer instanceof RecurringPayment ? BankingKeys.Transactions.RECURRING_PAYMENT_DETAILS_HEADING : (transfer instanceof ScheduledPayment ? BankingKeys.Transactions.SCHEDULED_PAYMENT_DETAILS_HEADING : (transfer instanceof ExternalPayment ? BankingKeys.Transactions.EXTERNAL_PAYMENT_HEADING_DETAILS : (transfer instanceof PaymentRequest ? BankingKeys.Transactions.PAYMENT_REQUEST_HEADING_DETAILS : (transfer instanceof Ticket ? BankingKeys.Transactions.TICKET_HEADING_DETAILS : BankingKeys.Transactions.DETAILS_HEADING))));
        }
        return this.trans(messageKey, (Trans)transfer);
    }

    private SerializableInputStream trans(MessageKey messageKey, Trans trans) throws FrameworkException {
        TransWrapper transWrapper = this.wrap(trans);
        TransWrapper transWrapper2 = this.wrap((Trans)transWrapper.getParentTransfer());
        List list = CollectionHelper.orEmpty((List)transWrapper.getChildTransfers()).stream().map(this.thymeleafWrappers::wrap).collect(Collectors.toList());
        TreeSet treeSet = new TreeSet(this.transactionCustomFieldService.listVisible((AccountOwner)trans.getFromOwner()));
        treeSet.addAll(this.transactionCustomFieldService.listVisible(trans.getToOwner()));
        if (transWrapper2 != null) {
            treeSet.addAll(this.transactionCustomFieldService.listVisible((AccountOwner)transWrapper2.getFromOwner()));
            treeSet.addAll(this.transactionCustomFieldService.listVisible(transWrapper2.getToOwner()));
        }
        List list2 = null;
        if (trans instanceof TransactionWithInstallments) {
            list2 = ((TransactionWithInstallments)trans).getInstallments();
        }
        List list3 = transWrapper.getBoughtVouchers();
        CollectionHelper.orEmpty((List)list3).forEach(voucherVO -> {
            CurrencyVO currencyVO = voucherVO.getPack().getType().getConfiguration().getCurrency();
            BigDecimal bigDecimal = (BigDecimal)ObjectHelper.defaultValue((Object)voucherVO.getAmount(), (Object)voucherVO.getPack().getAmount());
            voucherVO.setAttribute("amount", bigDecimal == null ? null : ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)bigDecimal));
            voucherVO.setAttribute("balance", (Object)ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)voucherVO.getBalance()));
        });
        boolean bl = CollectionHelper.size((Collection)list3) == 1;
        return this.pdfHandler.newTemplate("trans").title(messageKey, new Object[0]).bind("trans", (Object)transWrapper).bind("parent", (Object)transWrapper2).bind("children", list).bind("customValues", (Object)this.customFieldValueHandler.toValuesMap(treeSet, (Collection)trans.getCustomValues(), false)).bind("installments", (Object)list2).bind("isVoucherSent", (Object)(bl && ((VoucherVO)CollectionHelper.first((Iterable)list3)).getPack().getCreationType() == VoucherCreationType.SENT ? 1 : 0)).bind("boughtVoucher", bl ? CollectionHelper.first((Iterable)list3) : null).bind("boughtVouchers", (Object)(CollectionHelper.size((Collection)list3) > 1 ? list3 : null)).render();
    }

    private SerializableInputStream transactions(ExportHandler.ExportParameters exportParameters) {
        TransactionQuery transactionQuery = (TransactionQuery)exportParameters.getQueryParameters();
        InternalAccountOwner internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)transactionQuery.getOwner(), true).getInternalAccountOwner();
        Set set = CollectionHelper.orEmpty((Set)transactionQuery.getNatures());
        boolean bl = Boolean.TRUE.equals(transactionQuery.getAuthorized());
        boolean bl2 = bl || set.isEmpty() || set.stream().anyMatch(TransactionNature::hasStatus);
        boolean bl3 = set.isEmpty() || set.contains(TransactionNature.SCHEDULED_PAYMENT);
        boolean bl4 = set.isEmpty() || set.contains(TransactionNature.RECURRING_PAYMENT);
        List list = this.transactionCustomFieldService.listVisible((AccountOwner)internalAccountOwner);
        TransSearchContext transSearchContext = internalAccountOwner instanceof SystemAccountOwner ? TransSearchContext.SYSTEM_TRANSACTIONS : TransSearchContext.USER_TRANSACTIONS;
        List list2 = list.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInSearch().contains(transSearchContext)).collect(Collectors.toList());
        List list3 = list.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInList().contains(transSearchContext)).collect(Collectors.toList());
        MessageKey messageKey = BankingKeys.Transactions.SEARCH_HEADING;
        MessageKey messageKey2 = BankingKeys.Accounts.FROM_OR_TO;
        if (set.size() == 1) {
            switch ((TransactionNature)CollectionHelper.first((Iterable)set)) {
                case EXTERNAL_PAYMENT: {
                    messageKey = BankingKeys.Transactions.EXTERNAL_PAYMENT_HEADING_SEARCH;
                    messageKey2 = BankingKeys.Transactions.TO_PRINCIPAL_VALUE;
                    break;
                }
                case PAYMENT_REQUEST: {
                    messageKey = BankingKeys.Transactions.PAYMENT_REQUEST_HEADING_SEARCH;
                    break;
                }
                case RECURRING_PAYMENT: 
                case SCHEDULED_PAYMENT: {
                    messageKey = BankingKeys.Transactions.SCHEDULED_PAYMENTS_SEARCH_HEADING;
                    break;
                }
                case TICKET: {
                    messageKey = BankingKeys.Transactions.TICKET_HEADING_SEARCH;
                    messageKey2 = BankingKeys.Accounts.FROM;
                    break;
                }
            }
        } else if (set.size() == 2 && set.contains(TransactionNature.RECURRING_PAYMENT) && set.contains(TransactionNature.SCHEDULED_PAYMENT)) {
            messageKey = BankingKeys.Transactions.SCHEDULED_PAYMENTS_SEARCH_HEADING;
        }
        DataIterator dataIterator = exportParameters.getEntities();
        TransformedCloseableIterator transformedCloseableIterator = new TransformedCloseableIterator((Iterator)dataIterator, transaction -> new TransactionReportEntry(bl, (AccountOwner)internalAccountOwner, (Transaction)transaction));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(CollectionHelper.sort((Collection)transactionQuery.getAuthorizationStatuses()));
        arrayList.remove(TransactionAuthorizationStatus.NA);
        arrayList.addAll(CollectionHelper.sort((Collection)transactionQuery.getScheduledPaymentStatuses()));
        arrayList.addAll(CollectionHelper.sort((Collection)transactionQuery.getRecurringPaymentStatuses()));
        arrayList.addAll(CollectionHelper.sort((Collection)transactionQuery.getExternalPaymentStatuses()));
        arrayList.addAll(CollectionHelper.sort((Collection)transactionQuery.getPaymentRequestStatuses()));
        arrayList.addAll(CollectionHelper.sort((Collection)transactionQuery.getTicketStatuses()));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (internalAccountOwner instanceof User) {
            hashMap.put("owner", internalAccountOwner);
        }
        hashMap.put("direction", transactionQuery.getDirection());
        hashMap.put("period", this.conversionHandler.convert(DatePeriod.class, (Object)transactionQuery.getPeriod()));
        hashMap.put("statuses", arrayList);
        hashMap.put("user", this.conversionHandler.convert(User.class, (Object)transactionQuery.getUser()));
        hashMap.put("accountTypes", this.conversionHandler.convertList(AccountType.class, (Iterable)transactionQuery.getAccountTypes()));
        hashMap.put("transactionNumber", transactionQuery.getTransactionNumber());
        hashMap.put("customValues", this.customFieldValueHandler.toSearchFiltersMap(list2, (Collection)transactionQuery.getCustomValues(), true));
        return this.pdfHandler.newTemplate("transactions").title(messageKey, new Object[0]).bind("entries", (Object)transformedCloseableIterator).bind("related", (Object)messageKey2).bind("authorized", (Object)bl).bind("hasStatus", (Object)bl2).bind("hasScheduling", (Object)(bl3 || bl4 ? 1 : 0)).bind("filters", hashMap).bind("fieldsForList", list3).render();
    }

    private SerializableInputStream users(ExportHandler.ExportParameters exportParameters) {
        UserQuery userQuery = (UserQuery)exportParameters.getQueryParameters();
        Set set = this.conversionHandler.convertSet(User.class, (Iterable)userQuery.getBrokers());
        boolean bl = set.size() == 1 && set.contains(this.getLoggedUser());
        ProfileFieldSearchContext profileFieldSearchContext = userQuery.isMapDirectory() ? ProfileFieldSearchContext.MAP_DIRECTORY_FILTER : ProfileFieldSearchContext.USER_FILTER;
        List list = this.profileFieldHandler.getSearchFilters(profileFieldSearchContext, bl, null);
        List list2 = this.profileFieldHandler.getFieldsInUserList(bl);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("keywords", userQuery.getKeywords());
        hashMap.put("groups", CollectionHelper.sort((Collection)this.conversionHandler.convertList(BasicGroup.class, (Iterable)userQuery.getGroups())));
        hashMap.put("profileFields", this.profileFieldHandler.toSearchFiltersMap(list, (Collection)userQuery.getProfileFields(), true));
        return this.pdfHandler.newTemplate("users").title(UsersKeys.Users.PRINT_HEADING, new Object[0]).bind("users", (Object)exportParameters.getEntities()).bind("profileFieldsInList", (Object)list2).bind("filters", hashMap).render();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SerializableInputStream vouchers(ExportHandler.ExportParameters exportParameters, Map<VoucherTemplate, CloseableIterator<Voucher>> map) {
        SerializableInputStream serializableInputStream;
        List list = this.voucherCustomFieldService.listVisible(null);
        ArrayList<SerializableInputStream> arrayList = new ArrayList<SerializableInputStream>(map.size());
        try {
            for (Map.Entry<VoucherTemplate, CloseableIterator<Voucher>> pDFMergerUtility : map.entrySet()) {
                serializableInputStream = this.doVoucher(pDFMergerUtility.getKey(), pDFMergerUtility.getValue(), list);
                if (serializableInputStream == null) continue;
                arrayList.add(serializableInputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            arrayList.forEach(IOUtils::closeQuietly);
            throw runtimeException;
        }
        if (arrayList.isEmpty()) {
            throw new ValidationException(this.message(BankingKeys.Vouchers.ERROR_NO_PRINTABLE_VOUCHERS, new Object[0]));
        }
        if (arrayList.size() == 1) {
            return (SerializableInputStream)CollectionHelper.first(arrayList);
        }
        try {
            File file = this.cyclosProperties.newTempFile("vouchers-", ".pdf");
            try {
                PDFMergerUtility runtimeException = new PDFMergerUtility();
                runtimeException.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
                arrayList.forEach(arg_0 -> ((PDFMergerUtility)runtimeException).addSource(arg_0));
                runtimeException.setDestinationFileName(file.getAbsolutePath());
                runtimeException.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
                serializableInputStream = new SerializableInputStream(file);
                return serializableInputStream;
            }
            catch (RuntimeException runtimeException) {
                if (!file.exists()) throw runtimeException;
                file.delete();
                throw runtimeException;
            }
            finally {
                arrayList.forEach(IOUtils::closeQuietly);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private SerializableInputStream voucherTransaction(ExportHandler.ExportParameters exportParameters) {
        VoucherTransactionsVisibility voucherTransactionsVisibility;
        VoucherTransaction voucherTransaction = (VoucherTransaction)exportParameters.getEntity();
        Voucher voucher = voucherTransaction.getVoucher();
        String string = this.voucherService.formatToken(voucher);
        InternalTransaction internalTransaction = voucherTransaction.getTransaction();
        if (internalTransaction != null && !this.entityManagerHandler.isAccessible((IEntity)internalTransaction)) {
            internalTransaction = null;
        }
        if ((voucherTransactionsVisibility = this.voucherServiceSecurity.getTransactionVisibility(voucher)) == VoucherTransactionsVisibility.NONE) {
            throw new EntityNotFoundException(VoucherTransaction.class, voucherTransaction.getId());
        }
        return this.pdfHandler.newTemplate("voucher-transaction").title(voucherTransaction.getNature().getHeadingKey(), new Object[0]).bind("voucherTransaction", (Object)voucherTransaction).bind("transaction", (Object)internalTransaction).bind("payment", (Object)internalTransaction).bind("partial", (Object)(voucherTransactionsVisibility == VoucherTransactionsVisibility.PARTIAL ? 1 : 0)).bind("token", (Object)string).render();
    }

    private TransWrapper wrap(Trans trans) {
        if (trans == null) {
            return null;
        }
        return (TransWrapper)this.beanHandler.autowireWithArgs(TransWrapper.class, new Object[]{trans});
    }

    private static /* synthetic */ void lambda$accountHistory$4(SortedMap sortedMap, TransferStatus transferStatus) {
        sortedMap.computeIfAbsent(transferStatus.getFlow(), transferStatusFlow -> new TreeSet()).add(transferStatus);
    }

    public static class SystemMonitorFormatter {
        private Formatter formatter;
        private TranslationHandler translationHandler;

        public SystemMonitorFormatter(Formatter formatter, TranslationHandler translationHandler) {
            this.formatter = formatter;
            this.translationHandler = translationHandler;
        }

        public String formatBackgroundTasks(SystemInformationData systemInformationData) {
            boolean bl = systemInformationData.getRunningBackgroundTasks() + systemInformationData.getBackgroundTasksQueueSize() + systemInformationData.getScheduledBackgroundTasks() == 0;
            String string = bl ? this.message(SystemKeys.Monitor.SUMMARY_BACKGROUND_TASKS_VALUE_NO_TASKS, new Object[0]) : this.message(SystemKeys.Monitor.SUMMARY_BACKGROUND_TASKS_VALUE, systemInformationData.getRunningBackgroundTasks(), SystemKeys.Monitor.BACKGROUND_TASK_RUNNING, systemInformationData.getBackgroundTasksQueueSize(), SystemKeys.Monitor.BACKGROUND_TASK_ENQUEUED, systemInformationData.getScheduledBackgroundTasks());
            return string;
        }

        public String formatBakgroundTasksQueueCapacity(SystemInformationData systemInformationData) {
            int n = systemInformationData.getBackgroundTasksQueueSize();
            int n2 = systemInformationData.getBackgroundTasksQueueCapacity();
            return this.message(SystemKeys.Monitor.SUMMARY_BACKGROUND_TASKS_QUEUE_VALUE, n2, this.formatter.formatPercentage(Integer.valueOf(Math.max(0, n2 - n)), Integer.valueOf(n2)));
        }

        public String formatCacheHitRate(CacheStatsVO cacheStatsVO) {
            return Long.parseLong(cacheStatsVO.getRequestCount()) == 0L ? this.message(SystemKeys.Monitor.CACHE_HIT_RATE_NOT_APPLICABLE, new Object[0]) : this.formatter.formatPercentage(Double.valueOf(cacheStatsVO.getHitRate()), 2);
        }

        public String formatConnectedUsers(SystemInformationData systemInformationData) {
            Map map = systemInformationData.getConnectedUsers();
            Integer n = (Integer)map.get(Role.ADMIN);
            Integer n2 = (Integer)map.get(Role.BROKER);
            Integer n3 = (Integer)map.get(Role.MEMBER);
            Integer n4 = (Integer)map.get(Role.OPERATOR);
            return this.message(SystemKeys.Monitor.SUMMARY_CONNECTED_USERS_INFO, n, n2, n3, n4);
        }

        public String formatCpuLoadAverage(ServerData serverData) {
            return this.formatter.formatPercentage(Double.valueOf(serverData.getCpuLoadAverage() / 100.0));
        }

        public String formatCyclosArchivingDate(ArchivingInfoVO archivingInfoVO) {
            DateTime dateTime = archivingInfoVO.getCyclosArchivingDate();
            if (dateTime == null) {
                return this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_CYCLOS_ARCHIVING_DATE_NEVER, SystemKeys.Monitor.TAB_RECURRING_TASKS, SystemKeys.RecurringTasks.ARCHIVING);
            }
            Object object = this.formatter.format((IDate)dateTime);
            if (!archivingInfoVO.isCyclosArchivingFinished()) {
                object = (String)object + " " + this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_CYCLOS_ARCHIVING_DATE_RUNNING, SystemKeys.RecurringTasks.ARCHIVING);
            }
            return object;
        }

        public String formatDatabase(SystemInformationData systemInformationData) {
            Object object = this.message(SystemKeys.Monitor.SUMMARY_DATABASE_TEMPLATE, systemInformationData.getDatabaseName(), systemInformationData.getDatabaseVersion());
            if (StringHelper.isNotBlank((Object)systemInformationData.getRunningDbVacuumStartDate())) {
                object = (String)object + " " + this.message(SystemKeys.Monitor.VACUUM_DATABASE_RUNNING, systemInformationData.getRunningDbVacuumStartDate());
            }
            return object;
        }

        public String formatExternalArchivingStatus(ArchivingInfoVO archivingInfoVO) {
            DateTime dateTime = archivingInfoVO.getCyclosArchivingDate();
            DateTime dateTime2 = archivingInfoVO.getExternalArchivingDate();
            if (archivingInfoVO.isExternalArchivingRunning()) {
                return this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_EXTERNAL_STATUS_RUNNING, new Object[0]);
            }
            if (dateTime2 == null) {
                return this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_EXTERNAL_STATUS_NEVER, new Object[0]);
            }
            if (dateTime.equals((Object)dateTime2)) {
                return this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_EXTERNAL_STATUS_IN_SYNC, new Object[0]);
            }
            return this.message(SystemKeys.Monitor.SUMMARY_ARCHIVING_EXTERNAL_STATUS_DELAYED, dateTime2);
        }

        public String formatJvmMemory(JavaRuntimeData javaRuntimeData) {
            String string = javaRuntimeData.getAvailableMemoryInBytes();
            String string2 = javaRuntimeData.getTotalMemoryInBytes();
            if (!StringHelper.isBlank((Object)javaRuntimeData.getMaxMemoryInBytes())) {
                long l = Long.parseLong(javaRuntimeData.getMaxMemoryInBytes()) - Long.parseLong(javaRuntimeData.getUsedMemoryInBytes());
                string = String.valueOf(l);
                string2 = javaRuntimeData.getMaxMemoryInBytes();
            }
            return this.formatMem(string, string2, javaRuntimeData.getUsedMemoryInBytes());
        }

        public String formatLastBalanceClosing(SystemInformationData systemInformationData) {
            String string = StringHelper.isNotBlank((Object)systemInformationData.getBalanceRebuildRunner()) ? (systemInformationData.isClustering() ? this.message(SystemKeys.Monitor.REBUILD_BALANCES_RUNNING_CLUSTER, systemInformationData.getBalanceRebuildRunner(), systemInformationData.getRunningBalanceRebuildStartDate()) : this.message(SystemKeys.Monitor.REBUILD_BALANCES_RUNNING_SINGLE, systemInformationData.getRunningBalanceRebuildStartDate())) : (systemInformationData.getLastBalanceClosingDate() == null ? this.message(SystemKeys.Monitor.SUMMARY_LAST_BALANCES_CLOSING_DATE_NEVER_RUN, new Object[0]) : this.formatter.format((IDate)systemInformationData.getLastBalanceClosingDate()));
            return string;
        }

        public String formatPhysicalMem(ServerData serverData) {
            return this.formatMem(serverData.getAvailablePhysicalMemory(), serverData.getTotalPhysicalMemory(), null);
        }

        public String formatRecurringTaskLastExecution(RecurringTaskData recurringTaskData) {
            if (recurringTaskData.getLastStartDate() != null) {
                String string = StringHelper.isBlank((Object)recurringTaskData.getElapsedTime()) ? "" : this.formatter.formatDuration(Long.valueOf(Long.parseLong(recurringTaskData.getElapsedTime())));
                String string2 = this.formatter.format((IDate)recurringTaskData.getLastStartDate());
                return string2 + (String)(StringHelper.isBlank((Object)recurringTaskData.getElapsedTime()) ? "" : " " + this.message(SystemKeys.Monitor.RECURRING_TASK_TOOK, string));
            }
            return this.message(SystemKeys.Monitor.TASK_NEVER_RAN, new Object[0]);
        }

        public String formatRecurringTaskNextExecution(boolean bl, RecurringTaskData recurringTaskData) {
            if (recurringTaskData.getRunningBy() != null) {
                return bl ? this.message(SystemKeys.Monitor.RECURRING_TASK_RUNNING_CLUSTER, recurringTaskData.getRunningBy(), recurringTaskData.getRunningSince()) : this.message(SystemKeys.Monitor.RECURRING_TASK_RUNNING_SINGLE, recurringTaskData.getRunningSince());
            }
            if (recurringTaskData.getNextExecution() != null) {
                return this.formatter.format((IDate)recurringTaskData.getNextExecution());
            }
            return this.message(SystemKeys.Monitor.RECURRING_TASK_SCHEDULING_IN_PROCESS, new Object[0]);
        }

        public String formatStackTrace(String string, int n) {
            return StringUtils.join((Object[])this.getStackFrames(string, n), (String)System.lineSeparator());
        }

        public String formatTomcatVersion(ServerData serverData) {
            return StringHelper.isBlank((Object)serverData.getWebServer()) ? this.message(SystemKeys.Monitor.SUMMARY_UNKNOWN, new Object[0]) : serverData.getWebServer();
        }

        public String formatUptime(ServerData serverData) {
            long l = Long.parseLong(serverData.getUptimeInMillis());
            DateTime dateTime = serverData.getUpSince();
            return this.message(SystemKeys.Monitor.SUMMARY_SERVER_UPTIME_TEMPLATE, this.formatter.formatDuration(Long.valueOf(l)), dateTime);
        }

        private String formatMem(String string, String string2, String string3) {
            long l = Long.parseLong(string);
            long l2 = Long.parseLong(string2);
            long l3 = string3 != null ? Long.parseLong(string3) : l2 - l;
            return this.message(SystemKeys.Monitor.SUMMARY_SERVER_MEMORY_TEMPLATE, this.formatMemorySize(l3), this.formatMemorySize(l2), this.formatter.formatPercentage(Double.valueOf((double)l / (double)l2), 2));
        }

        private String formatMemorySize(long l) {
            Pair pair = FileSizeUnit.nearestFileSize((long)l, (boolean)false);
            return this.formatter.format((Number)pair.getFirst(), (FileSizeUnit)pair.getSecond());
        }

        private String[] getStackFrames(String string, int n) {
            int n2 = 0;
            String string2 = System.lineSeparator();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (StringHelper.isBlank((Object)string3)) continue;
                boolean bl2 = string3.toLowerCase().contains("caused by");
                if (arrayList.isEmpty() || bl2 || n2 < n) {
                    arrayList.add(string3);
                    bl = true;
                } else if (bl) {
                    arrayList.add("\tsome frames were suppressed");
                    bl = false;
                }
                if (bl2) {
                    n2 = 0;
                    continue;
                }
                if (!string3.trim().startsWith("at ")) continue;
                ++n2;
            }
            return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }

        private String message(MessageKey messageKey, Object ... objectArray) {
            return this.translationHandler.message(messageKey, objectArray);
        }
    }

    public static class ArchivedHistoryFieldResolver {
        private Formatter formatter;

        public ArchivedHistoryFieldResolver(Formatter formatter) {
            this.formatter = formatter;
        }

        public String findValue(TransactionCustomField transactionCustomField, Collection<CustomFieldValueVO> collection) {
            return this.formatter.format(CustomFieldHelper.findValue((ICustomField)transactionCustomField, collection));
        }
    }
}

