/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.PaymentImportedFile;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.system.BankingImportHandlerImpl;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.imports.BankingImportedFileDTO;
import org.cyclos.model.system.imports.BankingImportedFileData;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.PaymentImportedFileDTO;
import org.cyclos.model.system.imports.PaymentImportedFileData;
import org.cyclos.model.system.imports.TransactionImportField;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentImportHandlerImpl
extends BankingImportHandlerImpl<PaymentImportedFile, Payment> {
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    PaymentImportHandlerImpl() {
        super(EnumSet.complementOf(EnumSet.of(TransactionImportField.DATE)).toArray(new ImportField[0]));
    }

    public BankingImportedFileData getData(PaymentImportedFile paymentImportedFile) {
        PaymentImportedFileData paymentImportedFileData = new PaymentImportedFileData();
        paymentImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(PaymentImportedFileDTO.class, (Object)paymentImportedFile)));
        return paymentImportedFileData;
    }

    public Class<Payment> getEntityClass() {
        return Payment.class;
    }

    public Class<PaymentImportedFile> getImportedFileClass() {
        return PaymentImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.PAYMENTS_IMPORT;
    }

    public PaymentImportedFile newImportedFile(BankingImportedFileDTO bankingImportedFileDTO) {
        PaymentImportedFile paymentImportedFile = new PaymentImportedFile();
        paymentImportedFile.setSendNotifications(((PaymentImportedFileDTO)bankingImportedFileDTO).isSendNotifications());
        return paymentImportedFile;
    }

    public Payment processImportedLine(ImportedLine importedLine, Object object) {
        PerformPaymentDTO performPaymentDTO = this.convertToDTO(importedLine);
        this.transactionServiceSecurity.check((PerformInternalTransactionDTO)performPaymentDTO);
        PaymentImportedFile paymentImportedFile = (PaymentImportedFile)importedLine.getImportedFile();
        return this.paymentService.importPayment(performPaymentDTO, paymentImportedFile.isSendNotifications());
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) throws ValidationException {
        PerformPaymentDTO performPaymentDTO = this.convertToDTO(importedLine);
        this.transactionServiceSecurity.check((PerformInternalTransactionDTO)performPaymentDTO);
        this.paymentService.preview(performPaymentDTO);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(PaymentImportedFile paymentImportedFile) {
        return Arrays.asList(TransactionImportField.FROM, TransactionImportField.TO, TransactionImportField.AMOUNT, TransactionImportField.TYPE);
    }

    private PerformPaymentDTO convertToDTO(ImportedLine importedLine) {
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        InternalAccountOwner internalAccountOwner = this.parseAccountOwner(importedLine.getValue((ImportField)TransactionImportField.FROM));
        InternalAccountOwner internalAccountOwner2 = this.parseAccountOwner(importedLine.getValue((ImportField)TransactionImportField.TO));
        String string = importedLine.getValue((ImportField)TransactionImportField.FROM_NAME);
        String string2 = importedLine.getValue((ImportField)TransactionImportField.TO_NAME);
        TransferType transferType = this.parseTransferType(importedLine.getValue((ImportField)TransactionImportField.TYPE));
        if (transferType != null) {
            performPaymentDTO.setType(new TransferTypeVO(transferType.getId()));
            String string3 = importedLine.getValue((ImportField)TransactionImportField.AMOUNT);
            CurrencyAmountDTO currencyAmountDTO = this.parseAmount(string3, transferType.getCurrency());
            if (currencyAmountDTO != null) {
                performPaymentDTO.setAmount(currencyAmountDTO.getAmount());
            }
        }
        performPaymentDTO.setOwner(internalAccountOwner);
        performPaymentDTO.setSubject(internalAccountOwner2);
        performPaymentDTO.setDescription(importedLine.getValue((ImportField)TransactionImportField.DESCRIPTION));
        performPaymentDTO.setFromName(string);
        performPaymentDTO.setToName(string2);
        this.setCustomFieldValues(importedLine, performPaymentDTO);
        return performPaymentDTO;
    }
}

