/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.entities.system.ProfilingSession;
import org.cyclos.entities.system.QProfilingSession;
import org.cyclos.impl.AbstractNetworkedServerComponent;
import org.cyclos.impl.AbstractServerComponent;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandlerImpl;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.ConfigurationHandlerImpl;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockHandlerImpl;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.sql.CachingPreparedStatement;
import org.cyclos.impl.sql.ProfilingPreparedStatement;
import org.cyclos.impl.sql.ProfilingStatement;
import org.cyclos.impl.system.ConfigurationAccessorInvocationHandlerImpl;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ProfilingElement;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEntryType;
import org.cyclos.impl.system.ProfilingMeta;
import org.cyclos.impl.system.ProfilingScriptStartEvent;
import org.cyclos.impl.system.ProfilingServiceLocal;
import org.cyclos.impl.system.ProfilingTransactionStartEvent;
import org.cyclos.impl.system.ServiceInterceptorServiceLocal;
import org.cyclos.impl.users.ProductsAccessorInvocationHandlerImpl;
import org.cyclos.impl.users.ProductsHandlerImpl;
import org.cyclos.impl.users.productresolvers.ProductsResolver;
import org.cyclos.impl.utils.cache.AbstractCache;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.ClusterHostProfilingResult;
import org.cyclos.impl.utils.cluster.ClusterHostProfilingStats;
import org.cyclos.impl.utils.cluster.ClusterProfilingStats;
import org.cyclos.impl.utils.cluster.ClusterStopProfilingResult;
import org.cyclos.impl.utils.cluster.ProfilingManager;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.transaction.TransactionHandlerImpl;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.profiling.ProfilingData;
import org.cyclos.model.system.profiling.ProfilingSessionVO;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.access.InvocationData;
import org.cyclos.services.access.StatefulUserInvocationData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.SkipServiceLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfilingServiceImpl
extends BaseServiceImpl
implements ProfilingServiceLocal {
    private static final LockKey LOCK_KEY = LockType.PROFILING.key((String)null);
    private static final QProfilingSession $ = QProfilingSession.profilingSession;
    @Autowired
    private ServiceInterceptorServiceLocal serviceInterceptorService;
    @Autowired
    private ClusterHandler clusterHandler;
    @Autowired
    private ProfilingManager profilingManager;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public boolean collect(ProfilingEntry profilingEntry, Throwable throwable) {
        StartProfilingParams startProfilingParams = this.profilingManager.getStartParams();
        if (startProfilingParams == null || profilingEntry == null) {
            return false;
        }
        if (startProfilingParams.isWithScriptsOnly()) {
            if (!CollectionHelper.orEmpty((List)profilingEntry.getEvents()).stream().anyMatch(ProfilingScriptStartEvent.class::isInstance)) {
                return false;
            }
        }
        if (startProfilingParams.isSkipReadOnlyTransactions() && !CollectionHelper.orEmpty((List)profilingEntry.getEvents()).stream().anyMatch(profilingEvent -> profilingEvent instanceof ProfilingTransactionStartEvent && ((ProfilingTransactionStartEvent)profilingEvent).getLevel() == TransactionLevel.READ_WRITE)) {
            return false;
        }
        profilingEntry.end();
        if (throwable != null) {
            profilingEntry.setErrorTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        this.profilingManager.collect(profilingEntry);
        return true;
    }

    public ProfilingSessionVO getCurrent() throws FrameworkException {
        this.lockHandler.lock(LOCK_KEY);
        ClusterProfilingStats clusterProfilingStats = this.profilingManager.current();
        if (clusterProfilingStats == null) {
            return null;
        }
        StartProfilingParams startProfilingParams = clusterProfilingStats.getParams();
        ProfilingSessionVO profilingSessionVO = new ProfilingSessionVO();
        profilingSessionVO.setName(startProfilingParams.getName());
        profilingSessionVO.setComments(startProfilingParams.getComments());
        Optional<Object> optional = clusterProfilingStats.getStatsByHost().values().stream().map(ClusterHostProfilingStats::getStartDate).collect(Collectors.minBy(Comparator.naturalOrder()));
        profilingSessionVO.setStartDate(this.conversionHandler.toDateTime((Date)optional.orElse(null)));
        int n = 0;
        int n2 = 0;
        for (ClusterHostProfilingStats clusterHostProfilingStats : clusterProfilingStats.getStatsByHost().values()) {
            n += clusterHostProfilingStats.getEntryCount();
            n2 += clusterHostProfilingStats.getDiscardedCount();
        }
        profilingSessionVO.setEntryCount(n);
        profilingSessionVO.setDiscardedCount(n2);
        return profilingSessionVO;
    }

    public ProfilingData getData() throws FrameworkException {
        ProfilingData profilingData = new ProfilingData();
        profilingData.setMaxEntries(this.cyclosProperties.getProfilingMaxEntries());
        ProfilingSessionVO profilingSessionVO = this.getCurrent();
        if (profilingSessionVO == null) {
            StartProfilingParams startProfilingParams = new StartProfilingParams();
            startProfilingParams.setName(this.message(SystemKeys.Profiling.NAME_TEMPLATE, this.count() + 1L));
            startProfilingParams.setIncludeServices(true);
            startProfilingParams.setIncludeCustomWebServices(true);
            startProfilingParams.setIncludeScheduledTasks(true);
            profilingData.setStart(startProfilingParams);
            profilingData.setServices(this.serviceInterceptorService.listServices());
        } else {
            profilingData.setCurrentSession(profilingSessionVO);
        }
        return profilingData;
    }

    public List<ProfilingSessionVO> list() {
        return ((DBQuery)this.from(new EntityPath[]{$}).orderBy(ProfilingServiceImpl.$.startDate.desc())).list(ProfilingSessionVO.class, (Expression)$);
    }

    public ProfilingSessionVO load(@NotNull Long l) throws FrameworkException {
        ProfilingSession profilingSession = this.find(ProfilingSession.class, l);
        return (ProfilingSessionVO)this.conversionHandler.convert(ProfilingSessionVO.class, (Object)profilingSession);
    }

    public Pair<StartProfilingParams, ProfilingEntry> newIfEnabled(ProfilingEntryType profilingEntryType, InvocationData invocationData) {
        String string;
        StartProfilingParams startProfilingParams = this.profilingManager.getStartParams();
        if (startProfilingParams == null) {
            return null;
        }
        ProfilingEntry profilingEntry = null;
        switch (profilingEntryType) {
            case SERVICE: {
                SkipServiceLog skipServiceLog;
                if (!startProfilingParams.isIncludeServices()) break;
                string = invocationData.getServiceInterface().getSimpleName();
                String string2 = string + "." + invocationData.getMethodName();
                if (!CollectionHelper.isEmpty((Iterable)startProfilingParams.getServices()) && !startProfilingParams.getServices().contains(string) || !CollectionHelper.isEmpty((Iterable)startProfilingParams.getOperations()) && !startProfilingParams.getOperations().contains(string2)) break;
                try {
                    Method method = invocationData.getServiceInterface().getMethod(invocationData.getMethodName(), invocationData.getParameterTypes());
                    skipServiceLog = method.getAnnotation(SkipServiceLog.class);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    skipServiceLog = null;
                }
                if (skipServiceLog != null && !startProfilingParams.isIncludeServicesSkippedFromLog() && !CollectionHelper.isNotEmpty((Iterable)startProfilingParams.getOperations())) break;
                profilingEntry = new ProfilingEntry(profilingEntryType, string2);
                break;
            }
            case CUSTOM_WEB_SERVICE: {
                if (!startProfilingParams.isIncludeCustomWebServices()) break;
                profilingEntry = new ProfilingEntry(profilingEntryType, null);
                break;
            }
            case BUILTIN_RECURRING_TASK: 
            case BUILTIN_BACKGROUND_TASK: {
                if (!startProfilingParams.isIncludeScheduledTasks() || !startProfilingParams.isIncludeBuiltInTasks()) break;
                profilingEntry = new ProfilingEntry(profilingEntryType, null);
                break;
            }
            case CUSTOM_RECURRING_TASK: 
            case CUSTOM_BACKGROUND_TASK: {
                if (!startProfilingParams.isIncludeScheduledTasks()) break;
                profilingEntry = new ProfilingEntry(profilingEntryType, null);
            }
        }
        if (profilingEntry != null && invocationData != null) {
            profilingEntry.setSessionToken(invocationData instanceof StatefulUserInvocationData ? ((StatefulUserInvocationData)invocationData).getSessionToken() : null);
            profilingEntry.setChannel(invocationData.getChannel());
            string = invocationData.getRequestData();
            if (string != null) {
                profilingEntry.setNetwork(string.getNetworkInternalName());
                profilingEntry.setRemoteAddress(string.getRemoteAddress());
            }
        }
        return Pair.create((Object)startProfilingParams, profilingEntry);
    }

    public String readData(@NotNull Long l) throws FrameworkException {
        ProfilingSession profilingSession = this.find(ProfilingSession.class, l);
        return profilingSession.getData();
    }

    public void remove(Long l) throws FrameworkException {
        this.delete((EntityPath<?>)$).where(new Predicate[]{ProfilingServiceImpl.$.id.eq((Object)l)}).execute();
    }

    public int removeAll() throws FrameworkException {
        return (int)this.delete((EntityPath<?>)$).execute();
    }

    public void start(StartProfilingParams startProfilingParams) throws FrameworkException {
        this.validate(startProfilingParams);
        this.lockHandler.lock(LOCK_KEY);
        this.profilingManager.start(startProfilingParams);
    }

    public ProfilingSessionVO stop() throws FrameworkException {
        this.lockHandler.lock(LOCK_KEY);
        ClusterStopProfilingResult clusterStopProfilingResult = this.profilingManager.stop();
        StartProfilingParams startProfilingParams = clusterStopProfilingResult.getParams();
        Map map = clusterStopProfilingResult.getResultsByHost();
        Optional optional = map.values().stream().map(ClusterHostProfilingResult::getStartDate).collect(Collectors.minBy(Comparator.naturalOrder()));
        int n = map.values().stream().mapToInt(clusterHostProfilingResult -> clusterHostProfilingResult.getEntries().size()).sum();
        int n2 = map.values().stream().mapToInt(ClusterHostProfilingResult::getDiscardedCount).sum();
        ProfilingSession profilingSession = new ProfilingSession();
        profilingSession.setName(startProfilingParams.getName());
        profilingSession.setComments(startProfilingParams.getComments());
        profilingSession.setStartDate((Date)optional.get());
        profilingSession.setEndDate(new Date());
        profilingSession.setEntryCount(n);
        profilingSession.setDiscardedCount(n2);
        ProfilingMeta profilingMeta = new ProfilingMeta();
        profilingMeta.setCyclosRevision(CyclosVersion.getCommitId());
        profilingMeta.setCyclosVersion(CyclosVersion.get());
        profilingMeta.setTimestamp(profilingSession.getStartDate());
        profilingMeta.setDuration(Integer.valueOf((int)(profilingSession.getEndDate().getTime() - profilingSession.getStartDate().getTime())));
        profilingMeta.setParameters(startProfilingParams.values());
        profilingMeta.setEndedAt(profilingSession.getEndDate());
        ArrayList<ProfilingEntry> arrayList = new ArrayList<ProfilingEntry>(n);
        map.entrySet().forEach(entry -> {
            ClusterHostProfilingResult clusterHostProfilingResult = (ClusterHostProfilingResult)entry.getValue();
            if (this.clusterHandler.isCluster()) {
                clusterHostProfilingResult.getEntries().forEach(profilingEntry -> profilingEntry.setHost((String)entry.getKey()));
            }
            arrayList.addAll(clusterHostProfilingResult.getEntries());
        });
        if (map.size() > 1) {
            arrayList.sort(Comparator.comparing(ProfilingElement::getTimestamp));
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            ProfilingEntry profilingEntry = (ProfilingEntry)arrayList.get(i);
            profilingEntry.setSeq(Integer.valueOf(i + 1));
            if (!startProfilingParams.isIncludeScriptCode()) continue;
            CollectionHelper.orEmpty((Set)profilingEntry.getScripts()).stream().forEach(triple -> hashMap.computeIfAbsent(String.format("%s@%s", triple.getLeft(), triple.getRight()), string -> this.customScriptService.resolveCodeForProfiling((String)triple.getLeft(), (String)triple.getMiddle(), (String)triple.getRight())));
        }
        profilingMeta.setScriptCodes(startProfilingParams.isIncludeScriptCode() ? hashMap : null);
        profilingMeta.setEntries(arrayList);
        profilingMeta.setDiscarded(Integer.valueOf(n2));
        try {
            String string = this.jsonConverter.writeValueAsString((Object)profilingMeta);
            profilingSession.setData(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error writing the profiling results to JSON", iOException);
        }
        this.persist((IEntity)profilingSession);
        return (ProfilingSessionVO)this.conversionHandler.convert(ProfilingSessionVO.class, (Object)profilingSession);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private long count() {
        return this.from(new EntityPath[]{$}).fetchCount();
    }

    private void validate(StartProfilingParams startProfilingParams) {
        if (!(startProfilingParams.isIncludeServices() || startProfilingParams.isIncludeCustomWebServices() || startProfilingParams.isIncludeScheduledTasks())) {
            throw new ValidationException(this.message(SystemKeys.Profiling.ERROR_NO_ENTRY_POINTS, new Object[0]));
        }
    }

    static {
        ProfilingEntry.excludeClassFromProfilingContext((String)RequestContext.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)TransactionHandlerImpl.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)LockHandlerImpl.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)InvokerHandlerImpl.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)CachingPreparedStatement.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ProfilingPreparedStatement.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ProfilingStatement.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ProfilingEntry.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)AbstractServerComponent.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)AbstractNetworkedServerComponent.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)AbstractCache.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ConfigurationHandlerImpl.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ConfigurationAccessorInvocationHandlerImpl.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ProductsHandlerImpl.class.getName());
        ProfilingEntry.excludeClassFromProfilingContext((String)ProductsAccessorInvocationHandlerImpl.class.getName());
        ProfilingEntry.excludePackageFromProfilingContext((String)ProductsResolver.class.getName());
        ProfilingEntry.excludePackageFromProfilingContext((String)DBQuery.class.getName());
        ProfilingEntry.excludePackageFromProfilingContext((String)Cache.class.getName());
    }
}

