/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.QCustomFieldValueFile;
import org.cyclos.entities.system.QTempFile;
import org.cyclos.entities.system.TempFile;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.RawFile;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.RawFileServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.StoredFileException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageProducer;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RawFileServiceImpl
extends BaseServiceImpl
implements RawFileServiceLocal {
    private static final QTempFile t = QTempFile.tempFile;
    private static final QCustomFieldValueFile fv = QCustomFieldValueFile.customFieldValueFile;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;

    public TempFile createTemp(String string, String string2, SerializableInputStream serializableInputStream) {
        SessionData sessionData = this.getSessionData();
        TempFile tempFile = new TempFile();
        tempFile.setName(string);
        tempFile.setByUser(sessionData.getLoggedUser());
        tempFile.setLastModified(DateHelper.now());
        try {
            tempFile.setLength(Integer.valueOf((int)serializableInputStream.file().length()));
        }
        catch (Exception exception) {
            throw new StoredFileException((Throwable)exception);
        }
        tempFile.setContentType(string2);
        this.storedFileHandler.save((StoredFile)tempFile, serializableInputStream);
        return tempFile;
    }

    public long deleteExpiredTemp() {
        TimeInterval timeInterval = new TimeInterval(Integer.valueOf(2), TimeField.HOURS);
        Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)timeInterval);
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{t}).where((Predicate)RawFileServiceImpl.t.lastModified.lt((Comparable)date))).iterate((Expression)RawFileServiceImpl.t.id);
        return this.processBatch(closeableIterator, this::remove);
    }

    public <T extends RawFile> T findAs(Class<T> clazz, Long l) {
        return (T)((RawFile)this.find(clazz, l));
    }

    public List<RawFileVO> listTemp(String string, CustomFieldVO customFieldVO) throws FrameworkException {
        CustomField customField = this.customFieldValueHandler.getCustomField(customFieldVO);
        return this.createTempQuery(string, customField).list(RawFileVO.class, (Expression)t);
    }

    public RawFileVO load(Long l) throws FrameworkException {
        RawFile rawFile = this.find(l);
        return (RawFileVO)this.conversionHandler.convert(RawFileVO.class, (Object)rawFile);
    }

    public void move(TempFile tempFile, StoredFile storedFile) {
        this.storedFileHandler.move((StoredFile)tempFile, storedFile);
    }

    public SerializableInputStream readContent(Long l) throws FrameworkException {
        RawFile rawFile = this.find(l);
        return this.storedFileHandler.getContent((StoredFile)rawFile);
    }

    public void remove(Long l) throws FrameworkException {
        this.find(TempFile.class, l);
        this.storedFileHandler.remove(l.longValue());
    }

    public void removeAll(List<Long> list) throws FrameworkException {
        CollectionHelper.orEmpty(list).forEach(this::remove);
    }

    public void saveName(Long l, String string) throws FrameworkException {
        RawFile rawFile = this.find(l);
        rawFile.setName(string);
    }

    public RawFileVO saveTemp(String string, CustomFieldVO customFieldVO, String string2, String string3, SerializableInputStream serializableInputStream) throws FrameworkException {
        CustomField customField = this.customFieldValueHandler.getCustomField(customFieldVO);
        this.validateMaxTemp(string, customField);
        if (customField != null && customField.getType() != CustomFieldType.FILE) {
            throw new IllegalActionException();
        }
        this.validateContentType(customFieldVO, string3);
        try {
            SessionData sessionData = this.getSessionData();
            TempFile tempFile = new TempFile();
            tempFile.setName(string2);
            tempFile.setByUser(sessionData.getLoggedUser());
            String string4 = sessionData.isLoggedIn() ? null : (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string), (Object)sessionData.getRemoteAddress());
            tempFile.setGuestKey(string4);
            tempFile.setCustomField(customField);
            tempFile.setLastModified(DateHelper.now());
            tempFile.setLength(Integer.valueOf((int)serializableInputStream.file().length()));
            tempFile.setContentType(string3);
            this.storedFileHandler.save((StoredFile)tempFile, serializableInputStream);
            return (RawFileVO)this.conversionHandler.convert(RawFileVO.class, (Object)tempFile);
        }
        catch (IOException iOException) {
            throw new StoredFileException((Throwable)iOException);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(t.network());
        networkPathRegistry.register(fv.network());
    }

    private DBQuery<?> createTempQuery(String string, CustomField<?, ?, ?> customField) {
        String string2;
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        DBQuery<?> dBQuery = this.from(new EntityPath[]{t});
        if (user == null) {
            string2 = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string), (Object)sessionData.getRemoteAddress());
            dBQuery.where(new Predicate[]{t.byUser().isNull(), RawFileServiceImpl.t.guestKey.eq((Object)string2)});
        } else {
            dBQuery.where((Predicate)t.byUser().eq((Object)user));
        }
        string2 = this.storedFileHandler.customFieldEquals((EntityPath)t, customField);
        if (string2 != null) {
            dBQuery.where((Predicate)string2);
        }
        return dBQuery;
    }

    private RawFile find(Long l) {
        return this.find(RawFile.class, l);
    }

    private void validateContentType(CustomFieldVO customFieldVO, String string) throws ValidationException {
        List list;
        CustomField customField;
        Set set;
        Set set2;
        if (customFieldVO != null && !(set2 = ModelHelper.getAllowedMimeTypes((Collection)(set = (customField = this.customFieldValueHandler.getCustomField(customFieldVO)).getAllowedMimeTypes()), (Collection)(list = StringHelper.splitTrimming((String)customField.getOtherMimeTypes(), (String)"\n")))).contains(string)) {
            List list2 = ModelHelper.getFriendlyMimeTypes((Collection)set, (Collection)list, (MessageProducer)this.translationHandler);
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID_FILE, null, StringHelper.join((Collection)list2, (String)", ")));
        }
    }

    private void validateMaxTemp(String string, CustomField<?, ?, ?> customField) throws MaxItemsException {
        int n;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        int n2 = this.createTempQuery(string, customField).count(RawFileServiceImpl.t.id);
        int n3 = n = sessionData.isGuest() ? configurationAccessor.getMaxGuestTempImages() : configurationAccessor.getMaxUserTempImages();
        if (n2 > n) {
            throw new MaxItemsException(this.message(GeneralKeys.Errors.MAX_NUMBER_OF_TEMP_FILES, new Object[0]), n);
        }
    }
}

