/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.system.operations.ReceiptItemVO;
import org.cyclos.model.system.operations.ReceiptPartAlign;
import org.cyclos.model.system.operations.ReceiptPartSize;
import org.cyclos.model.system.operations.ReceiptPartStyle;
import org.cyclos.model.system.operations.ReceiptPartVO;
import org.cyclos.model.system.operations.ReceiptVO;
import org.cyclos.utils.StringHelper;
import org.springframework.stereotype.Component;

@Component
public class ReceiptVOConverter
extends ObjectConverter<ReceiptVO> {
    public ReceiptVOConverter() {
        super(ReceiptVO.class);
    }

    @Override
    protected void fill(Object object, ReceiptVO receiptVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, receiptVO, objectArray, conversionContext);
        if (receiptVO.getLabelSuffix() == null) {
            receiptVO.setLabelSuffix(": ");
        }
        this.fillDefaults(receiptVO.getHeader(), ReceiptPartStyle.NORMAL, ReceiptPartAlign.LEFT, ReceiptPartSize.NORMAL, false);
        this.fillDefaults(receiptVO.getTitle(), ReceiptPartStyle.BOLD, ReceiptPartAlign.CENTER, ReceiptPartSize.DOUBLE, false);
        if (receiptVO.getItems() == null) {
            receiptVO.setItems(Collections.emptyList());
        } else {
            if (receiptVO.getItems().stream().anyMatch(Objects::isNull)) {
                receiptVO.setItems(receiptVO.getItems().stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
            receiptVO.getItems().forEach(receiptItemVO -> this.fillDefaults((ReceiptPartVO)receiptItemVO, ReceiptPartStyle.NORMAL, StringHelper.isBlank((Object)receiptItemVO.getLabel()) ? ReceiptPartAlign.LEFT : ReceiptPartAlign.RIGHT, ReceiptPartSize.NORMAL, false));
        }
        this.fillDefaults(receiptVO.getFooter(), ReceiptPartStyle.BOLD, ReceiptPartAlign.CENTER, ReceiptPartSize.NORMAL, true);
    }

    private void fillDefaults(ReceiptPartVO receiptPartVO, ReceiptPartStyle receiptPartStyle, ReceiptPartAlign receiptPartAlign, ReceiptPartSize receiptPartSize, boolean bl) {
        if (receiptPartVO == null) {
            return;
        }
        if (receiptPartVO.getStyle() == null) {
            receiptPartVO.setStyle(receiptPartStyle);
        }
        if (receiptPartVO.getAlign() == null) {
            receiptPartVO.setAlign(receiptPartAlign);
        }
        if (receiptPartVO.getWidth() == null) {
            receiptPartVO.setWidth(ReceiptPartSize.NORMAL);
        }
        if (receiptPartVO.getHeight() == null) {
            receiptPartVO.setHeight(receiptPartSize);
        }
        if (receiptPartVO.getLineBefore() == null) {
            receiptPartVO.setLineBefore(Boolean.valueOf(bl));
        }
        if (receiptPartVO.getLineAfter() == null) {
            receiptPartVO.setLineAfter(Boolean.valueOf(bl));
        }
        if (receiptPartVO instanceof ReceiptItemVO) {
            ReceiptItemVO receiptItemVO = (ReceiptItemVO)receiptPartVO;
            if (StringHelper.isBlank((Object)receiptItemVO.getLabel())) {
                receiptItemVO.setLabel(null);
                receiptItemVO.setLabelStyle(null);
            } else {
                receiptItemVO.setAlign(null);
                receiptItemVO.setWidth(null);
                receiptItemVO.setHeight(null);
                if (receiptItemVO.getLabelStyle() == null) {
                    receiptItemVO.setLabelStyle(ReceiptPartStyle.BOLD);
                }
            }
        }
    }
}

