/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QReferenceHistory;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.impl.system.FirstAndLastData;
import org.cyclos.impl.system.ReferenceSubReportsTestableHandler;
import org.cyclos.impl.system.ReportSection;
import org.cyclos.impl.system.SubReportsHandler;
import org.cyclos.impl.system.SubReportsHandlerImpl;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReferenceSubReportsHandlerImpl
extends SubReportsHandlerImpl
implements ReferenceSubReportsTestableHandler {
    @Autowired
    private GeneralReferenceServiceLocal generalReferenceService;

    public Map<ReferenceLevel, Integer> countReferences(SystemReportQuery systemReportQuery, SubReportsHandler.PeriodLimit periodLimit) {
        Set set = this.groupsHandler.flattenVOs((Collection)systemReportQuery.getGroups(), true);
        Date date = this.getPeriodLimitAsDate(systemReportQuery, periodLimit);
        List list = this.generalReferenceService.getReferenceLevels();
        EnumMap<ReferenceLevel, Integer> enumMap = new EnumMap<ReferenceLevel, Integer>(ReferenceLevel.class);
        list.forEach(referenceLevel -> enumMap.put((ReferenceLevel)referenceLevel, 0));
        QReferenceHistory qReferenceHistory = QReferenceHistory.referenceHistory;
        Map map = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qReferenceHistory}).where(new Predicate[]{this.getGroupHistorySubQueryClause(qReferenceHistory.to(), set, date, false), qReferenceHistory.period().begin.loe((Comparable)date), qReferenceHistory.period().end.isNull().or((Predicate)qReferenceHistory.period().end.gt((Comparable)date))})).groupBy((Expression)qReferenceHistory.level)).map((Expression)qReferenceHistory.level, (Expression)qReferenceHistory.id.count());
        map.forEach((referenceLevel, l) -> {
            if (l != null && list.contains(referenceLevel)) {
                enumMap.put((ReferenceLevel)referenceLevel, l.intValue());
            }
        });
        return enumMap;
    }

    public List<ReportSection> data(SystemReportQuery systemReportQuery) {
        if (systemReportQuery.isReferences()) {
            ReportSection reportSection = new ReportSection((Object)SystemKeys.Reports.SYSTEM_REFERENCES, true, this.getReferenceData(systemReportQuery));
            return Collections.singletonList(reportSection);
        }
        return null;
    }

    public int order() {
        return 3;
    }

    private BooleanExpression getGroupHistorySubQueryClause(QUser qUser, Set<? extends Group> set, Date date, boolean bl) {
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        return ((DBQuery)this.subQuery(new EntityPath[]{qUserGroupLog}).where(new Predicate[]{qUserGroupLog.user().eq((Expression)qUser), qUserGroupLog.group().in(set), qUserGroupLog.startDate.before((Comparable)date), qUserGroupLog.endDate.isNull().or((Predicate)qUserGroupLog.endDate.after((Comparable)date))})).exists();
    }

    private List<FirstAndLastData> getReferenceData(SystemReportQuery systemReportQuery) {
        ArrayList<FirstAndLastData> arrayList = new ArrayList<FirstAndLastData>();
        Map<ReferenceLevel, Integer> map = this.countReferences(systemReportQuery, SubReportsHandler.PeriodLimit.BEGIN);
        Map<ReferenceLevel, Integer> map2 = this.countReferences(systemReportQuery, SubReportsHandler.PeriodLimit.END);
        Long l = 0L;
        Long l2 = 0L;
        if (CollectionHelper.isNotEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                ReferenceLevel referenceLevel = (ReferenceLevel)entry.getKey();
                FirstAndLastData firstAndLastData = new FirstAndLastData();
                MessageKey messageKey = referenceLevel.getMessageKey();
                firstAndLastData.setLabel(this.message(messageKey, new Object[0]));
                Integer n = (Integer)entry.getValue();
                firstAndLastData.setFirst(n);
                Integer n2 = map2.get(referenceLevel);
                firstAndLastData.setLast(n2);
                arrayList.add(firstAndLastData);
                l = l + (long)n.intValue();
                l2 = l2 + (long)n2.intValue();
            }
        }
        FirstAndLastData firstAndLastData = new FirstAndLastData();
        firstAndLastData.setLabel(this.message(SystemKeys.Reports.SYSTEM_REFERENCES_TOTAL, new Object[0]));
        firstAndLastData.setFirst(l);
        firstAndLastData.setLast(l2);
        arrayList.add(firstAndLastData);
        return arrayList;
    }
}

