/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.time.StopWatch;
import org.codehaus.groovy.control.CompilationFailedException;
import org.cyclos.bootstrap.BootstrapConfiguration;
import org.cyclos.bootstrap.ServicesConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class RunScript
implements AutoCloseable {
    private static final String INTERACTIVE_DEFAULT_CONFIRMATION_PROEPERTY = "interactive.default.confirmation";
    private List<ScriptFilesDescriptor> scriptFiles;
    private AnnotationConfigApplicationContext applicationContext;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private ConversionHandler conversionHandler;
    private Network network;
    private boolean interactive;
    private Boolean interactiveDefaultConfirmation;

    public static void main(String[] stringArray) {
        try (RunScript runScript = new RunScript();){
            runScript.initialize(stringArray);
            runScript.run();
            System.out.println("Execution finished.");
        }
        System.exit(0);
    }

    private static Options commandLineOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Show this help message");
        options.addOption(Option.builder((String)"s").argName("script").longOpt("script").desc("The path to the main script file (the .groovy extension is not mandatory) or to a folder with all scripts to be executed. The Groovy filename will be used as a base name to also find its related files in the same folder:\n* An optional <script>Bindings.groovy file, that will be executed before the main script to return a map with the binding variables available to the main script\n* An optional <script>.properties file, containing the script parameters (the same which is set in Cyclos as Script parameters)").required().hasArg().build());
        options.addOption(Option.builder((String)"c").argName("config").longOpt("config").desc("The file system path of the cyclos.properties file.\nThe default value is cyclos.properties").hasArg().build());
        options.addOption(Option.builder((String)"n").argName("network").longOpt("network").desc("The internal name of network to run the script on. When not set, uses the default network (or global mode if none). Also accepts global to force global mode.").hasArg().build());
        options.addOption(Option.builder((String)"i").argName("interactive").longOpt("interactive").desc("Do not exit the program after running the script. Instead, keep it running to allow the script to be executed again. This is useful during script development, as it allows for faster testing without the need to restart the program.").build());
        return options;
    }

    @Override
    public void close() {
        if (this.applicationContext != null) {
            this.applicationContext.close();
        }
    }

    private boolean confirmContinue(String string, Boolean bl) {
        String string2 = bl == null ? " (y/n) " : (bl != false ? " (default is yes) [Y/n] " : " (default is no) [y/N] ");
        System.out.print(string + " Continue?" + string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            boolean bl2 = true;
            while (true) {
                String string3 = bufferedReader.readLine();
                if (bl != null) {
                    return StringUtils.isBlank((CharSequence)string3) ? bl.booleanValue() : string3.toLowerCase().startsWith("y");
                }
                String string4 = string3 = string3 != null ? string3.toLowerCase() : string3;
                if (!StringUtils.isBlank((CharSequence)string3) && (string3.startsWith("y") || string3.startsWith("n"))) {
                    return string3.startsWith("y");
                }
                if (bl2) {
                    System.out.print("Please answer y or n: ");
                }
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void doRun() {
        StopWatch stopWatch = StopWatch.createStarted();
        if (this.scriptFiles.isEmpty()) {
            System.out.println("No scripts to run");
            return;
        }
        if (this.scriptFiles.size() > 1) {
            boolean bl;
            boolean bl2 = bl = !this.confirmContinue(String.format("%s scripts will be executed.", this.scriptFiles.size()), false);
            if (bl) {
                System.out.println("Aborted");
                System.exit(0);
            }
        }
        this.scriptFiles.forEach(scriptFilesDescriptor -> {
            try {
                this.run((ScriptFilesDescriptor)scriptFilesDescriptor);
            }
            catch (Exception exception) {
                if (this.scriptFiles.size() == 1 && !this.interactive) {
                    throw exception;
                }
                System.out.printf(">>>>> Error running script: %s%n", exception.getMessage());
                exception.printStackTrace();
            }
        });
        System.out.printf("All scripts ran in %s%n%n", stopWatch);
    }

    private void initialize(String[] stringArray) {
        CommandLine commandLine;
        Options options = RunScript.commandLineOptions();
        try {
            commandLine = new DefaultParser().parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
            this.showHelp();
            System.exit(10);
            return;
        }
        if (commandLine.hasOption("help")) {
            this.showHelp();
            System.exit(0);
        }
        this.interactive = commandLine.hasOption("interactive");
        if (this.interactive) {
            System.out.println("Running in interactive mode");
            this.interactiveDefaultConfirmation = System.getProperty(INTERACTIVE_DEFAULT_CONFIRMATION_PROEPERTY) == null ? null : Boolean.valueOf(System.getProperty(INTERACTIVE_DEFAULT_CONFIRMATION_PROEPERTY));
        }
        File file = null;
        String string = commandLine.getOptionValue("config");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            file = new File(string);
            if (!file.exists()) {
                System.out.println("Configuration file not found: " + file.getAbsolutePath());
                System.exit(20);
            }
            System.out.println("Configuration: " + file.getAbsolutePath());
        }
        String string2 = commandLine.getOptionValue("network");
        this.readScriptFiles(commandLine);
        System.setProperty("cyclos.maxBackgroundTasks", "0");
        System.setProperty("cyclos.maxRecurringTasks", "0");
        System.setProperty("cyclos.db.managed", "false");
        System.setProperty("cyclos.ignoreDatabaseLock", "true");
        if (file != null) {
            System.setProperty("cyclos.properties", file.getAbsolutePath());
        }
        System.setProperty("file.encoding", "UTF-8");
        this.applicationContext = new AnnotationConfigApplicationContext();
        this.applicationContext.register(new Class[]{BootstrapConfiguration.class});
        this.applicationContext.register(new Class[]{ServicesConfiguration.class});
        this.applicationContext.refresh();
        BeanHandler beanHandler = (BeanHandler)this.applicationContext.getBean(BeanHandler.class);
        beanHandler.autowire((Object)this);
        this.network = (Network)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            QNetwork qNetwork = QNetwork.network;
            if (string2 == null) {
                return (Network)((DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)qNetwork).where((Predicate)qNetwork.defaultNetwork.isTrue())).fetchFirst();
            }
            if (string2.equals("global")) {
                return null;
            }
            Network network = (Network)((DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)qNetwork).where((Predicate)qNetwork.internalName.eq((Object)string2))).fetchFirst();
            if (network == null) {
                System.out.println("Network not found: " + String.valueOf(network));
                System.exit(22);
            }
            return network;
        });
    }

    private Object parseAndRun(File file, Binding binding) {
        Script script;
        try {
            GroovyShell groovyShell = new GroovyShell(binding);
            script = groovyShell.parse(file);
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new IllegalStateException(compilationFailedException);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return script.run();
    }

    private void readScriptFiles(CommandLine commandLine) {
        this.scriptFiles = new ArrayList<ScriptFilesDescriptor>();
        String string = commandLine.getOptionValue("script");
        if (Files.isDirectory(Path.of(string, new String[0]), new LinkOption[0])) {
            if (commandLine.hasOption("interactive")) {
                System.out.println("Interactive mode is not supported for directories. It can be used when running a single script.");
                System.exit(23);
            }
            try {
                Files.list(Path.of(string, new String[0])).filter(path -> {
                    String string = path.toString();
                    return !string.endsWith("Bindings.groovy") && !string.endsWith(".properties") && string.endsWith(".groovy");
                }).map(path -> this.readScriptFilesFromBase(path.toFile().getAbsolutePath(), false)).forEach(this.scriptFiles::add);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        } else {
            ScriptFilesDescriptor scriptFilesDescriptor = this.readScriptFilesFromBase(string, true);
            this.scriptFiles.add(scriptFilesDescriptor);
        }
    }

    private ScriptFilesDescriptor readScriptFilesFromBase(String string, boolean bl) {
        String string2 = StringHelper.removeEnd((String)string, (String)".groovy");
        File file = new File(string2 + ".groovy");
        if (!file.exists()) {
            System.out.println("Script not found: " + file.getAbsolutePath());
            System.exit(21);
        }
        File file2 = new File(string2 + "Bindings.groovy");
        File file3 = new File(string2 + ".properties");
        return new ScriptFilesDescriptor(file, file2, file3, bl);
    }

    private void run() {
        this.doRun();
        while (this.interactive && this.confirmContinue("The script will be executed again.", this.interactiveDefaultConfirmation)) {
            this.doRun();
        }
    }

    private void run(ScriptFilesDescriptor scriptFilesDescriptor) {
        System.out.printf("Running script: %s...%n", scriptFilesDescriptor.scriptFile.getAbsolutePath());
        SessionData sessionData = SessionDataFactory.system((Network)this.network);
        this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
            Object object;
            MutableObject mutableObject = new MutableObject((Object)sessionData);
            MutableBoolean mutableBoolean = new MutableBoolean(true);
            Binding binding = new Binding((Map)this.customScriptService.resolveBindings(null, null));
            binding.setVariable("scriptParameters", (Object)scriptFilesDescriptor.getScriptParameters());
            if (scriptFilesDescriptor.bindingsFile.exists() && (object = this.parseAndRun(scriptFilesDescriptor.bindingsFile, binding)) instanceof Map) {
                Map map = (Map)object;
                Object v = map.get("sessionData");
                if (v instanceof SessionData) {
                    mutableObject.set((Object)((SessionData)v));
                } else {
                    Object v2 = map.get("runAs");
                    BasicUser basicUser = null;
                    if (v2 instanceof BasicUser) {
                        basicUser = (BasicUser)v2;
                    } else if (v2 instanceof CharSequence) {
                        basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)v2.toString());
                    }
                    if (basicUser != null) {
                        mutableObject.set((Object)SessionDataFactory.user((BasicUser)basicUser));
                    }
                }
                if (Boolean.FALSE.equals(map.get("allPermissions"))) {
                    mutableBoolean.setFalse();
                }
                map.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
            }
            mutableObject.set((Object)SessionDataFactory.script((SessionData)((SessionData)mutableObject.get()), (boolean)mutableBoolean.booleanValue()));
            binding.setVariable("sessionData", mutableObject.get());
            this.invokerHandler.runAs((SessionData)mutableObject.get(), () -> {
                Object object = this.parseAndRun(scriptFilesDescriptor.scriptFile, binding);
                if (object == null) {
                    System.out.println("The script didn't return any result");
                } else {
                    System.out.println("Result from script:\n" + String.valueOf(object));
                }
                return null;
            });
            return null;
        });
    }

    private void showHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(this.getClass().getSimpleName(), RunScript.commandLineOptions(), true);
    }

    private static class ScriptFilesDescriptor {
        private File scriptFile;
        private File bindingsFile;
        private File parametersFile;

        public ScriptFilesDescriptor(File file, File file2, File file3, boolean bl) {
            if (bl) {
                System.out.printf("Main script: %s%n", file.getAbsolutePath());
                System.out.printf("Bindings script: %s%n", !file2.exists() ? "<none>" : file2.getAbsolutePath());
                System.out.printf("Script parameters: %s%n", !file3.exists() ? "<none>" : file3.getAbsolutePath());
            }
            this.scriptFile = file;
            this.bindingsFile = file2;
            this.parametersFile = file3;
        }

        public Properties getScriptParameters() {
            Properties properties;
            if (this.parametersFile != null && this.parametersFile.exists()) {
                try {
                    properties = PropertiesHelper.from((Reader)new InputStreamReader((InputStream)new FileInputStream(this.parametersFile), StandardCharsets.UTF_8));
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            } else {
                properties = new Properties();
            }
            return properties;
        }
    }
}

