/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.contentmanagement.GuestHomeContent;
import org.cyclos.entities.contentmanagement.LoggedUserHomeContent;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.QUser;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PasswordTypeServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.system.LicenseHandler;
import org.cyclos.impl.system.LicenseServiceLocal;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.system.SetupServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.license.api.model.LicenseActivationParameters;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.passwordtypes.DefaultPasswordType;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.licensing.LicenseAuthenticationException;
import org.cyclos.model.system.licensing.LicenseServerOfflineException;
import org.cyclos.model.system.setup.SetupDTO;
import org.cyclos.model.system.setup.SetupData;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetupServiceImpl
extends BaseServiceImpl
implements SetupServiceLocal {
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private LicenseHandler licenseHandler;
    @Autowired
    private LicenseServiceLocal licenseService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private PasswordTypeServiceLocal passwordTypeService;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private InvokerHandler invokerHandler;

    public SetupData getSetupData() throws FrameworkException {
        List list;
        String string;
        SessionData sessionData = this.getSessionData();
        Language language = sessionData.getConfiguration().getLanguage();
        RequestData requestData = sessionData.getRequestData();
        List list2 = this.conversionHandler.convertList(Locale.class, (Iterable)requestData.getLocales());
        String string2 = null;
        Locale locale = (Locale)CollectionHelper.first((Iterable)list2);
        if (locale != null) {
            string = locale.getCountry();
            list = this.localizationService.getCountryCodes();
            string2 = list.contains(string) ? string : this.localizationService.getDefaultCountryForLanguage(locale.getLanguage());
        }
        string = new SetupDTO();
        string.setLanguage((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)language));
        string.setCountry(string2);
        list = new SetupData();
        list.setDto((SetupDTO)string);
        list.setLocalizationData(this.localizationService.getLocalizationData(string2, null));
        list.setLanguages(this.conversionHandler.convertList(LanguageVO.class, (Iterable)this.languageService.list()));
        list.setHasUsers(this.from(new EntityPath[]{QUser.user}).hasResults());
        return list;
    }

    public boolean isSetupDone() throws FrameworkException {
        return this.licenseHandler.isSet();
    }

    public void setup(SetupDTO setupDTO) throws FrameworkException, LicenseServerOfflineException, LicenseAuthenticationException {
        LicenseActivationParameters licenseActivationParameters;
        if (this.isSetupDone()) {
            throw new IllegalActionException();
        }
        boolean bl = this.from(new EntityPath[]{QUser.user}).hasResults();
        this.validate(setupDTO, bl);
        Configuration configuration = this.configurationHandler.getGlobalDefault();
        if (!bl) {
            Channel channel;
            configuration.setApplicationName(setupDTO.getApplicationName());
            configuration.setRootUrl(StringHelper.removeEnd((String)this.getSessionData().getRequestData().getBaseUrl(), (String)"/global"));
            licenseActivationParameters = (Language)this.conversionHandler.convert(Language.class, (Object)setupDTO.getLanguage());
            this.configurationService.setLocalization(configuration, (Language)licenseActivationParameters, setupDTO.getCountry(), setupDTO.getTimeZoneId());
            TranslationHandler translationHandler = this.translationHandler;
            configuration.setName(translationHandler.message((Language)licenseActivationParameters, GeneralKeys.InitialData.CONFIGURATION_GLOBAL_DEFAULT, new Object[0]));
            configuration.setApplicationUsername(translationHandler.message((Language)licenseActivationParameters, GeneralKeys.InitialData.CONFIGURATION_APPLICATION_USERNAME, new Object[0]));
            for (BuiltInChannel builtInChannel2 : BuiltInChannel.values()) {
                channel = this.channelService.load(builtInChannel2.getInternalName());
                channel.setName(translationHandler.message((Language)licenseActivationParameters, builtInChannel2.getMessageKey(), new Object[0]));
            }
            for (BuiltInChannel builtInChannel : ExistingBuiltInPrincipalType.values()) {
                channel = this.principalTypeService.find(builtInChannel.getInternalName(), null);
                channel.setName(translationHandler.message((Language)licenseActivationParameters, builtInChannel.getMessageKey(), new Object[0]));
            }
            for (BuiltInChannel builtInChannel : DefaultPasswordType.values()) {
                try {
                    channel = this.passwordTypeService.getByName(builtInChannel.getDisplayName());
                    channel.setName(translationHandler.message((Language)licenseActivationParameters, builtInChannel.getMessageKey(), new Object[0]));
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
            GuestHomeContent guestHomeContent = configuration.getGuestHomeContent();
            guestHomeContent.setTitle(translationHandler.message((Language)licenseActivationParameters, GeneralKeys.InitialData.STATIC_CONTENT_GLOBAL_GUEST_HOME_TITLE, new Object[]{configuration.getApplicationName()}));
            guestHomeContent.setContent(translationHandler.message(MessageFormat.HTML, (Language)licenseActivationParameters, GeneralKeys.InitialData.STATIC_CONTENT_GLOBAL_GUEST_HOME_CONTENT, new Object[0]));
            LoggedUserHomeContent loggedUserHomeContent = configuration.getLoggedUserHomeContent();
            loggedUserHomeContent.setTitle(translationHandler.message((Language)licenseActivationParameters, GeneralKeys.InitialData.STATIC_CONTENT_GLOBAL_LOGGED_USER_HOME_TITLE, new Object[0]));
            loggedUserHomeContent.setContent(translationHandler.message(MessageFormat.HTML, (Language)licenseActivationParameters, GeneralKeys.InitialData.STATIC_CONTENT_GLOBAL_LOGGED_USER_HOME_CONTENT, new Object[0]));
            AdminGroup adminGroup = this.groupService.getSystemAdmins();
            adminGroup.setName(translationHandler.message((Language)licenseActivationParameters, GeneralKeys.InitialData.GROUP_GLOBAL_ADMINISTRATORS, new Object[0]));
            UserRegistrationDTO userRegistrationDTO = new UserRegistrationDTO();
            userRegistrationDTO.setGroup(new GroupVO(adminGroup.getId()));
            userRegistrationDTO.setName(setupDTO.getAdminName());
            userRegistrationDTO.setUsername(setupDTO.getAdminUsername());
            userRegistrationDTO.setEmail(setupDTO.getAdminEmail());
            userRegistrationDTO.setSkipActivationEmail(true);
            channel = new PasswordRegistrationDTO();
            channel.setAssign(true);
            channel.setValue(setupDTO.getAdminPassword());
            channel.setConfirmationValue(channel.getValue());
            channel.setType(new PasswordTypeVO(PasswordTypeVO.INTERNAL_NAME, (Object)DefaultPasswordType.LOGIN_PASSWORD.getInternalName()));
            userRegistrationDTO.setPasswords(Arrays.asList(channel));
            this.userService.register(userRegistrationDTO);
        }
        licenseActivationParameters = new LicenseActivationParameters();
        licenseActivationParameters.setUsername(setupDTO.getLicenseUsername());
        licenseActivationParameters.setPassword(setupDTO.getLicensePassword());
        licenseActivationParameters.setCyclosInstanceName(configuration.getApplicationName());
        this.licenseHandler.activate(licenseActivationParameters);
        for (GuestHomeContent guestHomeContent : CacheType.all()) {
            this.cacheHandler.scheduleClear((CacheType)guestHomeContent);
        }
        InvocationContext.ensure().addCommitListener(false, () -> this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.licenseService.onlineUpdate()));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void validate(SetupDTO setupDTO, boolean bl) {
        Validator validator = new Validator();
        validator.property((Property)SetupDTO.LICENSE_USERNAME, SystemKeys.Setup.LICENSE_USERNAME).required();
        validator.property((Property)SetupDTO.LICENSE_PASSWORD, SystemKeys.Setup.LICENSE_PASSWORD).required();
        if (!bl) {
            validator.property((Property)SetupDTO.APPLICATION_NAME, SystemKeys.Configurations.APPLICATION_NAME).required().maxLength(100);
            validator.property((Property)SetupDTO.LANGUAGE, SystemKeys.Configurations.DEFAULT_LANGUAGE).required();
            validator.property((Property)SetupDTO.COUNTRY, SystemKeys.Configurations.COUNTRY).required().anyOf((Collection)this.localizationService.listCountryCodes());
            validator.property((Property)SetupDTO.TIME_ZONE_ID, SystemKeys.Configurations.TIME_ZONE_ID).required().anyOf((Collection)this.localizationService.listTimeZoneIds());
            validator.property((Property)SetupDTO.ADMIN_NAME, UsersKeys.Users.NAME).required().length(5, 100).maxWordSize(50);
            validator.property((Property)SetupDTO.ADMIN_USERNAME, UsersKeys.Users.USERNAME).required().length(3, 20);
            validator.property((Property)SetupDTO.ADMIN_EMAIL, UsersKeys.Users.EMAIL).required().email();
            PasswordType passwordType = this.getSessionData().getChannelAccessAccessor().getAccessPassword();
            if (passwordType.getPasswordMode() == PasswordMode.MANUAL) {
                org.cyclos.impl.utils.validation.Property property = validator.property((Property)SetupDTO.ADMIN_PASSWORD, UsersKeys.Users.PASSWORD).required();
                this.passwordService.addValidations(property, null, setupDTO.getAdminUsername(), passwordType, true);
                org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)SetupDTO.ADMIN_CONFIRM_PASSWORD, UsersKeys.Users.CONFIRM_PASSWORD).required();
                if (!Objects.equals(setupDTO.getAdminPassword(), setupDTO.getAdminConfirmPassword())) {
                    property2.invalid();
                }
            }
        }
        this.validate(validator, setupDTO, "setupDTO");
    }
}

