/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Date;
import java.util.List;
import org.cyclos.entities.banking.VoucherCategoryImage;
import org.cyclos.entities.banking.VoucherTypeImage;
import org.cyclos.entities.marketplace.AdCategoryImage;
import org.cyclos.entities.marketplace.AdImage;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValueImage;
import org.cyclos.entities.system.DefaultUserImage;
import org.cyclos.entities.system.QTempImage;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfoImage;
import org.cyclos.entities.users.IdentityProviderImage;
import org.cyclos.entities.users.OidcClientImage;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseImageServiceImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.TempImageServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TempImageServiceImpl
extends BaseImageServiceImpl<TempImage, QTempImage, NewTempImageParams>
implements TempImageServiceLocal {
    private static final String PREPROCESSED = "preProcessed";
    @Autowired
    protected BeanHandler beanHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;

    public TempImageServiceImpl() {
        super(ImageNature.TEMP, TempImage.class, QTempImage.tempImage);
    }

    public final long deleteExpiredImages() {
        TimeInterval timeInterval = new TimeInterval(Integer.valueOf(2), TimeField.HOURS);
        Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)timeInterval);
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where((Predicate)((QTempImage)this.$).lastModified.lt((Comparable)date))).iterate((Expression)((QTempImage)this.$).id);
        return this.processBatch(closeableIterator, this::remove);
    }

    public List<ImageVO> list(NewTempImageParams newTempImageParams) throws FrameworkException {
        return this.createQuery(newTempImageParams).list(ImageVO.class, (Expression)this.$);
    }

    public void move(TempImage tempImage, StoredFile storedFile) {
        switch (tempImage.getTarget()) {
            case USER_REGISTRATION: {
                if (storedFile instanceof UserImage) break;
                throw new IllegalActionException();
            }
            case USER_PROFILE: {
                UserImage userImage = (UserImage)ObjectHelper.ifType((Object)storedFile, UserImage.class);
                if (userImage != null && userImage.getUser().equals((Object)tempImage.getUser())) break;
                throw new IllegalActionException();
            }
            case CONTACT_INFO: {
                ContactInfoImage contactInfoImage = (ContactInfoImage)ObjectHelper.ifType((Object)storedFile, ContactInfoImage.class);
                if (contactInfoImage != null && (tempImage.getUser() == null || contactInfoImage.getContactInfo().getUser().equals((Object)tempImage.getUser()))) break;
                throw new IllegalActionException();
            }
            case ADVERTISEMENT: {
                AdImage adImage = (AdImage)ObjectHelper.ifType((Object)storedFile, AdImage.class);
                if (adImage != null && adImage.getAd().getOwner().equals((Object)tempImage.getUser())) break;
                throw new IllegalActionException();
            }
            case CUSTOM_VALUE: {
                CustomFieldValueImage customFieldValueImage = (CustomFieldValueImage)ObjectHelper.ifType((Object)storedFile, CustomFieldValueImage.class);
                if (customFieldValueImage != null && customFieldValueImage.getCustomFieldValue().getField().equals((Object)tempImage.getCustomField())) break;
                throw new IllegalActionException();
            }
            case AD_CATEGORY: {
                if (storedFile instanceof AdCategoryImage) break;
                throw new IllegalActionException();
            }
            case VOUCHER_TYPE: {
                if (storedFile instanceof VoucherTypeImage) break;
                throw new IllegalActionException();
            }
            case OIDC_CLIENT: {
                if (storedFile instanceof OidcClientImage) break;
                throw new IllegalActionException();
            }
            case IDENTITY_PROVIDER: {
                if (storedFile instanceof IdentityProviderImage) break;
                throw new IllegalActionException();
            }
            case VOUCHER_CATEGORY: {
                if (storedFile instanceof VoucherCategoryImage) break;
                throw new IllegalActionException();
            }
            case DEFAULT_USER: {
                if (storedFile instanceof DefaultUserImage) break;
                throw new IllegalActionException();
            }
        }
        this.storedFileHandler.move((StoredFile)tempImage, storedFile);
    }

    @Override
    public TempImage newImage(NewTempImageParams newTempImageParams) {
        this.preProcess(newTempImageParams);
        SessionData sessionData = this.getSessionData();
        TempImageTarget tempImageTarget = newTempImageParams.getTarget();
        CustomField customField = this.customFieldValueHandler.getCustomField(newTempImageParams.getCustomField());
        if (tempImageTarget == null) {
            tempImageTarget = customField != null ? TempImageTarget.CUSTOM_VALUE : TempImageTarget.USER_REGISTRATION;
        }
        BasicUser basicUser = tempImageTarget.requiresUser() ? this.userLocatorHandler.toBasicUserOrCurrent(newTempImageParams.getUser()) : null;
        TempImage tempImage = new TempImage();
        if (tempImageTarget.requiresMember()) {
            if (basicUser.isOperator()) {
                basicUser = basicUser.getUser();
            } else if (!basicUser.isMember()) {
                throw new IllegalActionException();
            }
        }
        if (customField != null != (tempImageTarget == TempImageTarget.CUSTOM_VALUE) || customField != null && customField.getType() != CustomFieldType.IMAGE) {
            throw new IllegalActionException();
        }
        tempImage.setTarget(tempImageTarget);
        tempImage.setCustomField(customField);
        tempImage.setUser(basicUser);
        tempImage.setByUser(sessionData.getLoggedUser());
        if (sessionData.isGuest()) {
            String string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)newTempImageParams.getGuestKey()), (Object)sessionData.getRemoteAddress());
            tempImage.setGuestKey(string);
        }
        return tempImage;
    }

    public void preProcess(NewTempImageParams newTempImageParams) {
        if (Boolean.TRUE.equals(newTempImageParams.getAttribute(PREPROCESSED))) {
            return;
        }
        TempImageTarget tempImageTarget = newTempImageParams.getTarget();
        CustomFieldVO customFieldVO = newTempImageParams.getCustomField();
        BasicUserVO basicUserVO = newTempImageParams.getUser();
        if (tempImageTarget == null) {
            tempImageTarget = customFieldVO == null ? TempImageTarget.USER_REGISTRATION : TempImageTarget.CUSTOM_VALUE;
            newTempImageParams.setTarget(tempImageTarget);
        }
        if (tempImageTarget != TempImageTarget.CUSTOM_VALUE && customFieldVO != null) {
            String string = this.message(UsersKeys.BulkActions.CUSTOM_FIELD, new Object[0]);
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID, string));
        }
        if (basicUserVO != null && ObjectHelper.isOneOf((Object)tempImageTarget, (Object[])new Object[]{TempImageTarget.USER_REGISTRATION, TempImageTarget.CUSTOM_VALUE})) {
            String string = this.message(UsersKeys.Users.USER, new Object[0]);
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID, string));
        }
        if (basicUserVO == null && ObjectHelper.isOneOf((Object)tempImageTarget, (Object[])new Object[]{TempImageTarget.ADVERTISEMENT, TempImageTarget.USER_PROFILE})) {
            User user = this.getLoggedUser();
            if (user == null) {
                throw new IllegalActionException();
            }
            newTempImageParams.setUser(new BasicUserVO(user.getId()));
        }
        newTempImageParams.setAttribute(PREPROCESSED, (Object)true);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTempImage)this.$).network());
    }

    @Override
    protected void validateMaxImages(NewTempImageParams newTempImageParams) throws MaxItemsException {
        int n;
        this.preProcess(newTempImageParams);
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        int n2 = this.createQuery(newTempImageParams).count(((QTempImage)this.$).id);
        int n3 = n = sessionData.isGuest() ? configurationAccessor.getMaxGuestTempImages() : configurationAccessor.getMaxUserTempImages();
        if (n2 > n) {
            throw new MaxItemsException(this.message(GeneralKeys.Errors.MAX_NUMBER_OF_TEMP_IMAGES, new Object[0]), n);
        }
    }

    private DBQuery<?> createQuery(NewTempImageParams newTempImageParams) {
        CustomField customField;
        BooleanExpression booleanExpression;
        String string;
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        DBQuery<?> dBQuery = this.from(this.$);
        if (user == null) {
            string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)newTempImageParams.getGuestKey()), (Object)sessionData.getRemoteAddress());
            dBQuery.where(new Predicate[]{((QTempImage)this.$).byUser().isNull(), ((QTempImage)this.$).guestKey.eq((Object)string)});
        } else {
            dBQuery.where((Predicate)((QTempImage)this.$).byUser().eq((Object)user));
        }
        string = (TempImageTarget)ObjectHelper.defaultValue((Object)newTempImageParams.getTarget(), (Object)TempImageTarget.USER_REGISTRATION);
        dBQuery.where((Predicate)((QTempImage)this.$).target.eq((Object)string));
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)newTempImageParams.getUser());
        if (basicUser != null) {
            dBQuery.where((Predicate)((QTempImage)this.$).user().eq((Object)basicUser));
        }
        if ((booleanExpression = this.storedFileHandler.customFieldEquals(this.$, customField = this.customFieldValueHandler.getCustomField(newTempImageParams.getCustomField()))) != null) {
            dBQuery.where((Predicate)booleanExpression);
        }
        return dBQuery;
    }
}

